/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartInXTabStatusManager;
import org.eclipse.birt.chart.reportitem.ui.QueryUIHelper;
import org.eclipse.birt.chart.reportitem.ui.ReportDataServiceProvider;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartXTabUIUtil
extends ChartXTabUtil {
    public static boolean addAxisChartInXTab(AggregationCellHandle cell, ChartWithAxes cwa, ExtendedItemHandle hostChartHandle, boolean bNewTotalJustAdded) throws BirtException {
        Object content;
        boolean bTransposed = cwa.isTransposed();
        int axisType = ChartXTabUIUtil.getXTabAxisType((boolean)bTransposed);
        if (bTransposed) {
            cell.setSpanOverOnRow(cell.getAggregationOnRow());
            cell.setSpanOverOnColumn(null);
            CrosstabCellHandle rowCell = ChartXTabUtil.getInnermostLevelCell((CrosstabReportItemHandle)cell.getCrosstab(), (int)0);
            if (rowCell == null) {
                return false;
            }
            if (rowCell.getHeight() == null || rowCell.getHeight().getMeasure() == 0.0) {
                cell.getCrosstab().setRowHeight(rowCell, DEFAULT_ROW_HEIGHT);
            }
            ChartXTabUIUtil.removeCellPadding(rowCell, bTransposed);
        } else {
            cell.setSpanOverOnColumn(cell.getAggregationOnColumn());
            cell.setSpanOverOnRow(null);
            CrosstabCellHandle columnCell = ChartXTabUtil.getInnermostLevelCell((CrosstabReportItemHandle)cell.getCrosstab(), (int)1);
            if (columnCell == null) {
                return false;
            }
            if (columnCell.getWidth() != null || columnCell.getWidth().getMeasure() == 0.0) {
                cell.getCrosstab().setColumnWidth(columnCell, DEFAULT_COLUMN_WIDTH);
            }
            ChartXTabUIUtil.removeCellPadding(columnCell, bTransposed);
        }
        ChartXTabUIUtil.removeCellPadding((CrosstabCellHandle)cell, bTransposed);
        ChartXTabUIUtil.removeCellPadding((CrosstabCellHandle)ChartXTabUIUtil.getGrandTotalAggregationCell(cell, !bTransposed), bTransposed);
        ChartXTabUIUtil.removeCellPadding((CrosstabCellHandle)ChartXTabUIUtil.getMeasureAggregationCell(cell), bTransposed);
        if (!ChartXTabUIUtil.isYAxisVisible(cwa)) {
            return bNewTotalJustAdded;
        }
        boolean bNewGrandTotol = bNewTotalJustAdded;
        if (cell.getCrosstab().getGrandTotal(axisType) == null) {
            bNewGrandTotol = true;
            cell.getCrosstab().addGrandTotal(axisType);
            ChartXTabUIUtil.deleteGrandTotalItems(cell.getCrosstab(), bTransposed);
        }
        ExtendedItemHandle axisChartHandle = ChartXTabUIUtil.createChartHandle(cell.getModelHandle(), "axisChart", hostChartHandle);
        AggregationCellHandle grandTotalAggCell = bTransposed ? ((MeasureViewHandle)cell.getContainer()).getAggregationCell(null, null, cell.getDimensionName(1), cell.getLevelName(1)) : ((MeasureViewHandle)cell.getContainer()).getAggregationCell(cell.getDimensionName(0), cell.getLevelName(0), null, null);
        if (bNewGrandTotol && (content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)grandTotalAggCell)) instanceof DesignElementHandle) {
            ((DesignElementHandle)content).dropAndClear();
        }
        if (grandTotalAggCell != null) {
            grandTotalAggCell.addContent((DesignElementHandle)axisChartHandle, 0);
        }
        return bNewGrandTotol;
    }

    public static boolean addAxisChartInXTab(AggregationCellHandle cell, ChartWithAxes cwa, ExtendedItemHandle hostChartHandle) throws BirtException {
        return ChartXTabUIUtil.addAxisChartInXTab(cell, cwa, hostChartHandle, !ChartInXTabStatusManager.hasGrandItem(hostChartHandle));
    }

    private static void deleteGrandTotalItems(CrosstabReportItemHandle xtab, boolean bTransposed) throws SemanticException {
        int i = 0;
        while (i < xtab.getMeasureCount()) {
            MeasureViewHandle mv = xtab.getMeasure(i);
            AggregationCellHandle aggCell = ChartXTabUIUtil.getGrandTotalAggregationCell(mv.getCell(), bTransposed);
            Object content = ChartXTabUIUtil.getFirstContent((CrosstabCellHandle)aggCell);
            if (content instanceof DataItemHandle) {
                ((DataItemHandle)content).dropAndClear();
            }
            ++i;
        }
    }

    public static void updateAxisChart(AggregationCellHandle cell, ChartWithAxes cwa, ExtendedItemHandle hostChartHandle) throws BirtException {
        boolean bTransposed = cwa.isTransposed();
        if (ChartXTabUIUtil.getGrandTotalCell((CrosstabCellHandle)cell, bTransposed) != null) {
            AggregationCellHandle grandTotalAggCell = ChartXTabUIUtil.getGrandTotalAggregationCell(cell, bTransposed);
            Object content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)grandTotalAggCell);
            if (content instanceof DataItemHandle) {
                if (ChartXTabUIUtil.isYAxisVisible(cwa)) {
                    ExtendedItemHandle axisChartHandle = ChartXTabUIUtil.createChartHandle(cell.getModelHandle(), "axisChart", hostChartHandle);
                    grandTotalAggCell.addContent((DesignElementHandle)axisChartHandle, 0);
                }
                if (!ChartInXTabStatusManager.hasGrandItem(cell)) {
                    ((DataItemHandle)content).dropAndClear();
                }
            } else if (ChartXTabUtil.isAxisChart((DesignElementHandle)((DesignElementHandle)content))) {
                if (((ExtendedItemHandle)content).getElementProperty("hostChart") != hostChartHandle) {
                    ((ExtendedItemHandle)content).setProperty("hostChart", (Object)hostChartHandle);
                }
            } else if (content == null) {
                ChartXTabUIUtil.addAxisChartInXTab(cell, cwa, hostChartHandle);
            }
        } else {
            ChartXTabUIUtil.addAxisChartInXTab(cell, cwa, hostChartHandle);
        }
    }

    public static AggregationCellHandle getGrandTotalAggregationCell(AggregationCellHandle cell, boolean bTransposed) {
        if (cell == null) {
            return null;
        }
        if (bTransposed) {
            return ((MeasureViewHandle)cell.getContainer()).getAggregationCell(null, null, cell.getDimensionName(1), cell.getLevelName(1));
        }
        return ((MeasureViewHandle)cell.getContainer()).getAggregationCell(cell.getDimensionName(0), cell.getLevelName(0), null, null);
    }

    public static AggregationCellHandle getMeasureAggregationCell(AggregationCellHandle cell) {
        if (cell == null) {
            return null;
        }
        return ((MeasureViewHandle)cell.getContainer()).getCell();
    }

    private static CrosstabCellHandle getGrandTotalCell(CrosstabCellHandle cell, boolean bTransposed) {
        if (cell == null) {
            return null;
        }
        return cell.getCrosstab().getGrandTotal(bTransposed ? 0 : 1);
    }

    public static List<ExtendedItemHandle> findChartInOtherMeasures(AggregationCellHandle cell, boolean bPlotChart) {
        if (cell.getCrosstab().getMeasureCount() > 1) {
            ArrayList<ExtendedItemHandle> list = new ArrayList<ExtendedItemHandle>();
            int i = 0;
            while (i < cell.getCrosstab().getMeasureCount()) {
                MeasureViewHandle mv = cell.getCrosstab().getMeasure(i);
                if (mv != cell.getContainer()) {
                    AggregationCellHandle aggCell = mv.getCell();
                    Object content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)aggCell);
                    if (bPlotChart && ChartXTabUtil.isPlotChart((DesignElementHandle)((DesignElementHandle)content)) || !bPlotChart && ChartXTabUtil.isAxisChart((DesignElementHandle)((DesignElementHandle)content))) {
                        list.add((ExtendedItemHandle)content);
                    }
                    int j = 0;
                    while (j < mv.getAggregationCount()) {
                        aggCell = mv.getAggregationCell(j);
                        content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)aggCell);
                        if (bPlotChart && ChartXTabUtil.isPlotChart((DesignElementHandle)((DesignElementHandle)content)) || !bPlotChart && ChartXTabUtil.isAxisChart((DesignElementHandle)((DesignElementHandle)content))) {
                            list.add((ExtendedItemHandle)content);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    private static boolean isEmptyInAllGrandTotalCells(CrosstabReportItemHandle xtab, boolean bTransposed) {
        int i = 0;
        while (i < xtab.getMeasureCount()) {
            MeasureViewHandle mv = xtab.getMeasure(i);
            AggregationCellHandle grandTotalCell = ChartXTabUIUtil.getGrandTotalAggregationCell(mv.getCell(), bTransposed);
            if (grandTotalCell != null && grandTotalCell.getContents().size() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void removeAxisChartInXTab(AggregationCellHandle cell, boolean bTransposed, boolean bCleanSpan) throws BirtException {
        AggregationCellHandle grandTotalAggCell;
        if (bCleanSpan) {
            cell.setSpanOverOnRow(null);
            cell.setSpanOverOnColumn(null);
        }
        if ((grandTotalAggCell = ChartXTabUIUtil.getGrandTotalAggregationCell(cell, bTransposed)) != null && grandTotalAggCell.getContents().size() > 0) {
            Object content = ChartXTabUIUtil.getFirstContent((CrosstabCellHandle)grandTotalAggCell);
            if (ChartXTabUIUtil.isAxisChart((DesignElementHandle)((DesignElementHandle)content))) {
                ((DesignElementHandle)content).dropAndClear();
            }
            if (ChartXTabUIUtil.isEmptyInAllGrandTotalCells(cell.getCrosstab(), bTransposed)) {
                cell.getCrosstab().removeGrandTotal(ChartXTabUIUtil.getXTabAxisType((boolean)bTransposed));
            }
        }
    }

    public static void updateXTabForAxis(AggregationCellHandle cell, ExtendedItemHandle hostChartHandle, boolean bTransOld, ChartWithAxes cmNew) throws BirtException {
        boolean bTransNew = cmNew.isTransposed();
        if (bTransOld != bTransNew) {
            ChartXTabUIUtil.updateXTabDirection(cell.getCrosstab(), bTransNew);
            boolean bNewTotalJustAdded = false;
            List<ExtendedItemHandle> otherPlotCharts = ChartXTabUIUtil.findChartInOtherMeasures(cell, true);
            int i = 0;
            while (i < otherPlotCharts.size()) {
                ExtendedItemHandle chartInOtherMeasure = otherPlotCharts.get(i);
                if (chartInOtherMeasure != null) {
                    ChartWithAxes cwa = ChartXTabUIUtil.updateChartModelWhenTransposing(chartInOtherMeasure, cmNew);
                    AggregationCellHandle cellAgg = ChartXTabUIUtil.getXtabContainerCell((DesignElementHandle)chartInOtherMeasure);
                    ChartXTabUIUtil.removeAxisChartInXTab(cellAgg, bTransOld, true);
                    bNewTotalJustAdded = ChartXTabUIUtil.addAxisChartInXTab(cellAgg, cwa, chartInOtherMeasure, bNewTotalJustAdded);
                }
                ++i;
            }
            ChartXTabUIUtil.removeAxisChartInXTab(cell, bTransOld, true);
            ChartXTabUIUtil.addAxisChartInXTab(cell, cmNew, hostChartHandle, bNewTotalJustAdded);
        }
    }

    private static ChartWithAxes updateChartModelWhenTransposing(ExtendedItemHandle eih, ChartWithAxes cmFrom) throws ExtendedElementException {
        ChartReportItemImpl reportItem = (ChartReportItemImpl)eih.getReportItem();
        ChartWithAxes cmOld = (ChartWithAxes)reportItem.getProperty("chart.instance");
        ChartWithAxes cmNew = cmOld.copyInstance();
        cmNew.setTransposed(cmFrom.isTransposed());
        cmNew.getBaseAxes()[0].setType(AxisType.TEXT_LITERAL);
        Query queryFrom = (Query)((SeriesDefinition)((Axis)cmFrom.getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries().getDataDefinition().get(0);
        Query queryTo = (Query)((SeriesDefinition)((Axis)cmNew.getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries().getDataDefinition().get(0);
        queryTo.setDefinition(queryFrom.getDefinition());
        reportItem.executeSetModelCommand(eih, (Chart)cmOld, (Chart)cmNew);
        return cmNew;
    }

    public static ExtendedItemHandle createChartHandle(DesignElementHandle anyHandle, String chartType, ExtendedItemHandle hostChartHandle) throws SemanticException {
        String name = ReportPlugin.getDefault().getCustomName("Chart");
        ExtendedItemHandle chartHandle = anyHandle.getElementFactory().newExtendedItem(name, "Chart");
        if (chartType != null) {
            chartHandle.setProperty("chartType", (Object)chartType);
        }
        if (hostChartHandle != null) {
            chartHandle.setProperty("hostChart", (Object)hostChartHandle);
        }
        return chartHandle;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkQueryExpression(String checkType, Object data, Chart cm, ExtendedItemHandle itemHandle, ReportDataServiceProvider provider) {
        if (data == null || "".equals(data)) {
            return true;
        }
        categoryDimension = null;
        yOptionDimension = null;
        categoryBindName = null;
        yOptionBindName = null;
        expression = (String)data;
        queryDefinitionsMap = QueryUIHelper.getQueryDefinitionsMap(cm);
        columnBindings = null;
        if (ChartXTabUtil.getBindingCube((DesignElementHandle)itemHandle) != null && provider.isInheritanceOnly() || provider.isSharedBinding()) {
            reportItemHandle = provider.getReportItemHandle();
            columnBindings = reportItemHandle.getColumnBindings().iterator();
        } else if (ChartXTabUtil.getBindingCube((DesignElementHandle)itemHandle) != null || provider.isInXTabMeasureCell() && !provider.isPartChart()) {
            columnBindings = ChartXTabUtil.getAllColumnBindingsIterator((ReportItemHandle)itemHandle);
        }
        if ("optional".equals(checkType)) {
            categoryExpr = null;
            querys = queryDefinitionsMap.get("category");
            if (querys != null && querys.length > 0) {
                categoryExpr = querys[0].getDefinition();
            }
            if (categoryExpr == null || "".equals(categoryExpr)) {
                return true;
            }
            categoryBindName = ChartXTabUtil.getBindingName((String)categoryExpr, (boolean)true);
            yOptionBindName = ChartXTabUtil.getBindingName((String)expression, (boolean)true);
        } else if ("category".equals(checkType)) {
            yOptionExpr = null;
            querys = queryDefinitionsMap.get("optional");
            if (querys != null && querys.length > 0) {
                yOptionExpr = querys[0].getDefinition();
            }
            if (yOptionExpr == null || "".equals(yOptionExpr)) {
                return true;
            }
            categoryBindName = ChartXTabUtil.getBindingName((String)expression, (boolean)true);
            yOptionBindName = ChartXTabUtil.getBindingName((String)yOptionExpr, (boolean)true);
        }
        if (columnBindings != null) ** GOTO lbl45
        return true;
lbl-1000:
        // 1 sources

        {
            columnHandle = (ComputedColumnHandle)columnBindings.next();
            bindName = columnHandle.getName();
            expr = columnHandle.getExpression();
            if (!ChartXTabUtil.isDimensionExpresion((String)expr)) continue;
            if (bindName.equals(categoryBindName)) {
                categoryDimension = ChartXTabUtil.getLevelNameFromDimensionExpression((String)expr)[0];
            }
            if (!bindName.equals(yOptionBindName)) continue;
            yOptionDimension = ChartXTabUtil.getLevelNameFromDimensionExpression((String)expr)[0];
lbl45:
            // 4 sources

            ** while (columnBindings.hasNext())
        }
lbl46:
        // 1 sources

        return categoryDimension == null || yOptionDimension == null || categoryDimension.equals(yOptionDimension) == false;
    }

    public static boolean isTransposedChartWithAxes(Chart cm) {
        if (cm instanceof ChartWithAxes) {
            return ((ChartWithAxes)cm).isTransposed();
        }
        throw new IllegalArgumentException(Messages.getString("Error.ChartShouldIncludeAxes"));
    }

    private static boolean isYAxisVisible(ChartWithAxes cwa) {
        Axis yAxis = (Axis)((Axis)cwa.getAxes().get(0)).getAssociatedAxes().get(0);
        return yAxis.getLineAttributes().isVisible();
    }

    public static void updateXTabDirection(CrosstabReportItemHandle xtab, boolean bTransposed) throws SemanticException {
        if (bTransposed) {
            if (!"horizontal".equals(xtab.getMeasureDirection())) {
                xtab.setMeasureDirection("horizontal");
            }
        } else if (!"vertical".equals(xtab.getMeasureDirection())) {
            xtab.setMeasureDirection("vertical");
        }
    }

    private static void removeCellPadding(CrosstabCellHandle cell, boolean bTransposed) throws SemanticException {
        if (cell != null) {
            if (bTransposed) {
                cell.getModelHandle().setProperty("paddingTop", (Object)new DimensionValue(0.0, "pt"));
                cell.getModelHandle().setProperty("paddingBottom", (Object)new DimensionValue(0.0, "pt"));
            } else {
                cell.getModelHandle().setProperty("paddingLeft", (Object)new DimensionValue(0.0, "pt"));
                cell.getModelHandle().setProperty("paddingRight", (Object)new DimensionValue(0.0, "pt"));
            }
        }
    }
}

