/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.reportitem.ChartReportItemPresentationBase;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.StyleHandle;

public final class ChartReportItemPresentationPlotImpl
extends ChartReportItemPresentationBase {
    protected Bounds computeBounds() throws ChartException {
        Bounds originalBounds = this.cm.getBlock().getBounds();
        Bounds bounds = originalBounds.copyInstance();
        try {
            AggregationCellHandle xtabCell = ChartXTabUtil.getXtabContainerCell((DesignElementHandle)this.modelHandle);
            if (xtabCell != null) {
                if (xtabCell.getSpanOverOnColumn() != null) {
                    CrosstabCellHandle columnCell = ChartXTabUtil.getInnermostLevelCell(xtabCell.getCrosstab(), 1);
                    double dWidth = ChartReportItemUtil.convertToPoints(xtabCell.getCrosstab().getColumnWidth(columnCell), this.dpi);
                    if (dWidth == 0.0) {
                        dWidth = ChartXTabUtil.DEFAULT_COLUMN_WIDTH.getMeasure();
                    }
                    StyleHandle style = xtabCell.getModelHandle().getPrivateStyle();
                    double dLeftBorder = ChartReportItemUtil.convertToPoints(style.getBorderLeftWidth(), this.dpi);
                    double dRightBorder = ChartReportItemUtil.convertToPoints(style.getBorderRightWidth(), this.dpi);
                    bounds.setWidth(-this.roundPointsWithPixels(dWidth + (dLeftBorder + dRightBorder) / 2.0));
                } else if (xtabCell.getSpanOverOnRow() != null) {
                    CrosstabCellHandle rowCell = ChartXTabUtil.getInnermostLevelCell(xtabCell.getCrosstab(), 0);
                    double dHeight = ChartReportItemUtil.convertToPoints(xtabCell.getCrosstab().getRowHeight(rowCell), this.dpi);
                    if (dHeight == 0.0) {
                        dHeight = ChartXTabUtil.DEFAULT_ROW_HEIGHT.getMeasure();
                    }
                    StyleHandle style = xtabCell.getModelHandle().getPrivateStyle();
                    double dTopBorder = ChartReportItemUtil.convertToPoints(style.getBorderTopWidth(), this.dpi);
                    double dBottomBorder = ChartReportItemUtil.convertToPoints(style.getBorderBottomWidth(), this.dpi);
                    bounds.setHeight(-this.roundPointsWithPixels(dHeight + (dTopBorder + dBottomBorder) / 2.0));
                }
            }
        }
        catch (BirtException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 3, (Throwable)e);
        }
        return bounds;
    }

    protected void updateChartModel() {
        ChartXTabUtil.updateModelToRenderPlot(this.cm, this.rtc.isRightToLeft());
    }

    private double roundPointsWithPixels(double points) {
        return (double)((int)(points / 72.0 * (double)this.dpi) * 72) / (double)this.dpi;
    }
}

