/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.Serializer;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.SerializerImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemConstants;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.IChartReportItemFactory;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartReportItemUtil
implements ChartReportItemConstants {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    public static final int REVISE_REFERENCE_REPORT_ITEM = 1;

    public static ReportItemHandle getBindingHolder(DesignElementHandle handle) {
        if (handle instanceof ReportElementHandle) {
            if (handle instanceof ReportItemHandle && (((ReportItemHandle)handle).getDataBindingReference() != null || ((ReportItemHandle)handle).getCube() != null || ((ReportItemHandle)handle).getDataSet() != null)) {
                return (ReportItemHandle)handle;
            }
            return ChartReportItemUtil.getBindingHolder(handle.getContainer());
        }
        return null;
    }

    public static boolean canScaleShared(ReportItemHandle eih, Chart cm) {
        return cm instanceof ChartWithAxes && eih.getDataSet() == null && ChartReportItemUtil.getBindingHolder((DesignElementHandle)eih) != null && ChartXTabUtil.isInXTabMeasureCell((DesignElementHandle)eih);
    }

    public static boolean isRtl() {
        boolean rtl = false;
        String eclipseCommands = SecurityUtil.getSysProp((String)"eclipse.commands");
        if (eclipseCommands != null) {
            String[] options = eclipseCommands.split("-");
            String regex = "[\\s]*[dD][iI][rR][\\s]*[rR][tT][lL][\\s]*";
            Pattern pattern = Pattern.compile(regex);
            int i = 0;
            while (i < options.length) {
                String option = options[i];
                if (pattern.matcher(option).matches()) {
                    rtl = true;
                    break;
                }
                ++i;
            }
        }
        return rtl;
    }

    public static Iterator<ComputedColumnHandle> getColumnDataBindings(ReportItemHandle itemHandle) {
        return ChartReportItemUtil.getColumnDataBindings(itemHandle, false);
    }

    public static Iterator<ComputedColumnHandle> getColumnDataBindings(ReportItemHandle itemHandle, boolean unique) {
        ComputedColumnHandle cch;
        if (itemHandle.getDataSet() != null || itemHandle.getCube() != null) {
            return itemHandle.columnBindingsIterator();
        }
        ReportItemHandle handle = ChartReportItemUtil.getBindingHolder((DesignElementHandle)itemHandle);
        if (handle == null) {
            return null;
        }
        LinkedHashMap<String, ComputedColumnHandle> bindingMap = new LinkedHashMap<String, ComputedColumnHandle>();
        ArrayList<ComputedColumnHandle> list = new ArrayList<ComputedColumnHandle>();
        Iterator i = handle.columnBindingsIterator();
        while (i.hasNext()) {
            cch = (ComputedColumnHandle)i.next();
            list.add(cch);
            bindingMap.put(cch.getName(), cch);
        }
        if (handle != itemHandle) {
            i = itemHandle.columnBindingsIterator();
            while (i.hasNext()) {
                cch = (ComputedColumnHandle)i.next();
                list.add(cch);
                bindingMap.put(cch.getName(), cch);
            }
        }
        if (unique) {
            return bindingMap.values().iterator();
        }
        return list.iterator();
    }

    public static int convertToDtEGroupUnit(DataType dataType, GroupingUnitType groupUnitType, double intervalRange) {
        if (dataType == DataType.NUMERIC_LITERAL) {
            if (intervalRange == 0.0) {
                return 0;
            }
            return 99;
        }
        if (dataType == DataType.DATE_TIME_LITERAL) {
            switch (groupUnitType.getValue()) {
                case 0: {
                    return 8;
                }
                case 1: {
                    return 7;
                }
                case 2: {
                    return 6;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 3;
                }
                case 7: {
                    return 1;
                }
            }
        } else if (dataType == DataType.TEXT_LITERAL) {
            switch (groupUnitType.getValue()) {
                case 9: {
                    return 100;
                }
            }
            return 0;
        }
        return 0;
    }

    public static double convertToDtEIntervalRange(DataType dataType, GroupingUnitType groupUnitType, double intervalRange) {
        double range = intervalRange;
        if (Double.isNaN(intervalRange)) {
            range = 0.0;
        }
        if (dataType == DataType.DATE_TIME_LITERAL && range <= 0.0) {
            range = 1.0;
        } else if (dataType == DataType.TEXT_LITERAL) {
            return (long)range;
        }
        return range;
    }

    public static int convertToDtESortDirection(SortOption sortOption) {
        if (sortOption == SortOption.ASCENDING_LITERAL) {
            return 0;
        }
        if (sortOption == SortOption.DESCENDING_LITERAL) {
            return 1;
        }
        return -1;
    }

    public static String convertToDtEAggFunction(String agg) {
        if ("Sum".equals(agg)) {
            return "SUM";
        }
        if ("Average".equals(agg)) {
            return "AVE";
        }
        if ("Count".equals(agg)) {
            return "COUNT";
        }
        if ("DistinctCount".equals(agg)) {
            return "COUNTDISTINCT";
        }
        if ("First".equals(agg)) {
            return "FIRST";
        }
        if ("Last".equals(agg)) {
            return "LAST";
        }
        if ("Min".equals(agg)) {
            return "MIN";
        }
        if ("Max".equals(agg)) {
            return "MAX";
        }
        if ("WeightedAverage".equals(agg)) {
            return "WEIGHTEDAVE";
        }
        if ("Median".equals(agg)) {
            return "MEDIAN";
        }
        if ("Mode".equals(agg)) {
            return "MODE";
        }
        if ("STDDEV".equals(agg)) {
            return "STDDEV";
        }
        if ("Variance".equals(agg)) {
            return "VARIANCE";
        }
        if ("Irr".equals(agg)) {
            return "IRR";
        }
        if ("Mirr".equals(agg)) {
            return "MIRR";
        }
        if ("NPV".equals(agg)) {
            return "NPV";
        }
        if ("Percentile".equals(agg)) {
            return "PERCENTILE";
        }
        if ("Quartile".equals(agg)) {
            return "QUARTILE";
        }
        if ("MovingAverage".equals(agg)) {
            return "MOVINGAVE";
        }
        if ("RunningSum".equals(agg)) {
            return "RUNNINGSUM";
        }
        if ("RunningNPV".equals(agg)) {
            return "RUNNINGNPV";
        }
        if ("Rank".equals(agg)) {
            return "RANK";
        }
        if ("Top".equals(agg)) {
            return "ISTOPN";
        }
        if ("TopPercent".equals(agg)) {
            return "ISTOPNPERCENT";
        }
        if ("Bottom".equals(agg)) {
            return "ISBOTTOMN";
        }
        if ("BottomPercent".equals(agg)) {
            return "ISBOTTOMNPERCENT";
        }
        if ("PercentRank".equals(agg)) {
            return "PERCENTRANK";
        }
        if ("PercentSum".equals(agg)) {
            return "PERCENTSUM";
        }
        if ("RunningCount".equals(agg)) {
            return "RUNNINGCOUNT";
        }
        return null;
    }

    public static boolean isEmpty(IBaseResultSet set) throws BirtException {
        if (set instanceof IQueryResultSet) {
            return ((IQueryResultSet)set).isEmpty();
        }
        return false;
    }

    public static boolean isYGroupingDefined(SeriesDefinition orthSeriesDefinition) {
        if (orthSeriesDefinition == null) {
            return false;
        }
        String yGroupExpr = null;
        if (orthSeriesDefinition.getQuery() != null) {
            yGroupExpr = orthSeriesDefinition.getQuery().getDefinition();
        }
        return yGroupExpr != null && !"".equals(yGroupExpr);
    }

    public static boolean isBaseGroupingDefined(SeriesDefinition baseSD) {
        return baseSD != null && !baseSD.getDesignTimeSeries().getDataDefinition().isEmpty() && baseSD.getGrouping() != null && baseSD.getGrouping().isEnabled();
    }

    public static boolean isGroupingDefined(Chart cm) {
        SeriesDefinition baseSD = null;
        SeriesDefinition orthSD = null;
        Object[] orthAxisArray = null;
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)cm;
            baseSD = (SeriesDefinition)cwa.getBaseAxes()[0].getSeriesDefinitions().get(0);
            orthAxisArray = cwa.getOrthogonalAxes(cwa.getBaseAxes()[0], true);
            orthSD = (SeriesDefinition)((Axis)orthAxisArray[0]).getSeriesDefinitions().get(0);
        } else if (cm instanceof ChartWithoutAxes) {
            ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
            baseSD = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
            orthSD = (SeriesDefinition)baseSD.getSeriesDefinitions().get(0);
        }
        return ChartReportItemUtil.isBaseGroupingDefined(baseSD) || ChartReportItemUtil.isYGroupingDefined(orthSD);
    }

    public static boolean isBaseGroupingDefined(Chart cm) {
        SeriesDefinition baseSD = null;
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)cm;
            baseSD = (SeriesDefinition)cwa.getBaseAxes()[0].getSeriesDefinitions().get(0);
        } else if (cm instanceof ChartWithoutAxes) {
            ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
            baseSD = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
        }
        return ChartReportItemUtil.isBaseGroupingDefined(baseSD);
    }

    public static boolean isSetRunningAggregation(Chart cm) throws ChartException {
        SeriesDefinition baseSD = (SeriesDefinition)ChartUtil.getBaseSeriesDefinitions((Chart)cm).get(0);
        for (SeriesDefinition orthoSD : ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm)) {
            for (Query query : orthoSD.getDesignTimeSeries().getDataDefinition()) {
                IAggregateFunction aFunc;
                String aggrFunc = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthoSD, (SeriesDefinition)baseSD, (Query)query);
                if (aggrFunc == null || (aFunc = PluginSettings.instance().getAggregateFunction(aggrFunc)) == null || aFunc.getType() != 1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSetSummaryAggregation(Chart cm) throws ChartException {
        SeriesDefinition baseSD = (SeriesDefinition)ChartUtil.getBaseSeriesDefinitions((Chart)cm).get(0);
        for (SeriesDefinition orthoSD : ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm)) {
            for (Query query : orthoSD.getDesignTimeSeries().getDataDefinition()) {
                IAggregateFunction aFunc;
                String aggrFunc = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthoSD, (SeriesDefinition)baseSD, (Query)query);
                if (aggrFunc == null || (aFunc = PluginSettings.instance().getAggregateFunction(aggrFunc)) == null || aFunc.getType() != 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAggregation(Chart cm) {
        SeriesDefinition baseSD = null;
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)cm;
            baseSD = (SeriesDefinition)cwa.getBaseAxes()[0].getSeriesDefinitions().get(0);
        } else if (cm instanceof ChartWithoutAxes) {
            ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
            baseSD = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
        }
        if (ChartReportItemUtil.isBaseGroupingDefined(baseSD) && !ChartUtil.isEmpty((String)baseSD.getGrouping().getAggregateExpression())) {
            return true;
        }
        try {
            if (cm instanceof ChartWithAxes) {
                EList axisList = ((Axis)((ChartWithAxes)cm).getAxes().get(0)).getAssociatedAxes();
                for (Axis a : axisList) {
                    for (SeriesDefinition orthSD : a.getSeriesDefinitions()) {
                        for (Query query : orthSD.getDesignTimeSeries().getDataDefinition()) {
                            if (ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)query) == null) continue;
                            return true;
                        }
                    }
                }
            } else if (cm instanceof ChartWithoutAxes) {
                for (SeriesDefinition orthSD : ((SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0)).getSeriesDefinitions()) {
                    for (Query query : orthSD.getDesignTimeSeries().getDataDefinition()) {
                        if (ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)query) == null) continue;
                        return true;
                    }
                }
            }
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
        }
        return false;
    }

    public static ChartReportItemImpl getChartReportItemFromHandle(ExtendedItemHandle eih) {
        ChartReportItemImpl item = null;
        if (!ChartReportItemUtil.isChartHandle(eih)) {
            return null;
        }
        try {
            item = (ChartReportItemImpl)eih.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log((Exception)((Object)e));
        }
        if (item == null) {
            try {
                eih.loadExtendedElement();
                item = (ChartReportItemImpl)eih.getReportItem();
            }
            catch (ExtendedElementException eeex) {
                logger.log((Exception)((Object)eeex));
            }
            if (item == null) {
                logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.UnableToLocateWrapper"));
            }
        }
        return item;
    }

    public static boolean isChartHandle(Object content) {
        return content instanceof ExtendedItemHandle && "Chart".equals(((ExtendedItemHandle)content).getExtensionName());
    }

    public static Chart getChartFromHandle(ExtendedItemHandle handle) {
        ChartReportItemImpl item = ChartReportItemUtil.getChartReportItemFromHandle(handle);
        if (item == null) {
            return null;
        }
        return (Chart)item.getProperty("chart.instance");
    }

    public static Iterator<ComputedColumnHandle> getAllColumnBindingsIterator(ReportItemHandle itemHandle) {
        ReportItemHandle container = ChartReportItemUtil.getBindingHolder((DesignElementHandle)itemHandle);
        if (container != null && container != itemHandle) {
            ArrayList<ComputedColumnHandle> allBindings = new ArrayList<ComputedColumnHandle>();
            Iterator ownBindings = itemHandle.columnBindingsIterator();
            while (ownBindings.hasNext()) {
                allBindings.add((ComputedColumnHandle)ownBindings.next());
            }
            Iterator containerBindings = container.columnBindingsIterator();
            while (containerBindings.hasNext()) {
                allBindings.add((ComputedColumnHandle)containerBindings.next());
            }
            return allBindings.iterator();
        }
        return itemHandle.columnBindingsIterator();
    }

    public static double convertToPoints(DimensionHandle handle, int dpi) {
        double retValue = 0.0;
        if (handle.getMeasure() > 0.0 && handle.getUnits().trim().length() > 0) {
            retValue = handle.getUnits() == "pt" ? handle.getMeasure() : (handle.getUnits() == "px" ? handle.getMeasure() * 72.0 / (double)dpi : DimensionUtil.convertTo((double)handle.getMeasure(), (String)handle.getUnits(), (String)"pt").getMeasure());
        }
        return retValue;
    }

    public static Bounds createDefaultChartBounds(ExtendedItemHandle eih, Chart cm) {
        if (ChartXTabUtil.isAxisChart((DesignElementHandle)eih)) {
            ChartWithAxes cmWA = (ChartWithAxes)cm;
            if (cmWA.isTransposed()) {
                return BoundsImpl.create((double)0.0, (double)0.0, (double)212.0, (double)22.0);
            }
            return BoundsImpl.create((double)0.0, (double)0.0, (double)22.0, (double)130.0);
        }
        return BoundsImpl.create((double)0.0, (double)0.0, (double)212.0, (double)130.0);
    }

    public static String convertToChartAggExpression(String agg) {
        if ("sum".equalsIgnoreCase(agg)) {
            return "Sum";
        }
        if ("average".equalsIgnoreCase(agg)) {
            return "Average";
        }
        if ("count".equalsIgnoreCase(agg)) {
            return "Count";
        }
        if ("count-distinct".equalsIgnoreCase(agg)) {
            return "DistinctCount";
        }
        if ("first".equalsIgnoreCase(agg)) {
            return "First";
        }
        if ("last".equalsIgnoreCase(agg)) {
            return "Last";
        }
        if ("min".equalsIgnoreCase(agg)) {
            return "Min";
        }
        if ("max".equalsIgnoreCase(agg)) {
            return "Max";
        }
        if ("weighted-avg".equalsIgnoreCase(agg)) {
            return "WeightedAverage";
        }
        if ("median".equalsIgnoreCase(agg)) {
            return "Median";
        }
        if ("mode".equalsIgnoreCase(agg)) {
            return "Mode";
        }
        if ("stddev".equalsIgnoreCase(agg)) {
            return "STDDEV";
        }
        if ("variance".equalsIgnoreCase(agg)) {
            return "Variance";
        }
        if ("irr".equalsIgnoreCase(agg)) {
            return "Irr";
        }
        if ("mirr".equalsIgnoreCase(agg)) {
            return "Mirr";
        }
        if ("npv".equalsIgnoreCase(agg)) {
            return "NPV";
        }
        if ("percentile".equalsIgnoreCase(agg)) {
            return "Percentile";
        }
        if ("quartile".equalsIgnoreCase(agg)) {
            return "Quartile";
        }
        if ("moving-ave".equalsIgnoreCase(agg)) {
            return "MovingAverage";
        }
        if ("running-sum".equalsIgnoreCase(agg)) {
            return "RunningSum";
        }
        if ("running-npv".equalsIgnoreCase(agg)) {
            return "RunningNPV";
        }
        if ("rank".equalsIgnoreCase(agg)) {
            return "Rank";
        }
        if ("is-top-n".equalsIgnoreCase(agg)) {
            return "Top";
        }
        if ("is-top-n-percent".equalsIgnoreCase(agg)) {
            return "TopPercent";
        }
        if ("is-bottom-n".equalsIgnoreCase(agg)) {
            return "Bottom";
        }
        if ("is-bottom-n-percent".equalsIgnoreCase(agg)) {
            return "BottomPercent";
        }
        if ("percent-rank".equalsIgnoreCase(agg)) {
            return "PercentRank";
        }
        if ("percent-sum".equalsIgnoreCase(agg)) {
            return "PercentSum";
        }
        if ("running-count".equalsIgnoreCase(agg)) {
            return "RunningCount";
        }
        return null;
    }

    public static boolean isChildOfMultiViewsHandle(DesignElementHandle handle) {
        return handle != null && handle.getContainer() instanceof MultiViewsHandle;
    }

    public static boolean checkStringInExpression(String expression) {
        boolean haveString = false;
        int i = 0;
        while (i < expression.length()) {
            if (expression.charAt(i) == '\"') {
                if (i == 0 || i == expression.length() - 1) {
                    haveString = true;
                    break;
                }
                if (expression.charAt(i - 1) != '[' && expression.charAt(i + 1) != ']') {
                    haveString = true;
                    break;
                }
            }
            ++i;
        }
        return haveString;
    }

    public static int compareVersion(String va, String vb) {
        return ChartUtil.compareVersion((String)va, (String)vb);
    }

    private static boolean isSharedGroupExpression(String expression, ReportItemHandle handle) {
        ReportItemHandle itemHandle = ChartReportItemUtil.getReportItemReference(handle);
        if (itemHandle instanceof ListingHandle) {
            ArrayList<GroupHandle> groupList = new ArrayList<GroupHandle>();
            SlotHandle groups = ((ListingHandle)itemHandle).getGroups();
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                groupList.add((GroupHandle)iter.next());
            }
            if (groupList.size() == 0) {
                return false;
            }
            for (GroupHandle gh : groupList) {
                if (!expression.equals(gh.getKeyExpr())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOldChartUsingInternalGroup(ReportItemHandle chartHandle, Chart cm) {
        if (ChartReportItemUtil.compareVersion(cm.getVersion(), "2.5.0") >= 0) {
            return false;
        }
        String reportVer = chartHandle.getModuleHandle().getVersion();
        if (reportVer == null || ChartReportItemUtil.compareVersion(reportVer, "3.2.16") < 0) {
            return true;
        }
        return chartHandle.getDataBindingReference() != null && ChartReportItemUtil.isBaseGroupingDefined(cm) && !ChartReportItemUtil.isSharedGroupExpression(ChartUtil.getCategoryExpressions((Chart)cm)[0], chartHandle);
    }

    public static boolean isSimpleExpression(String expr) {
        boolean isSingle;
        String rowPattern = "row\\[.*\\]";
        String dataPattern = "data\\[.*\\]";
        boolean matches = expr.matches(rowPattern) || expr.matches(dataPattern);
        boolean bl = isSingle = expr.indexOf("]") == expr.length() - 1;
        return matches && isSingle;
    }

    public static ReportItemHandle getReportItemReference(ReportItemHandle itemHandle) {
        return ChartReportItemUtil.getReportItemReferenceImpl(itemHandle, itemHandle);
    }

    private static ReportItemHandle getReportItemReferenceImpl(ReportItemHandle currentItemHandle, ReportItemHandle itemHandle) {
        ReportItemHandle handle = currentItemHandle.getDataBindingReference();
        if (handle == null) {
            if (currentItemHandle.getContainer() instanceof MultiViewsHandle) {
                return ChartReportItemUtil.getReportItemReferenceImpl((ReportItemHandle)currentItemHandle.getContainer().getContainer(), itemHandle);
            }
            if (currentItemHandle == itemHandle) {
                return null;
            }
            return currentItemHandle;
        }
        return ChartReportItemUtil.getReportItemReferenceImpl(handle, itemHandle);
    }

    public static boolean isChartReportItemHandle(ReportItemHandle handle) {
        return handle instanceof ExtendedItemHandle && ChartReportItemUtil.getChartFromHandle((ExtendedItemHandle)handle) != null;
    }

    public static String getRowBindingName(String expr, boolean hasOperation) {
        if (!ChartReportItemUtil.isRowBinding(expr, hasOperation)) {
            return null;
        }
        if (hasOperation) {
            return expr.replaceFirst(".*\\Qrow[\"\\E", "").replaceFirst("\\Q\"]\\E.*", "");
        }
        return expr.replaceFirst("\\Qrow[\"\\E", "").replaceFirst("\\Q\"]\\E", "");
    }

    public static boolean isRowBinding(String expr, boolean hasOperation) {
        if (expr == null) {
            return false;
        }
        String regExp = hasOperation ? ".*\\Qrow[\"\\E.*\\Q\"]\\E.*" : "\\Qrow[\"\\E.*\\Q\"]\\E";
        boolean result = expr.matches(regExp);
        if (hasOperation) {
            return result;
        }
        return result && ChartReportItemUtil.containsOnce(expr, "row[\"") && ChartReportItemUtil.containsOnce(expr, "\"]");
    }

    private static boolean containsOnce(String expr, String substring) {
        String text = expr;
        int index = text.indexOf(substring);
        if (index < 0) {
            return false;
        }
        return (text = text.substring(index + substring.length() - 1)).indexOf(substring) < 0;
    }

    public static String createBindingNameForRowExpression(String expr) {
        if (ChartReportItemUtil.isRowBinding(expr, false)) {
            return ChartReportItemUtil.getRowBindingName(expr, false);
        }
        if (ChartReportItemUtil.isRowBinding(expr, true)) {
            return ChartUtil.removeInvalidSymbols((String)expr);
        }
        return expr;
    }

    public static void copyAndInsertBindingFromContainer(ISubqueryDefinition query, String expr) throws DataException {
        String bindingName = ChartReportItemUtil.getRowBindingName(expr, false);
        if (bindingName != null && !query.getBindings().containsKey(bindingName) && query.getParentQuery().getBindings().containsKey(bindingName)) {
            IBinding parentBinding = (IBinding)query.getParentQuery().getBindings().get(bindingName);
            Binding binding = new Binding(bindingName, parentBinding.getExpression());
            binding.setAggrFunction(parentBinding.getAggrFunction());
            binding.setDataType(parentBinding.getDataType());
            binding.setDisplayName(parentBinding.getDisplayName());
            binding.setFilter(parentBinding.getFilter());
            query.addBinding((IBinding)binding);
        }
    }

    public static void reviseChartModel(int reviseType, Chart cm, ReportItemHandle itemHandle) {
        switch (reviseType) {
            case 1: {
                if (itemHandle.getDataBindingReference() == null || !ChartReportItemUtil.isBaseGroupingDefined(cm) || ChartReportItemUtil.isSharedGroupExpression(ChartUtil.getCategoryExpressions((Chart)cm)[0], itemHandle)) break;
                SeriesDefinition baseSD = null;
                if (cm instanceof ChartWithAxes) {
                    ChartWithAxes cwa = (ChartWithAxes)cm;
                    baseSD = (SeriesDefinition)cwa.getBaseAxes()[0].getSeriesDefinitions().get(0);
                } else if (cm instanceof ChartWithoutAxes) {
                    ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
                    baseSD = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
                }
                if (baseSD == null || baseSD.getGrouping() == null) break;
                baseSD.getGrouping().unsetEnabled();
            }
        }
    }

    public static boolean isChartInheritGroups(ReportItemHandle handle) {
        return handle.getDataSet() == null && ChartReportItemUtil.isContainerInheritable(handle) && !handle.getBooleanProperty("inheritColumns");
    }

    public static boolean isContainerInheritable(ReportItemHandle itemHandle) {
        DesignElementHandle container = itemHandle.getContainer();
        if (container instanceof CellHandle || container instanceof ListHandle || container instanceof ListGroupHandle) {
            while (container != null) {
                if (container instanceof ListingHandle) {
                    return true;
                }
                container = container.getContainer();
            }
        }
        return false;
    }

    public static ExtendedItemHandle getChartReferenceItemHandle(ReportItemHandle handle) {
        ReportItemHandle refHandle = handle.getDataBindingReference();
        if (refHandle == null || !ChartReportItemUtil.isChartHandle(refHandle)) {
            return null;
        }
        return ChartReportItemUtil.getChartReferenceItemHandleImpl((ExtendedItemHandle)refHandle);
    }

    private static ExtendedItemHandle getChartReferenceItemHandleImpl(ExtendedItemHandle chartHandle) {
        ReportItemHandle refHandle = chartHandle.getDataBindingReference();
        if (refHandle != null && ChartReportItemUtil.isChartHandle(refHandle)) {
            return ChartReportItemUtil.getChartReferenceItemHandleImpl((ExtendedItemHandle)chartHandle.getDataBindingReference());
        }
        return chartHandle;
    }

    public static void copyChartSeriesDefinition(Chart srcCM, Chart targetCM) {
        boolean isSameType = srcCM.getType().equals(targetCM.getType());
        EList srcRsds = ChartUtil.getBaseSeriesDefinitions((Chart)srcCM);
        EList tagRsds = ChartUtil.getBaseSeriesDefinitions((Chart)targetCM);
        int i = 0;
        while (i < srcRsds.size()) {
            SeriesDefinition sd = (SeriesDefinition)srcRsds.get(i);
            SeriesDefinition tagSD = null;
            if (i >= tagRsds.size()) {
                tagSD = SeriesDefinitionImpl.create();
                if (targetCM instanceof ChartWithAxes) {
                    ((Axis)((ChartWithAxes)targetCM).getAxes().get(0)).getSeriesDefinitions().add((Object)tagSD);
                } else if (targetCM instanceof ChartWithoutAxes) {
                    ((ChartWithoutAxes)targetCM).getSeriesDefinitions().add((Object)tagSD);
                }
            } else {
                tagSD = (SeriesDefinition)tagRsds.get(i);
            }
            ChartReportItemUtil.copySDQueryAttributes(sd, tagSD);
            ++i;
        }
        if (targetCM instanceof ChartWithAxes) {
            EList tagAxisList = ((Axis)((ChartWithAxes)targetCM).getAxes().get(0)).getAssociatedAxes();
            if (srcCM instanceof ChartWithAxes) {
                EList srcAxisList = ((Axis)((ChartWithAxes)srcCM).getAxes().get(0)).getAssociatedAxes();
                if (tagAxisList.size() > srcAxisList.size()) {
                    int i2 = tagAxisList.size() - 1;
                    while (i2 >= srcAxisList.size()) {
                        tagAxisList.remove(i2);
                        --i2;
                    }
                }
                if (isSameType) {
                    int i3 = 0;
                    while (i3 < srcAxisList.size()) {
                        if (i3 >= tagAxisList.size()) {
                            tagAxisList.add((Object)((Axis)srcAxisList.get(i3)).copyInstance());
                        }
                        srcRsds = ((Axis)srcAxisList.get(i3)).getSeriesDefinitions();
                        tagRsds = ((Axis)tagAxisList.get(i3)).getSeriesDefinitions();
                        ChartReportItemUtil.copySDListQueryAttributes((EList<SeriesDefinition>)srcRsds, (EList<SeriesDefinition>)tagRsds, isSameType);
                        ++i3;
                    }
                } else {
                    int minsize = srcAxisList.size() > tagAxisList.size() ? tagAxisList.size() : srcAxisList.size();
                    int i4 = 0;
                    while (i4 < minsize) {
                        srcRsds = ((Axis)srcAxisList.get(i4)).getSeriesDefinitions();
                        tagRsds = ((Axis)tagAxisList.get(i4)).getSeriesDefinitions();
                        ChartReportItemUtil.copySDListQueryAttributes((EList<SeriesDefinition>)srcRsds, (EList<SeriesDefinition>)tagRsds, isSameType);
                        ++i4;
                    }
                }
            } else {
                srcRsds = ((SeriesDefinition)((ChartWithoutAxes)srcCM).getSeriesDefinitions().get(0)).getSeriesDefinitions();
                if (tagAxisList.size() > 1) {
                    int i5 = 1;
                    while (i5 < tagAxisList.size()) {
                        tagAxisList.remove(i5);
                        ++i5;
                    }
                }
                tagRsds = ((Axis)tagAxisList.get(0)).getSeriesDefinitions();
                ChartReportItemUtil.copySDListQueryAttributes((EList<SeriesDefinition>)srcRsds, (EList<SeriesDefinition>)tagRsds, isSameType);
            }
        } else {
            tagRsds = ((SeriesDefinition)((ChartWithoutAxes)targetCM).getSeriesDefinitions().get(0)).getSeriesDefinitions();
            srcRsds = srcCM instanceof ChartWithAxes ? ((Axis)((Axis)((ChartWithAxes)srcCM).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions() : ((SeriesDefinition)((ChartWithoutAxes)srcCM).getSeriesDefinitions().get(0)).getSeriesDefinitions();
            ChartReportItemUtil.copySDListQueryAttributes((EList<SeriesDefinition>)srcRsds, (EList<SeriesDefinition>)tagRsds, isSameType);
        }
    }

    private static void copySDListQueryAttributes(EList<SeriesDefinition> srcRsds, EList<SeriesDefinition> tagRsds, boolean sameChartType) {
        int i;
        if (tagRsds.size() > srcRsds.size()) {
            i = tagRsds.size() - 1;
            while (i >= srcRsds.size()) {
                tagRsds.remove(i);
                --i;
            }
        }
        if (sameChartType) {
            i = 0;
            while (i < srcRsds.size()) {
                if (i >= tagRsds.size()) {
                    tagRsds.add((Object)((SeriesDefinition)srcRsds.get(i)).copyInstance());
                }
                SeriesDefinition sd = (SeriesDefinition)srcRsds.get(i);
                SeriesDefinition tagSD = (SeriesDefinition)tagRsds.get(i);
                ChartReportItemUtil.copySDQueryAttributes(sd, tagSD);
                ++i;
            }
        } else {
            int minSDsize = srcRsds.size() > tagRsds.size() ? tagRsds.size() : srcRsds.size();
            int i2 = 0;
            while (i2 < minSDsize) {
                SeriesDefinition sd = (SeriesDefinition)srcRsds.get(i2);
                SeriesDefinition tagSD = (SeriesDefinition)tagRsds.get(i2);
                ChartReportItemUtil.copySDQueryAttributes(sd, tagSD);
                ++i2;
            }
        }
    }

    private static void copySDQueryAttributes(SeriesDefinition sd, SeriesDefinition tagSD) {
        int i;
        int srcSize;
        int tagSize;
        if (sd.getQuery() != null) {
            tagSD.setQuery(sd.getQuery().copyInstance());
        } else {
            tagSD.setQuery(null);
        }
        if (sd.getGrouping() != null) {
            tagSD.setGrouping(sd.getGrouping().copyInstance());
        } else {
            tagSD.setGrouping(null);
        }
        if (sd.isSetSorting()) {
            tagSD.setSorting(sd.getSorting());
        }
        if (sd.getSortKey() != null) {
            tagSD.setSortKey(sd.getSortKey().copyInstance());
        } else {
            tagSD.setSortKey(null);
        }
        if (sd.isSetZOrder()) {
            tagSD.setZOrder(sd.getZOrder());
        }
        if ((tagSize = tagSD.getSeries().size()) > (srcSize = sd.getSeries().size())) {
            i = tagSize - 1;
            while (i >= srcSize) {
                tagSD.getSeries().remove(i);
                --i;
            }
        }
        i = 0;
        while (i < srcSize) {
            Series srcSeries;
            Series tagSeries;
            if (i >= tagSize) {
                tagSeries = ((Series)tagSD.getSeries().get(0)).copyInstance();
                tagSD.getSeries().add((Object)tagSeries);
                srcSeries = (Series)sd.getSeries().get(i);
                tagSeries.getDataDefinition().clear();
                for (Query q : srcSeries.getDataDefinition()) {
                    tagSeries.getDataDefinition().add((Object)q.copyInstance());
                }
            } else {
                tagSeries = (Series)tagSD.getSeries().get(i);
                srcSeries = (Series)sd.getSeries().get(i);
                tagSeries.getDataDefinition().clear();
                for (Query q : srcSeries.getDataDefinition()) {
                    tagSeries.getDataDefinition().add((Object)q.copyInstance());
                }
            }
            ++i;
        }
    }

    public static boolean checkChartBindingComplete(Chart cm) {
        Series bs = ((SeriesDefinition)ChartUtil.getBaseSeriesDefinitions((Chart)cm).get(0)).getDesignTimeSeries();
        if (bs.getDataDefinition().size() == 0 || ChartUtil.isEmpty((String)((Query)bs.getDataDefinition().get(0)).getDefinition())) {
            return false;
        }
        for (SeriesDefinition vsd : ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm)) {
            Series vs = vsd.getDesignTimeSeries();
            if (vs.getDataDefinition().size() != 0 && !ChartUtil.isEmpty((String)((Query)vs.getDataDefinition().get(0)).getDefinition())) continue;
            return false;
        }
        return true;
    }

    public static <T> T getAdapter(Object adaptable, Class<T> adapterClass) {
        IAdapterManager adapterManager = Platform.getAdapterManager();
        return adapterClass.cast(adapterManager.loadAdapter(adaptable, adapterClass.getName()));
    }

    public static Serializer instanceSerializer(ExtendedItemHandle handle) {
        IChartReportItemFactory factory = ChartReportItemUtil.getAdapter(handle, IChartReportItemFactory.class);
        if (factory != null) {
            return factory.createSerializer(handle);
        }
        return SerializerImpl.instance();
    }
}

