/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.reportitem.ChartBaseQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartSharingQueryHelper
extends ChartBaseQueryHelper {
    public ChartSharingQueryHelper(ReportItemHandle handle, Chart cm) {
        super(handle, cm);
    }

    public ChartSharingQueryHelper(ReportItemHandle handle, Chart cm, boolean bCreateBindingForExpression) {
        super(handle, cm, bCreateBindingForExpression);
    }

    public IDataQueryDefinition createQuery(IDataQueryDefinition parent) throws BirtException {
        BaseQueryDefinition query = this.createQueryDefinition(parent);
        if (query == null) {
            return null;
        }
        List<GroupHandle> groups = this.getGroups();
        Iterator<GroupHandle> iter = groups.iterator();
        while (iter.hasNext()) {
            ChartSharingQueryHelper.handleGroup(iter.next(), (IBaseQueryDefinition)query);
        }
        if (ChartReportItemUtil.isChartInheritGroups(this.fReportItemHandle)) {
            ListingHandle table = null;
            DesignElementHandle container = this.fReportItemHandle.getContainer();
            while (container != null) {
                if (container instanceof ListingHandle) {
                    table = (ListingHandle)container;
                    break;
                }
                container = container.getContainer();
            }
            if (table != null) {
                Iterator iterator = table.columnBindingsIterator();
                while (iterator.hasNext()) {
                    ComputedColumnHandle binding = (ComputedColumnHandle)iterator.next();
                    if (binding.getAggregateFunction() == null) continue;
                    this.addColumBinding((IBaseQueryDefinition)query, binding);
                }
            }
        }
        return query;
    }

    private List<GroupHandle> getGroups() {
        ArrayList<GroupHandle> groupList = new ArrayList<GroupHandle>();
        ListingHandle table = null;
        if (this.fReportItemHandle instanceof ListingHandle) {
            table = (ListingHandle)this.fReportItemHandle;
        } else if (ChartReportItemUtil.isChartInheritGroups(this.fReportItemHandle)) {
            DesignElementHandle container = this.fReportItemHandle.getContainer();
            while (container != null) {
                if (container instanceof ListingHandle) {
                    table = (ListingHandle)container;
                    break;
                }
                container = container.getContainer();
            }
        }
        if (table != null) {
            SlotHandle groups = table.getGroups();
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                groupList.add((GroupHandle)iter.next());
            }
        }
        return groupList;
    }

    @Override
    protected void addSortAndFilter(ReportItemHandle handle, BaseQueryDefinition query) {
        super.addSortAndFilter(handle, query);
        if (handle instanceof ListingHandle) {
            query.getSorts().addAll(ChartSharingQueryHelper.createSorts(((ListingHandle)handle).sortsIterator()));
        }
    }
}

