/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.reportitem.ChartReportItemConstants;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.data.IDimLevel;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.olap.api.query.ICubeElementFactory;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartXTabUtil
extends ChartReportItemUtil
implements ChartReportItemConstants {
    private static ICubeElementFactory cubeFactory = null;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    protected static final DimensionValue DEFAULT_COLUMN_WIDTH = new DimensionValue(80.0, "pt");
    protected static final DimensionValue DEFAULT_ROW_HEIGHT = new DimensionValue(30.0, "pt");

    public static synchronized ICubeElementFactory getCubeElementFactory() throws BirtException {
        if (cubeFactory != null) {
            return cubeFactory;
        }
        try {
            Class<?> cls = Class.forName("org.eclipse.birt.data.engine.olap.impl.query.CubeElementFactory");
            cubeFactory = (ICubeElementFactory)SecurityUtil.newClassInstance(cls);
        }
        catch (Exception e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 4, (Throwable)e);
        }
        return cubeFactory;
    }

    public static CubeHandle getBindingCube(DesignElementHandle element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ReportItemHandle) {
            CubeHandle cube = ((ReportItemHandle)element).getCube();
            if (cube != null) {
                return cube;
            }
            if (((ReportItemHandle)element).getDataBindingType() == 2) {
                return ChartXTabUtil.getBindingCube((DesignElementHandle)((ReportItemHandle)element).getDataBindingReference());
            }
            if (((ReportItemHandle)element).getDataBindingType() == 1) {
                return null;
            }
        }
        if (element.getContainer() != null) {
            return ChartXTabUtil.getBindingCube(element.getContainer());
        }
        return null;
    }

    public static List<MeasureHandle> getAllMeasures(CubeHandle cube) {
        if (cube.getContentCount("measureGroups") > 0) {
            ArrayList<MeasureHandle> measures = new ArrayList<MeasureHandle>();
            for (MeasureGroupHandle measureGroup : cube.getContents("measureGroups")) {
                measures.addAll(measureGroup.getContents("measures"));
            }
            return measures;
        }
        return Collections.emptyList();
    }

    public static List<LevelHandle> getAllLevels(CubeHandle cube) {
        if (cube.getContentCount("dimensions") > 0) {
            ArrayList<LevelHandle> levels = new ArrayList<LevelHandle>();
            for (DimensionHandle dimensionHandle : cube.getContents("dimensions")) {
                HierarchyHandle hierarchy = (HierarchyHandle)dimensionHandle.getContent("hierarchies", 0);
                int count = hierarchy.getLevelCount();
                int i = 0;
                while (i < count) {
                    levels.add(hierarchy.getLevel(i));
                    ++i;
                }
            }
            return levels;
        }
        return Collections.emptyList();
    }

    public static int getDimensionCount(CubeHandle cube) {
        if (cube == null) {
            return 0;
        }
        return cube.getContentCount("dimensions");
    }

    public static List<String> getAllLevelsBindingExpression(CrosstabReportItemHandle xtab) {
        DataItemHandle dataItemHandle;
        ArrayList<String> levels = new ArrayList<String>();
        Object content = ChartXTabUtil.getFirstContent(ChartXTabUtil.getInnermostLevelCell(xtab, 1));
        if (content instanceof DataItemHandle) {
            dataItemHandle = (DataItemHandle)content;
            levels.add(ExpressionUtil.createJSDataExpression((String)dataItemHandle.getResultSetColumn()));
        }
        if ((content = ChartXTabUtil.getFirstContent(ChartXTabUtil.getInnermostLevelCell(xtab, 0))) instanceof DataItemHandle) {
            dataItemHandle = (DataItemHandle)content;
            levels.add(ExpressionUtil.createJSDataExpression((String)dataItemHandle.getResultSetColumn()));
        }
        return levels;
    }

    public static List<String> getAllLevelsBindingExpression(Iterator columnBindings) {
        ArrayList<String> bindings = new ArrayList<String>();
        while (columnBindings.hasNext()) {
            ComputedColumnHandle cc = (ComputedColumnHandle)columnBindings.next();
            if (!ChartXTabUtil.isDimensionExpresion(cc.getExpression())) continue;
            bindings.add(ExpressionUtil.createJSDataExpression((String)cc.getName()));
        }
        return bindings;
    }

    public static List<String> getAllMeasuresBindingExpression(Iterator columnBindings) {
        ArrayList<String> bindings = new ArrayList<String>();
        while (columnBindings.hasNext()) {
            ComputedColumnHandle cc = (ComputedColumnHandle)columnBindings.next();
            if (ChartXTabUtil.isMeasureExpresion(ChartXTabUtil.getAggregationExpression(cc))) {
                bindings.add(ExpressionUtil.createJSDataExpression((String)cc.getName()));
                continue;
            }
            if (!"COUNT".equals(cc.getAggregateFunction()) && !"COUNTDISTINCT".equals(cc.getAggregateFunction())) continue;
            bindings.add(ExpressionUtil.createJSDataExpression((String)cc.getName()));
        }
        return bindings;
    }

    private static String getAggregationExpression(ComputedColumnHandle bindingColumn) {
        if (bindingColumn.getExpression() != null) {
            return bindingColumn.getExpression();
        }
        String functionName = bindingColumn.getAggregateFunction();
        try {
            IAggrFunction function = AggregationManager.getInstance().getAggregation(functionName);
            IParameterDefn[] iParameterDefnArray = function.getParameterDefn();
            int n = iParameterDefnArray.length;
            int n2 = 0;
            while (n2 < n) {
                IParameterDefn param = iParameterDefnArray[n2];
                if (param.isDataField()) {
                    Iterator iterator = bindingColumn.argumentsIterator();
                    while (iterator.hasNext()) {
                        AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
                        if (!arg.getName().equals(param.getName())) continue;
                        return arg.getValue();
                    }
                }
                ++n2;
            }
        }
        catch (BirtException e) {
            logger.log((Exception)((Object)e));
        }
        return null;
    }

    public static Object getFirstContent(CrosstabCellHandle cell) {
        List contents;
        if (cell != null && (contents = cell.getContents()) != null && contents.size() >= 1) {
            return contents.get(0);
        }
        return null;
    }

    public static LevelViewHandle getLevel(CrosstabReportItemHandle xtab, int axisType, int levelIndex) {
        if (xtab == null) {
            return null;
        }
        CrosstabViewHandle xtabView = xtab.getCrosstabView(axisType);
        if (xtabView == null) {
            return null;
        }
        int countAll = 0;
        int dimensionCount = xtabView.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dim = xtabView.getDimension(i);
            if (dim != null) {
                if (levelIndex >= countAll && levelIndex < countAll + dim.getLevelCount()) {
                    return dim.getLevel(levelIndex - countAll);
                }
                countAll += dim.getLevelCount();
            }
            ++i;
        }
        return null;
    }

    public static CrosstabCellHandle getInnermostLevelCell(CrosstabReportItemHandle xtab, int axisType) {
        int levelCount = ChartXTabUtil.getLevelCount(xtab, axisType);
        LevelViewHandle levelView = ChartXTabUtil.getLevel(xtab, axisType, levelCount - 1);
        if (levelView != null) {
            return levelView.getCell();
        }
        return null;
    }

    public static int getLevelCount(CrosstabReportItemHandle xtab, int axisType) {
        if (xtab == null) {
            return 0;
        }
        CrosstabViewHandle xtabView = xtab.getCrosstabView(axisType);
        if (xtabView == null) {
            return 0;
        }
        int countAll = 0;
        int dimensionCount = xtabView.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dim = xtabView.getDimension(i);
            if (dim != null) {
                countAll += dim.getLevelCount();
            }
            ++i;
        }
        return countAll;
    }

    public static AggregationCellHandle getXtabContainerCell(DesignElementHandle chartHandle) throws BirtException {
        ExtendedItemHandle xtabHandle;
        String exName;
        DesignElementHandle container = chartHandle.getContainer();
        if (container instanceof ExtendedItemHandle && "AggregationCell".equals(exName = (xtabHandle = (ExtendedItemHandle)container).getExtensionName())) {
            return (AggregationCellHandle)xtabHandle.getReportItem();
        }
        return null;
    }

    public static String createDimensionExpression(LevelHandle level) {
        if (level == null) {
            return null;
        }
        return ExpressionUtil.createJSDimensionExpression((String)level.getContainer().getContainer().getName(), (String)level.getName());
    }

    public static String createMeasureExpression(MeasureHandle measure) {
        if (measure == null) {
            return null;
        }
        return ExpressionUtil.createJSMeasureExpression((String)measure.getName());
    }

    public static String createLevelBindingName(LevelHandle level) {
        if (level == null) {
            return null;
        }
        return String.valueOf(level.getContainer().getContainer().getName()) + "/" + level.getName();
    }

    public static String createMeasureBindingName(MeasureHandle measure) {
        if (measure == null) {
            return null;
        }
        return String.valueOf(measure.getContainer().getName()) + "/" + measure.getName();
    }

    public static ComputedColumnHandle findBinding(ReportItemHandle handle, String expression) {
        if (expression != null) {
            Iterator<ComputedColumnHandle> bindings = ChartXTabUtil.getAllColumnBindingsIterator(handle);
            while (bindings.hasNext()) {
                ComputedColumnHandle cc = bindings.next();
                if (!expression.equals(cc.getExpression())) continue;
                return cc;
            }
        }
        return null;
    }

    public static boolean isInXTabMeasureCell(DesignElementHandle chartHandle) {
        String exName;
        DesignElementHandle container = chartHandle.getContainer();
        return container instanceof ExtendedItemHandle && "AggregationCell".equals(exName = ((ExtendedItemHandle)container).getExtensionName());
    }

    public static boolean isPlotChart(DesignElementHandle chartHandle) {
        if (ChartReportItemUtil.isChartHandle(chartHandle)) {
            return "plotChart".equals(chartHandle.getProperty("chartType"));
        }
        return false;
    }

    public static boolean isAxisChart(DesignElementHandle chartHandle) {
        if (ChartReportItemUtil.isChartHandle(chartHandle)) {
            return "axisChart".equals(chartHandle.getProperty("chartType"));
        }
        return false;
    }

    public static Chart updateModelToRenderPlot(Chart cm, boolean bRtL) {
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes chart = (ChartWithAxes)cm;
            boolean bTransposed = chart.isTransposed();
            chart.getLegend().setVisible(false);
            chart.getTitle().setVisible(false);
            chart.getBlock().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.setReverseCategory(bTransposed || bRtL);
            chart.getPlot().getOutline().setVisible(false);
            chart.getPlot().getClientArea().setVisible(true);
            chart.getPlot().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.getPlot().getClientArea().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.getPlot().setVerticalSpacing(0);
            chart.getPlot().setHorizontalSpacing(0);
            Axis xAxis = (Axis)chart.getAxes().get(0);
            Axis yAxis = (Axis)xAxis.getAssociatedAxes().get(0);
            xAxis.getTitle().setVisible(false);
            xAxis.getLabel().setVisible(false);
            xAxis.getLineAttributes().setVisible(false);
            xAxis.getMajorGrid().getTickAttributes().setVisible(false);
            xAxis.getMinorGrid().getTickAttributes().setVisible(false);
            xAxis.setCategoryAxis(true);
            yAxis.getTitle().setVisible(false);
            yAxis.getLabel().setVisible(false);
            yAxis.getLineAttributes().setVisible(false);
            yAxis.getMajorGrid().getTickAttributes().setVisible(false);
            yAxis.getMinorGrid().getTickAttributes().setVisible(false);
            yAxis.setLabelWithinAxes(true);
        }
        return cm;
    }

    public static Chart updateModelToRenderAxis(Chart cm, boolean bRtL) {
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes chart = (ChartWithAxes)cm;
            chart.getLegend().setVisible(false);
            chart.getTitle().setVisible(false);
            chart.getPlot().getOutline().setVisible(false);
            chart.getPlot().getClientArea().setVisible(false);
            chart.getBlock().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.getPlot().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.getPlot().getClientArea().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.getPlot().setVerticalSpacing(0);
            chart.getPlot().setHorizontalSpacing(0);
            boolean bTransposed = chart.isTransposed();
            Axis xAxis = (Axis)chart.getAxes().get(0);
            Axis yAxis = (Axis)xAxis.getAssociatedAxes().get(0);
            xAxis.getTitle().setVisible(false);
            xAxis.getLabel().setVisible(false);
            xAxis.getLineAttributes().setVisible(false);
            xAxis.getMajorGrid().getTickAttributes().setVisible(false);
            xAxis.getMajorGrid().getLineAttributes().setVisible(false);
            xAxis.getMinorGrid().getTickAttributes().setVisible(false);
            xAxis.getMinorGrid().getLineAttributes().setVisible(false);
            yAxis.getLabel().setVisible(true);
            yAxis.getMajorGrid().getTickAttributes().setVisible(true);
            yAxis.getTitle().setVisible(false);
            yAxis.getLineAttributes().setVisible(false);
            yAxis.getMajorGrid().getLineAttributes().setVisible(false);
            yAxis.getMinorGrid().getLineAttributes().setVisible(false);
            yAxis.getMajorGrid().setTickStyle(bTransposed || bRtL ? TickStyle.LEFT_LITERAL : TickStyle.RIGHT_LITERAL);
            yAxis.setLabelPosition(bTransposed || bRtL ? Position.LEFT_LITERAL : Position.RIGHT_LITERAL);
            yAxis.setLabelWithinAxes(true);
            if (bTransposed) {
                yAxis.getOrigin().setType(IntersectionType.MAX_LITERAL);
            }
        } else {
            cm = null;
        }
        return cm;
    }

    public static boolean isDimensionExpresion(String expression) {
        return expression != null && expression.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E");
    }

    public static String[] getLevelNameFromDimensionExpression(String expr) {
        if (ChartXTabUtil.isDimensionExpresion(expr)) {
            try {
                Set levels = ExpressionUtil.getReferencedDimLevel((String)expr);
                if (!levels.isEmpty()) {
                    IDimLevel level = (IDimLevel)levels.iterator().next();
                    return new String[]{level.getDimensionName(), level.getLevelName()};
                }
            }
            catch (BirtException e) {
                logger.log((Exception)((Object)e));
            }
        }
        return null;
    }

    public static boolean isMeasureExpresion(String expression) {
        return expression != null && expression.matches("\\Qmeasure[\"\\E.*\\Q\"]\\E");
    }

    public static String getMeasureName(String expr) {
        if (ChartXTabUtil.isMeasureExpresion(expr)) {
            try {
                return ExpressionUtil.getReferencedMeasure((String)expr);
            }
            catch (BirtException e) {
                logger.log((Exception)((Object)e));
            }
        }
        return null;
    }

    public static String getBindingName(String expr, boolean hasOperation) {
        if (ChartXTabUtil.isBinding(expr, hasOperation)) {
            try {
                List bindings = ExpressionUtil.extractColumnExpressions((String)expr, (String)"data");
                if (!bindings.isEmpty()) {
                    return ((IColumnBinding)bindings.get(0)).getResultSetColumnName();
                }
            }
            catch (BirtException e) {
                logger.log((Exception)((Object)e));
            }
        }
        return null;
    }

    public static List<String> getBindingNameList(String expr) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            List bindings = ExpressionUtil.extractColumnExpressions((String)expr, (String)"data");
            for (IColumnBinding binding : bindings) {
                names.add(binding.getResultSetColumnName());
            }
        }
        catch (BirtException e) {
            logger.log((Exception)((Object)e));
        }
        return names;
    }

    public static boolean isBinding(String expr, boolean hasOperation) {
        if (expr == null) {
            return false;
        }
        String regExp = hasOperation ? ".*\\Qdata[\"\\E.*\\Q\"]\\E.*" : "\\Qdata[\"\\E.*\\Q\"]\\E";
        return expr.matches(regExp);
    }

    public static String generateComputedColumnName(AggregationCellHandle cell) {
        MeasureViewHandle measureView = (MeasureViewHandle)cell.getContainer();
        LevelHandle rowLevelHandle = cell.getAggregationOnRow();
        LevelHandle colLevelHandle = cell.getAggregationOnColumn();
        String aggregationOnRow = rowLevelHandle == null ? null : rowLevelHandle.getFullName();
        String aggregationOnColumn = colLevelHandle == null ? null : colLevelHandle.getFullName();
        String name = "";
        String temp = measureView.getCubeMeasureName();
        if (temp != null && temp.length() > 0) {
            name = String.valueOf(name) + temp;
        }
        if (aggregationOnRow != null && aggregationOnRow.length() > 0) {
            name = name.length() > 0 ? String.valueOf(name) + "_" + aggregationOnRow : String.valueOf(name) + aggregationOnRow;
        }
        if (aggregationOnColumn != null && aggregationOnColumn.length() > 0) {
            name = name.length() > 0 ? String.valueOf(name) + "_" + aggregationOnColumn : String.valueOf(name) + aggregationOnColumn;
        }
        if (name.length() <= 0) {
            name = "measure";
        }
        ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)cell.getCrosstabHandle(), (String)name);
        String dataType = measureView.getDataType();
        column.setDataType(dataType);
        column.setExpression(ExpressionUtil.createJSMeasureExpression((String)measureView.getCubeMeasureName()));
        column.setAggregateFunction(ChartXTabUtil.getDefaultMeasureAggregationFunction(measureView));
        if (aggregationOnRow != null) {
            column.addAggregateOn(aggregationOnRow);
        }
        if (aggregationOnColumn != null) {
            column.addAggregateOn(aggregationOnColumn);
        }
        try {
            ComputedColumnHandle columnHandle = ((ReportItemHandle)cell.getCrosstabHandle()).addColumnBinding(column, false);
            return columnHandle.getName();
        }
        catch (SemanticException e) {
            logger.log((Exception)((Object)e));
            return name;
        }
    }

    static String getDefaultMeasureAggregationFunction(MeasureViewHandle mv) {
        String func;
        if (mv != null && mv.getCubeMeasure() != null && (func = mv.getCubeMeasure().getFunction()) != null) {
            return ChartXTabUtil.getRollUpAggregationFunction(func);
        }
        return "sum";
    }

    static String getRollUpAggregationFunction(String functionName) {
        if ("average".equals(functionName) || "count".equals(functionName) || "count-distinct".equals(functionName)) {
            return "sum";
        }
        return functionName;
    }

    public static List<String> getRelatedBindingNames(String dimExpr, Collection values) {
        ArrayList<String> bindingNames = new ArrayList<String>(1);
        for (ComputedColumnHandle cch : values) {
            if (!dimExpr.equals(cch.getExpression())) continue;
            bindingNames.add(cch.getName());
        }
        return bindingNames;
    }

    public static ExtendedItemHandle findReferenceChart(ExtendedItemHandle chartHandle) {
        if (ChartXTabUtil.isAxisChart((DesignElementHandle)chartHandle)) {
            return (ExtendedItemHandle)chartHandle.getElementProperty("hostChart");
        }
        if (ChartXTabUtil.isPlotChart((DesignElementHandle)chartHandle)) {
            Iterator iterator = chartHandle.clientsIterator();
            while (iterator.hasNext()) {
                DesignElementHandle client = (DesignElementHandle)iterator.next();
                if (!ChartXTabUtil.isAxisChart(client)) continue;
                return (ExtendedItemHandle)client;
            }
        }
        return null;
    }

    public static boolean isDetailCell(AggregationCellHandle cell) {
        return "detail".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
    }

    public static boolean isAggregationCell(AggregationCellHandle cell) {
        return "aggregations".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
    }

    public static int getXTabAxisType(boolean bTransposed) {
        return bTransposed ? 0 : 1;
    }
}

