/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.romdoc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.birt.doc.romdoc.DataTypeParser;
import org.eclipse.birt.doc.romdoc.DocChoice;
import org.eclipse.birt.doc.romdoc.DocComparator;
import org.eclipse.birt.doc.romdoc.DocComposite;
import org.eclipse.birt.doc.romdoc.DocElement;
import org.eclipse.birt.doc.romdoc.DocInheritedProperty;
import org.eclipse.birt.doc.romdoc.DocMethod;
import org.eclipse.birt.doc.romdoc.DocParser;
import org.eclipse.birt.doc.romdoc.DocProperty;
import org.eclipse.birt.doc.romdoc.DocPropertyType;
import org.eclipse.birt.doc.romdoc.DocSlot;
import org.eclipse.birt.doc.romdoc.DocStructure;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.birt.report.model.api.metadata.IPropertyType;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaDataReader;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StructureDefn;

public class Generator {
    ArrayList elements = new ArrayList();
    ArrayList structs = new ArrayList();
    PrintStream writer;
    PrintStream index;
    private static final String PROPERTY_NAME = "Property";
    private static final String METHOD_NAME = "Method";
    private static final String SLOT_NAME = "Slot";
    private String typeHeader;
    ArrayList propertyTypes = new ArrayList();
    String outputDir = "romdoc/gen";
    String templateDir = "romdoc/docs";

    public void generate() throws Exception {
        this.loadModel();
        this.createDocObjects();
        this.loadElementDocs();
        this.loadStructureDocs();
        this.loadTypeDoc();
        this.semanticCheck();
        this.writeDocs();
    }

    private void loadModel() throws MetaDataParserException {
        try {
            MetaDataReader.read(ReportDesign.class.getResourceAsStream("rom.def"));
        }
        catch (MetaDataParserException e) {
            System.out.println("rom.def load failed.");
            throw e;
        }
    }

    public void setOutputDir(String dir) {
        this.outputDir = dir;
    }

    public void setTemplateDir(String dir) {
        this.templateDir = dir;
    }

    private void createDocObjects() {
        this.createElements();
        this.createStructures();
        this.createTypes();
    }

    private void createElements() {
        MetaDataDictionary dict = MetaDataDictionary.getInstance();
        for (ElementDefn elementDefn : dict.getElements()) {
            DocElement element = new DocElement(elementDefn);
            this.elements.add(element);
        }
        Collections.sort(this.elements, new DocComparator());
    }

    private void createStructures() {
        MetaDataDictionary dict = MetaDataDictionary.getInstance();
        for (StructureDefn structureDefn : dict.getStructures()) {
            DocStructure struct = new DocStructure(structureDefn);
            this.structs.add(struct);
        }
        Collections.sort(this.structs, new DocComparator());
    }

    private void createTypes() {
        MetaDataDictionary dict = MetaDataDictionary.getInstance();
        List<IPropertyType> list = dict.getPropertyTypes();
        Collections.sort(list, new TypeComparator());
        for (PropertyType propertyType : list) {
            DocPropertyType type = new DocPropertyType(propertyType);
            this.propertyTypes.add(type);
        }
    }

    private void loadElementDocs() {
        for (DocElement element : this.elements) {
            DocParser parser = new DocParser(this);
            try {
                parser.parse(element);
            }
            catch (DocParser.ParseException parseException) {
                System.err.println("Parse of document file for element " + element.getName() + " failed.");
            }
        }
    }

    private void loadStructureDocs() {
        for (DocStructure struct : this.structs) {
            DocParser parser = new DocParser(this);
            try {
                parser.parse(struct);
            }
            catch (DocParser.ParseException parseException) {
                System.err.println("Parse of document file for element " + struct.getName() + " failed.");
            }
        }
    }

    private void loadTypeDoc() {
        DataTypeParser parser = new DataTypeParser(this);
        try {
            parser.parse();
        }
        catch (DocParser.ParseException parseException) {
            System.err.println("Parse of property types file failed.");
        }
    }

    private void semanticCheck() {
    }

    private void writeDocs() throws IOException {
        this.startIndex();
        this.writeElements();
        this.writeStructures();
        this.write(this.index, "<h1>Supporting Indexes</h1>\n<table class=\"summary-table\">\n");
        this.writeTypes();
        this.writeStyles();
        this.writePropertyIndex();
        this.writeInheritanceTable();
        this.write(this.index, "</table><br>\n\n");
        this.endIndex();
    }

    private void writeElements() throws IOException {
        this.write(this.index, "<h1>Elements</h1>\n<table class=\"summary-table\">\n");
        for (DocElement element : this.elements) {
            try {
                this.write(element);
            }
            catch (IOException e) {
                System.out.println("Failed to write file for Element " + element.getName());
                throw e;
            }
        }
        this.write(this.index, "</table>\n\n");
    }

    private void write(String s) {
        this.write(this.writer, s);
    }

    private void write(PrintStream out, String s) {
        if (s == null) {
            return;
        }
        if (s.indexOf(10) == -1) {
            out.print(s);
            return;
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\n') {
                out.println();
            } else {
                out.print(c);
            }
            ++i;
        }
    }

    private void writeln(String s) {
        this.write(s);
        this.writer.println();
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private void startIndex() throws IOException {
        File output = this.makeFile(null, "index.html");
        try {
            this.index = new PrintStream(new FileOutputStream(output));
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open the index.html file.");
            throw e;
        }
        this.write(this.index, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.0 transitional//EN\">\n");
        this.write(this.index, "<html>\n<head>\n<title>BIRT ROM Documentation</title>\n");
        this.write(this.index, "<link rel=\"stylesheet\" href=\"style/style.css\" type=\"text/css\"/>\n");
        this.write(this.index, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n");
        this.write(this.index, "</head>\n<body>\n");
        this.write(this.index, "<p class=\"title\">Eclipse BIRT Report Object Model (ROM)</p>\n");
        this.write(this.index, "<p class=\"subtitle\">Table of Contents</p>\n");
    }

    private void endIndex() {
        this.write(this.index, "</body>\n</html>\n");
        this.index.close();
    }

    private File makeFile(String relativeDir, String fileName) throws IOException {
        File output;
        File dir;
        if (relativeDir == null) {
            relativeDir = "";
        }
        if (!(dir = new File(String.valueOf(this.outputDir) + "/" + relativeDir)).exists()) {
            dir.mkdir();
        }
        if (!(output = new File(dir, fileName)).exists()) {
            output.createNewFile();
        }
        return output;
    }

    private void write(DocElement element) throws IOException {
        File output = this.makeFile("elements", String.valueOf(element.getName()) + ".html");
        this.writer = new PrintStream(new FileOutputStream(output));
        this.writeIndexEntry(element);
        this.writeHeader(element);
        this.writeElement(element);
        this.writeProperties(element);
        this.writeMethods(element);
        this.writeSlots(element);
        this.writeFooter();
        this.writer.close();
    }

    private void writeHeader(DocComposite obj) {
        this.writeln("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.0 transitional//EN\">");
        this.write("<html>\n<head>\n<title>");
        String title = obj.getDisplayName();
        if (this.isBlank(obj.getDisplayName())) {
            title = obj.getName();
        }
        this.write(title);
        this.writeln(" Element (Eclipse BIRT ROM Documentation)</title>");
        this.writeln("<link rel=\"stylesheet\" href=\"../style/style.css\" type=\"text/css\"/>");
        this.writeln("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        this.writeln("</head>\n<body>");
        this.writeln("<p class=\"title\">Eclipse BIRT Report Object Model (ROM)</p>");
        this.write("<p class=\"subtitle\">");
        this.write(obj.getName());
        if (obj.isElement()) {
            this.write(" Element");
        } else {
            this.write(" Structure");
        }
        this.writeln("</p>");
    }

    private void writeIndexEntry(DocComposite obj) {
        this.write(this.index, "<tr><td><a href=\"");
        if (obj.isElement()) {
            this.write(this.index, "elements/");
        } else {
            this.write(this.index, "structs/");
        }
        this.write(this.index, obj.getName());
        this.write(this.index, ".html\">");
        this.write(this.index, obj.getName());
        this.write(this.index, "</a></td>\n<td>");
        this.write(this.index, obj.getSummary());
        this.write(this.index, "</td></tr>\n");
    }

    private void writeElement(DocElement element) {
        this.write("<h1>Element Overview</h1>\n");
        this.writeSectionBody(element.getSummary());
        this.writeDetails(element);
        this.writePropertySummary(element);
        this.writeMethodSummary(element);
        this.writeSlotSummary(element);
        this.writeInheritedProperties(element);
        this.writeStyleProperties(element);
        this.writeInheritedMethods(element);
        this.writeInheritedSlots(element);
        this.writeSection("Description", element.getDescription());
        this.writeSection("XML Summary", element.getXmlSummary());
        this.writeSection("See Also", element.getSeeAlso());
    }

    private void writeSection(String title, String body) {
        if (this.isBlank(body)) {
            return;
        }
        this.writeSectionHeader(title);
        this.writeSectionBody(body);
    }

    private void writeSectionBody(String body) {
        if (this.isBlank(body)) {
            return;
        }
        this.writeln("<div class=\"section-text\">");
        this.write(body);
        this.writeln("</div>");
    }

    private void writeSectionHeader(String title) {
        this.write("<h3>");
        this.write(title);
        this.writeln("</h3>\n");
    }

    private void writeDetails(DocElement element) {
        this.writeSectionHeader("Details");
        this.startDetailsTable();
        this.detailRow("Display Name", element.getDisplayName());
        this.detailRow("Since", element.getSince());
        this.detailRow("XML Element", "<code>" + element.getXmlElement() + "</code>");
        this.detailRow("Extends", element.getExtends());
        this.detailRow("Extendable", element.getExtendable());
        this.detailRow("Abstract", element.getAbstract());
        this.detailRow("Name Space", element.getNameSpace());
        this.detailRow("Name Requirement", element.getNameRequirement());
        this.detailRow("Allows User Properties", element.getUserProperties());
        this.detailRow("Has Style", element.getHasStyle());
        if (element.hasStyle()) {
            this.detailRow("Default Style", element.getStyle());
        }
        this.endDetailsTable();
    }

    private void startSummaryTable(String title) {
        this.writeSectionHeader(String.valueOf(title) + " Summary");
        this.writeln("<dl class=\"section-text\">");
    }

    private void summaryTableRow(String type, String name, String summary) {
        this.write("<dt><a href=\"#");
        this.write(Generator.getTagName(type, name));
        this.write("\">");
        this.write(name);
        this.write("</a></dt>\n<dd>");
        this.write(summary);
        this.writeln("</dd>");
    }

    private void finishSummaryTable() {
        this.writeln("</dl>\n");
    }

    private void writePropertySummary(DocComposite obj) {
        if (!obj.hasProperties()) {
            return;
        }
        this.startSummaryTable(PROPERTY_NAME);
        for (DocProperty prop : obj.getProperties()) {
            this.summaryTableRow(PROPERTY_NAME, prop.getName(), prop.getSummary());
        }
        this.finishSummaryTable();
    }

    private void writeMethodSummary(DocElement element) {
        if (!element.hasMethods()) {
            return;
        }
        this.startSummaryTable(METHOD_NAME);
        for (DocMethod method : element.getMethods()) {
            this.summaryTableRow(METHOD_NAME, method.getName(), method.getSummary());
        }
        this.finishSummaryTable();
    }

    private void writeSlotSummary(DocElement element) {
        if (!element.hasSlots()) {
            return;
        }
        this.startSummaryTable(SLOT_NAME);
        for (DocSlot slot : element.getSlots()) {
            this.summaryTableRow(SLOT_NAME, slot.getName(), slot.getSummary());
        }
        this.finishSummaryTable();
    }

    private String makeMemberReference(String dir, String objName, String prefix, String name) {
        StringBuffer link = new StringBuffer();
        link.append("<a href=\"");
        if (dir != null) {
            link.append(dir);
            link.append("/");
        }
        link.append(objName);
        link.append(".html#");
        link.append(Generator.getTagName(prefix, name));
        link.append("\">");
        link.append(name);
        link.append("</a>");
        return link.toString();
    }

    public static String getTagName(String prefix, String name) {
        return String.valueOf(prefix) + "-" + name;
    }

    private void writeInheritedProperties(DocElement element) {
        List props = element.getInheritedProperties();
        if (props.isEmpty()) {
            return;
        }
        this.writeSectionHeader("Inherited Properties");
        this.writeln("<p class=\"section-text\">");
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            Object prop = (PropertyDefn)iter.next();
            this.write(this.makeMemberReference(null, ((PropertyDefn)prop).definedBy().getName(), PROPERTY_NAME, ((PropertyDefn)prop).getName()));
            if (!iter.hasNext()) continue;
            this.writeln(", ");
        }
        this.writeln("\n</p>");
        props = element.getInheritedPropertyNotes();
        if (props.isEmpty()) {
            return;
        }
        this.writeSectionHeader("Inherited Property Notes");
        this.writeln("<dl class=\"section-text\">");
        for (Object prop : props) {
            if (((DocInheritedProperty)prop).isReserved(element)) continue;
            String baseElement = element.getDefiningElement(((DocInheritedProperty)prop).getName());
            this.write("<dt>");
            this.write(this.makeMemberReference(null, baseElement, PROPERTY_NAME, ((DocInheritedProperty)prop).getName()));
            this.write("</dt>\n<dd>");
            this.write(((DocInheritedProperty)prop).getDescription());
            this.writeln("</dd>");
        }
        this.finishSummaryTable();
    }

    private void writeStyleProperties(DocElement element) {
        List props = element.getStyleProperties();
        if (props.isEmpty()) {
            return;
        }
        this.writeSectionHeader("Style Properties");
        this.writeln("<p class=\"section-text\">");
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            PropertyDefn prop = (PropertyDefn)iter.next();
            this.write(this.makeMemberReference(null, prop.definedBy().getName(), PROPERTY_NAME, prop.getName()));
            if (!iter.hasNext()) continue;
            this.writeln(", ");
        }
        this.writeln("\n</p>");
    }

    private void writeInheritedMethods(DocElement element) {
        List props = element.getInheritedMethods();
        if (props.isEmpty()) {
            return;
        }
        this.writeSectionHeader("Inherited Methods");
        this.writeln("<p class=\"section-text\">");
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            PropertyDefn method = (PropertyDefn)iter.next();
            this.write(this.makeMemberReference(null, method.definedBy().getName(), METHOD_NAME, method.getName()));
            if (!iter.hasNext()) continue;
            this.writeln(", ");
        }
        this.writeln("</p>");
    }

    private void writeInheritedSlots(DocElement element) {
    }

    private void writeProperties(DocComposite obj) {
        if (!obj.hasProperties()) {
            return;
        }
        this.writeln("<h1>Property Detail</h1>\n");
        Iterator iter = obj.getProperties().iterator();
        while (iter.hasNext()) {
            DocProperty prop = (DocProperty)iter.next();
            this.writePropertyDetail(obj, prop);
            if (!iter.hasNext()) continue;
            this.writeln("\n<hr>");
        }
    }

    private void startDetail(String type, String name, String summary) {
        this.write("<h2><a name=\"");
        this.write(Generator.getTagName(type, name));
        this.write("\">");
        this.write(name);
        this.write(" ");
        this.write(type);
        this.writeln("</a></h2>\n");
        this.write("<p class=\"section-text\">");
        this.write(summary);
        this.writeln("</p>");
    }

    private void startDetailsTable() {
        this.writeln("<table class=\"detail-table\">");
    }

    private void detailRow(String label, String value) {
        this.write("<tr><td>");
        this.write(label);
        this.writeln(":</td>");
        this.write("<td>");
        this.write(value);
        this.writeln("</td></tr>");
    }

    private void endDetailsTable() {
        this.writeln("</table>\n");
    }

    private void writePropertyDetail(DocComposite obj, DocProperty prop) {
        this.startDetail(PROPERTY_NAME, prop.getName(), prop.getSummary());
        this.writeln("<h3>Details</h3>\n");
        this.startDetailsTable();
        this.detailRow("Type", prop.getType());
        if (prop.isExpression()) {
            this.detailRow("Context", prop.getContext());
            this.detailRow("Expression Type", prop.getReturnType());
        }
        this.detailRow("Since", prop.getSince());
        this.detailRow("Required", prop.getRequired());
        this.detailRow("Display Name", prop.getDisplayName());
        this.detailRow("JavaScript Type", prop.getJSType());
        this.detailRow("Default Value", prop.getDefaultValue());
        if (obj.isElement()) {
            this.detailRow("Inherited", prop.getInherited());
        }
        this.detailRow("Runtime Settable", prop.getRuntimeSettable());
        if (obj.isElement()) {
            DocElement element = (DocElement)obj;
            this.detailRow("Property Sheet Visibility", prop.getVisibility(element));
            this.detailRow("Property Sheet Group", prop.getGroup());
        }
        this.endDetailsTable();
        this.writeChoices(prop);
        this.writeSection("Description", prop.getDescription());
        this.writeSection("See Also", prop.getSeeAlso());
    }

    private void writeChoices(DocProperty prop) {
        if (!prop.hasChoices()) {
            return;
        }
        this.writeln("<h3>Choices</h3>\n");
        this.writeln("<table class=\"section-table\">");
        this.writeln("<thead><tr><td>Name</td><td>Display Name</td>");
        this.writeln("<td>Value</td><td>Description</td></tr></thead>");
        this.writeln("<tbody>");
        for (DocChoice choice : prop.getChoices()) {
            this.write("<tr><td>");
            this.write(choice.getName());
            this.write("</td>\n<td>");
            this.write(choice.getDisplayName());
            this.write("</td>\n<td>");
            this.write(choice.getValue());
            this.write("</td>\n<td>");
            this.write(choice.getDescription());
            this.writeln("</td></tr>");
        }
        this.writeln("</tbody></table><br>");
    }

    private void writeMethods(DocElement element) {
        if (!element.hasMethods()) {
            return;
        }
        this.writeln("<h1>Method Detail</h1>\n");
        Iterator iter = element.getMethods().iterator();
        while (iter.hasNext()) {
            DocMethod method = (DocMethod)iter.next();
            this.writeMethodDetail(method);
            if (!iter.hasNext()) continue;
            this.writeln("\n<hr>");
        }
    }

    private void writeMethodDetail(DocMethod method) {
        this.startDetail(METHOD_NAME, method.getName(), method.getSummary());
        this.writeSynopsis(method);
        this.writeSectionHeader("Details\n");
        this.startDetailsTable();
        this.detailRow("Since", method.getSince());
        this.detailRow("Context", method.getContext());
        this.detailRow("Arguments", "None");
        this.detailRow("Return Type", method.getReturnType());
        this.endDetailsTable();
        this.writeSection("Return", method.getReturnText());
        this.writeSection("Description", method.getDescription());
        this.writeSection("See Also", method.getSeeAlso());
    }

    private void writeSynopsis(DocMethod method) {
        this.writeSectionHeader("Synopsis\n");
        this.write("<p class=\"section-text\"><code>");
        if (method.getReturnType() != null) {
            this.write(method.getReturnType());
            this.write("&nbsp;");
        }
        this.write("obj.");
        this.write(method.getName());
        this.writeln("(&nbsp;)</code></p>");
    }

    private void writeSlots(DocElement element) {
        if (!element.hasSlots()) {
            return;
        }
        this.writeln("<h1>Slot Detail</h1>\n");
        Iterator iter = element.getSlots().iterator();
        while (iter.hasNext()) {
            DocSlot slot = (DocSlot)iter.next();
            this.writeSlotDetail(element, slot);
            if (!iter.hasNext()) continue;
            this.writeln("\n<hr>");
        }
    }

    private void writeSlotDetail(DocElement element, DocSlot slot) {
        this.startDetail(SLOT_NAME, slot.getName(), slot.getSummary());
        this.writeln("<h3>Details</h3>\n");
        this.startDetailsTable();
        this.detailRow("Display Name", slot.getDisplayName());
        this.detailRow("Since", slot.getSince());
        String name = slot.getXmlName();
        name = this.isBlank(name) ? "None. (The contents appear directly within the container element.)" : "<code>" + name + "</code>";
        this.detailRow("XML Element", name);
        this.detailRow("Contents", slot.getContents());
        if (element.hasStyle() || slot.hasStyle()) {
            this.detailRow("Default Style", slot.getStyle());
        }
        this.endDetailsTable();
        this.writeSection("Description", slot.getDescription());
        this.writeSection("See Also", slot.getSeeAlso());
    }

    private void writeStructures() throws IOException {
        this.write(this.index, "<h1>Structures</h1>\n<table class=\"summary-table\">\n");
        for (DocStructure struct : this.structs) {
            try {
                this.write(struct);
            }
            catch (IOException e) {
                System.out.println("Failed to write file for Structure " + struct.getName());
                throw e;
            }
        }
        this.write(this.index, "</table>\n\n");
    }

    private void write(DocStructure struct) throws IOException {
        File output = this.makeFile("structs", String.valueOf(struct.getName()) + ".html");
        this.writer = new PrintStream(new FileOutputStream(output));
        this.writeIndexEntry(struct);
        this.writeHeader(struct);
        this.writeStructure(struct);
        this.writeProperties(struct);
        this.writeFooter();
        this.writer.close();
    }

    private void writeIndexEntry(String title, String file, String descrip) {
        this.write(this.index, "<tr><td><a href=\"");
        this.write(this.index, file);
        this.write(this.index, ".html\">");
        this.write(this.index, title);
        this.write(this.index, "</a></td>\n<td>");
        this.write(this.index, descrip);
        this.write(this.index, "</td></tr>\n");
    }

    private void writeStructure(DocStructure struct) {
        this.write("<h1>Structure Overview</h1>\n");
        this.writeSectionBody(struct.getSummary());
        this.writeDetails(struct);
        this.writePropertySummary(struct);
        this.writeSection("Description", struct.getDescription());
        this.writeSection("XML Summary", struct.getXmlSummary());
        this.writeSection("See Also", struct.getSeeAlso());
    }

    private void writeDetails(DocStructure struct) {
        this.writeSectionHeader("Details");
        this.startDetailsTable();
        this.detailRow("Display Name", struct.getDisplayName());
        this.detailRow("Since", struct.getSince());
        this.endDetailsTable();
    }

    private void writeTypes() throws IOException {
        this.writeIndexEntry("Property Types", "types", "The set of types used to define ROM properties.");
        File output = this.makeFile(null, "types.html");
        this.writer = new PrintStream(new FileOutputStream(output));
        this.writeln("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.0 transitional//EN\">");
        this.write("<html>\n<head>\n<title>");
        this.writeln(" Element (Eclipse BIRT ROM Documentation)</title>");
        this.writeln("<link rel=\"stylesheet\" href=\"style/style.css\" type=\"text/css\"/>");
        this.writeln("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        this.writeln("</head>\n<body>");
        this.writeln("<p class=\"title\">Eclipse BIRT Report Object Model (ROM)</p>");
        this.writeln("<p class=\"subtitle\">Property Types</p>");
        this.writeln("<h1>Property Types</h1>\n<table class=\"summary-table\">");
        this.writeSectionBody(this.typeHeader);
        this.writeln("<hr>");
        Iterator iter = this.propertyTypes.iterator();
        while (iter.hasNext()) {
            DocPropertyType type = (DocPropertyType)iter.next();
            this.write("<h2><a name=\"");
            this.write(type.getName());
            this.write("\">");
            this.write(type.getName());
            this.writeln("</a></h2>");
            this.writeSectionBody(type.getSummary());
            this.writeSectionHeader("Details");
            this.startDetailsTable();
            this.detailRow("Display Name", type.getDisplayName());
            this.detailRow("Since", type.getSince());
            this.detailRow("XML Name", "<code>" + type.getXmlName() + "</code>");
            this.detailRow("JavaScript Design Type", type.getJSDesignType());
            this.detailRow("JavaScript Runtime Type", type.getJSRuntimeType());
            this.endDetailsTable();
            this.writeSection("Description", type.getDescription());
            if (type.getSeeAlso() != null) {
                this.writeSection("See Also", type.getSeeAlso());
            }
            if (iter.hasNext()) {
                // empty if block
            }
            this.writeln("<hr>");
        }
        this.finishSummaryTable();
        this.writeFooter();
        this.writer.close();
    }

    private void writeStyles() throws IOException {
        this.writeIndexEntry("Predefined Styles", "styles", "Styles defined by BIRT, usually as a \"default style\" for an element or slot.");
        File output = this.makeFile(null, "styles.html");
        this.writer = new PrintStream(new FileOutputStream(output));
        Properties selectors = new Properties();
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(String.valueOf(this.templateDir) + "/style/selectors.properties"));
            selectors.load(is);
        }
        catch (IOException iOException) {
            System.out.println("Can not read in \"selectors.properties\". ");
        }
        this.writeln("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.0 transitional//EN\">");
        this.write("<html>\n<head>\n<title>");
        this.writeln(" Element (Eclipse BIRT ROM Documentation)</title>");
        this.writeln("<link rel=\"stylesheet\" href=\"style/style.css\" type=\"text/css\"/>");
        this.writeln("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        this.writeln("</head>\n<body>");
        this.writeln("<p class=\"title\">Eclipse BIRT Report Object Model (ROM)</p>");
        this.writeln("<p class=\"subtitle\">Predefined Styles</p>");
        this.writeln("<h1>Predefined Styles</h1>\n<table class=\"summary-table\">");
        MetaDataDictionary dict = MetaDataDictionary.getInstance();
        ArrayList<IPredefinedStyle> list = new ArrayList<IPredefinedStyle>();
        list.addAll(dict.getPredefinedStyles());
        Collections.sort(list, new StyleComparator());
        for (PredefinedStyle predefinedStyle : list) {
            this.write("<tr><td><a name=\"");
            this.write(predefinedStyle.getName());
            this.write("\">");
            this.write(predefinedStyle.getName());
            this.write("</a></td>\n<td>");
            String description = selectors.getProperty(predefinedStyle.getName());
            if (description == null) {
                System.err.println("Missing selector description for " + predefinedStyle.getName());
            }
            this.write(description);
            this.writeln("</td></tr>");
        }
        this.finishSummaryTable();
        this.writeFooter();
        this.writer.close();
    }

    private void writePropertyIndex() throws IOException {
        this.writeIndexEntry("Property Index", "prop-index", "Index of properties with a link to their definition.");
        HashMap props = new HashMap();
        this.buildIndex(props, this.elements);
        this.buildIndex(props, this.structs);
        ArrayList list = new ArrayList();
        list.addAll(props.values());
        Collections.sort(list, new PropInfoComparator());
        File output = this.makeFile(null, "prop-index.html");
        this.writer = new PrintStream(new FileOutputStream(output));
        this.writeln("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.0 transitional//EN\">");
        this.write("<html>\n<head>\n<title>");
        this.writeln(" Element (Eclipse BIRT ROM Documentation)</title>");
        this.writeln("<link rel=\"stylesheet\" href=\"style/style.css\" type=\"text/css\"/>");
        this.writeln("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        this.writeln("</head>\n<body>");
        this.writeln("<p class=\"title\">Eclipse BIRT Report Object Model (ROM)</p>");
        this.writeln("<p class=\"subtitle\">Property Index</p>");
        this.writeln("<h1>Property Index</h1>\n<table class=\"summary-table\">");
        for (PropInfo prop : list) {
            this.write("<tr><td>");
            this.write(prop.name);
            this.write("</td>\n<td>");
            Collections.sort(prop.uses, new DocComparator());
            Iterator i2 = prop.uses.iterator();
            while (i2.hasNext()) {
                DocComposite obj = (DocComposite)i2.next();
                this.write("<a href=\"");
                if (obj.isElement()) {
                    this.write("elements");
                } else {
                    this.write("structs");
                }
                this.write("/");
                this.write(obj.getName());
                this.write(".html\">");
                this.write(obj.getName());
                this.write("</a> ");
                if (obj.isElement()) {
                    this.write("Element");
                } else {
                    this.write("Structure");
                }
                if (i2.hasNext()) {
                    this.write(", ");
                }
                this.writeln("");
            }
            this.writeln("</td>\n");
        }
        this.finishSummaryTable();
        this.writeFooter();
        this.writer.close();
    }

    private void buildIndex(HashMap props, List objs) {
        for (DocComposite obj : objs) {
            for (DocProperty prop : obj.getProperties()) {
                PropInfo info = (PropInfo)props.get(prop.getName());
                if (info == null) {
                    info = new PropInfo();
                    info.name = prop.getName();
                    props.put(info.name, info);
                }
                info.uses.add(obj);
            }
        }
    }

    private void writeInheritanceTable() {
    }

    private void writeFooter() {
        this.writeln("</body>\n</html>");
    }

    void setTypeHeader(String text) {
        this.typeHeader = text;
    }

    DocPropertyType findType(String name) {
        for (DocPropertyType type : this.propertyTypes) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    static class PropInfo {
        String name;
        ArrayList uses = new ArrayList();

        PropInfo() {
        }
    }

    static class PropInfoComparator
    implements Comparator {
        PropInfoComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            PropInfo s1 = (PropInfo)arg0;
            PropInfo s2 = (PropInfo)arg1;
            return s1.name.compareTo(s2.name);
        }
    }

    static class StyleComparator
    implements Comparator {
        StyleComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            PredefinedStyle s1 = (PredefinedStyle)arg0;
            PredefinedStyle s2 = (PredefinedStyle)arg1;
            return s1.getName().compareTo(s2.getName());
        }
    }

    static class TypeComparator
    implements Comparator {
        TypeComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            PropertyType s1 = (PropertyType)arg0;
            PropertyType s2 = (PropertyType)arg1;
            return s1.getName().compareTo(s2.getName());
        }
    }
}

