/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.filterExtension;

import org.eclipse.birt.report.model.api.filterExtension.OdaFilterExprHelper;
import org.eclipse.birt.report.model.api.filterExtension.interfaces.IBirtFilterOperatorConstants;
import org.eclipse.birt.report.model.api.filterExtension.interfaces.IFilterExprDefinition;

public class FilterExprDefinition
implements IFilterExprDefinition {
    private String birtFilterExprId = null;
    private String birtFilterDisplayName = null;
    private int minArgs = -1;
    private int maxArgs = -1;
    private boolean supportUnboundedMaxArgs = false;

    public FilterExprDefinition(String birtFilterExpr) throws IllegalArgumentException {
        this.birtFilterExprId = birtFilterExpr;
        if (!OdaFilterExprHelper.birtPredefinedFilters.contains(birtFilterExpr)) {
            throw new IllegalArgumentException("The Birt filter expression Id is not valid.");
        }
        this.initBitExpr(birtFilterExpr);
    }

    public int expressionSupportedType() {
        return 0;
    }

    public String getBirtFilterExprDisplayName() {
        return this.birtFilterDisplayName;
    }

    public String getBirtFilterExprId() {
        return this.birtFilterExprId;
    }

    public String getExtFilterDisplayName() {
        return null;
    }

    public String getExtFilterExprId() {
        return null;
    }

    public Integer getMaxArguments() {
        return this.maxArgs;
    }

    public Integer getMinArguments() {
        return this.minArgs;
    }

    public String getProviderExtensionId() {
        return null;
    }

    public boolean supportsUnboundedMaxArguments() {
        return this.supportUnboundedMaxArgs;
    }

    private void initBitExpr(String birtExpr) {
        int birtOperator = birtExpr.toLowerCase().hashCode();
        if (IBirtFilterOperatorConstants.FILTER_OPERATOR_BETWEEN == birtOperator) {
            this.birtFilterExprId = "between";
            this.birtFilterDisplayName = "Between";
            this.maxArgs = 2;
            this.minArgs = 2;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_BOTTOM_N == birtOperator) {
            this.birtFilterExprId = "bottom-n";
            this.birtFilterDisplayName = "Botton N";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_BOTTOM_PERCENT == birtOperator) {
            this.birtFilterExprId = "bottom-percent";
            this.birtFilterDisplayName = "Botton Percent";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_EQ == birtOperator) {
            this.birtFilterExprId = "eq";
            this.birtFilterDisplayName = "Equal To";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_FALSE == birtOperator) {
            this.birtFilterExprId = "is-false";
            this.birtFilterDisplayName = "Is False";
            this.maxArgs = 0;
            this.minArgs = 0;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_GE == birtOperator) {
            this.birtFilterExprId = "ge";
            this.birtFilterDisplayName = "Greater Than or Equal";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_GT == birtOperator) {
            this.birtFilterExprId = "gt";
            this.birtFilterDisplayName = "Greater Than";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_LE == birtOperator) {
            this.birtFilterExprId = "le";
            this.birtFilterDisplayName = "Less Than or Equal";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_LIKE == birtOperator) {
            this.birtFilterExprId = "like";
            this.birtFilterDisplayName = "Like";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_LT == birtOperator) {
            this.birtFilterExprId = "lt";
            this.birtFilterDisplayName = "Less Than";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NE == birtOperator) {
            this.birtFilterExprId = "ne";
            this.birtFilterDisplayName = "Not Equal to";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NOT_BETWEEN == birtOperator) {
            this.birtFilterExprId = "not-between";
            this.birtFilterDisplayName = "Not Between";
            this.maxArgs = 2;
            this.minArgs = 2;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NOT_IN == birtOperator) {
            this.birtFilterExprId = "not-in";
            this.birtFilterDisplayName = "Not In";
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = true;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NOT_NULL == birtOperator) {
            this.birtFilterExprId = "is-not-null";
            this.birtFilterDisplayName = "Not Null";
            this.maxArgs = 0;
            this.minArgs = 0;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NULL == birtOperator) {
            this.birtFilterExprId = "is-null";
            this.birtFilterDisplayName = "Is Null";
            this.maxArgs = 0;
            this.minArgs = 0;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_TOP_N == birtOperator) {
            this.birtFilterExprId = "top-n";
            this.birtFilterDisplayName = "Top N";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_TOP_PERCENT == birtOperator) {
            this.birtFilterExprId = "top-percent";
            this.birtFilterDisplayName = "Top Percent";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_TRUE == birtOperator) {
            this.birtFilterExprId = "is-true";
            this.birtFilterDisplayName = "Is True";
            this.maxArgs = 0;
            this.minArgs = 0;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_MATCH == birtOperator) {
            this.birtFilterExprId = "match";
            this.birtFilterDisplayName = "Match";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NOT_LIKE == birtOperator) {
            this.birtFilterExprId = "not-like";
            this.birtFilterDisplayName = "Not Like";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NOT_MATCH == birtOperator) {
            this.birtFilterExprId = "not-match";
            this.birtFilterDisplayName = "Not Match";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_IN == birtOperator) {
            this.birtFilterExprId = "in";
            this.birtFilterDisplayName = "In";
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = true;
        }
    }
}

