/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.ContentElementCommand;
import org.eclipse.birt.report.model.command.ContentElementInfo;
import org.eclipse.birt.report.model.command.ContentRecord;
import org.eclipse.birt.report.model.command.GroupElementCommand;
import org.eclipse.birt.report.model.command.MoveContentRecord;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.IContainerDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ContentExceptionFactory;
import org.eclipse.birt.report.model.util.LevelContentIterator;

abstract class AbstractContentCommand
extends AbstractElementCommand {
    protected final ContainerContext focus;
    protected ContentElementInfo eventTarget;

    public AbstractContentCommand(Module module, DesignElement obj) {
        super(module, obj);
        this.focus = null;
    }

    public AbstractContentCommand(Module module, ContainerContext containerInfo) {
        super(module, containerInfo.getElement());
        this.focus = containerInfo;
        this.eventTarget = this.getEventTarget();
    }

    public final void add(DesignElement content, int newPos) throws ContentException, NameException {
        assert (newPos >= 0 || newPos == -1);
        assert (content.getContainer() == null);
        if (this.eventTarget != null && !(this instanceof ContentElementCommand)) {
            ContentElementCommand attrCmd = new ContentElementCommand(this.module, this.focus);
            attrCmd.add(content, newPos);
            return;
        }
        if (content instanceof GroupElement && this.element instanceof ListingElement && !(this instanceof GroupElementCommand)) {
            GroupElementCommand attrCmd = new GroupElementCommand(this.module, this.focus);
            attrCmd.add(content, newPos);
            return;
        }
        try {
            this.checkBeforeAdd(content);
        }
        catch (ContentException e) {
            throw e;
        }
        catch (NameException e) {
            throw e;
        }
        this.doAdd(newPos, content);
    }

    protected void checkBeforeAdd(DesignElement content) throws ContentException, NameException {
        ElementDefn metaData = (ElementDefn)this.element.getDefn();
        if (!metaData.isContainer()) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.NOT_CONTAINER");
        }
        IContainerDefn containerDefn = this.focus.getContainerDefn();
        if (containerDefn == null) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.SLOT_NOT_FOUND");
        }
        if (!containerDefn.canContain(content)) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.WRONG_TYPE");
        }
        if (this.element.isContentOf(content)) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.RECURSIVE");
        }
        if (!this.focus.isContainerMultipleCardinality() && this.focus.getContentCount(this.module) > 0) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.SLOT_IS_FULL");
        }
    }

    protected void doAdd(int newPos, DesignElement content) throws ContentException, NameException {
        ContentRecord addRecord = newPos == -1 ? new ContentRecord(this.module, this.focus, content, true) : new ContentRecord(this.module, this.focus, content, newPos);
        addRecord.setEventTarget(this.eventTarget);
        ActivityStack stack = this.getActivityStack();
        stack.execute(addRecord);
    }

    public final void add(DesignElement content) throws ContentException, NameException {
        this.add(content, -1);
    }

    public final void remove(DesignElement content) throws SemanticException {
        assert (content != null);
        if (this.eventTarget != null && !(this instanceof ContentElementCommand)) {
            ContentElementCommand attrCmd = new ContentElementCommand(this.module, this.focus);
            attrCmd.remove(content);
            return;
        }
        if (content instanceof GroupElement && this.element instanceof ListingElement && !(this instanceof GroupElementCommand)) {
            boolean flag = ((ContentCommand)this).flag;
            boolean unresolveReference = ((ContentCommand)this).unresolveReference;
            GroupElementCommand attrCmd = new GroupElementCommand(this.module, this.focus, flag, unresolveReference);
            attrCmd.remove(content);
            return;
        }
        this.checkBeforeRemove(content);
        this.doRemove(content);
    }

    protected void checkBeforeRemove(DesignElement content) throws SemanticException {
        if (!this.element.getDefn().isContainer()) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.NOT_CONTAINER");
        }
        IContainerDefn containerDefn = this.focus.getContainerDefn();
        if (containerDefn == null) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.SLOT_NOT_FOUND");
        }
        if (!this.focus.contains(this.module, content)) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.CONTENT_NOT_FOUND");
        }
    }

    private void doRemove(DesignElement content) throws SemanticException {
        ActivityStack stack = this.getActivityStack();
        stack.startFilterEventTrans(CommandLabelFactory.getCommandLabel("Message.DropElement"));
        try {
            this.doDelectAction(content);
        }
        catch (SemanticException ex) {
            stack.rollback();
            throw ex;
        }
        ContentRecord dropRecord = new ContentRecord(this.module, this.focus, content, false);
        dropRecord.setEventTarget(this.eventTarget);
        stack.execute(dropRecord);
        stack.commit();
    }

    protected void doDelectAction(DesignElement content) throws SemanticException {
        ElementDefn metaData = (ElementDefn)content.getDefn();
        if (!metaData.isContainer()) {
            return;
        }
        LevelContentIterator iter = new LevelContentIterator(this.module, content, 1);
        while (iter.hasNext()) {
            DesignElement tmpContent = iter.next();
            AbstractContentCommand cmd = null;
            if (this instanceof ContentCommand) {
                cmd = new ContentCommand(this.module, tmpContent.getContainerInfo(), true, ((ContentCommand)this).unresolveReference);
            } else if (this instanceof ContentElementCommand) {
                cmd = new ContentElementCommand(this.module, tmpContent.getContainerInfo());
            }
            if (cmd == null) continue;
            cmd.remove(tmpContent);
        }
    }

    public final void move(DesignElement content, ContainerContext toContainerInfor) throws ContentException {
        this.move(content, toContainerInfor, -1);
    }

    public final void move(DesignElement content, ContainerContext toContainerInfor, int newPos) throws ContentException {
        if (this.focus.equals(toContainerInfor)) {
            this.movePosition(content, newPos);
            return;
        }
        if (this.eventTarget != null && !(this instanceof ContentElementCommand)) {
            ContentElementCommand attrCmd = new ContentElementCommand(this.module, this.focus);
            attrCmd.move(content, toContainerInfor, newPos);
            return;
        }
        this.checkBeforeMove(content, toContainerInfor);
        this.doMove(content, toContainerInfor, newPos);
    }

    protected void doMove(DesignElement content, ContainerContext toContainerInfor, int newPos) {
        MoveContentRecord record = new MoveContentRecord(this.module, this.focus, toContainerInfor, content, newPos);
        record.setEventTarget(this.eventTarget);
        this.getActivityStack().execute(record);
    }

    protected void checkBeforeMove(DesignElement content, ContainerContext toContainerInfor) throws ContentException {
        assert (content != null);
        assert (toContainerInfor != null);
        if (toContainerInfor.getElement().isContentOf(content)) {
            throw ContentExceptionFactory.createContentException(toContainerInfor, content, "Error.ContentException.RECURSIVE");
        }
        if (!this.element.getDefn().isContainer()) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.NOT_CONTAINER");
        }
        if (!toContainerInfor.getElement().getDefn().isContainer()) {
            throw ContentExceptionFactory.createContentException(toContainerInfor, "Error.ContentException.NOT_CONTAINER");
        }
        IContainerDefn containerDefn = this.focus.getContainerDefn();
        if (containerDefn == null) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.SLOT_NOT_FOUND");
        }
        containerDefn = toContainerInfor.getContainerDefn();
        if (containerDefn == null) {
            throw ContentExceptionFactory.createContentException(toContainerInfor, "Error.ContentException.SLOT_NOT_FOUND");
        }
        if (!this.focus.contains(this.module, content)) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.CONTENT_NOT_FOUND");
        }
        containerDefn = toContainerInfor.getContainerDefn();
        if (!containerDefn.canContain(content)) {
            throw ContentExceptionFactory.createContentException(toContainerInfor, content, "Error.ContentException.WRONG_TYPE");
        }
        if (!toContainerInfor.isContainerMultipleCardinality() && toContainerInfor.getContentCount(this.module) > 0) {
            throw ContentExceptionFactory.createContentException(toContainerInfor, "Error.ContentException.SLOT_IS_FULL");
        }
    }

    public final void movePosition(DesignElement content, int newPosn) throws ContentException {
        assert (content != null);
        if (this.eventTarget != null && !(this instanceof ContentElementCommand)) {
            ContentElementCommand attrCmd = new ContentElementCommand(this.module, this.focus);
            attrCmd.movePosition(content, newPosn);
            return;
        }
        if (content instanceof GroupElement && this.element instanceof ListingElement && !(this instanceof GroupElementCommand)) {
            GroupElementCommand attrCmd = new GroupElementCommand(this.module, this.focus);
            attrCmd.movePosition(content, newPosn);
            return;
        }
        this.checkBeforeMovePosition(content, newPosn);
        this.doMovePosition(content, newPosn);
    }

    protected void checkBeforeMovePosition(DesignElement content, int newPosn) throws ContentException {
        assert (content != null);
        if (!this.element.getDefn().isContainer()) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.NOT_CONTAINER");
        }
        IContainerDefn defn = this.focus.getContainerDefn();
        if (defn == null) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.SLOT_NOT_FOUND");
        }
        if (!content.isContentOf(this.element)) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.CONTENT_NOT_FOUND");
        }
    }

    protected void doMovePosition(DesignElement content, int newPosn) throws ContentException {
        int adjustedNewPosn;
        if (!this.focus.isContainerMultipleCardinality()) {
            return;
        }
        int oldPosn = this.focus.indexOf(this.module, content);
        if (oldPosn == (adjustedNewPosn = AbstractContentCommand.checkAndAdjustPosition(oldPosn, newPosn, this.focus.getContentCount(this.module)))) {
            return;
        }
        MoveContentRecord record = new MoveContentRecord(this.module, this.focus, content, adjustedNewPosn);
        record.setEventTarget(this.eventTarget);
        this.getActivityStack().execute(record);
    }

    private ContentElementInfo getEventTarget() {
        IContainerDefn tmpContainerDefn = this.focus.getContainerDefn();
        if (tmpContainerDefn instanceof SlotDefn) {
            return null;
        }
        DesignElement tmpElement = this.focus.getElement();
        PropertyDefn tmpPropDefn = (PropertyDefn)tmpContainerDefn;
        ContentElementInfo retTarget = new ContentElementInfo(true);
        while (tmpElement != null && tmpPropDefn != null) {
            retTarget.pushStep(tmpPropDefn, -1);
            if (tmpPropDefn.getTypeCode() == 24 && !(tmpElement instanceof ContentElement)) {
                retTarget.setTopElement(tmpElement);
                return retTarget;
            }
            ContainerContext context = tmpElement.getContainerInfo();
            if (context == null) break;
            tmpElement = tmpElement.getContainer();
            tmpPropDefn = tmpElement.getPropertyDefn(context.getPropertyName());
        }
        return null;
    }
}

