/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable;

import java.util.Set;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.internal.databinding.identity.IdentitySet;
import org.eclipse.core.runtime.Assert;

public class ObservableTracker {
    private static ThreadLocal currentChangeListener = new ThreadLocal();
    private static ThreadLocal currentStaleListener = new ThreadLocal();
    private static ThreadLocal currentGetterCalledSet = new ThreadLocal();
    private static ThreadLocal currentObservableCreatedSet = new ThreadLocal();

    public static IObservable[] runAndMonitor(Runnable runnable, IChangeListener changeListener, IStaleListener staleListener) {
        Set lastObservableSet = (Set)currentGetterCalledSet.get();
        IChangeListener lastChangeListener = (IChangeListener)currentChangeListener.get();
        IStaleListener lastStaleListener = (IStaleListener)currentStaleListener.get();
        IdentitySet observableSet = new IdentitySet();
        currentGetterCalledSet.set(observableSet);
        currentChangeListener.set(changeListener);
        currentStaleListener.set(staleListener);
        try {
            runnable.run();
        }
        finally {
            currentGetterCalledSet.set(lastObservableSet);
            currentChangeListener.set(lastChangeListener);
            currentStaleListener.set(lastStaleListener);
        }
        return observableSet.toArray((T[])new IObservable[observableSet.size()]);
    }

    public static IObservable[] runAndCollect(Runnable runnable) {
        Set lastObservableCreatedSet = (Set)currentObservableCreatedSet.get();
        IdentitySet observableSet = new IdentitySet();
        currentObservableCreatedSet.set(observableSet);
        try {
            runnable.run();
        }
        finally {
            currentObservableCreatedSet.set(lastObservableCreatedSet);
        }
        return observableSet.toArray((T[])new IObservable[observableSet.size()]);
    }

    public static void runAndIgnore(Runnable runnable) {
        Set lastGetterCalledSet = (Set)currentGetterCalledSet.get();
        Set lastObservableCreatedSet = (Set)currentObservableCreatedSet.get();
        IChangeListener lastChangeListener = (IChangeListener)currentChangeListener.get();
        IStaleListener lastStaleListener = (IStaleListener)currentStaleListener.get();
        currentGetterCalledSet.set(null);
        currentObservableCreatedSet.set(null);
        currentChangeListener.set(null);
        currentStaleListener.set(null);
        try {
            runnable.run();
        }
        finally {
            currentGetterCalledSet.set(lastGetterCalledSet);
            currentObservableCreatedSet.set(lastObservableCreatedSet);
            currentChangeListener.set(lastChangeListener);
            currentStaleListener.set(lastStaleListener);
        }
    }

    private static String toString(IObservable observable) {
        return String.valueOf(observable.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(observable));
    }

    public static void getterCalled(IObservable observable) {
        Set getterCalledSet;
        Realm realm;
        if (observable.isDisposed()) {
            Assert.isTrue((boolean)false, (String)("Getter called on disposed observable " + ObservableTracker.toString(observable)));
        }
        if (!(realm = observable.getRealm()).isCurrent()) {
            Assert.isTrue((boolean)false, (String)("Getter called outside realm of observable " + ObservableTracker.toString(observable)));
        }
        if ((getterCalledSet = (Set)currentGetterCalledSet.get()) != null && getterCalledSet.add(observable)) {
            IStaleListener staleListener;
            IChangeListener changeListener = (IChangeListener)currentChangeListener.get();
            if (changeListener != null) {
                observable.addChangeListener(changeListener);
            }
            if ((staleListener = (IStaleListener)currentStaleListener.get()) != null) {
                observable.addStaleListener(staleListener);
            }
        }
    }

    public static void observableCreated(IObservable observable) {
        Set observableCreatedSet = (Set)currentObservableCreatedSet.get();
        if (observableCreatedSet != null) {
            observableCreatedSet.add(observable);
        }
    }
}

