/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ColumnAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ComputedColumnAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ConditionAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ExpressionAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.FilterAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.GroupAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.InputParamBindingAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.JointDataSetAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.OdaDataSetAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.OdaDataSourceAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ParameterAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ScriptDataSetAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ScriptDataSourceAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.SortAdapter;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.mozilla.javascript.Scriptable;

public class ModelAdapter
implements IModelAdapter {
    DataSessionContext context;

    ModelAdapter(DataSessionContext context) {
        this.context = context;
    }

    public BaseDataSourceDesign adaptDataSource(DataSourceHandle handle) throws BirtException {
        if (handle instanceof OdaDataSourceHandle) {
            Scriptable propBindingScope = this.context.hasExternalScope() ? this.context.getTopScope() : null;
            return new OdaDataSourceAdapter((OdaDataSourceHandle)handle, propBindingScope);
        }
        if (handle instanceof ScriptDataSourceHandle) {
            return new ScriptDataSourceAdapter((ScriptDataSourceHandle)handle);
        }
        assert (false);
        return null;
    }

    public BaseDataSetDesign adaptDataSet(DataSetHandle handle) throws BirtException {
        if (handle instanceof OdaDataSetHandle) {
            Scriptable propBindingScope = this.context.hasExternalScope() ? this.context.getTopScope() : null;
            return new OdaDataSetAdapter((OdaDataSetHandle)handle, propBindingScope);
        }
        if (handle instanceof ScriptDataSetHandle) {
            return new ScriptDataSetAdapter((ScriptDataSetHandle)handle);
        }
        if (handle instanceof JointDataSetHandle) {
            return new JointDataSetAdapter((JointDataSetHandle)handle);
        }
        assert (false);
        return null;
    }

    public ConditionalExpression adaptConditionalExpression(String mainExpr, String operator, String operand1, String operand2) {
        return new ConditionAdapter(mainExpr, operator, operand1, operand2);
    }

    public ScriptExpression adaptExpression(String exprText, String dataType) {
        return new ExpressionAdapter(exprText, dataType);
    }

    public ScriptExpression adaptExpression(ComputedColumnHandle ccHandle) {
        return new ExpressionAdapter(ccHandle);
    }

    public FilterDefinition adaptFilter(FilterConditionHandle modelFilter) {
        return new FilterAdapter(modelFilter);
    }

    public GroupDefinition adaptGroup(GroupHandle groupHandle) {
        return new GroupAdapter(groupHandle);
    }

    public SortDefinition adaptSort(SortKeyHandle sortHandle) {
        return new SortAdapter(sortHandle);
    }

    public SortDefinition adaptSort(String sortKeyExpr, String direction) {
        return new SortAdapter(sortKeyExpr, direction);
    }

    public ParameterDefinition adaptParameter(DataSetParameterHandle paramHandle) {
        return new ParameterAdapter(paramHandle);
    }

    public InputParameterBinding adaptInputParamBinding(ParamBindingHandle modelHandle) {
        return new InputParamBindingAdapter(modelHandle);
    }

    public ColumnDefinition ColumnAdaptor(ResultSetColumnHandle modelColumn) {
        return new ColumnAdapter(modelColumn);
    }

    public ComputedColumn adaptComputedColumn(ComputedColumnHandle modelHandle) throws AdapterException {
        return new ComputedColumnAdapter(modelHandle);
    }

    public IBinding adaptBinding(ComputedColumnHandle handle) throws AdapterException {
        if (handle == null) {
            return null;
        }
        Binding result = new Binding(handle.getName());
        if (handle.getExpression() != null) {
            result.setExpression((IBaseExpression)new ScriptExpression(handle.getExpression()));
        }
        result.setDataType(DataAdapterUtil.adaptModelDataType(handle.getDataType()));
        result.setAggrFunction(DataAdapterUtil.adaptModelAggregationType(handle.getAggregateFunction()));
        result.setFilter((IBaseExpression)(handle.getFilterExpression() == null ? null : new ScriptExpression(handle.getFilterExpression())));
        ModelAdapter.populateArgument((IBinding)result, handle);
        this.populateAggregateOns((IBinding)result, handle);
        return result;
    }

    private void populateAggregateOns(IBinding result, ComputedColumnHandle handle) throws AdapterException {
        List aggrOns = handle.getAggregateOnList();
        if (aggrOns == null) {
            return;
        }
        int i = 0;
        while (i < aggrOns.size()) {
            try {
                result.addAggregateOn(aggrOns.get(i).toString());
            }
            catch (DataException e) {
                throw new AdapterException(e.getLocalizedMessage(), e);
            }
            ++i;
        }
    }

    private static void populateArgument(IBinding binding, ComputedColumnHandle modelCmptdColumn) throws AdapterException {
        Iterator it = modelCmptdColumn.argumentsIterator();
        while (it != null && it.hasNext()) {
            AggregationArgumentHandle arg = (AggregationArgumentHandle)it.next();
            try {
                binding.addArgument((IBaseExpression)new ScriptExpression(arg.getValue()));
            }
            catch (DataException e) {
                throw new AdapterException(e.getLocalizedMessage(), e);
            }
        }
    }
}

