/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.manifest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.manifest.AggregateDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;
import org.eclipse.datatools.connectivity.oda.spec.manifest.FilterExpressionDefinition;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultExtensionExplorer {
    public static final String DTP_ODA_DYNAMIC_RESULT_SETS_EXT_POINT = "org.eclipse.datatools.connectivity.oda.dynamicResultSet";
    public static final String FILTER_GROUP_NAME = "filterExpressionTypes";
    public static final String AGGREGATE_GROUP_NAME = "aggregateExpressionTypes";
    private static ResultExtensionExplorer sm_instance = null;
    private static Logger sm_logger = null;
    private static final ExtensionContributor[] EMTPY_CONTRIBUTOR_ARRAY = new ExtensionContributor[0];
    private Map<ExtensionContributor, Map<String, FilterExpressionDefinition>> m_filterExpressionsByExtn;
    private Map<ExtensionContributor, Map<String, AggregateDefinition>> m_aggregateTypesByExtn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultExtensionExplorer getInstance() {
        if (sm_instance != null) return sm_instance;
        Class<ResultExtensionExplorer> clazz = ResultExtensionExplorer.class;
        synchronized (ResultExtensionExplorer.class) {
            if (sm_instance != null) return sm_instance;
            sm_instance = new ResultExtensionExplorer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInstance() {
        Class<ResultExtensionExplorer> clazz = ResultExtensionExplorer.class;
        synchronized (ResultExtensionExplorer.class) {
            sm_instance = null;
            sm_logger = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Logger getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<ResultExtensionExplorer> clazz = ResultExtensionExplorer.class;
        synchronized (ResultExtensionExplorer.class) {
            if (sm_logger != null) return sm_logger;
            sm_logger = Logger.getLogger(ResultExtensionExplorer.class.getPackage().getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }

    private ResultExtensionExplorer() {
    }

    public void refresh() {
        if (this.m_filterExpressionsByExtn != null) {
            this.m_filterExpressionsByExtn.clear();
        }
        if (this.m_aggregateTypesByExtn != null) {
            this.m_aggregateTypesByExtn.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ExtensionContributor, Map<String, FilterExpressionDefinition>> getCachedFilterExtensions() {
        if (this.m_filterExpressionsByExtn == null) {
            ResultExtensionExplorer resultExtensionExplorer = this;
            synchronized (resultExtensionExplorer) {
                if (this.m_filterExpressionsByExtn == null) {
                    this.m_filterExpressionsByExtn = Collections.synchronizedMap(new HashMap());
                }
            }
        }
        return this.m_filterExpressionsByExtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FilterExpressionDefinition> getCachedFilterDefinitionsByExtension(String extensionId) {
        if (this.getCachedFilterExtensions().isEmpty()) {
            return null;
        }
        Map<ExtensionContributor, Map<String, FilterExpressionDefinition>> map = this.getCachedFilterExtensions();
        synchronized (map) {
            for (Map.Entry<ExtensionContributor, Map<String, FilterExpressionDefinition>> entry : this.getCachedFilterExtensions().entrySet()) {
                if (!entry.getKey().getDeclaringExtensionId().equals(extensionId)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ExtensionContributor, Map<String, AggregateDefinition>> getCachedAggregateExtensions() {
        if (this.m_aggregateTypesByExtn == null) {
            ResultExtensionExplorer resultExtensionExplorer = this;
            synchronized (resultExtensionExplorer) {
                if (this.m_aggregateTypesByExtn == null) {
                    this.m_aggregateTypesByExtn = Collections.synchronizedMap(new HashMap());
                }
            }
        }
        return this.m_aggregateTypesByExtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AggregateDefinition> getCachedAggregateDefinitionsByExtension(String extensionId) {
        if (this.getCachedAggregateExtensions().isEmpty()) {
            return null;
        }
        Map<ExtensionContributor, Map<String, AggregateDefinition>> map = this.getCachedAggregateExtensions();
        synchronized (map) {
            for (Map.Entry<ExtensionContributor, Map<String, AggregateDefinition>> entry : this.getCachedAggregateExtensions().entrySet()) {
                if (!entry.getKey().getDeclaringExtensionId().equals(extensionId)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private Map<String, AggregateDefinition> getContributedAggregateDefinitionMap(ExtensionContributor extensionContributor) throws OdaException {
        Map<String, AggregateDefinition> aggregateDefns = this.getCachedAggregateExtensions().get(extensionContributor);
        if (aggregateDefns == null) {
            ExtensionContributor contributor = this.addExtension(extensionContributor.getDeclaringExtensionId());
            aggregateDefns = this.getContributedAggregateDefinitionMap(contributor);
        }
        return aggregateDefns;
    }

    private FilterExpressionDefinition[] convertFilterDefnValuesToSortByNameArray(Map<String, FilterExpressionDefinition> exprDefns) {
        TreeMap<String, FilterExpressionDefinition> sortedDefnsByName = new TreeMap<String, FilterExpressionDefinition>();
        for (FilterExpressionDefinition exprDefn : exprDefns.values()) {
            sortedDefnsByName.put(exprDefn.getDisplayName(), exprDefn);
        }
        return sortedDefnsByName.values().toArray(new FilterExpressionDefinition[sortedDefnsByName.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtensionContributor[] getCachedContributorsByDataSet(String odaDataSourceId, String odaDataSetId) {
        if (this.getCachedFilterExtensions().isEmpty()) {
            return null;
        }
        ArrayList<ExtensionContributor> contributors = new ArrayList<ExtensionContributor>(this.getCachedFilterExtensions().size());
        Map<ExtensionContributor, Map<String, FilterExpressionDefinition>> map = this.getCachedFilterExtensions();
        synchronized (map) {
            for (ExtensionContributor aContributor : this.getCachedFilterExtensions().keySet()) {
                if (!aContributor.supportsDataSetType(odaDataSourceId, odaDataSetId)) continue;
                contributors.add(aContributor);
            }
        }
        return contributors.isEmpty() ? null : contributors.toArray(new ExtensionContributor[contributors.size()]);
    }

    public ExtensionContributor[] getContributorsOfDataSet(String odaDataSourceId, String odaDataSetId) throws IllegalArgumentException, OdaException {
        if (odaDataSourceId == null || odaDataSourceId.length() == 0) {
            throw new IllegalArgumentException(odaDataSourceId);
        }
        if (odaDataSetId == null || odaDataSetId.length() == 0) {
            throw new IllegalArgumentException(odaDataSetId);
        }
        ExtensionContributor[] contributors = this.getCachedContributorsByDataSet(odaDataSourceId, odaDataSetId);
        if (contributors == null) {
            this.addAllExtensions();
            contributors = this.getCachedContributorsByDataSet(odaDataSourceId, odaDataSetId);
        }
        return contributors == null ? EMTPY_CONTRIBUTOR_ARRAY : contributors;
    }

    private Map<String, FilterExpressionDefinition> getContributedFilterDefinitionMap(ExtensionContributor extensionContributor) throws OdaException {
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getCachedFilterExtensions().get(extensionContributor);
        if (filterExprDefns == null) {
            ExtensionContributor contributor = this.addExtension(extensionContributor.getDeclaringExtensionId());
            filterExprDefns = this.getContributedFilterDefinitionMap(contributor);
        }
        return filterExprDefns;
    }

    public FilterExpressionDefinition[] getContributedFilterDefinitions(ExtensionContributor extensionContributor) throws IllegalArgumentException, OdaException {
        if (extensionContributor == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        Map<String, FilterExpressionDefinition> exprDefns = this.getContributedFilterDefinitionMap(extensionContributor);
        return this.convertFilterDefnValuesToSortByNameArray(exprDefns);
    }

    public FilterExpressionDefinition[] getExtensionFilterDefinitions(String extensionId) throws IllegalArgumentException, OdaException {
        if (extensionId == null || extensionId.length() == 0) {
            throw new IllegalArgumentException(extensionId);
        }
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getCachedFilterDefinitionsByExtension(extensionId);
        if (filterExprDefns == null) {
            ExtensionContributor contributor = this.addExtension(extensionId);
            filterExprDefns = this.getContributedFilterDefinitionMap(contributor);
        }
        return this.convertFilterDefnValuesToSortByNameArray(filterExprDefns);
    }

    public FilterExpressionDefinition getContributedFilterDefinition(ExtensionContributor extensionContributor, String exprId) throws IllegalArgumentException, OdaException {
        if (extensionContributor == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        if (exprId == null || exprId.length() == 0) {
            throw new IllegalArgumentException(exprId);
        }
        Map<String, FilterExpressionDefinition> exprDefns = this.getContributedFilterDefinitionMap(extensionContributor);
        return exprDefns == null ? null : exprDefns.get(exprId);
    }

    public FilterExpressionDefinition getExtensionFilterDefinition(String extensionId, String exprId) throws IllegalArgumentException, OdaException {
        if (extensionId == null || extensionId.length() == 0) {
            throw new IllegalArgumentException(extensionId);
        }
        if (exprId == null || exprId.length() == 0) {
            throw new IllegalArgumentException(exprId);
        }
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getCachedFilterDefinitionsByExtension(extensionId);
        if (filterExprDefns == null) {
            ExtensionContributor contributor = this.addExtension(extensionId);
            filterExprDefns = this.getContributedFilterDefinitionMap(contributor);
        }
        return filterExprDefns == null ? null : filterExprDefns.get(exprId);
    }

    public ExtensionContributor getExtensionContributor(String extensionId) throws OdaException {
        FilterExpressionDefinition[] defns = this.getExtensionFilterDefinitions(extensionId);
        if (defns.length == 0) {
            return null;
        }
        return defns[0].getContributor();
    }

    private void addAllExtensions() throws OdaException {
        IExtension[] extensions = ManifestExplorer.getExtensions(DTP_ODA_DYNAMIC_RESULT_SETS_EXT_POINT);
        int i = 0;
        while (i < extensions.length) {
            this.addExtension(extensions[i], false);
            ++i;
        }
    }

    private ExtensionContributor addExtension(String extensionId) throws OdaException {
        IExtension[] extensions = ManifestExplorer.getExtensions(DTP_ODA_DYNAMIC_RESULT_SETS_EXT_POINT);
        IExtension dynamicResultExtn = ResultExtensionExplorer.findExtension(extensionId, extensions);
        if (dynamicResultExtn == null) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_EXTENSION_ID_NOT_FOUND, (Object[])new Object[]{DTP_ODA_DYNAMIC_RESULT_SETS_EXT_POINT, extensionId}));
        }
        ExtensionContributor contributor = this.addExtension(dynamicResultExtn, true);
        return contributor;
    }

    private static IExtension findExtension(String extensionId, IExtension[] extensions) throws OdaException {
        int length = extensions == null ? 0 : extensions.length;
        int i = 0;
        while (i < length) {
            IExtension extension = extensions[i];
            if (extensionId.equals(extension.getUniqueIdentifier())) {
                return extension;
            }
            ++i;
        }
        return null;
    }

    private ExtensionContributor addExtension(IExtension dynamicResultExtn, boolean replaceExisting) throws OdaException {
        IConfigurationElement[] aggregateExprGroup;
        int i;
        IConfigurationElement[] filterExprGroup;
        IConfigurationElement contributorElement = ManifestUtil.getNamedElement(dynamicResultExtn, "contributor");
        if (contributorElement == null) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_MISSING_EXT_POINT_ELEMENT, (Object[])new Object[]{DTP_ODA_DYNAMIC_RESULT_SETS_EXT_POINT, dynamicResultExtn.getUniqueIdentifier(), "contributor"}));
        }
        ExtensionContributor contributor = new ExtensionContributor(contributorElement);
        if ((replaceExisting || this.getCachedFilterExtensions().get(contributor) == null) && (filterExprGroup = ManifestUtil.getNamedElements(dynamicResultExtn, FILTER_GROUP_NAME)).length > 0) {
            IConfigurationElement[] filterExprElements = filterExprGroup[0].getChildren("filterType");
            HashMap<String, FilterExpressionDefinition> filterExprs = new HashMap<String, FilterExpressionDefinition>(filterExprElements.length);
            i = 0;
            while (i < filterExprElements.length) {
                FilterExpressionDefinition filerExprDefn = new FilterExpressionDefinition(filterExprElements[i], contributor);
                filterExprs.put(filerExprDefn.getId(), filerExprDefn);
                ++i;
            }
            this.getCachedFilterExtensions().put(contributor, filterExprs);
        }
        if ((aggregateExprGroup = ManifestUtil.getNamedElements(dynamicResultExtn, AGGREGATE_GROUP_NAME)).length > 0) {
            IConfigurationElement[] aggregateElements = aggregateExprGroup[0].getChildren("aggregateType");
            HashMap<String, AggregateDefinition> aggregateExprs = new HashMap<String, AggregateDefinition>(aggregateElements.length);
            i = 0;
            while (i < aggregateElements.length) {
                AggregateDefinition aggregateDefn = new AggregateDefinition(aggregateElements[i], contributor);
                aggregateExprs.put(aggregateDefn.getId(), aggregateDefn);
                ++i;
            }
            this.getCachedAggregateExtensions().put(contributor, aggregateExprs);
        }
        return contributor;
    }

    public AggregateDefinition[] getContributedAggregateDefinitions(ExtensionContributor extensionContributor) throws IllegalArgumentException, OdaException {
        if (extensionContributor == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        Map<String, AggregateDefinition> exprDefns = this.getContributedAggregateDefinitionMap(extensionContributor);
        return this.convertAggregateDefnValuesToSortByNameArray(exprDefns);
    }

    public AggregateDefinition[] getExtensionAggregateDefinitions(String extensionId) throws IllegalArgumentException, OdaException {
        if (extensionId == null || extensionId.length() == 0) {
            throw new IllegalArgumentException(extensionId);
        }
        Map<String, AggregateDefinition> exprDefns = this.getCachedAggregateDefinitionsByExtension(extensionId);
        if (exprDefns == null) {
            ExtensionContributor contributor = this.addExtension(extensionId);
            exprDefns = this.getContributedAggregateDefinitionMap(contributor);
        }
        return this.convertAggregateDefnValuesToSortByNameArray(exprDefns);
    }

    public AggregateDefinition getContributedAggregateDefinition(ExtensionContributor extensionContributor, String exprId) throws IllegalArgumentException, OdaException {
        if (extensionContributor == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        if (exprId == null || exprId.length() == 0) {
            throw new IllegalArgumentException(exprId);
        }
        Map<String, AggregateDefinition> exprDefns = this.getContributedAggregateDefinitionMap(extensionContributor);
        return exprDefns == null ? null : exprDefns.get(exprId);
    }

    public AggregateDefinition getExtensionAggregateDefinition(String extensionId, String exprId) throws IllegalArgumentException, OdaException {
        if (extensionId == null || extensionId.length() == 0) {
            throw new IllegalArgumentException(extensionId);
        }
        if (exprId == null || exprId.length() == 0) {
            throw new IllegalArgumentException(exprId);
        }
        Map<String, AggregateDefinition> exprDefns = this.getCachedAggregateDefinitionsByExtension(extensionId);
        if (exprDefns == null) {
            ExtensionContributor contributor = this.addExtension(extensionId);
            exprDefns = this.getContributedAggregateDefinitionMap(contributor);
        }
        return exprDefns == null ? null : exprDefns.get(exprId);
    }

    private AggregateDefinition[] convertAggregateDefnValuesToSortByNameArray(Map<String, AggregateDefinition> exprDefns) {
        TreeMap<String, AggregateDefinition> sortedDefnsByName = new TreeMap<String, AggregateDefinition>();
        for (AggregateDefinition exprDefn : exprDefns.values()) {
            sortedDefnsByName.put(exprDefn.getDisplayName(), exprDefn);
        }
        return sortedDefnsByName.values().toArray(new AggregateDefinition[sortedDefnsByName.size()]);
    }
}

