/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.swt.composites.GroupSortingDialog;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class BaseGroupSortingDialog
extends GroupSortingDialog {
    public BaseGroupSortingDialog(Shell shell, ChartWizardContext wizardContext, SeriesDefinition sd) {
        super(shell, wizardContext, sd);
    }

    public void createSortArea(Composite parent) {
        super.createSortArea(parent);
        if (this.onlyCategoryExprAsCategorySortKey()) {
            this.setSortKeySelectionState(false);
        }
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
        if (event.widget == this.cmbSorting) {
            if (!this.cmbSorting.getText().equals(UNSORTED_OPTION) && this.onlyCategoryExprAsCategorySortKey()) {
                this.cmbSortExpr.setText((String)this.getBaseSeriesExpression().toArray()[0]);
            }
            this.populateSortKeyList();
        } else if (event.widget == this.cmbSortExpr) {
            this.getSeriesDefinitionForProcessing().getSortKey().setDefinition(this.cmbSortExpr.getText());
        }
    }

    protected void populateLists() {
        super.populateLists();
        this.populateSortKeyList();
    }

    private void populateSortKeyList() {
        this.initSortKey();
        LinkedHashSet<String> exprList = new LinkedHashSet<String>();
        String sortExpr = null;
        if (this.cmbSorting.getText().equals(UNSORTED_OPTION)) {
            this.getSeriesDefinitionForProcessing().eUnset((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting());
            exprList.add("");
        } else {
            exprList.addAll(this.getBaseSeriesExpression());
            if (!this.onlyCategoryExprAsCategorySortKey()) {
                exprList.addAll(this.getValueSeriesExpressions());
            }
            if (!this.onlyCategoryExprAsCategorySortKey()) {
                sortExpr = this.getSeriesDefinitionForProcessing().getSortKey().getDefinition();
                this.setSortKeySelectionState(true);
            } else {
                this.setSortKeySelectionState(false);
            }
        }
        if (sortExpr != null && !"".equals(sortExpr)) {
            exprList.add(sortExpr);
        }
        this.cmbSortExpr.removeAll();
        Iterator iter = exprList.iterator();
        while (iter.hasNext()) {
            this.cmbSortExpr.add((String)iter.next());
        }
        if (sortExpr != null && !"".equals(sortExpr)) {
            this.cmbSortExpr.setText(sortExpr);
        } else {
            this.cmbSortExpr.select(0);
        }
        this.setSortKeyInModel();
    }
}

