/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesGroupingImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.SeriesGroupingComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GroupSortingDialog
extends TrayDialog
implements Listener,
SelectionListener {
    protected static final String UNSORTED_OPTION = Messages.getString("BaseSeriesDataSheetImpl.Choice.Unsorted");
    protected ChartWizardContext wizardContext;
    private SeriesDefinition sd;
    protected Combo cmbSorting;
    protected Combo cmbSortExpr;
    protected Button btnSortExprBuilder;
    protected boolean fEnableAggregation = true;
    private boolean fHasExprBuilder = true;
    protected SeriesGroupingComposite fGroupingComposite;

    public GroupSortingDialog(Shell shell, ChartWizardContext wizardContext, SeriesDefinition sd) {
        super(shell);
        this.wizardContext = wizardContext;
        this.sd = sd;
    }

    public GroupSortingDialog(Shell shell, ChartWizardContext wizardContext, SeriesDefinition sd, boolean disableAggregation, boolean hasExprBuilder) {
        super(shell);
        this.wizardContext = wizardContext;
        this.sd = sd;
        this.fEnableAggregation = disableAggregation;
        this.fHasExprBuilder = hasExprBuilder;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        c.pack();
        return c;
    }

    protected Control createDialogArea(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.GroupAndSort_ID");
        this.getShell().setText(Messages.getString("GroupSortingDialog.Label.GroupAndSorting"));
        Composite cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(2, false);
        cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        cmpContent.setLayoutData((Object)gd);
        Composite cmpBasic = new Composite(cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(768);
        cmpBasic.setLayoutData((Object)gd);
        this.createSortArea(cmpBasic);
        if (ChartUIUtil.isGroupingSupported((ChartWizardContext)this.wizardContext)) {
            this.createGroupArea(cmpBasic);
        }
        this.initSortKey();
        this.populateLists();
        return cmpContent;
    }

    protected void createGroupArea(Composite cmpBasic) {
        Composite cmpGrouping = new Composite(cmpBasic, 0);
        GridData gdCMPGrouping = new GridData(768);
        gdCMPGrouping.horizontalSpan = 2;
        cmpGrouping.setLayoutData((Object)gdCMPGrouping);
        cmpGrouping.setLayout((Layout)new FillLayout());
        this.fGroupingComposite = this.createSeriesGroupingComposite(cmpGrouping);
    }

    protected SeriesGroupingComposite createSeriesGroupingComposite(Composite parent) {
        SeriesGrouping grouping = this.getSeriesDefinitionForProcessing().getGrouping();
        if (grouping == null) {
            grouping = SeriesGroupingImpl.create();
            this.getSeriesDefinitionForProcessing().setGrouping(grouping);
        }
        return new SeriesGroupingComposite(parent, 0, grouping, this.fEnableAggregation, this.wizardContext, null);
    }

    public void createSortArea(Composite parent) {
        Composite cmpSortArea = new Composite(parent, 0);
        cmpSortArea.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        cmpSortArea.setLayoutData((Object)gd);
        Label lblSorting = new Label(cmpSortArea, 0);
        lblSorting.setText(Messages.getString("BaseSeriesDataSheetImpl.Lbl.DataSorting"));
        this.cmbSorting = new Combo(cmpSortArea, 12);
        GridData gdCMBSorting = new GridData(768);
        this.cmbSorting.setLayoutData((Object)gdCMBSorting);
        this.cmbSorting.addListener(13, (Listener)this);
        new Label(cmpSortArea, 0);
        Label lblSortExpr = new Label(cmpSortArea, 0);
        lblSortExpr.setText(Messages.getString("BaseGroupSortingDialog.Label.SortOn"));
        this.cmbSortExpr = new Combo(cmpSortArea, 4);
        GridData gdCMBSortExpr = new GridData(768);
        this.cmbSortExpr.setLayoutData((Object)gdCMBSortExpr);
        this.cmbSortExpr.addListener(13, (Listener)this);
        this.cmbSortExpr.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String sExpr = GroupSortingDialog.this.cmbSortExpr.getText();
                GroupSortingDialog.this.registerSortKey(sExpr);
                GroupSortingDialog.this.getSeriesDefinitionForProcessing().getSortKey().setDefinition(sExpr);
            }
        });
        if (this.fHasExprBuilder) {
            this.btnSortExprBuilder = new Button(cmpSortArea, 8);
            GridData gdBTNBuilder = new GridData();
            gdBTNBuilder.heightHint = 20;
            gdBTNBuilder.widthHint = 20;
            this.btnSortExprBuilder.setLayoutData((Object)gdBTNBuilder);
            this.btnSortExprBuilder.setImage(UIHelper.getImage((String)"icons/obj16/expressionbuilder.gif"));
            this.btnSortExprBuilder.addSelectionListener((SelectionListener)this);
            this.btnSortExprBuilder.setToolTipText(Messages.getString("DataDefinitionComposite.Tooltip.InvokeExpressionBuilder"));
            this.btnSortExprBuilder.getImage().setBackground(this.btnSortExprBuilder.getBackground());
            this.btnSortExprBuilder.setEnabled(this.wizardContext.getUIServiceProvider().isInvokingSupported());
            this.btnSortExprBuilder.setVisible(this.wizardContext.getUIServiceProvider().isEclipseModeSupported());
        }
    }

    protected SeriesDefinition getSeriesDefinitionForProcessing() {
        return this.sd;
    }

    protected void populateLists() {
        this.cmbSorting.add(UNSORTED_OPTION);
        String[] nss = LiteralHelper.sortOptionSet.getDisplayNames();
        int i = 0;
        while (i < nss.length) {
            this.cmbSorting.add(nss[i]);
            ++i;
        }
        if (!this.getSeriesDefinitionForProcessing().eIsSet((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting())) {
            this.cmbSorting.select(0);
        } else {
            this.cmbSorting.select(LiteralHelper.sortOptionSet.getNameIndex(this.getSeriesDefinitionForProcessing().getSorting().getName()) + 1);
        }
        this.diableSortKeySelectionStateBySortDirection();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.cmbSorting) {
            this.diableSortKeySelectionStateBySortDirection();
            if (this.cmbSorting.getText().equals(UNSORTED_OPTION)) {
                this.getSeriesDefinitionForProcessing().eUnset((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting());
                this.getSeriesDefinitionForProcessing().getSortKey().setDefinition(null);
            } else {
                this.getSeriesDefinitionForProcessing().setSorting(SortOption.getByName((String)LiteralHelper.sortOptionSet.getNameByDisplayName(this.cmbSorting.getText())));
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnSortExprBuilder)) {
            try {
                String sExpr = this.wizardContext.getUIServiceProvider().invoke(1, this.cmbSortExpr.getText(), this.wizardContext.getExtendedItem(), "");
                this.registerSortKey(sExpr);
                this.cmbSortExpr.setText(sExpr);
                this.getSeriesDefinitionForProcessing().getSortKey().setDefinition(sExpr);
            }
            catch (ChartException e1) {
                WizardBase.displayException((Throwable)e1);
            }
        }
    }

    private void registerSortKey(String sExpr) {
        String[] items = this.cmbSortExpr.getItems();
        boolean contains = false;
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(sExpr)) {
                contains = true;
                break;
            }
            ++i;
        }
        if (!contains) {
            this.cmbSortExpr.add(sExpr);
        }
    }

    protected void setSortKeySelectionState(boolean enabled) {
        this.cmbSortExpr.setEnabled(enabled);
        if (this.btnSortExprBuilder != null) {
            this.btnSortExprBuilder.setEnabled(enabled);
        }
    }

    protected void diableSortKeySelectionStateBySortDirection() {
        if (this.cmbSorting.getText().equals(UNSORTED_OPTION)) {
            this.setSortKeySelectionState(false);
        }
    }

    protected void initSortKey() {
        if (this.getSeriesDefinitionForProcessing().getSortKey() == null) {
            this.getSeriesDefinitionForProcessing().setSortKey(QueryImpl.create(null));
        }
    }

    protected boolean onlyCategoryExprAsCategorySortKey() {
        boolean isCube;
        int stateInfo = this.wizardContext.getDataServiceProvider().getState();
        boolean bl = isCube = (stateInfo & 2) == 2 && (stateInfo & 0x10) != 16;
        return this.isYGroupingEnabled() && !isCube;
    }

    protected boolean isYGroupingEnabled() {
        SeriesDefinition baseSD = null;
        SeriesDefinition orthSD = null;
        Object[] orthAxisArray = null;
        Chart cm = this.wizardContext.getModel();
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)cm;
            orthAxisArray = cwa.getOrthogonalAxes(cwa.getBaseAxes()[0], true);
            orthSD = (SeriesDefinition)((Axis)orthAxisArray[0]).getSeriesDefinitions().get(0);
        } else if (cm instanceof ChartWithoutAxes) {
            ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
            baseSD = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
            orthSD = (SeriesDefinition)baseSD.getSeriesDefinitions().get(0);
        }
        String yGroupExpr = null;
        if (orthSD != null && orthSD.getQuery() != null) {
            yGroupExpr = orthSD.getQuery().getDefinition();
        }
        return yGroupExpr != null && !"".equals(yGroupExpr);
    }

    protected Set getBaseSeriesExpression() {
        LinkedHashSet<String> exprList = new LinkedHashSet<String>();
        Chart chart = this.wizardContext.getModel();
        if (chart instanceof ChartWithAxes) {
            SeriesDefinition baseSD;
            Series seBase;
            EList elBaseSeries;
            Axis axPrimaryBase = ((ChartWithAxes)chart).getPrimaryBaseAxes()[0];
            EList elSD = axPrimaryBase.getSeriesDefinitions();
            if (elSD != null && elSD.size() >= 1 && (elBaseSeries = (seBase = (baseSD = (SeriesDefinition)elSD.get(0)).getDesignTimeSeries()).getDataDefinition()) != null && elBaseSeries.size() >= 1) {
                String baseSeriesExpression = ((Query)elBaseSeries.get(0)).getDefinition();
                exprList.add(baseSeriesExpression);
            }
        } else {
            EList lstSDs = ((ChartWithoutAxes)chart).getSeriesDefinitions();
            int i = 0;
            while (i < lstSDs.size()) {
                SeriesDefinition sd = (SeriesDefinition)lstSDs.get(i);
                Series series = sd.getDesignTimeSeries();
                EList seriesList = series.getDataDefinition();
                if (seriesList.size() > 0) {
                    int j = 0;
                    while (j < seriesList.size()) {
                        Query qSeries = (Query)seriesList.get(j);
                        if (qSeries != null && qSeries.getDefinition() != null) {
                            exprList.add(qSeries.getDefinition());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return exprList;
    }

    protected Set getValueSeriesExpressions() {
        LinkedHashSet<String> exprList = new LinkedHashSet<String>();
        Chart chart = this.wizardContext.getModel();
        if (chart instanceof ChartWithAxes) {
            Axis axPrimaryBase = ((ChartWithAxes)chart).getPrimaryBaseAxes()[0];
            Axis[] axaOrthogonal = ((ChartWithAxes)chart).getOrthogonalAxes(axPrimaryBase, true);
            int j = 0;
            while (j < axaOrthogonal.length) {
                EList lstOrthogonalSDs = axaOrthogonal[j].getSeriesDefinitions();
                int k = 0;
                while (k < lstOrthogonalSDs.size()) {
                    SeriesDefinition orthoSD = (SeriesDefinition)lstOrthogonalSDs.get(k);
                    Series seOrthogonal = orthoSD.getDesignTimeSeries();
                    EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
                    if (elOrthogonalSeries.size() > 0) {
                        int i = 0;
                        while (i < elOrthogonalSeries.size()) {
                            Query qOrthogonalSeries = (Query)elOrthogonalSeries.get(i);
                            if (qOrthogonalSeries != null && qOrthogonalSeries.getDefinition() != null) {
                                exprList.add(qOrthogonalSeries.getDefinition());
                            }
                            ++i;
                        }
                    }
                    ++k;
                }
                ++j;
            }
        } else {
            EList lstSDs = ((ChartWithoutAxes)chart).getSeriesDefinitions();
            int i = 0;
            while (i < lstSDs.size()) {
                SeriesDefinition sd = (SeriesDefinition)lstSDs.get(i);
                EList orthSDs = sd.getSeriesDefinitions();
                for (SeriesDefinition orthSD : orthSDs) {
                    Series orthSeries = orthSD.getDesignTimeSeries();
                    EList orthSeriesList = orthSeries.getDataDefinition();
                    if (orthSeriesList.size() <= 0) continue;
                    int j = 0;
                    while (j < orthSeriesList.size()) {
                        Query qSeries = (Query)orthSeriesList.get(j);
                        if (qSeries != null && qSeries.getDefinition() != null) {
                            exprList.add(qSeries.getDefinition());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return exprList;
    }

    protected void setSortKeyInModel() {
        String sortKey = this.cmbSortExpr.getText();
        if ("".equals(sortKey)) {
            sortKey = null;
        }
        this.getSeriesDefinitionForProcessing().getSortKey().setDefinition(sortKey);
    }
}

