/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ColorPalette;
import org.eclipse.birt.chart.ui.swt.DataDefinitionTextManager;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.BaseDataDefinitionComponent;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DataDefinitionSelector
extends DefaultSelectDataComponent
implements SelectionListener {
    private EList<SeriesDefinition> seriesDefns = null;
    private ChartWizardContext wizardContext = null;
    private String sTitle = null;
    private Composite cmpTop = null;
    private Composite cmpData = null;
    private ISelectDataComponent dataComponent = null;
    private Button btnAxisDelete;
    private Combo cmbAxisSelect;
    private Button btnSeriesDelete;
    private Combo cmbSeriesSelect;
    private int axisIndex;
    private String selectionName = Messages.getString("DataDefinitionSelector.Label.Series");
    private String description = "";
    private int areaType = 1;
    private ISelectDataCustomizeUI selectDataUI = null;

    public DataDefinitionSelector(int axisIndex, EList seriesDefns, ChartWizardContext wizardContext, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this.seriesDefns = seriesDefns;
        this.wizardContext = wizardContext;
        this.sTitle = sTitle;
        this.axisIndex = axisIndex;
        this.selectDataUI = selectDataUI;
    }

    public DataDefinitionSelector(ChartWizardContext wizardContext, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this.wizardContext = wizardContext;
        this.sTitle = sTitle;
        this.axisIndex = -1;
        this.selectDataUI = selectDataUI;
    }

    public Composite createArea(Composite parent) {
        if (this.axisIndex >= 0) {
            this.cmpTop = new Group(parent, 0);
            ((Group)this.cmpTop).setText(String.valueOf(Messages.getString("DataDefinitionSelector.Label.YAxis")) + (this.axisIndex + 1));
        } else {
            this.cmpTop = new Composite(parent, 0);
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        this.cmpTop.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.cmpTop.setLayoutData((Object)gd);
        if (this.wizardContext.isMoreAxesSupported()) {
            this.cmbAxisSelect = new Combo(this.cmpTop, 12);
            this.cmbAxisSelect.setLayoutData((Object)new GridData(768));
            this.cmbAxisSelect.addSelectionListener((SelectionListener)this);
            this.refreshAxisCombo();
            this.cmbAxisSelect.select(0);
            this.btnAxisDelete = new Button(this.cmpTop, 0);
            GridData gridData = new GridData();
            gridData.heightHint = 20;
            gridData.widthHint = 20;
            this.btnAxisDelete.setLayoutData((Object)gridData);
            this.btnAxisDelete.setImage(UIHelper.getImage((String)"icons/obj16/delete_edit.gif"));
            this.btnAxisDelete.setToolTipText(Messages.getString("DataDefinitionSelector.Tooltip.RemoveAxis"));
            this.btnAxisDelete.addSelectionListener((SelectionListener)this);
            this.setAxisDeleteEnabled();
            Label lblSeparator = new Label(this.cmpTop, 258);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            lblSeparator.setLayoutData((Object)gd);
            this.axisIndex = this.cmbAxisSelect.getSelectionIndex();
            this.seriesDefns = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)this.getChart(), (int)this.axisIndex);
        }
        this.cmbSeriesSelect = this.createSeriesSelectCombo(this.cmpTop, this.wizardContext);
        this.btnSeriesDelete = this.createSeriesDeleteButton(this.cmpTop, this.wizardContext);
        this.setSeriesDeleteEnabled();
        this.updateDataDefinition();
        return this.cmpTop;
    }

    protected Combo createSeriesSelectCombo(Composite cmpTop, ChartWizardContext wizardContext) {
        Combo combo = new Combo(cmpTop, 12);
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)this);
        this.refreshSeriesCombo(combo);
        combo.select(0);
        return combo;
    }

    protected Button createSeriesDeleteButton(Composite cmpTop, ChartWizardContext wizardContext) {
        Button button = new Button(cmpTop, 0);
        GridData gridData = new GridData();
        ChartUIUtil.setChartImageButtonSizeByPlatform((GridData)gridData);
        button.setLayoutData((Object)gridData);
        button.setImage(UIHelper.getImage((String)"icons/obj16/delete_edit.gif"));
        button.setToolTipText(Messages.getString("DataDefinitionSelector.Tooltip.RemoveSeries"));
        button.addSelectionListener((SelectionListener)this);
        return button;
    }

    private void updateDataDefinition() {
        ISelectDataComponent newComponent = this.getDataDefinitionComponent(this.getCurrentSeriesDefinition());
        if (this.dataComponent != null && this.dataComponent.getClass() == newComponent.getClass()) {
            return;
        }
        if (this.cmpData != null && !this.cmpData.isDisposed()) {
            this.cmpData.dispose();
        }
        this.dataComponent = newComponent;
        this.cmpData = this.dataComponent.createArea(this.cmpTop);
        if (this.cmpData != null) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.cmpData.setLayoutData((Object)gd);
        }
    }

    private SeriesDefinition getCurrentSeriesDefinition() {
        if (this.seriesDefns.isEmpty()) {
            this.addNewSeriesDefinition();
            this.refreshSeriesCombo();
            this.cmbSeriesSelect.select(0);
        }
        return (SeriesDefinition)this.seriesDefns.get(this.cmbSeriesSelect.getSelectionIndex());
    }

    private int getFirstIndexOfSameAxis() {
        if (this.axisIndex > 0) {
            return ChartUIUtil.getLastSeriesIndexWithinAxis((Chart)this.getChart(), (int)(this.axisIndex - 1)) + 1;
        }
        return 0;
    }

    protected void addNewSeriesDefinition() {
        SeriesDefinition sdTmp = SeriesDefinitionImpl.create();
        ChartAdapter.beginIgnoreNotifications();
        if (!this.seriesDefns.isEmpty()) {
            Palette pa = ((SeriesDefinition)this.seriesDefns.get(0)).getSeriesPalette();
            int i = 0;
            while (i < pa.getEntries().size()) {
                int index = i + this.seriesDefns.size();
                int paletteSize = pa.getEntries().size();
                while (index >= pa.getEntries().size()) {
                    index -= paletteSize;
                }
                sdTmp.getSeriesPalette().getEntries().add(i, (Object)((Fill)pa.getEntries().get(index)).copyInstance());
                ++i;
            }
            sdTmp.getSeriesPalette().getEntries().remove(pa.getEntries().size());
            sdTmp.getSeries().add((Object)((SeriesDefinition)this.seriesDefns.get(0)).getDesignTimeSeries().copyInstance());
            sdTmp.setQuery(((SeriesDefinition)this.seriesDefns.get(0)).getQuery().copyInstance());
            this.cleanDataDefinition(sdTmp);
            sdTmp.getDesignTimeSeries().setSeriesIdentifier((Object)"");
            sdTmp.eAdapters().addAll((Collection)((SeriesDefinition)this.seriesDefns.get(0)).eAdapters());
            int firstIndex = this.getFirstIndexOfSameAxis();
            EList list = this.getChart().getSampleData().getOrthogonalSampleData();
            OrthogonalSampleData sdOrthogonal = ((OrthogonalSampleData)list.get(firstIndex)).copyInstance();
            if (this.axisIndex == -1) {
                sdOrthogonal.setSeriesDefinitionIndex(this.seriesDefns.size());
            } else {
                sdOrthogonal.setSeriesDefinitionIndex(ChartUIUtil.getLastSeriesIndexWithinAxis((Chart)this.getChart(), (int)this.axisIndex) + 1);
            }
            sdOrthogonal.setDataSetRepresentation(this.convertDataSetRepresentation(sdOrthogonal.getDataSetRepresentation(), sdOrthogonal.getSeriesDefinitionIndex()));
            sdOrthogonal.eAdapters().addAll((Collection)this.getChart().getSampleData().eAdapters());
            int sdIndex = sdOrthogonal.getSeriesDefinitionIndex();
            ArrayList<OrthogonalSampleData> al = new ArrayList<OrthogonalSampleData>();
            if (sdIndex >= list.size()) {
                list.add((Object)sdOrthogonal);
            } else {
                int i2 = sdIndex;
                while (i2 < list.size()) {
                    al.add((OrthogonalSampleData)list.get(i2));
                    ++i2;
                }
                list.set(sdIndex, (Object)sdOrthogonal);
                i2 = 1;
                while (i2 < al.size()) {
                    list.set(i2 + sdIndex, (Object)((OrthogonalSampleData)al.get(i2 - 1)));
                    ((OrthogonalSampleData)list.get(i2 + sdIndex)).setSeriesDefinitionIndex(i2 + sdIndex);
                    ++i2;
                }
                list.add((Object)((OrthogonalSampleData)al.get(al.size() - 1)));
                ((OrthogonalSampleData)list.get(list.size() - 1)).setSeriesDefinitionIndex(list.size() - 1);
            }
        } else {
            sdTmp.getSeries().add((Object)BarSeriesImpl.create());
            OrthogonalSampleData sampleData = DataFactory.eINSTANCE.createOrthogonalSampleData();
            sampleData.setDataSetRepresentation(ChartUtil.getNewSampleData((AxisType)AxisType.LINEAR_LITERAL, (int)0));
            sampleData.setSeriesDefinitionIndex(0);
            this.getChart().getSampleData().getOrthogonalSampleData().add(this.getFirstIndexOfSameAxis(), (Object)sampleData);
        }
        this.seriesDefns.add((Object)sdTmp);
        ChartAdapter.endIgnoreNotifications();
        ChartUIUtil.setSeriesName((Chart)this.wizardContext.getModel());
    }

    private String convertDataSetRepresentation(String dsRepresentation, int seriesDefinitionIndex) {
        if (dsRepresentation != null) {
            String[] strTok = ChartUtil.getStringTokens((String)dsRepresentation);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < strTok.length) {
                String strDataElement = strTok[i];
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
                NumberFormat nf = NumberFormat.getNumberInstance();
                try {
                    Date dateElement = sdf.parse(strDataElement);
                    dateElement.setTime(dateElement.getTime() + dateElement.getTime() * (long)seriesDefinitionIndex / 10L);
                    sb.append(sdf.format(dateElement));
                }
                catch (ParseException parseException) {
                    try {
                        Number numberElement = nf.parse(strDataElement);
                        sb.append(numberElement.doubleValue() * (double)(seriesDefinitionIndex + 1));
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                }
                if (i < strTok.length - 1) {
                    sb.append(",");
                }
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    private void cleanDataDefinition(SeriesDefinition sd) {
        EList dds = sd.getDesignTimeSeries().getDataDefinition();
        int i = 0;
        while (i < dds.size()) {
            ((Query)dds.get(i)).setDefinition("");
            if (((Query)dds.get(i)).getGrouping() != null) {
                ((Query)dds.get(i)).getGrouping().setEnabled(false);
            }
            ++i;
        }
    }

    private void updateSeriesPalette(int removedIndex) {
        int i = 0;
        int j = 0;
        while (i < this.seriesDefns.size()) {
            if (i != removedIndex) {
                ((SeriesDefinition)this.seriesDefns.get(i)).getSeriesPalette().shift(-j++);
            }
            ++i;
        }
    }

    protected void removeSeriesDefinition() {
        boolean isNotificaionIgnored = ChartAdapter.isNotificationIgnored();
        ChartAdapter.ignoreNotifications((boolean)true);
        int firstIndex = this.getFirstIndexOfSameAxis();
        EList list = this.getChart().getSampleData().getOrthogonalSampleData();
        int i = 0;
        while (i < list.size()) {
            if (((OrthogonalSampleData)list.get(i)).getSeriesDefinitionIndex() == firstIndex + this.cmbSeriesSelect.getSelectionIndex()) {
                list.remove(i);
                break;
            }
            ++i;
        }
        ChartUIUtil.reorderOrthogonalSampleDataIndex((Chart)this.getChart());
        this.updateSeriesPalette(this.cmbSeriesSelect.getSelectionIndex());
        ChartAdapter.ignoreNotifications((boolean)isNotificaionIgnored);
        this.seriesDefns.remove(this.cmbSeriesSelect.getSelectionIndex());
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.equals(this.btnSeriesDelete)) {
            this.updateColorRegistry(this.cmbSeriesSelect.getSelectionIndex());
            this.removeSeriesDefinition();
            this.setSeriesDeleteEnabled();
            int oldSelectedIndex = this.cmbSeriesSelect.getSelectionIndex();
            this.refreshSeriesCombo();
            if (oldSelectedIndex > this.cmbSeriesSelect.getItemCount() - 2) {
                oldSelectedIndex = this.cmbSeriesSelect.getItemCount() - 2;
            }
            this.cmbSeriesSelect.select(oldSelectedIndex);
            this.updateDataDefinition();
            this.refreshQuery();
            this.setSelectedSeriesIndex();
            ChartUIUtil.setSeriesName((Chart)this.wizardContext.getModel());
            this.selectDataUI.layoutAll();
        } else if (e.widget.equals(this.cmbSeriesSelect)) {
            if (this.cmbSeriesSelect.getSelectionIndex() == this.cmbSeriesSelect.getItemCount() - 1 && !this.isPartChart()) {
                this.addNewSeriesDefinition();
                this.setSeriesDeleteEnabled();
                this.refreshSeriesCombo();
                this.cmbSeriesSelect.select(this.cmbSeriesSelect.getItemCount() - 2);
            }
            this.updateDataDefinition();
            this.refreshQuery();
            this.setSelectedSeriesIndex();
            this.selectDataUI.layoutAll();
        } else if (e.widget.equals(this.cmbAxisSelect)) {
            if (this.cmbAxisSelect.getSelectionIndex() == this.cmbAxisSelect.getItemCount() - 1) {
                String currentDimension = ChartUIUtil.getDimensionString((ChartDimension)this.getChart().getDimension());
                boolean isDimensionSupported = this.wizardContext.getChartType().isDimensionSupported(currentDimension, this.wizardContext, this.cmbAxisSelect.getItemCount(), 0);
                if (!isDimensionSupported) {
                    ChartAdapter.beginIgnoreNotifications();
                    this.getChart().setDimension(ChartUIUtil.getDimensionType((String)this.wizardContext.getChartType().getDefaultDimension()));
                    ChartAdapter.endIgnoreNotifications();
                }
                ChartUIUtil.addAxis((ChartWithAxes)((ChartWithAxes)this.getChart()));
                this.setAxisDeleteEnabled();
                this.refreshAxisCombo();
                this.cmbAxisSelect.select(this.cmbAxisSelect.getItemCount() - 2);
            }
            this.axisIndex = this.cmbAxisSelect.getSelectionIndex();
            this.updateAllSeriesUnderAxis();
        } else if (e.widget.equals(this.btnAxisDelete)) {
            this.updateColorRegistry(-1);
            ChartUIUtil.removeAxis((Chart)this.getChart(), (int)this.axisIndex);
            this.setAxisDeleteEnabled();
            this.refreshAxisCombo();
            if (this.axisIndex > this.cmbAxisSelect.getItemCount() - 2) {
                this.axisIndex = this.cmbAxisSelect.getItemCount() - 2;
            }
            this.cmbAxisSelect.select(this.axisIndex);
            ChartUIUtil.setSeriesName((Chart)this.wizardContext.getModel());
            this.updateAllSeriesUnderAxis();
        }
        ChartUIUtil.checkAggregateType((ChartWizardContext)this.wizardContext);
    }

    private void updateAllSeriesUnderAxis() {
        this.seriesDefns = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)this.getChart(), (int)this.axisIndex);
        this.setSeriesDeleteEnabled();
        this.refreshSeriesCombo();
        this.cmbSeriesSelect.select(0);
        this.updateDataDefinition();
        this.refreshQuery();
        this.setSelectedSeriesIndex();
        this.selectDataUI.layoutAll();
    }

    private void updateColorRegistry(int seriesIndex) {
        int i;
        Object dataDefinitions = null;
        if (seriesIndex > -1) {
            dataDefinitions = ((SeriesDefinition)this.seriesDefns.get(seriesIndex)).getDesignTimeSeries().getDataDefinition();
        } else {
            List allSeriesDefns = ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.getChart());
            dataDefinitions = new ArrayList();
            i = 0;
            while (i < allSeriesDefns.size()) {
                dataDefinitions.addAll(((SeriesDefinition)allSeriesDefns.get(i)).getDesignTimeSeries().getDataDefinition());
                ++i;
            }
        }
        HashMap<String, Integer> queryMap = new HashMap<String, Integer>();
        i = 0;
        while (i < dataDefinitions.size()) {
            String expression = ((Query)dataDefinitions.get(i)).getDefinition();
            if (queryMap.containsKey(expression)) {
                int expCount = (Integer)queryMap.get(expression);
                queryMap.put(expression, expCount++);
            } else {
                queryMap.put(expression, 1);
            }
            ++i;
        }
        for (Map.Entry entry : queryMap.entrySet()) {
            String expression = (String)entry.getKey();
            if (DataDefinitionTextManager.getInstance().getNumberOfSameDataDefinition(expression) != ((Integer)entry.getValue()).intValue()) continue;
            ColorPalette.getInstance().retrieveColor(expression);
        }
        final Event e = new Event();
        e.data = this;
        e.type = 2;
        e.detail = 3;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                DataDefinitionSelector.this.wizardContext.getDataSheet().notifyListeners(e);
            }
        });
    }

    private void setSelectedSeriesIndex() {
        if (!this.wizardContext.isMoreAxesSupported()) {
            int axisNum = this.axisIndex < 0 ? 0 : this.axisIndex;
            int[] indexArray = this.selectDataUI.getSeriesIndex();
            indexArray[axisNum] = this.cmbSeriesSelect.getSelectionIndex();
            this.selectDataUI.setSeriesIndex(indexArray);
        }
    }

    private void setSeriesDeleteEnabled() {
        if (this.btnSeriesDelete != null) {
            this.btnSeriesDelete.setEnabled(this.seriesDefns.size() > 1);
        }
    }

    private void setAxisDeleteEnabled() {
        if (this.btnAxisDelete != null) {
            this.btnAxisDelete.setEnabled(ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChart()) > 1);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void refreshQuery() {
        Object[] data = new Object[]{this.getCurrentSeriesDefinition(), ChartUIUtil.getDataQuery((SeriesDefinition)this.getCurrentSeriesDefinition(), (int)0)};
        this.dataComponent.selectArea(true, (Object)data);
    }

    private void refreshSeriesCombo() {
        this.refreshSeriesCombo(this.cmbSeriesSelect);
    }

    private void refreshSeriesCombo(Combo cmbSeriesSelect) {
        ArrayList<String> itemList = new ArrayList<String>();
        int seriesSize = this.seriesDefns.size();
        int i = 1;
        while (i <= seriesSize) {
            itemList.add(String.valueOf(this.selectionName) + " " + i);
            ++i;
        }
        if (!this.isPartChart()) {
            itemList.add(Messages.getString("DataDefinitionSelector.Text.NewSeries"));
        }
        cmbSeriesSelect.removeAll();
        cmbSeriesSelect.setItems(itemList.toArray(new String[seriesSize]));
    }

    private boolean isPartChart() {
        return this.wizardContext.getDataServiceProvider().checkState(32);
    }

    private void refreshAxisCombo() {
        ArrayList<String> itemList = new ArrayList<String>();
        int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChart());
        int i = 1;
        while (i <= axisNum) {
            itemList.add(String.valueOf(Messages.getString("DataDefinitionSelector.Label.Axis")) + i);
            ++i;
        }
        itemList.add(Messages.getString("DataDefinitionSelector.Text.NewAxis"));
        this.cmbAxisSelect.removeAll();
        this.cmbAxisSelect.setItems(itemList.toArray(new String[axisNum]));
    }

    private ISelectDataComponent getDataDefinitionComponent(SeriesDefinition seriesDefn) {
        ISelectDataComponent sdc = this.selectDataUI.getAreaComponent(this.areaType, seriesDefn, this.wizardContext, this.sTitle);
        if (sdc instanceof BaseDataDefinitionComponent) {
            ((BaseDataDefinitionComponent)sdc).setDescription(this.description);
        }
        return sdc;
    }

    public void selectArea(boolean selected, Object data) {
        this.dataComponent.selectArea(selected, data);
    }

    public void dispose() {
        if (this.dataComponent != null) {
            this.dataComponent.dispose();
        }
        super.dispose();
    }

    public void setSelectionPrefix(String selectionNamePrefix) {
        this.selectionName = selectionNamePrefix;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAreaType(int areaType) {
        this.areaType = areaType;
    }

    private Chart getChart() {
        return this.wizardContext.getModel();
    }
}

