/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class AggregateOnBindingsFormHandleProvider
extends DataSetColumnBindingsFormHandleProvider {
    public AggregateOnBindingsFormHandleProvider() {
        this.setShowAggregation(true);
    }

    public AggregateOnBindingsFormHandleProvider(boolean bShowAggregation) {
        this.setShowAggregation(bShowAggregation);
    }

    public boolean doAddAggregateOnItem(int pos) {
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(true);
        dialog.setAggreate(true);
        dialog.setInput((ReportItemHandle)this.getBindingObject());
        if (dialog.open() == 0 && this.viewer != null) {
            this.viewer.refresh(true);
            return true;
        }
        return false;
    }

    public boolean doEditItem(int pos) {
        ComputedColumnHandle bindingHandle = null;
        if ((pos = this.getOriginalIndex(pos)) > -1 && this.getBindingObject() instanceof ReportItemHandle) {
            bindingHandle = (ComputedColumnHandle)((ReportItemHandle)this.getBindingObject()).getColumnBindings().getAt(pos);
        }
        if (bindingHandle == null) {
            return false;
        }
        boolean isResultSetColumn = false;
        String resultSetName = null;
        if (this.getBindingObject() instanceof DataItemHandle) {
            resultSetName = ((DataItemHandle)this.getBindingObject()).getResultSetColumn();
        }
        if (resultSetName != null && bindingHandle.getName().equals(resultSetName)) {
            isResultSetColumn = true;
        }
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(false);
        dialog.setInput((ReportItemHandle)this.getBindingObject(), bindingHandle);
        if (dialog.open() == 0) {
            if (isResultSetColumn) {
                try {
                    ((DataItemHandle)this.getBindingObject()).setResultSetColumn(bindingHandle.getName());
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            if (this.viewer != null) {
                this.viewer.refresh(true);
                return true;
            }
        }
        return false;
    }

    public void addAggregateOn(int pos) throws Exception {
        boolean sucess = false;
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
        try {
            sucess = this.doAddAggregateOnItem(pos);
        }
        catch (Exception e) {
            stack.rollback();
            throw new Exception(e);
        }
        if (sucess) {
            stack.commit();
        } else {
            stack.rollback();
        }
    }
}

