/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import com.ibm.icu.util.ULocale;
import java.text.Collator;
import java.util.TreeMap;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;

public abstract class FormatDescriptorProvider
extends AbstractDescriptorProvider {
    protected static final String NONE = Messages.getString((String)"FormatDescriptorProvider.DisplayName.None");
    public static final TreeMap<String, ULocale> LOCALE_TABLE = new TreeMap(Collator.getInstance());

    static {
        ULocale[] locales = ULocale.getAvailableLocales();
        if (locales != null) {
            int i = 0;
            while (i < locales.length) {
                ULocale locale = locales[i];
                if (locale != null) {
                    LOCALE_TABLE.put(locale.getDisplayName(), locale);
                }
                ++i;
            }
        }
    }

    public String[] getLocaleDisplayNames() {
        String[] oldNames = LOCALE_TABLE.keySet().toArray(new String[0]);
        String[] newNames = new String[oldNames.length + 1];
        newNames[0] = NONE;
        System.arraycopy(oldNames, 0, newNames, 1, oldNames.length);
        return newNames;
    }

    public ULocale getLocaleByDisplayName(String localeDisplayName) {
        if (NONE.equals(localeDisplayName) || localeDisplayName == null) {
            return null;
        }
        return LOCALE_TABLE.get(localeDisplayName);
    }

    public String getLocaleDisplayName(ULocale locale) {
        if (locale == null) {
            return NONE;
        }
        return locale.getDisplayName();
    }
}

