/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ITextDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.HyperlinkBuilder;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.ui.PlatformUI;

public class HyperLinkDescriptorProvider
extends AbstractDescriptorProvider
implements ITextDescriptorProvider {
    private static final String LABEL_LINK_TO = Messages.getString((String)"HyperLinkPage.Label.LnikTo");
    private static final String LABEL_NONE = Messages.getString((String)"HyperLinkPage.Label.None");
    private Object oldValue;
    protected Object input;
    private boolean needRefresh = true;

    public String getDisplayName() {
        return LABEL_LINK_TO;
    }

    public Object load() {
        if (this.needRefresh) {
            if (this.getActionHandle() != null) {
                String previewString = null;
                if ("hyperlink".equals(this.getActionHandle().getLinkType())) {
                    previewString = this.getActionHandle().getURI();
                } else if ("bookmark-link".equals(this.getActionHandle().getLinkType())) {
                    previewString = this.getActionHandle().getTargetBookmark();
                } else if ("drill-through".equals(this.getActionHandle().getLinkType())) {
                    previewString = this.getActionHandle().getReportName();
                    if (this.getActionHandle().getTargetBookmark() != null) {
                        previewString = String.valueOf(previewString) + ":" + this.getActionHandle().getTargetBookmark();
                    }
                }
                this.oldValue = previewString == null ? LABEL_NONE : previewString;
            } else {
                this.oldValue = LABEL_NONE;
            }
        }
        return this.oldValue;
    }

    public void save(Object value) throws SemanticException {
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public boolean hyperLinkSelected() {
        boolean flag = true;
        HyperlinkBuilder dialog = new HyperlinkBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        this.getActionStack().startTrans(Messages.getString((String)"HyperLinkPage.Menu.Save"));
        ActionHandle handle = this.getActionHandle();
        if (handle == null) {
            try {
                handle = DEUtil.setAction((ReportItemHandle)((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input)), (Action)StructureFactory.createAction());
            }
            catch (SemanticException e1) {
                this.getActionStack().rollback();
                ExceptionHandler.handle((Throwable)e1);
                return false;
            }
        }
        dialog.setInput(handle);
        this.needRefresh = false;
        boolean isOK = dialog.open() == 0;
        this.needRefresh = true;
        if (isOK) {
            this.getActionStack().commit();
            flag = true;
        } else {
            this.getActionStack().rollback();
            flag = false;
        }
        return flag;
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    private ActionHandle getActionHandle() {
        return DEUtil.getActionHandle((ReportItemHandle)((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input)));
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isEnable() {
        return DEUtil.getInputSize((Object)this.input) == 1;
    }
}

