/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.graphics.Image;

public class MarginsPropertyDescriptorProvider
extends PropertyDescriptorProvider {
    private IChoiceSet choiceSet;

    public MarginsPropertyDescriptorProvider(String property, String element) {
        super(property, element);
        this.choiceSet = ChoiceSetFactory.getDimensionChoiceSet((String)element, (String)property);
    }

    public String getUnit(String unit) {
        IChoice choice = this.choiceSet.findChoiceByDisplayName(unit);
        if (choice != null) {
            return choice.getName();
        }
        return null;
    }

    public String getUnitDisplayName(String unit) {
        IChoice choice = this.choiceSet.findChoice(unit);
        if (choice != null) {
            return choice.getDisplayName();
        }
        return null;
    }

    public String[] getUnits() {
        return ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)this.choiceSet);
    }

    public String getDefaultUnit() {
        String value = this.load().toString();
        if (value == null || value.equals("")) {
            return value;
        }
        try {
            DimensionValue dimensionValue = DimensionValue.parse((String)value);
            return dimensionValue.getUnits();
        }
        catch (PropertyValueException e) {
            ExceptionHandler.handle((Throwable)e);
            return "";
        }
    }

    public String getMeasureValue() {
        String value = this.load().toString();
        if (value == null || value.equals("")) {
            return value;
        }
        try {
            DimensionValue dimensionValue = DimensionValue.parse((String)value);
            return StringUtil.doubleToString((double)dimensionValue.getMeasure(), (int)3);
        }
        catch (PropertyValueException e) {
            ExceptionHandler.handle((Throwable)e);
            return "";
        }
    }

    public Image getImage() {
        return ReportPlatformUIImages.getImage((String)this.getProperty());
    }
}

