/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;

public class SimpleComboPropertyDescriptorProvider
extends PropertyDescriptorProvider {
    public SimpleComboPropertyDescriptorProvider(String property, String element) {
        super(property, element);
    }

    public String[] getItems() {
        String[] items = null;
        if ("dataSet".equals(this.getProperty())) {
            items = ChoiceSetFactory.getDataSets();
        } else if ("masterPage".equals(this.getProperty())) {
            items = ChoiceSetFactory.getMasterPages();
        } else if ("style".equals(this.getProperty())) {
            items = this.getModifiedStyles();
        } else if ("theme".equals(this.getProperty())) {
            items = ChoiceSetFactory.getThemes();
        }
        return items;
    }

    private String[] getAllStyles() {
        String[] items = ChoiceSetFactory.getStyles();
        List preStyles = DesignEngine.getMetaDataDictionary().getPredefinedStyles();
        ArrayList<String> preStyleNames = new ArrayList<String>();
        int i = 0;
        while (i < preStyles.size()) {
            preStyleNames.add(((IPredefinedStyle)preStyles.get(i)).getName());
            ++i;
        }
        ArrayList<String> sytleNames = new ArrayList<String>();
        int i2 = 0;
        while (i2 < items.length) {
            if (preStyleNames.indexOf(items[i2]) == -1) {
                sytleNames.add(items[i2]);
            }
            ++i2;
        }
        String[] styleNamesArray = sytleNames.toArray(new String[0]);
        return styleNamesArray;
    }

    private String[] getModifiedStyles() {
        String[] styleNamesArray;
        block10: {
            LibraryHandle libary;
            ThemeHandle theme;
            ArrayList cssList;
            ModuleHandle module;
            ArrayList<String> sytleNames;
            block8: {
                styleNamesArray = this.getAllStyles();
                sytleNames = new ArrayList<String>();
                sytleNames.addAll(Arrays.asList(styleNamesArray));
                module = SessionHandleAdapter.getInstance().getReportDesignHandle();
                cssList = new ArrayList();
                if (!(module instanceof ReportDesignHandle)) break block8;
                ReportDesignHandle reportDesign = (ReportDesignHandle)module;
                cssList.addAll(reportDesign.getAllCssStyleSheets());
                int i = 0;
                while (i < cssList.size()) {
                    block9: {
                        CssStyleSheetHandle css = (CssStyleSheetHandle)cssList.get(i);
                        IncludedCssStyleSheetHandle inCss = reportDesign.findIncludedCssStyleSheetHandleByFileName(css.getFileName());
                        if (inCss == null || inCss.getExternalCssURI() == null || inCss.getExternalCssURI().length() <= 0) break block9;
                        String fileName = inCss.getExternalCssURI();
                        CssStyleSheetHandle uriCss = null;
                        try {
                            uriCss = SessionHandleAdapter.getInstance().getReportDesignHandle().openCssStyleSheet(fileName);
                            if (uriCss == null) {
                            }
                        }
                        catch (StyleSheetException styleSheetException) {}
                        break block9;
                        Iterator iter = css.getStyleIterator();
                        while (iter.hasNext()) {
                            SharedStyleHandle styleHandle = (SharedStyleHandle)iter.next();
                            int index = sytleNames.indexOf(styleHandle.getName());
                            if (index < 0 || uriCss.findStyle(styleHandle.getName()) == null) continue;
                            styleNamesArray[index] = String.valueOf(styleHandle.getName()) + " " + Messages.getString((String)"CssStyleSheetNodeProvider.Tooltip.URI");
                        }
                    }
                    ++i;
                }
                break block10;
            }
            if (!(module instanceof LibraryHandle) || (theme = (libary = (LibraryHandle)module).getTheme()) == null) break block10;
            cssList.addAll(theme.getAllCssStyleSheets());
            int i = 0;
            while (i < cssList.size()) {
                CssStyleSheetHandle css = (CssStyleSheetHandle)cssList.get(i);
                IncludedCssStyleSheetHandle inCss = theme.findIncludedCssStyleSheetHandleByName(css.getFileName());
                if (inCss != null && inCss.getExternalCssURI() != null && inCss.getExternalCssURI().length() > 0) {
                    Iterator iter = css.getStyleIterator();
                    while (iter.hasNext()) {
                        SharedStyleHandle styleHandle = (SharedStyleHandle)iter.next();
                        int index = sytleNames.indexOf(styleHandle.getName());
                        String tooltipURI = Messages.getString((String)"CssStyleSheetNodeProvider.Tooltip.URI");
                        if (index < 0) continue;
                        styleNamesArray[index] = String.valueOf(styleHandle.getName()) + " " + tooltipURI;
                    }
                }
                ++i;
            }
        }
        return styleNamesArray;
    }

    public boolean isSpecialProperty() {
        return "style".equals(this.getProperty()) || "theme".equals(this.getProperty()) || "masterPage".equals(this.getProperty());
    }

    public void save(Object value) throws SemanticException {
        if ("style".equals(this.getProperty())) {
            String[] styleNamesArray = this.getAllStyles();
            String[] modifiedArray = this.getModifiedStyles();
            int index = Arrays.asList(modifiedArray).indexOf(value);
            value = index >= 0 ? styleNamesArray[index] : null;
        }
        super.save(value);
    }
}

