/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.io.File;
import java.net.URL;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IResourceKeyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResourceKeyDescriptor
extends PropertyDescriptor {
    private Text text;
    private Button btnBrowse;
    private Button btnReset;
    private String oldValue;
    IResourceKeyDescriptorProvider provider;
    private Composite innerParent;

    public ResourceKeyDescriptor(boolean isFormStyle) {
        this.setFormStyle(isFormStyle);
    }

    public void load() {
        if (!this.provider.isEnable()) {
            this.text.setEnabled(false);
            this.btnBrowse.setEnabled(false);
            this.btnReset.setEnabled(false);
            return;
        }
        this.text.setEnabled(true);
        this.btnBrowse.setEnabled(true);
        this.btnReset.setEnabled(true);
        this.oldValue = this.getDescriptorProvider().load().toString();
        String baseName = this.provider.getBaseName();
        if (baseName == null) {
            this.btnBrowse.setEnabled(false);
        } else {
            URL resource = this.provider.getResourceURL();
            String path = null;
            try {
                if (resource != null) {
                    path = DEUtil.getFilePathFormURL((URL)resource);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (resource == null || path == null || !new File(path).exists()) {
                this.btnBrowse.setEnabled(false);
            } else {
                this.btnBrowse.setEnabled(true);
            }
        }
        this.text.setEnabled(baseName != null);
        this.text.setText(DEUtil.resolveNull((String)this.oldValue));
    }

    public Control getControl() {
        return this.innerParent;
    }

    public Control createControl(Composite parent) {
        this.innerParent = new Composite(parent, 0);
        this.innerParent.setLayout((Layout)new GridLayout(3, false));
        this.text = this.isFormStyle() ? FormWidgetFactory.getInstance().createText(this.innerParent, "", 8) : new Text(this.innerParent, 2056);
        this.text.setLayoutData((Object)new GridData(768));
        this.btnBrowse = FormWidgetFactory.getInstance().createButton(this.innerParent, 8, this.isFormStyle());
        this.btnBrowse.setText(this.provider.getBrowseText());
        this.btnBrowse.setToolTipText(this.provider.getBrowseTooltipText());
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceKeyDescriptor.this.handleBrowserSelectedEvent();
            }
        });
        this.btnReset = FormWidgetFactory.getInstance().createButton(this.innerParent, 8, this.isFormStyle());
        this.btnReset.setText(this.provider.getResetText());
        this.btnReset.setToolTipText(this.provider.getResetTooltipText());
        this.btnReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceKeyDescriptor.this.handleSelectedEvent(null);
            }
        });
        return this.innerParent;
    }

    private void handleSelectedEvent(String newValue) {
        if ("".equals(newValue)) {
            newValue = null;
        }
        try {
            if (this.oldValue != null && this.oldValue.equals(newValue)) {
                this.save(null);
            }
            this.save(newValue);
            this.text.setText(DEUtil.resolveNull((String)newValue));
        }
        catch (SemanticException e) {
            this.text.setText(DEUtil.resolveNull((String)this.oldValue));
            WidgetUtil.processError(this.text.getShell(), (Exception)((Object)e));
        }
    }

    public void save(Object obj) throws SemanticException {
        this.getDescriptorProvider().save(obj);
    }

    protected void handleBrowserSelectedEvent() {
        ResourceEditDialog dlg = new ResourceEditDialog(this.btnBrowse.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
        dlg.setResourceURL(this.provider.getResourceURL());
        if (dlg.open() == 0) {
            this.handleSelectedEvent((String)dlg.getResult());
        }
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof IResourceKeyDescriptorProvider) {
            this.provider = (IResourceKeyDescriptorProvider)provider;
        }
    }

    public String getStringValue() {
        return this.text.getText();
    }

    public void setStringValue(String value) {
        this.text.setText(value);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.text, isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.text.setVisible(isVisible);
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.getDescriptorProvider().setInput(input);
    }
}

