/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import org.eclipse.birt.report.designer.core.model.views.outline.IScriptTreeNode;
import org.eclipse.birt.report.designer.core.model.views.outline.ScriptElementNode;
import org.eclipse.birt.report.designer.core.model.views.outline.ScriptObjectNode;
import org.eclipse.birt.report.designer.core.model.views.outline.ScriptsNode;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

public class ScriptTreeNodeProvider
implements INodeProvider {
    private static final String SCRIPS_NODE_NAME = Messages.getString((String)"Scripts.Node.DisplayName");
    private static final Object[] EMPTY = new Object[0];
    private static final String EMPTY_STR = "";

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        if (object instanceof IMenuListener) {
            ((IMenuListener)object).menuAboutToShow(menu);
        }
    }

    public Object[] getChildren(Object object) {
        if (object != null && object instanceof IScriptTreeNode) {
            return ((IScriptTreeNode)object).getChildren();
        }
        return EMPTY;
    }

    public String getNodeDisplayName(Object model) {
        if (model instanceof ScriptsNode) {
            return SCRIPS_NODE_NAME;
        }
        if (model instanceof ScriptElementNode) {
            Object designElementModel = ((ScriptElementNode)model).getParent();
            return DEUtil.getFlatHirarchyPathName((Object)designElementModel);
        }
        if (model instanceof ScriptObjectNode) {
            return ((ScriptObjectNode)model).getText();
        }
        return EMPTY_STR;
    }

    public Image getNodeIcon(Object model) {
        if (model instanceof ScriptsNode) {
            return ReportPlatformUIImages.getImage((String)"Scripts Node");
        }
        if (model instanceof ScriptElementNode) {
            Object designElementModel = ((ScriptElementNode)model).getParent();
            return ProviderFactory.createProvider((Object)designElementModel).getNodeIcon(designElementModel);
        }
        if (model instanceof ScriptObjectNode) {
            return ReportPlatformUIImages.getImage((String)"Script Method Node");
        }
        return null;
    }

    public String getNodeTooltip(Object model) {
        if (model instanceof IScriptTreeNode) {
            this.getNodeDisplayName(model);
        }
        return EMPTY_STR;
    }

    public Object getParent(Object model) {
        if (model instanceof IScriptTreeNode) {
            return ((IScriptTreeNode)model).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public boolean performRequest(Object model, Request request) throws Exception {
        return false;
    }
}

