/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.StatusInfo;
import org.eclipse.help.ui.internal.preferences.TestConnectionUtility;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ViewICPropsDialog
extends StatusDialog
implements IShellProvider {
    private Label nameLabel;
    private Label nameText;
    private Label hostLabel;
    private Label hostText;
    private Label pathLabel;
    private Label pathText;
    private Label portLabel;
    private Label portText;
    private Label urlLabel;
    private Label urlValue;
    private Label enabledLabel;
    private Label enabledValue;
    Point shellSize;
    Point shellLocation;
    private String infoCenterName = "";
    private String selectedName = "";
    private String selectedHost = "";
    private String selectedPort = "";
    private String selectedPath = "";
    private boolean selectedEnabled;

    public ViewICPropsDialog(Shell parentShell, String infoCenterName) {
        super(parentShell);
        this.infoCenterName = infoCenterName;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelpContent");
        Composite topComposite = (Composite)super.createDialogArea(parent);
        topComposite.setSize(topComposite.computeSize(-1, -1));
        Composite topGroup = new Composite(topComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        topGroup.setLayout((Layout)layout);
        topGroup.setFont(topComposite.getFont());
        topGroup.setLayoutData((Object)new GridData(768));
        this.createNameSection(topGroup);
        this.createHostSection(topGroup);
        this.createPathSection(topGroup);
        this.createPortSection(topGroup);
        this.createURLValidateSection(topGroup);
        this.createEnabledSection(topGroup);
        return topComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButton(parent, 0, Messages.ViewICPropsDialog_6, true);
        super.createButton(parent, 1, Messages.ViewICPropsDialog_7, false);
    }

    public void initializeBounds() {
        this.shellSize = this.getInitialSize();
        this.shellLocation = this.getInitialLocation(this.shellSize);
        this.getShell().setBounds(this.shellLocation.x, this.shellLocation.y, this.shellSize.x + 150, this.shellSize.y);
        this.getShell().setText(NLS.bind((String)Messages.ViewICPropsDialog_8, (Object)this.infoCenterName));
    }

    private void createNameSection(Composite parent) {
        this.nameLabel = new Label(parent, 0);
        this.nameLabel.setText(Messages.ViewICPropsDialog_10);
        this.nameText = new Label(parent, 0);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.setText(this.selectedName);
    }

    private void createHostSection(Composite parent) {
        this.hostLabel = new Label(parent, 0);
        this.hostLabel.setText(Messages.ViewICPropsDialog_11);
        this.hostText = new Label(parent, 0);
        this.hostText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hostText.setText(this.selectedHost);
    }

    private void createPathSection(Composite parent) {
        this.pathLabel = new Label(parent, 0);
        this.pathLabel.setText(Messages.ViewICPropsDialog_12);
        this.pathText = new Label(parent, 0);
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pathText.setText(this.selectedPath);
    }

    private void createPortSection(Composite parent) {
        this.portLabel = new Label(parent, 0);
        this.portLabel.setText(Messages.ViewICPropsDialog_13);
        this.portText = new Label(parent, 0);
        this.portText.setText(this.selectedPort);
    }

    private void createURLValidateSection(Composite parent) {
        this.urlLabel = new Label(parent, 0);
        this.urlLabel.setText(Messages.ViewICPropsDialog_URL);
        this.urlValue = new Label(parent, 0);
        if (this.selectedPort.equals("80")) {
            this.urlValue.setText("http://" + this.selectedHost + this.selectedPath);
        } else {
            this.urlValue.setText("http://" + this.selectedHost + ":" + this.selectedPort + this.selectedPath);
        }
    }

    private void createEnabledSection(Composite parent) {
        this.enabledLabel = new Label(parent, 0);
        this.enabledLabel.setText(Messages.ViewICPropsDialog_19);
        this.enabledValue = new Label(parent, 0);
        if (this.selectedEnabled) {
            this.enabledValue.setText(Messages.ViewICPropsDialog_20);
        } else {
            this.enabledValue.setText(Messages.ViewICPropsDialog_21);
        }
    }

    public void setTextValues(String icName, String host, String port, String path, boolean isEnabled) {
        this.selectedName = icName;
        this.selectedHost = host;
        this.selectedPort = port;
        this.selectedPath = path;
        this.selectedEnabled = isEnabled;
    }

    public void okPressed() {
        StatusInfo status = new StatusInfo();
        boolean isConnection = TestConnectionUtility.testConnection(this.selectedHost, this.selectedPort, this.selectedPath);
        if (isConnection) {
            status.setInfo(Messages.ViewICPropsDialog_23);
        } else {
            status.setError(Messages.ViewICPropsDialog_24);
        }
        this.updateStatus(status);
    }

    public void cancelPressed() {
        this.setReturnCode(0);
        this.close();
    }
}

