/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import com.ibm.icu.util.ULocale;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.excel.BlankData;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.DataCache;
import org.eclipse.birt.report.engine.emitter.excel.DateTimeUtil;
import org.eclipse.birt.report.engine.emitter.excel.ExcelEmitter;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.ImageData;
import org.eclipse.birt.report.engine.emitter.excel.RowData;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.Span;
import org.eclipse.birt.report.engine.emitter.excel.StyleBuilder;
import org.eclipse.birt.report.engine.emitter.excel.StyleEngine;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.AxisProcessor;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;
import org.eclipse.birt.report.engine.emitter.excel.layout.PageDef;
import org.eclipse.birt.report.engine.emitter.excel.layout.TableInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsCell;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsTable;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.util.FlashFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelLayoutEngine {
    public static final String EMPTY = "";
    private static final double DEFAULT_ROW_HEIGHT = 15.0;
    private int autoBookmarkIndex = 0;
    public static final String AUTO_GENERATED_BOOKMARK = "auto_generated_bookmark_";
    public static final int MAX_ROW_OFFICE2007 = 0x100000;
    public static final int MAX_COL_OFFICE2007 = 16384;
    public static final int MAX_ROW_OFFICE2003 = 65535;
    public static final int MAX_COLUMN_OFFICE2003 = 255;
    private int maxRow = 65535;
    private int maxCol = 255;
    private HashMap<String, String> cachedBookmarks = new HashMap();
    private DataCache cache;
    private AxisProcessor axis;
    private StyleEngine engine;
    private ExcelEmitter emitter;
    private Stack<XlsContainer> containers = new Stack();
    private Stack<XlsTable> tables = new Stack();
    private ExcelContext context = null;
    private String messageFlashObjectNotSupported;
    private ULocale locale;
    private HashMap<String, BookmarkDef> bookmarkList = new HashMap();

    public ExcelLayoutEngine(PageDef page, ExcelContext context, ExcelEmitter emitter) {
        this.context = context;
        this.emitter = emitter;
        this.locale = context.getLocale();
        EngineResourceHandle resourceHandle = new EngineResourceHandle(this.locale);
        this.messageFlashObjectNotSupported = resourceHandle.getMessage("Error.FlashObjectNotSupported");
        this.initalize(page);
    }

    private void initalize(PageDef page) {
        this.axis = new AxisProcessor();
        this.axis.addCoordinate(page.contentwidth);
        this.setCacheSize();
        ContainerSizeInfo rule = new ContainerSizeInfo(0, page.contentwidth);
        this.cache = new DataCache(this.maxCol, this.maxRow);
        this.engine = new StyleEngine(this);
        this.containers.push(this.createContainer(rule, page.style, null));
    }

    private void setCacheSize() {
        if (this.context.getOfficeVersion().equals("office2007")) {
            this.maxCol = 16384;
        }
    }

    public XlsContainer getCurrentContainer() {
        return this.containers.peek();
    }

    public Stack<XlsContainer> getContainers() {
        return this.containers;
    }

    public void setPageStyle(IStyle style) {
        XlsContainer topContainer = this.containers.peek();
        topContainer.setStyle(StyleBuilder.createStyleEntry(style));
    }

    public void addTable(TableInfo table, IStyle style) {
        XlsContainer currentContainer = this.getCurrentContainer();
        ContainerSizeInfo parentSizeInfo = currentContainer.getSizeInfo();
        int startCoordinate = parentSizeInfo.getStartCoordinate();
        int endCoordinate = parentSizeInfo.getEndCoordinate();
        int[] columnStartCoordinates = this.calculateColumnCoordinates(table, startCoordinate, endCoordinate);
        this.splitColumns(startCoordinate, endCoordinate, columnStartCoordinates);
        this.createTable(table, style, currentContainer, columnStartCoordinates);
    }

    private void createTable(TableInfo tableInfo, IStyle style, XlsContainer currentContainer, int[] columnStartCoordinates) {
        int leftCordinate = columnStartCoordinates[0];
        int width = columnStartCoordinates[columnStartCoordinates.length - 1] - leftCordinate;
        ContainerSizeInfo sizeInfo = new ContainerSizeInfo(leftCordinate, width);
        StyleEntry styleEntry = this.engine.createEntry(sizeInfo, style);
        XlsTable table = new XlsTable(tableInfo, styleEntry, sizeInfo, currentContainer);
        this.tables.push(table);
        this.addContainer(table);
    }

    private void splitColumns(int startCoordinate, int endCoordinate, int[] columnStartCoordinates) {
        int[] scale = this.axis.getColumnCoordinatesInRange(startCoordinate, endCoordinate);
        int i = 0;
        while (i < scale.length - 1) {
            int startPosition = scale[i];
            int endPostion = scale[i + 1];
            int[] range = this.inRange(startPosition, endPostion, columnStartCoordinates);
            if (range.length > 0) {
                int pos = this.axis.getColumnIndexByCoordinate(startPosition);
                this.cache.insertColumns(pos, range.length);
                int j = 0;
                while (j < range.length) {
                    this.axis.addCoordinate(range[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    private int[] calculateColumnCoordinates(TableInfo table, int startCoordinate, int endCoordinate) {
        int columnCount = table.getColumnCount();
        int[] columnStartCoordinates = new int[columnCount + 1];
        columnStartCoordinates[0] = startCoordinate;
        int i = 1;
        while (i <= columnCount) {
            columnStartCoordinates[i] = columnStartCoordinates[i - 1] + table.getColumnWidth(i - 1);
            ++i;
        }
        return columnStartCoordinates;
    }

    private int[] inRange(int start, int end, int[] data) {
        int[] range = new int[data.length];
        int count = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] > start && data[i] < end) {
                range[++count] = data[i];
            }
            ++i;
        }
        int[] result = new int[count];
        int j = 0;
        int i2 = 0;
        while (i2 < range.length) {
            if (range[i2] != 0) {
                result[j] = range[i2];
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public void addCell(int col, int colSpan, int rowSpan, IStyle style) {
        XlsTable table = this.tables.peek();
        ContainerSizeInfo cellSizeInfo = table.getColumnSizeInfo(col, colSpan);
        XlsCell cell = new XlsCell(this.engine.createEntry(cellSizeInfo, style), cellSizeInfo, this.getCurrentContainer(), rowSpan);
        this.addContainer(cell);
    }

    public void endCell() {
        this.endNormalContainer();
    }

    public void addRow(IStyle style) {
        XlsContainer parent = this.getCurrentContainer();
        ContainerSizeInfo sizeInfo = parent.getSizeInfo();
        XlsContainer container = this.createContainer(sizeInfo, style, parent);
        container.setEmpty(false);
        this.addContainer(container);
    }

    public void endRow(DimensionType rowHeight) {
        this.synchronize(rowHeight);
        this.endContainer();
    }

    private void synchronize(DimensionType height) {
        XlsContainer rowContainer = this.getCurrentContainer();
        ContainerSizeInfo rowSizeInfo = rowContainer.getSizeInfo();
        int startCoordinate = rowSizeInfo.getStartCoordinate();
        int endCoordinate = rowSizeInfo.getEndCoordinate();
        int startColumnIndex = this.axis.getColumnIndexByCoordinate(startCoordinate);
        int endColumnIndex = this.axis.getColumnIndexByCoordinate(endCoordinate);
        int maxRowIndex = 0;
        int[] rowIndexes = new int[endColumnIndex - startColumnIndex];
        int currentColumnIndex = startColumnIndex;
        while (currentColumnIndex < endColumnIndex) {
            int rowIndex;
            rowIndexes[currentColumnIndex - startColumnIndex] = rowIndex = this.cache.getMaxRowIndex(currentColumnIndex);
            maxRowIndex = maxRowIndex > rowIndex ? maxRowIndex : rowIndex;
            ++currentColumnIndex;
        }
        int startRowIndex = rowContainer.getRowIndex();
        if (maxRowIndex == startRowIndex) {
            ++maxRowIndex;
        }
        rowContainer.setRowIndex(maxRowIndex);
        double rowHeight = height != null ? ExcelUtil.covertDimensionType(height, 0) : 0;
        double resize = rowHeight / (double)(maxRowIndex - startRowIndex);
        int i = startRowIndex + 1;
        while (i <= maxRowIndex) {
            this.cache.setRowHeight(i, resize);
            ++i;
        }
        int currentColumnIndex2 = startColumnIndex;
        while (currentColumnIndex2 < endColumnIndex) {
            SheetData upstair;
            int rowspan = maxRowIndex - rowIndexes[currentColumnIndex2 - startColumnIndex];
            if (rowspan > 0 && (upstair = this.cache.getColumnLastData(currentColumnIndex2)) != null && this.canSpan(upstair, rowContainer)) {
                SheetData predata = upstair;
                int rs = predata.getRowSpan() + rowspan;
                predata.setRowSpan(rs);
                SheetData realData = this.getRealData(predata);
                BlankData blankData = new BlankData(realData);
                if (!this.isInContainer(predata, rowContainer)) {
                    blankData.decreasRowSpanInDesign();
                }
                int rowIndex = predata.getRowIndex();
                int p = 1;
                while (p <= rowspan) {
                    BlankData blank = new BlankData(predata);
                    blank.setRowIndex(rowIndex + p);
                    this.cache.addData(currentColumnIndex2, blank);
                    ++p;
                }
            }
            ++currentColumnIndex2;
        }
    }

    private boolean canSpan(SheetData data, XlsContainer rowContainer) {
        SheetData realData = this.getRealData(data);
        if (realData == null) {
            return false;
        }
        if (this.isInContainer(realData, rowContainer)) {
            return true;
        }
        return realData.getRowSpanInDesign() > 0;
    }

    private SheetData getRealData(SheetData data) {
        if (data.isBlank()) {
            return ((BlankData)data).getData();
        }
        return data;
    }

    private boolean isInContainer(SheetData data, XlsContainer rowContainer) {
        XlsContainer container = data.getContainer();
        while (container != null) {
            if (container == rowContainer) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    public void endTable() {
        if (!this.tables.isEmpty()) {
            this.tables.pop();
            this.endContainer();
        }
    }

    public void addContainer(IStyle style, HyperlinkDef link) {
        XlsContainer parent = this.getCurrentContainer();
        ContainerSizeInfo sizeInfo = parent.getSizeInfo();
        StyleEntry entry = this.engine.createEntry(sizeInfo, style);
        this.addContainer(new XlsContainer(entry, sizeInfo, parent));
    }

    private void addContainer(XlsContainer child) {
        XlsContainer parent = child.getParent();
        if (parent != null) {
            parent.setEmpty(false);
        }
        this.containers.push(child);
    }

    public void endContainer() {
        this.setParentContainerIndex();
        this.endNormalContainer();
    }

    private void setParentContainerIndex() {
        XlsContainer container = this.getCurrentContainer();
        XlsContainer parent = container.getParent();
        if (parent != null) {
            parent.setRowIndex(container.getRowIndex());
        }
    }

    public void endNormalContainer() {
        XlsContainer container = this.getCurrentContainer();
        if (container.isEmpty()) {
            Data data = new Data(EMPTY, container.getStyle(), 2, container);
            data.setSizeInfo(container.getSizeInfo());
            this.addData(data);
        }
        this.engine.applyContainerBottomStyle();
        this.containers.pop();
    }

    public void addData(Object txt, IStyle style, HyperlinkDef link, BookmarkDef bookmark) {
        this.addData(txt, style, link, bookmark, null);
    }

    public void addData(Object txt, IStyle style, HyperlinkDef link, BookmarkDef bookmark, String dataLocale) {
        ContainerSizeInfo rule = this.getCurrentContainer().getSizeInfo();
        StyleEntry entry = this.engine.getStyle(style, rule);
        Data data = this.createData(txt, entry, dataLocale);
        data.setHyperlinkDef(link);
        data.setBookmark(bookmark);
        data.setSizeInfo(rule);
        this.addData(data);
    }

    public void addImageData(IImageContent image, IStyle style, HyperlinkDef link, BookmarkDef bookmark) {
        XlsContainer container = this.getCurrentContainer();
        ContainerSizeInfo rule = container.getSizeInfo();
        StyleEntry entry = this.engine.getStyle(style, rule);
        SheetData data = this.createImageData(image, entry, container);
        data.setHyperlinkDef(link);
        data.setBookmark(bookmark);
        data.setSizeInfo(rule);
        this.addData(data);
    }

    private SheetData createImageData(IImageContent image, StyleEntry entry, XlsContainer container) {
        int type = 5;
        entry.setProperty(25, Integer.toString(type));
        String uri = image.getURI();
        String mimeType = image.getMIMEType();
        String extension = image.getExtension();
        String altText = image.getAltText();
        if (FlashFile.isFlash((String)mimeType, (String)uri, (String)extension)) {
            if (altText == null) {
                altText = this.messageFlashObjectNotSupported;
            }
            return this.createData(altText, entry);
        }
        Image imageInfo = EmitterUtil.parseImage((IImageContent)image, (int)image.getImageSource(), (String)image.getURI(), (String)image.getMIMEType(), (String)image.getExtension());
        byte[] data = imageInfo.getData();
        if (data != null) {
            return new ImageData(image, entry, type, imageInfo, container);
        }
        return this.createData(image.getAltText(), entry);
    }

    public void addDateTime(Object txt, IStyle style, HyperlinkDef link, BookmarkDef bookmark, String dateTimeLocale) {
        ContainerSizeInfo rule = this.getCurrentContainer().getSizeInfo();
        StyleEntry entry = this.engine.getStyle(style, rule);
        Data data = null;
        IDataContent dataContent = (IDataContent)txt;
        Object value = dataContent.getValue();
        Date date = ExcelUtil.getDate(value);
        if (date != null && (date instanceof Time || date.getYear() >= 0)) {
            data = this.createDateData(value, entry, style.getDateTimeFormat(), dateTimeLocale);
            data.setHyperlinkDef(link);
            data.setBookmark(bookmark);
            data.setSizeInfo(rule);
            this.addData(data);
        } else {
            this.addData(dataContent.getText(), style, link, bookmark, dateTimeLocale);
        }
    }

    public void addCaption(String text) {
        ContainerSizeInfo rule = this.getCurrentContainer().getSizeInfo();
        StyleEntry entry = StyleBuilder.createEmptyStyleEntry();
        entry.setProperty(8, "Center");
        Data data = this.createData(text, entry);
        data.setSizeInfo(rule);
        this.addData(data);
    }

    private Data createData(Object txt, StyleEntry entry) {
        return this.createData(txt, entry, this.getLocale(null));
    }

    private Data createData(Object txt, StyleEntry entry, String dlocale) {
        return this.createData(txt, entry, this.getLocale(dlocale));
    }

    private Data createData(Object txt, StyleEntry entry, ULocale dataLocale) {
        int type = 2;
        if (1 == ExcelUtil.getType(txt)) {
            String format = ExcelUtil.getPattern(txt, entry.getProperty(23));
            format = ExcelUtil.formatNumberPattern(format, dataLocale);
            entry.setProperty(23, format);
            type = 1;
        } else if (ExcelUtil.getType(txt) == 0) {
            String format = ExcelUtil.getPattern(txt, entry.getProperty(22));
            entry.setProperty(22, format);
            type = 0;
        }
        entry.setProperty(25, Integer.toString(type));
        return new Data(txt, entry, type, this.getCurrentContainer());
    }

    private Data createDateData(Object txt, StyleEntry entry, String timeFormat, String dlocale) {
        ULocale dateLocale = this.getLocale(dlocale);
        timeFormat = ExcelUtil.parse(txt, timeFormat, dateLocale);
        timeFormat = DateTimeUtil.formatDateTime(timeFormat, dateLocale);
        entry.setProperty(22, timeFormat);
        entry.setProperty(25, Integer.toString(0));
        return new Data(txt, entry, 0, this.getCurrentContainer());
    }

    private ULocale getLocale(String dlocale) {
        return dlocale == null ? this.locale : new ULocale(dlocale);
    }

    private void addData(SheetData data) {
        XlsContainer container = this.getCurrentContainer();
        container.setEmpty(false);
        int col = this.axis.getColumnIndexByCoordinate(data.getSizeInfo().getStartCoordinate());
        int span = this.axis.getColumnIndexByCoordinate(data.getSizeInfo().getEndCoordinate()) - col;
        this.applyTopBorderStyle(data);
        this.outputDataIfBufferIsFull();
        this.updataRowIndex(data, container);
        this.addDatatoCache(col, data);
        Data newData = new Data(data);
        int i = col + 1;
        while (i < col + span) {
            BlankData blankData = new BlankData(newData);
            this.addDatatoCache(i, blankData);
            ++i;
        }
        if (container instanceof XlsCell) {
            XlsCell cell = (XlsCell)container;
            data.setRowSpanInDesign(cell.getRowSpan() - 1);
        }
    }

    private void updataRowIndex(SheetData data, XlsContainer container) {
        int rowIndex = container.getRowIndex() + 1;
        data.setRowIndex(rowIndex);
        container.setRowIndex(rowIndex);
    }

    private void outputDataIfBufferIsFull() {
        if (this.getCurrentContainer().getRowIndex() >= this.maxRow) {
            this.emitter.outputSheet();
            this.cache.clearCachedSheetData();
            this.resetContainers();
        }
    }

    private void applyTopBorderStyle(SheetData data) {
        XlsContainer container = this.getCurrentContainer();
        int rowIndex = container.getRowIndex();
        XlsContainer parent = container;
        while (parent != null && parent.getStartRowId() == rowIndex) {
            StyleBuilder.applyTopBorder(parent.getStyle(), data.getStyle());
            parent = parent.getParent();
        }
    }

    public XlsContainer createContainer(ContainerSizeInfo sizeInfo, IStyle style, XlsContainer parent) {
        return new XlsContainer(this.engine.createEntry(sizeInfo, style), sizeInfo, parent);
    }

    public XlsContainer createCellContainer(IStyle style, XlsContainer parent, int rowSpan) {
        ContainerSizeInfo sizeInfo = parent.getSizeInfo();
        return new XlsCell(this.engine.createEntry(sizeInfo, style), sizeInfo, parent, rowSpan);
    }

    public Map<StyleEntry, Integer> getStyleMap() {
        return this.engine.getStyleIDMap();
    }

    public int[] getCoordinates() {
        int[] coord = this.axis.getColumnWidths();
        if (coord.length <= this.maxCol) {
            return coord;
        }
        int[] ncoord = new int[this.maxCol];
        System.arraycopy(coord, 0, ncoord, 0, this.maxCol);
        return ncoord;
    }

    public int getRowCount() {
        return this.cache.getMaxRow();
    }

    public AxisProcessor getAxis() {
        return this.axis;
    }

    public SheetData getColumnLastData(int column) {
        return this.cache.getColumnLastData(column);
    }

    private void addDatatoCache(int col, SheetData value) {
        this.cache.addData(col, value);
    }

    public void complete() {
        this.engine.applyContainerBottomStyle((XlsContainer)this.containers.get(0));
        DataCache.DataCahceIterator iterator = this.cache.getRowIterator();
        while (iterator.hasNext()) {
            SheetData[] rowData = (SheetData[])iterator.next();
            int j = 0;
            while (j < rowData.length) {
                SheetData data = rowData[j];
                if (data != null && !data.isBlank()) {
                    int styleid = this.engine.getStyleID(data.getStyle());
                    data.setStyleId(styleid);
                    ContainerSizeInfo rule = data.getSizeInfo();
                    int start = this.axis.getColumnIndexByCoordinate(rule.getStartCoordinate()) + 1;
                    int end = this.axis.getColumnIndexByCoordinate(rule.getEndCoordinate()) + 1;
                    end = Math.min(end, this.maxCol);
                    int scount = Math.max(0, end - start - 1);
                    Span span = new Span(start, scount);
                    data.setSpan(span);
                    HyperlinkDef hyperLink = data.getHyperlinkDef();
                    if (hyperLink != null && hyperLink.getType() == 2) {
                        this.setLinkedBookmark(data, hyperLink);
                    }
                }
                ++j;
            }
        }
    }

    private void setLinkedBookmark(SheetData data, HyperlinkDef hyperLink) {
        String bookmarkName = hyperLink.getUrl();
        BookmarkDef linkedBookmark = this.bookmarkList.get(bookmarkName);
        if (linkedBookmark != null) {
            data.setLinkedBookmark(linkedBookmark);
        } else {
            BookmarkDef newBookmark;
            if (ExcelUtil.isValidBookmarkName(bookmarkName)) {
                newBookmark = new BookmarkDef(bookmarkName);
            } else {
                String generateBookmarkName = this.getGenerateBookmark(bookmarkName);
                newBookmark = new BookmarkDef(generateBookmarkName);
                this.cachedBookmarks.put(bookmarkName, generateBookmarkName);
            }
            data.setLinkedBookmark(newBookmark);
        }
    }

    public Stack<XlsTable> getTable() {
        return this.tables;
    }

    public void addContainerStyle(IStyle computedStyle) {
        this.engine.addContainderStyle(computedStyle);
    }

    public void removeContainerStyle() {
        this.engine.removeForeignContainerStyle();
    }

    public void resetContainers() {
        for (XlsContainer container : this.containers) {
            container.setRowIndex(0);
            container.setStartRowId(0);
        }
        for (XlsTable table : this.tables) {
            table.setRowIndex(0);
        }
    }

    public ExcelLayoutEngineIterator getIterator() {
        return new ExcelLayoutEngineIterator();
    }

    public void cacheBookmarks(int sheetIndex) {
        List<BookmarkDef> currentSheetBookmarks = this.cache.getBookmarks();
        for (BookmarkDef book : currentSheetBookmarks) {
            book.setSheetIndex(sheetIndex);
            this.bookmarkList.put(book.getName(), book);
        }
    }

    public HashMap<String, BookmarkDef> getAllBookmarks() {
        return this.bookmarkList;
    }

    public String getGenerateBookmark(String bookmarkName) {
        String generatedName = this.cachedBookmarks.get(bookmarkName);
        return generatedName != null ? generatedName : AUTO_GENERATED_BOOKMARK + this.autoBookmarkIndex++;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExcelLayoutEngineIterator
    implements Iterator<RowData> {
        Iterator<SheetData[]> rowIterator;

        public ExcelLayoutEngineIterator() {
            this.rowIterator = ExcelLayoutEngine.this.cache.getRowIterator();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext();
        }

        @Override
        public RowData next() {
            SheetData[] row = this.rowIterator.next();
            ArrayList<SheetData> data = new ArrayList<SheetData>();
            int width = Math.min(row.length, ExcelLayoutEngine.this.maxCol - 1);
            double rowHeight = 15.0;
            int i = 0;
            while (i < width) {
                SheetData d = row[i];
                if (d != null && !d.isBlank() && !d.isProcessed()) {
                    d.setProcessed(true);
                    data.add(row[i]);
                    if (d instanceof ImageData) {
                        ImageData imagedata = (ImageData)d;
                        double height = imagedata.getHeight();
                        if (height > rowHeight) {
                            rowHeight = height;
                        }
                    } else {
                        double height = d.getRowHeight();
                        rowHeight = height > rowHeight ? height : rowHeight;
                    }
                }
                ++i;
            }
            SheetData[] rowdata = new SheetData[data.size()];
            data.toArray(rowdata);
            return new RowData(rowdata, rowHeight);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

