/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class CharConstantNode
extends ConstantNode {
    public void init(Object object) throws StandardException {
        if (object instanceof TypeId) {
            super.init(object, Boolean.TRUE, ReuseFactory.getInteger(0));
        } else {
            String string = (String)object;
            super.init(TypeId.CHAR_ID, string == null ? Boolean.TRUE : Boolean.FALSE, string != null ? ReuseFactory.getInteger(string.length()) : ReuseFactory.getInteger(0));
            this.setValue(this.getDataValueFactory().getCharDataValue(string));
        }
    }

    public void init(Object object, Object object2) throws StandardException {
        String string = (String)object;
        int n = (Integer)object2;
        super.init(TypeId.CHAR_ID, string == null ? Boolean.TRUE : Boolean.FALSE, object2);
        if (string.length() > n) {
            throw StandardException.newException("22001", (Object)"CHAR", (Object)string, (Object)String.valueOf(n));
        }
        while (string.length() < n) {
            string = string + ' ';
        }
        this.setValue(this.getDataValueFactory().getCharDataValue(string));
    }

    public String getString() throws StandardException {
        return this.value.getString();
    }

    Object getConstantValueAsObject() throws StandardException {
        return this.value.getString();
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.setCollationUsingCompilationSchema(1);
        this.value = ((StringDataValue)this.value).getValue(this.getLanguageConnectionContext().getDataValueFactory().getCharacterCollator(this.getTypeServices().getCollationType()));
        return this;
    }

    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        methodBuilder.push(this.getString());
    }
}

