/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.URLValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiURLValuesScriptGenerator {
    private MultiURLValues fURLValues;
    private static final String SHOW_MENU_FUNCTION;
    private static final String HIDE_MENU_FUNCTION;
    private static final String ON_MOUSE_OVER_FUNCTION;
    private static final String ON_MOUSE_OUT_FUNCTION;
    private static final String CREATE_MENU_ITEM_FUNCTION;
    private static final String CREATE_MENU_FUNCTION;

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\tfunction showMenu()  ");
        sb.append("\n\t{  ");
        sb.append("\n\t\tvar redge=document.body.clientWidth-evt.clientX;  ");
        sb.append("\n\t\tvar bedge=document.body.clientHeight-evt.clientY;  ");
        sb.append("\n\t\tvar menu = document.getElementById( rightMenuName );  ");
        sb.append("\n\t\tif (redge<menu.offsetWidth) {  ");
        sb.append("\n\t\t\tmenu.style.left=document.body.scrollLeft + evt.clientX-menu.offsetWidth + 'px';  ");
        sb.append("\n\t\t} else {  ");
        sb.append("\n\t\t\tmenu.style.left=document.body.scrollLeft + evt.clientX + 'px';  ");
        sb.append("\n\t\t}  ");
        sb.append("\n\t\tif (bedge<menu.offsetHeight) {  ");
        sb.append("\n\t\t\tmenu.style.top=document.body.scrollTop - document.body.getBoundingClientRect().top + evt.clientY - menu.offsetHeight + 'px';  ");
        sb.append("\n\t\t} else {  ");
        sb.append("\n\t\t\tmenu.style.top = document.body.scrollTop - document.body.getBoundingClientRect().top + evt.clientY + 'px';  ");
        sb.append("\n\t\t}  ");
        sb.append("\n\t\tmenu.style.display = 'block';  ");
        sb.append("\n\t}  ");
        sb.append("\n\t  ");
        SHOW_MENU_FUNCTION = sb.toString();
        sb = new StringBuilder();
        sb.append("\n\tfunction hideMenu()  ");
        sb.append("\n\t{  ");
        sb.append("\n\t\tdocument.getElementById( rightMenuName ).style.display='none';  ");
        sb.append("\n\t}  ");
        sb.append("\n\t  ");
        HIDE_MENU_FUNCTION = sb.toString();
        sb = new StringBuilder();
        sb.append("\n\tfunction onMouseOver( )  ");
        sb.append("\n\t{  ");
        sb.append("\n\t\ttry {  ");
        sb.append("\n\t\t\twindow.clearTimeout(hideTimer);  ");
        sb.append("\n\t\t} catch(e) {  ");
        sb.append("\n\t\t};  ");
        sb.append("\n\t\t  ");
        sb.append("\n\t\tsetOnMouseOverStyle( this.style );  ");
        sb.append("\n\t}  ");
        sb.append("\n\t  ");
        ON_MOUSE_OVER_FUNCTION = sb.toString();
        sb = new StringBuilder();
        sb.append("\n\tfunction onMouseOut()  ");
        sb.append("\n\t{  ");
        sb.append("\n\t\thideTimer = window.setTimeout(\"document.getElementById( '\" +rightMenuName + \"').style.display='none';\", 300);  ");
        sb.append("\n\t\tsetOnMouseOutStyle( this.style );  ");
        sb.append("\n\t}  ");
        sb.append("\n\t  ");
        ON_MOUSE_OUT_FUNCTION = sb.toString();
        sb = new StringBuilder();
        sb.append("\n\tfunction createMenuItem( menuItemName, displayText, urlLink, urlTarget, tooltip )  ");
        sb.append("\n\t{  ");
        sb.append("\n\t\tvar divMenuItem          = document.createElement('Div');  ");
        sb.append("\n\t\tdivMenuItem.className   = menuItemName;  ");
        sb.append("\n\t\tif ( tooltip ) divMenuItem.title = tooltip; ");
        sb.append("\n\t\telse  divMenuItem.title = '';  ");
        sb.append("\n\t\tdivMenuItem.onmouseover = onMouseOver;  ");
        sb.append("\n\t\tdivMenuItem.onmouseout  = onMouseOut;  ");
        sb.append("\n\t\tdivMenuItem.onclick     = function( ) {  ");
        sb.append("\n\t\t\t\t\thideMenu();  ");
        sb.append("\n\t\t\t\t\tvar url = urlLink;  ");
        sb.append("\n\t\t\t\t\tvar target = '_blank'; ");
        sb.append("\n\t\t\t\t\tif ( urlTarget ) target = urlTarget;  ");
        sb.append("\n\t\t\t\t\tif ( !target || target == '' ) target = '_self';  ");
        sb.append("\n\t\t\t\t\tif ( url.indexOf('#', 0) == 0 ) {  ");
        sb.append("\n\t\t\t\t\t\twindow.location= url;  ");
        sb.append("\n\t\t\t\t\t\treturn;\t  ");
        sb.append("\n\t\t\t\t\t}  ");
        sb.append("\n\t\t\t\t\tif ( url.indexOf( 'javascript:', 0) == 0 ) {  ");
        sb.append("\n\t\t\t\t\t\teval( url.substring( 11, url.length -1 ) ) ;  ");
        sb.append("\n\t\t\t\t\t\treturn;  ");
        sb.append("\n\t\t\t\t\t}  ");
        sb.append("\n\t\t\t\t\ttry {  ");
        sb.append("\n\t\t\t\t\t\twindow.open( url, target );\t  ");
        sb.append("\n\t\t\t\t\t} catch( e ) {  ");
        sb.append("\n\t\t\t\t\t\tredirect( target, url );  ");
        sb.append("\n\t\t\t\t\t}  ");
        sb.append("\n\t\t}; ");
        sb.append("\n\t\tdivMenuItem.innerHTML   = displayText;  ");
        sb.append("\n\t \tsetMenuItemStyle( divMenuItem.style );  ");
        sb.append("\n\t\treturn divMenuItem;  ");
        sb.append("\n\t}   ");
        sb.append("\n\t  ");
        CREATE_MENU_ITEM_FUNCTION = sb.toString();
        sb = new StringBuilder();
        sb.append("\n\tfunction createMenu( menuName )  ");
        sb.append("\n\t{  ");
        sb.append("\n\t\tvar divMenu          = document.createElement('Div');  ");
        sb.append("\n\t\tdivMenu.style.display='none';  ");
        sb.append("\n\t\tdivMenu.id           = menuName;  ");
        sb.append("\n\t\tdivMenu.className    = menuName;  ");
        sb.append("\n\t\tsetMenuStyle( divMenu.style );  ");
        sb.append("\n\t\treturn divMenu;   ");
        sb.append("\n\t}  ");
        sb.append("\n\t  ");
        CREATE_MENU_FUNCTION = sb.toString();
    }

    public MultiURLValuesScriptGenerator(MultiURLValues urlValues) {
        this.fURLValues = urlValues;
    }

    public String getJSContent() {
        StringBuilder sb = this.generateMenuBase();
        sb.append(this.generateMenu(sb.hashCode()));
        return sb.toString();
    }

    public String getJSKey() {
        return this.generateMenuBase().toString();
    }

    private StringBuilder generateMenuBase() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\tvar hideTimer;  ");
        sb.append("\n\tvar rightMenuName = 'div_RightMenu';  ");
        sb.append("\n\tvar menuItemName = 'divMenuItem';  ");
        sb.append("\n\t  ");
        sb.append(SHOW_MENU_FUNCTION);
        sb.append(HIDE_MENU_FUNCTION);
        sb.append(ON_MOUSE_OVER_FUNCTION);
        sb.append(ON_MOUSE_OUT_FUNCTION);
        for (Map.Entry e : this.fURLValues.getPropertiesMap().entrySet()) {
            String properties = (String)e.getValue();
            sb.append(this.generateSetStyle((String)e.getKey(), properties));
        }
        sb.append(CREATE_MENU_FUNCTION);
        sb.append(CREATE_MENU_ITEM_FUNCTION);
        return sb;
    }

    private String generateSetStyle(String key, String properties) {
        List<String[]> attributes = this.deserializeProperties(properties);
        StringBuffer sb = new StringBuffer();
        sb.append("\n\tfunction set" + key + "Style( style )  ");
        sb.append("\n\t{  ");
        for (String[] att : attributes) {
            sb.append("\n    style." + att[0] + "=\"" + att[1] + "\";");
        }
        sb.append("\n\t}  ");
        sb.append("\n\t  ");
        return sb.toString();
    }

    private String generateMenu(int uniqueKey) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n   rightMenuName = rightMenuName + " + uniqueKey);
        sb.append("\n   menuItemName = menuItemName + " + uniqueKey);
        sb.append("\n\tif(document.getElementById(rightMenuName) != null)  ");
        sb.append("\n\t{  ");
        sb.append("\n\t\tdocument.body.removeChild(document.getElementById(rightMenuName));  ");
        sb.append("\n\t}  ");
        sb.append("\n\t  ");
        sb.append("\n\tvar divMenu = createMenu(rightMenuName);  ");
        sb.append("\n\tdocument.body.appendChild(divMenu);   ");
        for (URLValue uv : MultiURLValuesScriptGenerator.getValidURLValues(this.fURLValues)) {
            String target = uv.getTarget() == null ? "" : uv.getTarget();
            String url = uv.getBaseUrl();
            if (!url.startsWith("\"") && !url.endsWith("\"")) {
                url = "\"" + url + "\"";
            }
            sb.append("\n    divMenu.appendChild( createMenuItem( menuItemName,");
            sb.append(" '" + uv.getLabel().getCaption().getValue() + "',");
            sb.append(String.valueOf(url) + ",");
            if (uv.getTooltip() != null && uv.getTooltip().trim().length() > 0) {
                sb.append(" '" + target + "',");
                sb.append(" '" + uv.getTooltip() + "' ) );");
                continue;
            }
            sb.append(" '" + target + "' ) );");
        }
        sb.append("\n\tdocument.body.oncontextmenu = hideMenu;  ");
        sb.append("\n\t  ");
        sb.append("\n\tshowMenu();   ");
        sb.append("\n");
        return sb.toString();
    }

    private List<String[]> deserializeProperties(String properties) {
        String[] attributes = properties.split(";");
        ArrayList<String[]> AttrList = new ArrayList<String[]>(attributes.length);
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            int index = v.indexOf(58);
            String[] element = new String[]{v.substring(0, index), v.substring(index + 1)};
            AttrList.add(element);
            ++n2;
        }
        return AttrList;
    }

    public static List<URLValue> getValidURLValues(MultiURLValues multiUrlValue) {
        ArrayList<URLValue> validURLValues = new ArrayList<URLValue>();
        for (URLValue uv : multiUrlValue.getURLValues()) {
            if (uv.getBaseUrl() == null || uv.getBaseUrl().length() <= 0 || uv.getBaseUrl().equals("\"\"")) continue;
            validURLValues.add(uv);
        }
        return validURLValues;
    }
}

