/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.internal.adapter;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSourceDesign;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.internal.adapter.DataAdapterUtil;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.ExtendedPropertyHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.mozilla.javascript.Scriptable;

public class OdaDataSourceAdapter
extends OdaDataSourceDesign {
    private Scriptable bindingScope;

    public OdaDataSourceAdapter(OdaDataSourceHandle source, Scriptable propBindingScope) throws BirtException {
        super(source.getQualifiedName());
        Iterator elmtIter;
        this.bindingScope = propBindingScope;
        DataAdapterUtil.adaptBaseDataSource((DataSourceHandle)source, (BaseDataSourceDesign)this);
        String driverName = source.getExtensionID();
        if (driverName == null || driverName.length() == 0) {
            throw new AdapterException("datasource.exid.error", source.getName());
        }
        this.setExtensionID(driverName);
        Map staticProps = DataAdapterUtil.getExtensionProperties((ReportElementHandle)source, source.getExtensionPropertyDefinitionList());
        if (staticProps != null && !staticProps.isEmpty()) {
            for (String propName : staticProps.keySet()) {
                assert (propName != null);
                String bindingExpr = source.getPropertyBinding(propName);
                String propValue = this.bindingScope != null && bindingExpr != null && bindingExpr.length() > 0 ? JavascriptEvalUtil.evaluateScript(null, (Scriptable)this.bindingScope, (String)bindingExpr, (String)ScriptExpression.defaultID, (int)0).toString() : (String)staticProps.get(propName);
                this.addPublicProperty(propName, propValue);
            }
        }
        if ((elmtIter = source.privateDriverPropertiesIterator()) != null) {
            while (elmtIter.hasNext()) {
                ExtendedPropertyHandle modelProp = (ExtendedPropertyHandle)elmtIter.next();
                this.addPrivateProperty(modelProp.getName(), modelProp.getValue());
            }
        }
        this.addPropertyConfigurationId(this);
    }

    private void addPropertyConfigurationId(OdaDataSourceDesign dteSource) throws BirtException {
        String configIdValue = String.valueOf(dteSource.getExtensionID()) + "_" + dteSource.getName();
        dteSource.addPublicProperty("OdaPropertyConfigId", configIdValue);
    }
}

