/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.util.HashMap;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalMode
extends AggrFunction {
    public String getName() {
        return "MODE";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 0;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalMode.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalMode.displayName");
    }

    private class MyAccumulator
    extends SummaryAccumulator {
        private HashMap cacheMap;
        private HashMap modeMap;
        private Object mode;
        private int maxCount;
        private int rowIndex;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.rowIndex = 0;
            this.cacheMap = new HashMap();
            this.maxCount = 0;
            this.mode = null;
            this.modeMap = new HashMap();
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (args[0] != null) {
                Object value = this.getTypedData(args[0]);
                Counter counter = (Counter)this.cacheMap.get(value);
                if (counter == null) {
                    counter = new Counter(1, this.rowIndex);
                    this.cacheMap.put(value, counter);
                } else {
                    ++counter.count;
                }
                if (counter.count > this.maxCount) {
                    this.mode = value;
                    this.maxCount = counter.count;
                    this.modeMap.clear();
                    this.modeMap.put(value, counter);
                } else if (counter.count == this.maxCount) {
                    this.modeMap.put(value, counter);
                }
                ++this.rowIndex;
            }
        }

        public void finish() throws DataException {
            super.finish();
            this.cacheMap = null;
        }

        public Object getSummaryValue() {
            if (this.maxCount == 1) {
                return null;
            }
            if (!this.modeMap.isEmpty()) {
                int minIndex = Integer.MAX_VALUE;
                for (Object key : this.modeMap.keySet()) {
                    Counter info = (Counter)this.modeMap.get(key);
                    if (info.firstIndex >= minIndex) continue;
                    minIndex = info.firstIndex;
                    this.mode = key;
                }
                this.modeMap = null;
            }
            return this.mode;
        }

        class Counter {
            int count;
            int firstIndex;

            public Counter(int count, int firstIndex) {
                this.count = count;
                this.firstIndex = firstIndex;
            }
        }
    }
}

