/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.factory.ActionEvaluatorAdapter;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.SearchKeyHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BIRTActionEvaluator
extends ActionEvaluatorAdapter {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public String[] getActionExpressions(Action action, StructureSource source) {
        TooltipValue tv;
        String exp;
        if (ActionType.URL_REDIRECT_LITERAL.equals((Object)action.getType())) {
            ArrayList<String> expList = new ArrayList<String>();
            if (action.getValue() instanceof URLValue) {
                URLValue uv = (URLValue)action.getValue();
                this.getURLValueExpressions(expList, uv);
            } else if (action.getValue() instanceof MultiURLValues) {
                for (URLValue uv : ((MultiURLValues)action.getValue()).getURLValues()) {
                    this.getURLValueExpressions(expList, uv);
                }
            }
            if (expList.size() > 0) {
                return expList.toArray(new String[expList.size()]);
            }
        } else if (ActionType.SHOW_TOOLTIP_LITERAL.equals((Object)action.getType()) && StructureType.SERIES.equals(source.getType()) && (exp = (tv = (TooltipValue)action.getValue()).getText()) != null && exp.trim().length() > 0) {
            return new String[]{exp};
        }
        return null;
    }

    private void getURLValueExpressions(List<String> expList, URLValue uv) {
        String sa = uv.getBaseUrl();
        try {
            ActionHandle handle = ModuleUtil.deserializeAction((String)sa);
            if ("hyperlink".equals(handle.getLinkType())) {
                String exp = handle.getURI();
                if (!expList.contains(exp)) {
                    expList.add(exp);
                }
            } else if ("bookmark-link".equals(handle.getLinkType())) {
                String exp = handle.getTargetBookmark();
                if (!expList.contains(exp)) {
                    expList.add(exp);
                }
            } else if ("drill-through".equals(handle.getLinkType())) {
                String exp = handle.getTargetBookmark();
                if (exp != null && !expList.contains(exp)) {
                    expList.add(exp);
                }
                for (SearchKeyHandle skh : handle.getSearch()) {
                    exp = skh.getExpression();
                    if (expList.contains(exp)) continue;
                    expList.add(exp);
                }
                for (ParamBindingHandle pbh : handle.getParamBindings()) {
                    exp = pbh.getExpression();
                    if (expList.contains(exp)) continue;
                    expList.add(exp);
                }
            }
        }
        catch (DesignFileException e) {
            logger.log((Exception)((Object)e));
        }
    }
}

