/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.registry;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.registry.Category;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetCollectionElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetItemExtensionElement;
import org.eclipse.ui.internal.cheatsheets.registry.RegistryReader;
import org.eclipse.ui.internal.cheatsheets.registry.Sorter;

public class CheatSheetRegistryReader
extends RegistryReader
implements IRegistryChangeListener {
    private static final String ATT_CATEGORY = "category";
    public static final String ATT_CONTENTFILE = "contentFile";
    protected static final String ATT_ICON = "icon";
    protected static final String ATT_ID = "id";
    protected static final String ATT_LISTENERCLASS = "listener";
    protected static final String ATT_NAME = "name";
    protected static final String ATT_CLASS = "class";
    private static final String ATT_COMPOSITE = "composite";
    private static final String CATEGORY_SEPARATOR = "/";
    private static final String ATT_ITEM_ATTRIBUTE = "itemAttribute";
    private static CheatSheetRegistryReader instance;
    private static final String TAG_CATEGORY = "category";
    public static final String TAG_CHEATSHEET = "cheatsheet";
    protected static final String TAG_ITEM_EXTENSION = "itemExtension";
    protected static final String TAG_TASK_EDITOR = "taskEditor";
    protected static final String TAG_TASK_EXPLORER = "taskExplorer";
    protected static final String trueString = "TRUE";
    private static final String UNCATEGORIZED_CHEATSHEET_CATEGORY = "org.eclipse.ui.Other";
    private static final String UNCATEGORIZED_CHEATSHEET_CATEGORY_LABEL;
    public static final String CHEAT_SHEET_CONTENT = "cheatSheetContent";
    protected ArrayList cheatsheetItemExtensions;
    protected CheatSheetCollectionElement cheatsheets;
    private ArrayList deferCategories = null;
    private ArrayList deferCheatSheets = null;
    private final String csItemExtension = "cheatSheetItemExtension";
    protected Map taskExplorers = new HashMap();
    protected Map taskEditors = new HashMap();

    static {
        UNCATEGORIZED_CHEATSHEET_CATEGORY_LABEL = Messages.CHEAT_SHEET_OTHER_CATEGORY;
    }

    public static CheatSheetRegistryReader getInstance() {
        if (instance == null) {
            instance = new CheatSheetRegistryReader();
            IExtensionRegistry xregistry = Platform.getExtensionRegistry();
            xregistry.addRegistryChangeListener((IRegistryChangeListener)instance, "org.eclipse.ui.cheatsheets");
        }
        return instance;
    }

    private CheatSheetRegistryReader() {
    }

    protected void addNewElementToResult(CheatSheetElement element, IConfigurationElement config, CheatSheetCollectionElement cheatsheets2) {
        this.deferCheatSheet(element);
    }

    protected CheatSheetElement createCheatSheetElement(IConfigurationElement element) {
        String nameString = element.getAttribute(ATT_NAME);
        if (nameString == null) {
            this.logMissingAttribute(element, ATT_NAME);
            return null;
        }
        CheatSheetElement result = new CheatSheetElement(nameString);
        if (this.initializeCheatSheet(result, element)) {
            return result;
        }
        return null;
    }

    protected CheatSheetCollectionElement createCollectionElement(CheatSheetCollectionElement parent, String pluginId, String id, String label) {
        CheatSheetCollectionElement newElement = new CheatSheetCollectionElement(pluginId, id, label, parent);
        parent.add(newElement);
        return newElement;
    }

    protected CheatSheetCollectionElement createEmptyCheatSheetCollection() {
        return new CheatSheetCollectionElement(null, "root", "root", null);
    }

    private void deferCategory(IConfigurationElement config) {
        Category category = null;
        try {
            category = new Category(config);
        }
        catch (CoreException e) {
            CheatSheetPlugin.getPlugin().getLog().log(e.getStatus());
            return;
        }
        if (this.deferCategories == null) {
            this.deferCategories = new ArrayList(20);
        }
        this.deferCategories.add(category);
    }

    private void deferCheatSheet(CheatSheetElement element) {
        if (this.deferCheatSheets == null) {
            this.deferCheatSheets = new ArrayList(50);
        }
        this.deferCheatSheets.add(element);
    }

    public CheatSheetElement findCheatSheet(String id) {
        Object[] cheatsheetsList = this.getCheatSheets().getChildren();
        int nX = 0;
        while (nX < cheatsheetsList.length) {
            CheatSheetCollectionElement collection = (CheatSheetCollectionElement)((Object)cheatsheetsList[nX]);
            CheatSheetElement element = collection.findCheatSheet(id, true);
            if (element != null) {
                return element;
            }
            ++nX;
        }
        return null;
    }

    public TaskEditorNode findTaskEditor(String id) {
        if (this.cheatsheets == null) {
            this.readCheatSheets();
        }
        return (TaskEditorNode)this.taskEditors.get(id);
    }

    public TaskExplorerNode findTaskExplorer(String id) {
        if (this.cheatsheets == null) {
            this.readCheatSheets();
        }
        return (TaskExplorerNode)this.taskExplorers.get(id);
    }

    public String[] getExplorerIds() {
        if (this.cheatsheets == null) {
            this.readCheatSheets();
        }
        Set keys = this.taskExplorers.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    private void finishCategories() {
        if (this.deferCategories == null) {
            return;
        }
        Object[] flatArray = new CategoryNode[this.deferCategories.size()];
        int i = 0;
        while (i < this.deferCategories.size()) {
            flatArray[i] = new CategoryNode((Category)this.deferCategories.get(i));
            ++i;
        }
        Sorter sorter = new Sorter(){
            private Collator collator = Collator.getInstance();

            public boolean compare(Object o1, Object o2) {
                String s1 = ((CategoryNode)o1).getPath();
                String s2 = ((CategoryNode)o2).getPath();
                return this.collator.compare(s2, s1) > 0;
            }
        };
        Object[] sortedCategories = sorter.sort(flatArray);
        int nX = 0;
        while (nX < sortedCategories.length) {
            Category cat = ((CategoryNode)sortedCategories[nX]).getCategory();
            this.finishCategory(cat);
            ++nX;
        }
        this.deferCategories = null;
    }

    private void finishCategory(Category category) {
        CheatSheetCollectionElement test;
        CheatSheetCollectionElement currentResult = this.cheatsheets;
        String[] categoryPath = category.getParentPath();
        CheatSheetCollectionElement parent = currentResult;
        if (categoryPath != null) {
            int i = 0;
            while (i < categoryPath.length) {
                CheatSheetCollectionElement tempElement = this.getChildWithID(parent, categoryPath[i]);
                if (tempElement == null) {
                    return;
                }
                parent = tempElement;
                ++i;
            }
        }
        if ((test = this.getChildWithID(parent, category.getId())) != null) {
            return;
        }
        if (parent != null) {
            this.createCollectionElement(parent, category.getPluginId(), category.getId(), category.getLabel());
        }
    }

    private void finishCheatSheet(CheatSheetElement element, IConfigurationElement config, CheatSheetCollectionElement result) {
        CheatSheetCollectionElement currentResult = result;
        StringTokenizer familyTokenizer = new StringTokenizer(this.getCategoryStringFor(config), CATEGORY_SEPARATOR);
        CheatSheetCollectionElement currentCollectionElement = currentResult;
        boolean moveToOther = false;
        while (familyTokenizer.hasMoreElements()) {
            CheatSheetCollectionElement tempCollectionElement = this.getChildWithID(currentCollectionElement, familyTokenizer.nextToken());
            if (tempCollectionElement == null) {
                moveToOther = true;
                break;
            }
            currentCollectionElement = tempCollectionElement;
        }
        if (moveToOther) {
            this.moveElementToUncategorizedCategory(currentResult, element);
        } else {
            currentCollectionElement.add(element);
        }
    }

    private void finishCheatSheets() {
        if (this.deferCheatSheets != null) {
            Iterator iter = this.deferCheatSheets.iterator();
            while (iter.hasNext()) {
                CheatSheetElement cheatsheet = (CheatSheetElement)((Object)iter.next());
                IConfigurationElement config = cheatsheet.getConfigurationElement();
                this.finishCheatSheet(cheatsheet, config, this.cheatsheets);
            }
            this.deferCheatSheets = null;
        }
    }

    protected String getCategoryStringFor(IConfigurationElement config) {
        String result = config.getAttribute("category");
        if (result == null) {
            result = UNCATEGORIZED_CHEATSHEET_CATEGORY;
        }
        return result;
    }

    public CheatSheetCollectionElement getCheatSheets() {
        if (this.cheatsheets == null) {
            this.readCheatSheets();
        }
        return this.cheatsheets;
    }

    protected CheatSheetCollectionElement getChildWithID(CheatSheetCollectionElement parent, String id) {
        Object[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            CheatSheetCollectionElement currentChild = (CheatSheetCollectionElement)((Object)children[i]);
            if (currentChild.getId().equals(id)) {
                return currentChild;
            }
            ++i;
        }
        return null;
    }

    protected boolean initializeCheatSheet(CheatSheetElement element, IConfigurationElement config) {
        String composite;
        element.setID(config.getAttribute(ATT_ID));
        element.setDescription(this.getDescription(config));
        element.setConfigurationElement(config);
        element.setRegistered(true);
        String contentFile = config.getAttribute(ATT_CONTENTFILE);
        if (contentFile != null) {
            element.setContentFile(contentFile);
        }
        if (element.getConfigurationElement() == null || element.getContentFile() == null) {
            this.logMissingAttribute(config, ATT_CONTENTFILE);
            return false;
        }
        String listenerClass = config.getAttribute(ATT_LISTENERCLASS);
        if (listenerClass != null) {
            element.setListenerClass(listenerClass);
        }
        if ((composite = config.getAttribute(ATT_COMPOSITE)) != null) {
            element.setComposite(composite.equalsIgnoreCase(trueString));
        }
        return true;
    }

    protected void moveElementToUncategorizedCategory(CheatSheetCollectionElement root, CheatSheetElement element) {
        CheatSheetCollectionElement otherCategory = this.getChildWithID(root, UNCATEGORIZED_CHEATSHEET_CATEGORY);
        if (otherCategory == null) {
            otherCategory = this.createCollectionElement(root, null, UNCATEGORIZED_CHEATSHEET_CATEGORY, UNCATEGORIZED_CHEATSHEET_CATEGORY_LABEL);
        }
        otherCategory.add(element);
    }

    private void pruneEmptyCategories(CheatSheetCollectionElement parent) {
        Object[] children = parent.getChildren();
        int nX = 0;
        while (nX < children.length) {
            CheatSheetCollectionElement child = (CheatSheetCollectionElement)((Object)children[nX]);
            this.pruneEmptyCategories(child);
            ++nX;
        }
    }

    protected void readCheatSheets() {
        IExtensionRegistry xregistry = Platform.getExtensionRegistry();
        if (this.cheatsheets == null) {
            this.cheatsheets = this.createEmptyCheatSheetCollection();
            this.readRegistry(xregistry, "org.eclipse.ui.cheatsheets", CHEAT_SHEET_CONTENT);
        }
        this.finishCategories();
        this.finishCheatSheets();
        if (this.cheatsheets != null) {
            CheatSheetCollectionElement parent = this.cheatsheets;
            this.pruneEmptyCategories(parent);
        }
    }

    public ArrayList readItemExtensions() {
        if (this.cheatsheetItemExtensions == null) {
            this.cheatsheetItemExtensions = new ArrayList();
            IExtensionRegistry xregistry = Platform.getExtensionRegistry();
            this.readRegistry(xregistry, "org.eclipse.ui.cheatsheets", "cheatSheetItemExtension");
        }
        return this.cheatsheetItemExtensions;
    }

    private void createItemExtensionElement(IConfigurationElement element) {
        String className = element.getAttribute(ATT_CLASS);
        String itemAttribute = element.getAttribute(ATT_ITEM_ATTRIBUTE);
        if (className == null) {
            this.logMissingAttribute(element, ATT_CLASS);
            return;
        }
        if (itemAttribute == null) {
            this.logMissingAttribute(element, ATT_ITEM_ATTRIBUTE);
            return;
        }
        CheatSheetItemExtensionElement itemExtensionElement = new CheatSheetItemExtensionElement();
        itemExtensionElement.setClassName(className);
        itemExtensionElement.setItemAttribute(itemAttribute);
        itemExtensionElement.setConfigurationElement(element);
        this.cheatsheetItemExtensions.add(itemExtensionElement);
    }

    private String getAndCheckAttribute(IConfigurationElement element, String name) {
        String result = element.getAttribute(name);
        if (result == null) {
            this.logMissingAttribute(element, name);
        }
        return result;
    }

    private void createTaskExplorerElement(IConfigurationElement element) {
        String icon = element.getAttribute(ATT_ICON);
        String className = this.getAndCheckAttribute(element, ATT_CLASS);
        String name = this.getAndCheckAttribute(element, ATT_NAME);
        String id = this.getAndCheckAttribute(element, ATT_ID);
        String pluginId = element.getContributor().getName();
        if (id != null && className != null && name != null) {
            TaskExplorerNode node = new TaskExplorerNode();
            node.setId(id);
            node.setIconPath(icon);
            node.setClassName(className);
            node.setName(name);
            node.setPluginId(pluginId);
            this.taskExplorers.put(id, node);
        }
    }

    private void createTaskEditorElement(IConfigurationElement element) {
        String icon = this.getAndCheckAttribute(element, ATT_ICON);
        String className = this.getAndCheckAttribute(element, ATT_CLASS);
        String id = this.getAndCheckAttribute(element, ATT_ID);
        String pluginId = element.getContributor().getName();
        if (id != null && className != null && icon != null) {
            TaskEditorNode node = new TaskEditorNode();
            node.setId(id);
            node.setIconPath(icon);
            node.setClassName(className);
            node.setPluginId(pluginId);
            this.taskEditors.put(id, node);
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals("category")) {
            this.deferCategory(element);
            return true;
        }
        if (element.getName().equals(TAG_ITEM_EXTENSION)) {
            this.createItemExtensionElement(element);
            return true;
        }
        if (element.getName().equals(TAG_TASK_EDITOR)) {
            this.createTaskEditorElement(element);
            return true;
        }
        if (element.getName().equals(TAG_TASK_EXPLORER)) {
            this.createTaskExplorerElement(element);
            return true;
        }
        if (!element.getName().equals(TAG_CHEATSHEET)) {
            return false;
        }
        CheatSheetElement cheatsheet = this.createCheatSheetElement(element);
        if (cheatsheet != null) {
            this.addNewElementToResult(cheatsheet, element, this.cheatsheets);
        }
        return true;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] itemExtensionDeltas;
        IExtensionDelta[] cheatSheetDeltas = event.getExtensionDeltas("org.eclipse.ui.cheatsheets", CHEAT_SHEET_CONTENT);
        if (cheatSheetDeltas.length > 0) {
            this.cheatsheets = null;
        }
        if ((itemExtensionDeltas = event.getExtensionDeltas("org.eclipse.ui.cheatsheets", "cheatSheetItemExtension")).length > 0) {
            this.cheatsheetItemExtensions = null;
        }
    }

    public void stop() {
        IExtensionRegistry xregistry = Platform.getExtensionRegistry();
        xregistry.removeRegistryChangeListener((IRegistryChangeListener)instance);
        instance = null;
    }

    private class CategoryNode {
        private Category category;
        private String path;

        public CategoryNode(Category cat) {
            this.category = cat;
            this.path = "";
            String[] categoryPath = this.category.getParentPath();
            if (categoryPath != null) {
                int nX = 0;
                while (nX < categoryPath.length) {
                    this.path = String.valueOf(this.path) + categoryPath[nX] + '/';
                    ++nX;
                }
            }
            this.path = String.valueOf(this.path) + cat.getId();
        }

        public Category getCategory() {
            return this.category;
        }

        public String getPath() {
            return this.path;
        }
    }

    public class TaskEditorNode {
        private String className;
        private String iconPath;
        private String id;
        private String pluginId;

        public void setClassName(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public void setIconPath(String iconPath) {
            this.iconPath = iconPath;
        }

        public String getIconPath() {
            return this.iconPath;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        public String getPluginId() {
            return this.pluginId;
        }
    }

    public class TaskExplorerNode {
        private String className;
        private String iconPath;
        private String name;
        private String id;
        private String pluginId;

        public void setClassName(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public void setIconPath(String iconPath) {
            this.iconPath = iconPath;
        }

        public String getIconPath() {
            return this.iconPath;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        public String getPluginId() {
            return this.pluginId;
        }
    }
}

