/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.Polygon;
import org.eclipse.birt.chart.computation.Vector;
import org.eclipse.birt.chart.internal.computations.Matrix;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;

public class Object3D {
    private Vector[] va;
    private Vector[] viewVa;
    private Vector center;
    private Vector normal;
    private double xMax;
    private double xMin;
    private double yMax;
    private double yMin;
    private double zMax;
    private double zMin;
    private int iZmin;
    private int iZmax;
    private HashMap<Object3D, Boolean> hmSwap = new HashMap();
    protected static final IGObjectFactory goFactory = GObjectFactory.instance();

    public Object3D(int points) {
        this.va = new Vector[points];
    }

    public Object3D(Location3D la) {
        this(new Location3D[]{la});
    }

    public Object3D(Location3D[] loa) {
        this(loa, false);
    }

    public Object3D(Location3D[] loa, boolean inverted) {
        loa = this.removeDuplicatePoints(loa);
        this.va = new Vector[loa.length];
        int i = 0;
        while (i < this.va.length) {
            if (!inverted) {
                this.va[i] = new Vector(loa[i]);
                loa[i].linkToVector(this.va[i]);
            } else {
                this.va[this.va.length - 1 - i] = new Vector(loa[i]);
                loa[i].linkToVector(this.va[this.va.length - 1 - i]);
            }
            ++i;
        }
    }

    public Object3D(Object3D original) {
        if (original == null) {
            return;
        }
        this.va = new Vector[original.va.length];
        int i = 0;
        while (i < original.va.length) {
            this.va[i] = new Vector(original.va[i]);
            ++i;
        }
        this.center = original.center;
        this.normal = original.normal;
        this.zMax = original.zMax;
        this.zMin = original.zMin;
        this.yMax = original.yMax;
        this.yMin = original.yMin;
        this.xMax = original.xMax;
        this.xMin = original.xMin;
        this.iZmin = 0;
        this.iZmax = 0;
    }

    public Location3D[] getLocation3D() {
        Location3D[] loa3d = new Location3D[this.va.length];
        int i = 0;
        while (i < this.va.length) {
            loa3d[i] = goFactory.createLocation3D(this.va[i].get(0), this.va[i].get(1), this.va[i].get(2));
            ++i;
        }
        return loa3d;
    }

    public static Vector getPlaneNormal(Vector pt0, Vector pt1, Vector pt2) {
        Vector v1 = new Vector(pt1);
        v1.sub(pt0);
        Vector v2 = new Vector(pt2);
        v2.sub(pt0);
        return v1.crossProduct(v2);
    }

    public Vector getNormal() {
        if (this.normal == null) {
            if (this.va == null || this.va.length < 3) {
                return null;
            }
            this.normal = Object3D.getPlaneNormal(this.va[0], this.va[1], this.va[2]);
        }
        return this.normal;
    }

    public Vector getCenter() {
        if (this.center == null) {
            if (this.va == null || this.va.length == 0) {
                return null;
            }
            double m = this.va.length;
            this.center = new Vector();
            int i = 0;
            while ((double)i < m) {
                this.center.add(this.va[i]);
                ++i;
            }
            this.center.scale(1.0 / m);
        }
        return this.center;
    }

    public void reset() {
        this.center = null;
        this.normal = null;
        this.va = null;
        this.viewVa = null;
        this.zMax = 0.0;
        this.zMin = 0.0;
        this.yMax = 0.0;
        this.yMin = 0.0;
        this.xMax = 0.0;
        this.xMin = 0.0;
        this.iZmin = 0;
        this.iZmax = 0;
    }

    public Vector getZMaxPoint() {
        return this.va[this.iZmax];
    }

    public Vector getZMinPoint() {
        return this.va[this.iZmin];
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getZMax() {
        return this.zMax;
    }

    public double getZMin() {
        return this.zMin;
    }

    public void transform(Matrix m) {
        int i = 0;
        while (i < this.va.length) {
            this.va[i].multiply(m);
            ++i;
        }
    }

    private void computeExtremums() {
        this.xMin = Double.MAX_VALUE;
        this.xMax = -1.7976931348623157E308;
        this.yMin = Double.MAX_VALUE;
        this.yMax = -1.7976931348623157E308;
        this.zMin = Double.MAX_VALUE;
        this.zMax = -1.7976931348623157E308;
        int i = 0;
        while (i < this.va.length) {
            this.xMin = Math.min(this.xMin, this.va[i].get(0));
            this.xMax = Math.max(this.xMax, this.va[i].get(0));
            this.yMin = Math.min(this.yMin, this.va[i].get(1));
            this.yMax = Math.max(this.yMax, this.va[i].get(1));
            if (this.zMin > this.va[i].get(2)) {
                this.zMin = this.va[i].get(2);
                this.iZmin = i;
            }
            if (this.zMax < this.va[i].get(2)) {
                this.zMax = this.va[i].get(2);
                this.iZmax = i;
            }
            ++i;
        }
    }

    public void clip(Engine3D engine) {
        ArrayList<Vector> lst = new ArrayList<Vector>();
        switch (this.va.length) {
            case 0: {
                break;
            }
            case 1: {
                Vector start = new Vector(this.va[0]);
                Vector end = new Vector(this.va[0]);
                byte retval = engine.checkClipping(start, end);
                if (retval == 4) break;
                lst.add(start);
                break;
            }
            case 2: {
                Vector start = new Vector(this.va[0]);
                Vector end = new Vector(this.va[1]);
                byte retval = engine.checkClipping(start, end);
                if (retval == 4) break;
                lst.add(start);
                lst.add(end);
                break;
            }
            default: {
                boolean endClipped = false;
                int i = 0;
                while (i < this.va.length) {
                    Vector start = null;
                    Vector end = null;
                    if (i == this.va.length - 1) {
                        start = new Vector(this.va[i]);
                        end = new Vector(this.va[0]);
                    } else {
                        start = new Vector(this.va[i]);
                        end = new Vector(this.va[i + 1]);
                    }
                    byte retval = engine.checkClipping(start, end);
                    if (retval != 4) {
                        if (i == 0 || (retval & 2) != 0 || endClipped) {
                            lst.add(start);
                        }
                        endClipped = false;
                        if ((retval & 1) != 0) {
                            endClipped = true;
                        }
                        if (i != this.va.length - 1 || endClipped) {
                            lst.add(end);
                        }
                    }
                    ++i;
                }
                break block0;
            }
        }
        this.va = lst.toArray(new Vector[lst.size()]);
    }

    public void prepareZSort() {
        this.computeExtremums();
        this.getNormal();
        this.getCenter();
        this.viewVa = new Vector[this.va.length];
        int i = 0;
        while (i < this.va.length) {
            this.viewVa[i] = new Vector(this.va[i]);
            ++i;
        }
    }

    public void perspective(double distance) {
        int i = 0;
        while (i < this.va.length) {
            this.va[i].perspective(distance);
            ++i;
        }
    }

    public Vector[] getVectors() {
        return this.va;
    }

    public Vector[] getViewerVectors() {
        return this.viewVa;
    }

    public Location[] getPoints2D(double xOffset, double yOffset) {
        Location[] locations = new Location[this.va.length];
        int i = 0;
        while (i < this.va.length) {
            locations[i] = goFactory.createLocation(this.va[i].get(0) + xOffset, this.va[i].get(1) + yOffset);
            ++i;
        }
        return locations;
    }

    protected boolean testAside(Object3D comparedObj, boolean bFront, Engine3D engine) {
        int thisPointsNumber = this.viewVa.length;
        int comparedPointsNumber = comparedObj.getViewerVectors().length;
        if (thisPointsNumber == 0 || comparedPointsNumber == 0) {
            return true;
        }
        if (thisPointsNumber < 3 && comparedPointsNumber < 3) {
            return true;
        }
        Vector normal = null;
        Vector ov = this.viewVa[0];
        double d = 0.0;
        if (thisPointsNumber < 3 || comparedPointsNumber < 3) {
            return true;
        }
        normal = this.getNormal();
        d = -normal.scalarProduct(ov);
        Vector vVRP = engine.getViewReferencePoint();
        boolean bViewerOutside = this.isOutSide(normal, d, vVRP);
        if (bFront) {
            return this.testPolygon(normal, d, comparedObj, bViewerOutside);
        }
        return this.testPolygon(normal, d, comparedObj, !bViewerOutside);
    }

    private boolean isOutSide(Vector vNormal, double d, Vector vPoint) {
        double p = vNormal.scalarProduct(vPoint) + d;
        return p > -1.0E-7;
    }

    public boolean isBehind(Vector point) {
        double d = -this.getNormal().scalarProduct(this.viewVa[0]);
        return this.isOutSide(this.getNormal(), d, point);
    }

    protected boolean testPolygon(Vector normal, double d, Object3D obj, boolean outside) {
        Vector[] tva = obj.getViewerVectors();
        int i = 0;
        while (i < tva.length) {
            double p = tva[i].scalarProduct(normal) + d;
            if (outside ? p < -1.0E-7 : p > 1.0E-7) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean testIntersect(Object3D near, Engine3D engine) {
        Vector[] va1 = this.getVectors();
        Vector[] va2 = near.getVectors();
        Polygon p1 = new Polygon();
        int i = 0;
        while (i < va1.length) {
            p1.add(va1[i].get(0), va1[i].get(1));
            ++i;
        }
        Polygon p2 = new Polygon();
        int i2 = 0;
        while (i2 < va2.length) {
            p2.add(va2[i2].get(0), va2[i2].get(1));
            ++i2;
        }
        return p1.intersects(p2);
    }

    protected boolean testXOverlap(Object3D near) {
        return !(this.getXMin() > near.getXMax()) && !(near.getXMin() > this.getXMax());
    }

    protected boolean testYOverlap(Object3D near) {
        return !(this.getYMin() > near.getYMax()) && !(near.getYMin() > this.getYMax());
    }

    public boolean testSwap(Object3D near, Engine3D engine) {
        Boolean bCached = this.hmSwap.get(near);
        if (bCached != null) {
            return bCached;
        }
        Object3D far = this;
        boolean swap = false;
        if (far.testXOverlap(near) && far.testYOverlap(near) && !far.testAside(near, true, engine) && !near.testAside(far, false, engine) && far.testIntersect(near, engine)) {
            swap = true;
        }
        this.hmSwap.put(near, swap);
        return swap;
    }

    public boolean testZOverlap(Object3D near) {
        return !(this.getZMin() > near.getZMax()) && !(near.getZMin() > this.getZMax());
    }

    private Location3D[] removeDuplicatePoints(Location3D[] loa) {
        if (loa.length > 3) {
            int iWrong = -1;
            int i = 1;
            while (i < loa.length) {
                if (loa[i].getX() == loa[i - 1].getX() && loa[i].getY() == loa[i - 1].getY() && loa[i].getZ() == loa[i - 1].getZ()) {
                    iWrong = i;
                    break;
                }
                ++i;
            }
            if (iWrong >= 0) {
                Location3D[] newLoa = new Location3D[loa.length - 1];
                int i2 = 0;
                int j = 0;
                while (i2 < loa.length) {
                    if (i2 != iWrong) {
                        newLoa[j++] = loa[i2];
                    }
                    ++i2;
                }
                return this.removeDuplicatePoints(newLoa);
            }
        }
        return loa;
    }

    protected int getFollowingIndex(int index, boolean next) {
        if (next) {
            if (index + 1 > this.va.length - 1) {
                return 0;
            }
            return index + 1;
        }
        if (index - 1 < 0) {
            return this.va.length - 1;
        }
        return index - 1;
    }

    public Object3D getSharedEdge(Object3D other) {
        int i = 0;
        while (i < this.va.length) {
            int j = 0;
            while (j < other.va.length) {
                if (this.va[i].equals(other.va[j])) {
                    int adjacentIndex = 0;
                    int otherAdjacentIndex = 0;
                    boolean next = true;
                    boolean otherNext = true;
                    int k = 0;
                    while (k < 4) {
                        switch (k) {
                            case 0: {
                                next = true;
                                otherNext = true;
                                break;
                            }
                            case 1: {
                                next = true;
                                otherNext = false;
                                break;
                            }
                            case 2: {
                                next = false;
                                otherNext = true;
                                break;
                            }
                            case 3: {
                                next = false;
                                otherNext = false;
                            }
                        }
                        adjacentIndex = this.getFollowingIndex(i, next);
                        otherAdjacentIndex = other.getFollowingIndex(j, otherNext);
                        if (this.va[adjacentIndex].equals(other.va[otherAdjacentIndex])) {
                            Object3D sharedEdge = new Object3D(6);
                            sharedEdge.va[0] = this.va[i];
                            sharedEdge.va[1] = this.computeNextEdgePoint(i, !next);
                            sharedEdge.va[2] = this.computeNextEdgePoint(adjacentIndex, next);
                            sharedEdge.va[3] = this.va[adjacentIndex];
                            sharedEdge.va[4] = other.computeNextEdgePoint(otherAdjacentIndex, otherNext);
                            sharedEdge.va[5] = other.computeNextEdgePoint(j, !otherNext);
                            return sharedEdge;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    protected Vector computeNextEdgePoint(int i, boolean next) {
        Vector point = this.va[i];
        Vector nextPoint = this.va[this.getFollowingIndex(i, next)];
        Vector dir = nextPoint.getSub(point);
        dir.normalize();
        return point.getAdd(dir);
    }
}

