/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;

public class Data
extends SheetData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -316995334044186083L;
    private static int ID = 0;
    private int id;
    private static Logger log = Logger.getLogger(Data.class.getName());

    public Data(SheetData data) {
        this(data.getText(), data.getStyle(), data.getDatatype(), data.getContainer());
        this.rowIndex = data.getRowIndex();
    }

    public Data(Object txt, int datatype, XlsContainer container) {
        this(txt, null, datatype, container);
    }

    public Data(Object txt, StyleEntry s, int datatype, XlsContainer container) {
        this(txt, s, datatype, container, 0);
    }

    public Data(Object txt, StyleEntry s, int datatype, XlsContainer container, int rowSpanOfDesign) {
        this.txt = txt;
        this.style = s;
        this.datatype = datatype;
        this.id = ID++;
        this.container = container;
        this.rowSpanInDesign = 0;
    }

    public Object getText() {
        if (this.txt == null) {
            return " ";
        }
        return this.txt;
    }

    public void formatTxt() {
        if (this.txt == null) {
            return;
        }
        if (this.datatype == 0) {
            this.txt = ExcelUtil.formatDate(this.txt);
        } else if (this.datatype == 1) {
            Number number = (Number)this.txt;
            if (ExcelUtil.isBigNumber(number)) {
                this.txt = ExcelUtil.formatNumberAsScienceNotation(number);
            } else if (number.toString().length() > 31) {
                this.txt = ExcelUtil.displayedAsScientific(number) ? ExcelUtil.formatNumberAsScienceNotation(number) : ExcelUtil.formatNumberAsDecimal(number);
            }
        }
    }

    public boolean isBigNumber() {
        if (this.txt == null) {
            return false;
        }
        if (this.datatype == 1) {
            return ExcelUtil.isBigNumber(this.txt);
        }
        return false;
    }

    public boolean isInfility() {
        if (this.txt == null) {
            return false;
        }
        if (this.datatype == 1) {
            return ExcelUtil.isInfinity(this.txt);
        }
        return false;
    }

    public boolean isNaN() {
        if (this.txt == null) {
            return false;
        }
        if (this.datatype == 1) {
            return ExcelUtil.isNaN(this.txt);
        }
        return false;
    }

    public Object getValue() {
        return this.txt;
    }

    public int hashCode() {
        return this.id;
    }

    protected Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            log.log(Level.WARNING, "clone data failed");
        }
        return o;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Data)) {
            return false;
        }
        Data data = (Data)o;
        return data.id == this.id;
    }
}

