/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.awt.Toolkit;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.engine.emitter.excel.GroupInfo;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class ExcelUtil {
    private static final double SECONDS_PER_DAY = 86400.0;
    private static final double SECONDS_PER_MINUTE = 60.0;
    private static final double SECONDS_PER_HOUR = 3600.0;
    protected static final Logger log;
    protected static final BigDecimal MAX_DOUBLE;
    protected static final BigDecimal MIN_DOUBLE;
    protected static final BigDecimal MIN_POSITIVE_DECIMAL_NUMBER;
    protected static final BigDecimal MAX_POSITIVE_DECIMAL_NUMBER;
    protected static final BigDecimal MIN_NEGATIVE_DECIMAL_NUMBER;
    protected static final BigDecimal MAX_NEGATIVE_DECIMAL_NUMBER;
    protected static final long MILLISECS_PER_DAY = 86400000L;
    private static final long BASE_DATE_TIME;
    private static final String validStr = "#.0<>()%_";
    private static final String specialStr = "mMdDyYhHsSeEbBgGnN/*\"@";
    private static final String currencySymbol = "\u00a3\u00a2\u20ac\uffe5\u00a5";
    protected static Logger logger;
    private static final HashSet<Character> splitChar;
    public static final double INCH_PX;
    public static final double INCH_PT = 72.0;
    public static final double PT_TWIPS = 20.0;
    public static final double INCH_TWIPS = 1440.0;
    public static final double PX_TWIPS;
    public static final double PX_PT;
    private static String invalidBookmarkChars;
    private static final int max_formula_length = 512;
    private static final String reg1 = "Total.(count|ave|sum|max|min)\\(";
    private static final String reg2 = "\\)";
    private static final String reg3 = "\\[";
    private static final String reg4 = "\\]";
    public static String ZIP;
    public static String PHONE;
    public static String SOCIAL;
    public static String ZIP_CODE;
    public static String PHONE_CODE;
    public static String SOCIALNUMBER_CODE;

    static {
        double Temp_PX;
        log = Logger.getLogger(ExcelUtil.class.getName());
        MAX_DOUBLE = new BigDecimal(Double.MAX_VALUE);
        MIN_DOUBLE = MAX_DOUBLE.negate().subtract(BigDecimal.ONE);
        MIN_POSITIVE_DECIMAL_NUMBER = new BigDecimal("0.000000000000001");
        MAX_POSITIVE_DECIMAL_NUMBER = new BigDecimal(1.0E16).subtract(MIN_POSITIVE_DECIMAL_NUMBER);
        MIN_NEGATIVE_DECIMAL_NUMBER = new BigDecimal(-1.0E15).add(new BigDecimal("0.000000000000001"));
        MAX_NEGATIVE_DECIMAL_NUMBER = MIN_POSITIVE_DECIMAL_NUMBER.negate();
        logger = Logger.getLogger(ExcelUtil.class.getName());
        splitChar = new HashSet();
        Calendar date = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)"GMT-0:00"));
        date.setTime(new java.util.Date("1900/01/01"));
        BASE_DATE_TIME = date.getTimeInMillis();
        splitChar.add(new Character(' '));
        splitChar.add(new Character('\r'));
        splitChar.add(new Character('\n'));
        try {
            Temp_PX = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Exception exception) {
            Temp_PX = 96.0;
        }
        INCH_PX = Temp_PX;
        PX_TWIPS = 1440.0 / INCH_PX;
        PX_PT = 72.0 / INCH_PX;
        invalidBookmarkChars = "`~!@#$%^&*()-=+\\|[]{};:'\",./?>< \t\n\r\uff01\uffe5\uff08\uff09\uff1a\uff1b\uff0c";
        ZIP = "@@@@@-@@@@";
        PHONE = "(@@@)@@@-@@@@";
        SOCIAL = "@@@-@@-@@@@";
        ZIP_CODE = "00000\\-0000";
        PHONE_CODE = "[<=9999999]###\\-####;\\(###\\)\\ ###\\-####";
        SOCIALNUMBER_CODE = "000\\-00\\-0000";
    }

    public static String ridQuote(String val) {
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static boolean isValidBookmarkName(String name) {
        if (name.equalsIgnoreCase("r")) {
            return false;
        }
        if (name.equalsIgnoreCase("c")) {
            return false;
        }
        if (name.startsWith("auto_generated_bookmark_")) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (invalidBookmarkChars.indexOf(name.charAt(i)) != -1) {
                return false;
            }
            ++i;
        }
        if (name.matches("[0-9].*")) {
            return false;
        }
        if (name.matches("([A-Za-z]|[A-Ha-h][A-Za-z]|[Ii][A-Va-v])[0-9]{1,5}")) {
            String[] strs = name.split("[A-Za-z]");
            if (strs.length > 0) {
                int rowId = 0;
                try {
                    rowId = Integer.parseInt(strs[strs.length - 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    return true;
                }
                return rowId > 65536;
            }
            return true;
        }
        return true;
    }

    public static String formatDate(Object data) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        java.util.Date date = ExcelUtil.getDate(data);
        if (date == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public static java.util.Date getDate(Object data) {
        java.util.Date date = null;
        date = data instanceof Calendar ? ((Calendar)data).getTime() : (data instanceof java.util.Date ? (java.util.Date)data : null);
        return date;
    }

    public static String formatNumberAsDecimal(Object data) {
        Number number = (Number)data;
        DecimalFormat numberFormat = new DecimalFormat("0.##############");
        numberFormat.setMaximumFractionDigits(15);
        return numberFormat.format(number);
    }

    /*
     * Unable to fully structure code
     */
    public static String formatNumberAsScienceNotation(Number data) {
        block5: {
            if (!ExcelUtil.$assertionsDisabled && !(data instanceof BigDecimal)) {
                throw new AssertionError();
            }
            bigDecimal = (BigDecimal)data;
            scale = 0;
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                return "0";
            }
            prefix = "";
            if (bigDecimal.compareTo(BigDecimal.ZERO) == -1) {
                prefix = "-";
                bigDecimal = bigDecimal.negate();
            }
            if (bigDecimal.compareTo(BigDecimal.ONE) != -1) ** GOTO lbl19
            while (bigDecimal.compareTo(BigDecimal.ONE) == -1) {
                bigDecimal = bigDecimal.movePointRight(1);
                --scale;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                bigDecimal = bigDecimal.movePointLeft(1);
                ++scale;
lbl19:
                // 2 sources

                ** while (bigDecimal.compareTo((BigDecimal)BigDecimal.TEN) == 1)
            }
        }
        decimalFormat = new DecimalFormat("0.##############");
        number = decimalFormat.format(bigDecimal);
        sign = scale >= 0 ? "+" : "";
        return String.valueOf(prefix) + number + "E" + sign + scale;
    }

    public static int getType(Object val) {
        if (val instanceof Number) {
            return 1;
        }
        if (val instanceof java.util.Date) {
            return 0;
        }
        if (val instanceof Calendar) {
            return 3;
        }
        return 2;
    }

    private static String replaceDateFormat(String pattern) {
        if (pattern == null) {
            String rg = "";
            return rg;
        }
        StringBuffer toAppendTo = new StringBuffer();
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch != prevCh && count > 0) {
                toAppendTo.append(ExcelUtil.subReplaceDateFormat(prevCh, count));
                count = 0;
            }
            if (ch == '/') {
                toAppendTo.append('\\');
                toAppendTo.append(ch);
            } else if (ch == '\'') {
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '\'') {
                    toAppendTo.append("\"");
                    ++i;
                } else {
                    inQuote = !inQuote;
                }
            } else if (!inQuote) {
                prevCh = ch;
                ++count;
            } else {
                toAppendTo.append(ch);
            }
            ++i;
        }
        if (count > 0) {
            toAppendTo.append(ExcelUtil.subReplaceDateFormat(prevCh, count));
        }
        return toAppendTo.toString();
    }

    private static String subReplaceDateFormat(char ch, int count) {
        String current = "";
        int patternCharIndex = -1;
        String datePatternChars = "GyMdkHmsSEDFwWahKz";
        patternCharIndex = datePatternChars.indexOf(ch);
        if (patternCharIndex == -1) {
            int i = 0;
            while (i < count) {
                current = String.valueOf(current) + ch;
                ++i;
            }
            return current;
        }
        switch (patternCharIndex) {
            case 0: {
                current = "";
                break;
            }
            case 1: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 4: {
                current = "h";
                break;
            }
            case 5: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 9: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + "a";
                    ++i;
                }
                break;
            }
            case 14: {
                current = "AM/PM";
                break;
            }
            case 15: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 17: {
                current = "";
                break;
            }
            default: {
                current = "";
            }
        }
        return current;
    }

    public static String getPattern(Object data, String val) {
        if (val != null && data instanceof java.util.Date) {
            return ExcelUtil.replaceDateFormat(val);
        }
        if (val == null && data instanceof Time) {
            return "Long Time";
        }
        if (val == null && data instanceof Date) {
            return "mmm d, yyyy";
        }
        if (val == null && data instanceof java.util.Date) {
            return "mmm d, yyyy h:mm AM/PM";
        }
        if (val != null && data instanceof Number) {
            return new NumberFormatter(val).getPattern();
        }
        if (val != null && data instanceof String) {
            return new StringFormatter(val).getPattern();
        }
        return null;
    }

    public static String replaceAll(String str, String old, String news) {
        if (str == null) {
            return str;
        }
        int begin = 0;
        int idx = 0;
        int len = old.length();
        StringBuffer buf = new StringBuffer();
        while ((idx = str.indexOf(old, begin)) >= 0) {
            buf.append(str.substring(begin, idx));
            buf.append(news);
            begin = idx + len;
        }
        return new String(buf.append(str.substring(begin)));
    }

    public static String getValue(String val) {
        if (val == null) {
            return "NULL";
        }
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static int convertToPt(String size) {
        try {
            int s = Integer.valueOf(size.substring(0, size.length() - 2));
            if (size.endsWith("in")) {
                return s * 72;
            }
            if (size.endsWith("cm")) {
                return (int)((double)s / 2.54 * 72.0);
            }
            if (size.endsWith("mm")) {
                return (int)((double)(s * 10) / 2.54 * 72.0);
            }
            if (size.endsWith("pc")) {
                return s;
            }
            return s;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "unknown size: " + size);
            return 0;
        }
    }

    public static String convertColWith(int width) {
        double result = 0.0;
        if (width < 0) {
            return "0.0";
        }
        double digitalWidth = 5.25;
        result = (int)((double)width / digitalWidth * 100.0 + 0.5);
        return Double.toString(result /= 100.0);
    }

    public static boolean isBigNumber(Object number) {
        try {
            BigDecimal num = ExcelUtil.getBigDecimal(number);
            return num.compareTo(MAX_DOUBLE) == 1 || num.compareTo(MIN_DOUBLE) == -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static BigDecimal getBigDecimal(Object number) {
        BigDecimal num = null;
        num = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.toString());
        return num;
    }

    public static boolean displayedAsScientific(Object number) {
        BigDecimal num = ExcelUtil.getBigDecimal(number);
        if (num.compareTo(MAX_POSITIVE_DECIMAL_NUMBER) <= 0 && num.compareTo(MIN_POSITIVE_DECIMAL_NUMBER) >= 0) {
            return false;
        }
        return num.compareTo(MAX_NEGATIVE_DECIMAL_NUMBER) > 0 || num.compareTo(MIN_NEGATIVE_DECIMAL_NUMBER) < 0;
    }

    public static boolean isInfinity(Object number) {
        try {
            return Double.isInfinite((Double)number);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getColumnOfExp(String exp) {
        return exp.substring(exp.indexOf("dataSetRow["), exp.lastIndexOf("]") + 1);
    }

    public static String createFormula(String txt, String exp, List positions) {
        exp = ExcelUtil.getFormulaName(exp);
        StringBuffer sb = new StringBuffer(String.valueOf(exp) + "(");
        int i = 0;
        while (i < positions.size()) {
            GroupInfo.Position p = (GroupInfo.Position)positions.get(i);
            sb.append("R" + p.row + "C" + p.column + ",");
            ++i;
        }
        sb.setCharAt(sb.length() - 1, ')');
        if (sb.length() > 512 || positions.size() == 0) {
            return txt;
        }
        return sb.toString();
    }

    private static String getFormulaName(String expression) {
        if (expression.startsWith("Total.sum")) {
            return "=SUM";
        }
        if (expression.startsWith("Total.ave")) {
            return "=AVERAGE";
        }
        if (expression.startsWith("Total.max")) {
            return "=MAX";
        }
        if (expression.startsWith("Total.min")) {
            return "=MIN";
        }
        if (expression.startsWith("Total.count")) {
            return "=COUNT";
        }
        throw new RuntimeException("Cannot parse the expression" + expression);
    }

    public static boolean isValidExp(String exp, String[] columnNames) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < columnNames.length) {
            sb.append(String.valueOf(columnNames[i]) + "|");
            ++i;
        }
        String columnRegExp = "(" + sb.substring(0, sb.length() - 1) + ")";
        columnRegExp = columnRegExp.replaceAll(reg3, "Z");
        columnRegExp = columnRegExp.replaceAll(reg4, "Z");
        String aggregateRegExp = reg1 + columnRegExp + reg2;
        exp = exp.replaceAll(reg3, "Z");
        exp = exp.replaceAll(reg4, "Z");
        Pattern p = Pattern.compile(aggregateRegExp);
        Matcher m = p.matcher(exp);
        boolean agg = m.matches();
        p = Pattern.compile(columnRegExp);
        m = p.matcher(exp);
        return agg || m.matches();
    }

    public static String expression(String val, String target, String[] res, boolean casesenstive) {
        boolean flag = casesenstive ? target.equals(val) : target.equalsIgnoreCase(val);
        return flag ? res[1] : res[0];
    }

    public static int covertDimensionType(DimensionType value, int parent) {
        if ("%".equals(value.getUnits())) {
            return (int)(value.getMeasure() / 100.0 * (double)parent);
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return (int)(value.getMeasure() * PX_PT);
        }
        if ("em".equalsIgnoreCase(value.getUnits()) || "ex".equalsIgnoreCase(value.getUnits())) {
            return (int)value.getMeasure() * 12;
        }
        return (int)value.convertTo("pt");
    }

    public static String parse(Object txt, String dateTime, ULocale locale) {
        if (dateTime == null) {
            DateFormatter format = new DateFormatter(locale);
            if (txt instanceof Date) {
                format.applyPattern("DateUnformatted");
            } else if (txt instanceof Time) {
                format.applyPattern("TimeUnformatted");
            } else {
                format.applyPattern("DateTimeUnformatted");
            }
            dateTime = format.getLocalizedFormatCode();
        }
        if (dateTime.indexOf("Date") != -1 || dateTime.indexOf("Time") != -1) {
            DateFormatter dateFormatter = new DateFormatter(dateTime, locale);
            dateTime = dateFormatter.getLocalizedFormatCode();
        }
        StringBuffer buffer = new StringBuffer();
        boolean inQuto = false;
        int count = 0;
        while (count < dateTime.length()) {
            char tempChar = dateTime.charAt(count);
            if (inQuto) {
                if (tempChar == '\'' && ExcelUtil.nextIsQuto(dateTime, count)) {
                    buffer.append(tempChar);
                    ++count;
                } else if (tempChar == '\'') {
                    inQuto = false;
                } else if (specialStr.indexOf(tempChar) != -1) {
                    buffer.append("\\" + tempChar);
                } else {
                    buffer.append(tempChar);
                }
            } else if (tempChar == '\'') {
                if (ExcelUtil.nextIsQuto(dateTime, count)) {
                    buffer.append(tempChar);
                    ++count;
                } else {
                    inQuto = true;
                }
            } else if (tempChar == 'a') {
                buffer.append("AM/PM");
            } else if ("zZFWwGE".indexOf(tempChar) == -1) {
                if ("kK".indexOf(tempChar) != -1) {
                    buffer.append("h");
                } else {
                    buffer.append(tempChar);
                }
            }
            ++count;
        }
        return buffer.toString();
    }

    public static String formatNumberPattern(String givenValue) {
        return ExcelUtil.formatNumberPattern(givenValue, ULocale.getDefault());
    }

    public static String formatNumberPattern(String givenValue, ULocale locale) {
        String returnStr = "";
        if (givenValue == null) {
            return "";
        }
        if (givenValue.length() == 1) {
            char ch = givenValue.charAt(0);
            if (ch == 'G' || ch == 'g' || ch == 'd' || ch == 'D') {
                return "###,##0.###";
            }
            if (ch == 'C' || ch == 'c') {
                return String.valueOf(ExcelUtil.getCurrencySymbol(locale)) + "###,##0.00";
            }
            if (ch == 'f' || ch == 'F') {
                return "#0.00";
            }
            if (ch == 'N' || ch == 'n') {
                return "###,##0.00";
            }
            if (ch == 'p' || ch == 'P') {
                return "###,##0.00 %";
            }
            if (ch == 'e' || ch == 'E') {
                return "0.000000E00";
            }
            if (ch == 'x' || ch == 'X') {
                return "####";
            }
        }
        if (givenValue.equals("Fixed")) {
            return "Fixed";
        }
        if (givenValue.equals("Percent")) {
            return "Percent";
        }
        if (givenValue.equals("Scientific")) {
            return "Scientific";
        }
        if (givenValue.equals("Standard")) {
            return "Standard";
        }
        if (givenValue.equals("General Number")) {
            return "General";
        }
        if (ExcelUtil.validType(givenValue)) {
            return givenValue;
        }
        int count = givenValue.length();
        boolean flag = false;
        int num = 0;
        while (num < count) {
            char temp = givenValue.charAt(num);
            if (temp == '\'') {
                if (flag) {
                    flag = false;
                } else {
                    char nextChar = givenValue.charAt(num + 1);
                    if (nextChar == '\'') {
                        returnStr = String.valueOf(returnStr) + '\'';
                        ++num;
                        flag = false;
                    } else {
                        flag = true;
                    }
                }
            } else if (flag) {
                returnStr = String.valueOf(returnStr) + "\\" + temp;
            } else if (specialStr.indexOf(temp) != -1) {
                returnStr = String.valueOf(returnStr) + "\\" + temp;
            } else if (temp == '\u00a4') {
                String symbol = ExcelUtil.getCurrencySymbol(locale);
                returnStr = String.valueOf(returnStr) + "\"" + symbol + "\"";
            } else {
                returnStr = currencySymbol.indexOf(temp) != -1 ? String.valueOf(returnStr) + "\"" + temp + "\"" : String.valueOf(returnStr) + temp;
            }
            ++num;
        }
        if (returnStr.indexOf("#") == -1 && returnStr.indexOf("0") == -1) {
            returnStr = String.valueOf(returnStr) + "#";
        }
        return returnStr;
    }

    private static String getCurrencySymbol(ULocale locale) {
        NumberFormat format = NumberFormat.getCurrencyInstance((ULocale)locale);
        String symbol = format.getCurrency().getSymbol();
        if (symbol.equals("EUR")) {
            symbol = "\u20ac";
        }
        if (symbol.equals("GBP")) {
            symbol = "\u00a3";
        }
        if (symbol.equals("XXX")) {
            symbol = "\u00a4";
        }
        return symbol;
    }

    protected static boolean validType(String str) {
        int count = 0;
        while (count < str.length()) {
            char ch = str.charAt(count);
            if (validStr.indexOf(ch) == -1) {
                return false;
            }
            ++count;
        }
        return true;
    }

    private static boolean nextIsQuto(String forPar, int index) {
        if (forPar.length() - 1 == index) {
            return false;
        }
        return forPar.charAt(index + 1) == '\'';
    }

    public static boolean equalsIgnoreCase(String obj1, String obj2) {
        return obj1 == null ? obj2 == null : obj1.equalsIgnoreCase(obj2);
    }

    public static String getDay(java.util.Date d, TimeZone zone) {
        long currentTimeInMillis;
        int dayComponent;
        Calendar currentDay = Calendar.getInstance((TimeZone)zone);
        currentDay.setTime(d);
        int hours = currentDay.get(11);
        int minutes = currentDay.get(12);
        int seconds = currentDay.get(13);
        double timeComponent = ((double)hours * 3600.0 + (double)minutes * 60.0 + (double)seconds) / 86400.0;
        if (timeComponent < 0.0 || timeComponent > 1.0) {
            logger.log(Level.WARNING, "Invalid time!");
            timeComponent = 0.0;
        }
        if ((dayComponent = (int)(((currentTimeInMillis = currentDay.getTimeInMillis()) - BASE_DATE_TIME) / 86400000L)) < 0 || dayComponent > 2958463) {
            logger.log(Level.WARNING, "Invaild day");
            dayComponent = 0;
        }
        dayComponent = dayComponent <= 59 ? ++dayComponent : (dayComponent += 2);
        double dateTime = (double)dayComponent + timeComponent;
        return Double.toString(dateTime);
    }

    public static String convertColor(String value) {
        if (value == null || "transparent".equalsIgnoreCase(value) || "null".equalsIgnoreCase(value)) {
            return null;
        }
        return value.replace("#", "FF");
    }

    public static String covertBorderStyle(String style) {
        if (style == null) {
            return null;
        }
        if (style.equalsIgnoreCase("Dot")) {
            return "dotted";
        }
        if (style.equalsIgnoreCase("DashDot")) {
            return "dashDot";
        }
        if (style.equalsIgnoreCase("Double")) {
            return "double";
        }
        if (style.equalsIgnoreCase("Continuous")) {
            return "thin";
        }
        return null;
    }

    public static String capitalize(String text) {
        boolean capitalizeNextChar = true;
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            Character c = new Character(text.charAt(i));
            if (splitChar.contains(c)) {
                capitalizeNextChar = true;
            } else if (capitalizeNextChar) {
                array[i] = Character.toUpperCase(array[i]);
                capitalizeNextChar = false;
            }
            ++i;
        }
        return new String(array);
    }

    public static String getRef(int row, int column) {
        Stack<Character> digits = new Stack<Character>();
        int dividant = column;
        while (dividant > 26) {
            int remain = dividant % 26;
            dividant /= 26;
            if (remain == 0) {
                remain = 26;
                --dividant;
            }
            digits.push(Character.valueOf((char)(65 + remain - 1)));
        }
        digits.push(Character.valueOf((char)(65 + dividant - 1)));
        StringBuffer buffer = new StringBuffer();
        while (!digits.empty()) {
            buffer.append(digits.pop());
        }
        if (row >= 0) {
            buffer.append(row);
        }
        return buffer.toString();
    }

    public static double convertImageSize(DimensionType value, int ref) {
        if (value == null) {
            return (double)ref * PX_PT;
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() * PX_PT;
        }
        if ("%".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() / 100.0 * (double)ref * PX_PT;
        }
        return value.convertTo("in") * 72.0;
    }

    public static String convertStringFormat(String property) {
        if (property == null) {
            return null;
        }
        if (ZIP.equals(property)) {
            return ZIP_CODE;
        }
        if (PHONE.equals(property)) {
            return PHONE_CODE;
        }
        if (SOCIAL.equals(property)) {
            return SOCIALNUMBER_CODE;
        }
        return property;
    }

    public static String convertSciFormat(String code) {
        if (code == null) {
            return null;
        }
        int index = code.indexOf(69);
        if (index != -1) {
            return String.valueOf(code.substring(0, index - 1)) + "E" + "+" + code.substring(index + 1);
        }
        return code;
    }

    public static boolean isNaN(Object number) {
        try {
            return Double.isNaN((Double)number);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

