/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.XMLEncodeUtil;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.IExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelXmlWriter
implements IExcelWriter {
    private boolean isRTLSheet = false;
    public static final int rightToLeftisTrue = 1;
    private final XMLWriterXLS writer = new XMLWriterXLS();
    private String pageHeader;
    private String pageFooter;
    private String orientation;
    private int sheetIndex = 1;
    protected static Logger logger = Logger.getLogger(ExcelXmlWriter.class.getName());
    ExcelContext context = null;

    public XMLWriterXLS getWriter() {
        return this.writer;
    }

    public ExcelXmlWriter(OutputStream out, ExcelContext context) {
        this(out, "UTF-8", context);
    }

    public ExcelXmlWriter(OutputStream out) {
        this.writer.open(out, "UTF-8");
    }

    public ExcelXmlWriter(OutputStream out, String encoding, ExcelContext context) {
        this.context = context;
        this.writer.open(out, encoding);
    }

    public ExcelXmlWriter(OutputStream out, boolean isRTLSheet) {
        this.isRTLSheet = isRTLSheet;
        this.writer.open(out, "UTF-8");
    }

    public ExcelXmlWriter(OutputStream out, ExcelContext context, boolean isRTLSheet) {
        this(out, "UTF-8", context);
        this.isRTLSheet = isRTLSheet;
    }

    public ExcelXmlWriter(OutputStream out, String encoding, ExcelContext context, boolean isRTLSheet) {
        this.context = context;
        this.isRTLSheet = isRTLSheet;
        this.writer.open(out, encoding);
    }

    private void writeDocumentProperties(IReportContent reportContent) {
        ReportDesignHandle reportDesign = reportContent.getDesign().getReportDesign();
        this.writer.openTag("DocumentProperties");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:office");
        this.writer.openTag("Author");
        this.writer.text(reportDesign.getStringProperty("author"));
        this.writer.closeTag("Author");
        this.writer.openTag("Title");
        this.writer.text(reportDesign.getStringProperty("title"));
        this.writer.closeTag("Title");
        this.writer.openTag("Description");
        this.writer.text(reportDesign.getStringProperty("description"));
        this.writer.closeTag("Description");
        this.writer.closeTag("DocumentProperties");
    }

    private void writeText(Data d) {
        this.writer.openTag("Data");
        int type = d.getDatatype();
        if (type == 1) {
            if (d.isNaN() || d.isBigNumber() || d.isInfility()) {
                this.writer.attribute("ss:Type", "String");
            } else {
                this.writer.attribute("ss:Type", "Number");
            }
        } else if (type == 0) {
            this.writer.attribute("ss:Type", "DateTime");
        } else {
            this.writer.attribute("ss:Type", "String");
        }
        d.formatTxt();
        String txt = d.getText().toString();
        if ("capitalize".equalsIgnoreCase(d.getStyle().getProperty(26))) {
            txt = this.capitalize(txt);
        } else if ("uppercase".equalsIgnoreCase(d.getStyle().getProperty(26))) {
            txt = txt.toUpperCase();
        } else if ("lowercase".equalsIgnoreCase(d.getStyle().getProperty(26))) {
            txt = txt.toLowerCase();
        }
        this.writer.text(txt);
        this.writer.closeTag("Data");
    }

    private String capitalize(String text) {
        boolean capitalizeNextChar = true;
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\n' || c == '\r') {
                capitalizeNextChar = true;
            } else if (capitalizeNextChar) {
                array[i] = Character.toUpperCase(array[i]);
                capitalizeNextChar = false;
            }
            ++i;
        }
        return new String(array);
    }

    @Override
    public void startRow(double rowHeight) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        this.writer.attribute("ss:Height", rowHeight);
    }

    @Override
    public void endRow() {
        this.writer.closeTag("Row");
    }

    private void startCell(int cellindex, int colspan, int rowspan, int styleid, HyperlinkDef hyperLink, BookmarkDef linkedBookmark) {
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", cellindex);
        this.writer.attribute("ss:StyleID", styleid);
        if (hyperLink != null) {
            String urlAddress = hyperLink.getUrl();
            if (hyperLink.getType() == 2) {
                if (linkedBookmark != null) {
                    urlAddress = "#" + linkedBookmark.getValidName();
                } else {
                    logger.log(Level.WARNING, "The bookmark: {" + urlAddress + "} is not defined!");
                }
            }
            if (urlAddress != null && urlAddress.length() >= 255) {
                logger.log(Level.WARNING, "The URL: {" + urlAddress + "} is too long!");
                urlAddress = urlAddress.substring(0, 254);
            }
            this.writer.attribute("ss:HRef", urlAddress);
        }
        this.writer.attribute("ss:MergeAcross", colspan);
        this.writer.attribute("ss:MergeDown", rowspan);
    }

    public void writeDefaultCell(Data d) {
        this.writer.openTag("Cell");
        if (d.getStyleId() != 0) {
            this.writer.attribute("ss:StyleID", d.getStyleId());
        }
        this.writeText(d);
        this.writer.closeTag("Cell");
    }

    @Override
    public void outputData(SheetData sheetData) {
        if (sheetData.getDatatype() == 5) {
            return;
        }
        Data d = (Data)sheetData;
        this.startCell(d.span.getCol(), d.span.getColSpan(), d.getRowSpan(), d.styleId, d.hyperLink, d.getLinkedBookmark());
        this.writeText(d);
        if (d.hyperLink != null && d.hyperLink.getToolTip() != null) {
            this.writeComments(d.hyperLink);
        }
        this.endCell();
    }

    protected void writeComments(HyperlinkDef linkDef) {
        String toolTip = linkDef.getToolTip();
        this.writer.openTag("Comment");
        this.writer.openTag("ss:Data");
        this.writer.attribute("xmlns", "http://www.w3.org/TR/REC-html40");
        this.writer.openTag("Font");
        this.writer.text(toolTip);
        this.writer.closeTag("Font");
        this.writer.closeTag("ss:Data");
        this.writer.closeTag("Comment");
    }

    protected void writeFormulaData(Data d) {
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", d.span.getCol());
        this.writer.attribute("ss:Formula", d.txt.toString());
        this.writer.attribute("ss:MergeAcross", d.span.getColSpan());
        this.writer.attribute("ss:StyleID", d.styleId);
        this.writer.closeTag("Cell");
    }

    private void endCell() {
        this.writer.closeTag("Cell");
    }

    private void writeAlignment(String horizontal, String vertical, String direction, boolean wrapText) {
        this.writer.openTag("Alignment");
        if (this.isValid(horizontal)) {
            this.writer.attribute("ss:Horizontal", horizontal);
        }
        if (this.isValid(vertical)) {
            this.writer.attribute("ss:Vertical", vertical);
        }
        if (this.isValid(direction)) {
            if ("rtl".equals(direction)) {
                this.writer.attribute("ss:ReadingOrder", "RightToLeft");
            } else {
                this.writer.attribute("ss:ReadingOrder", "LeftToRight");
            }
        }
        if (wrapText) {
            this.writer.attribute("ss:WrapText", "1");
        }
        this.writer.closeTag("Alignment");
    }

    private void writeBorder(String position, String lineStyle, String weight, String color) {
        this.writer.openTag("Border");
        this.writer.attribute("ss:Position", position);
        if (this.isValid(lineStyle)) {
            this.writer.attribute("ss:LineStyle", lineStyle);
        }
        if (this.isValid(weight)) {
            this.writer.attribute("ss:Weight", weight);
        }
        if (this.isValid(color)) {
            this.writer.attribute("ss:Color", color);
        }
        this.writer.closeTag("Border");
    }

    private void writeFont(String fontName, String size, String bold, String italic, String strikeThrough, String underline, String color) {
        this.writer.openTag("Font");
        if (this.isValid(fontName)) {
            this.writer.attribute("ss:FontName", fontName);
        }
        if (this.isValid(size)) {
            this.writer.attribute("ss:Size", size);
        }
        if (this.isValid(bold)) {
            this.writer.attribute("ss:Bold", bold);
        }
        if (this.isValid(italic)) {
            this.writer.attribute("ss:Italic", italic);
        }
        if (this.isValid(strikeThrough)) {
            this.writer.attribute("ss:StrikeThrough", strikeThrough);
        }
        if (this.isValid(underline) && !"0".equalsIgnoreCase(underline)) {
            this.writer.attribute("ss:Underline", "Single");
        }
        if (this.isValid(color)) {
            this.writer.attribute("ss:Color", color);
        }
        this.writer.closeTag("Font");
    }

    private void writeBackGroudColor(String bgColor) {
        if (this.isValid(bgColor)) {
            this.writer.openTag("Interior");
            this.writer.attribute("ss:Color", bgColor);
            this.writer.attribute("ss:Pattern", "Solid");
            this.writer.closeTag("Interior");
        }
    }

    private boolean isValid(String value) {
        return !StyleEntry.isNull(value);
    }

    private void declareStyle(StyleEntry style, int id) {
        boolean wrapText = this.context.getWrappingText();
        String whiteSpace = style.getProperty(28);
        if ("nowrap".equals(whiteSpace)) {
            wrapText = false;
        }
        this.writer.openTag("Style");
        this.writer.attribute("ss:ID", id);
        if (style.getName() == "Hyperlink") {
            this.writer.attribute("ss:Parent", "HyperlinkId");
        }
        if (id >= 20) {
            String direction = style.getProperty(27);
            String horizontalAlign = style.getProperty(8);
            String verticalAlign = style.getProperty(9);
            this.writeAlignment(horizontalAlign, verticalAlign, direction, wrapText);
            this.writer.openTag("Borders");
            String bottomColor = style.getProperty(10);
            String bottomLineStyle = style.getProperty(11);
            String bottomWeight = style.getProperty(12);
            this.writeBorder("Bottom", bottomLineStyle, bottomWeight, bottomColor);
            String topColor = style.getProperty(13);
            String topLineStyle = style.getProperty(14);
            String topWeight = style.getProperty(15);
            this.writeBorder("Top", topLineStyle, topWeight, topColor);
            String leftColor = style.getProperty(16);
            String leftLineStyle = style.getProperty(17);
            String leftWeight = style.getProperty(18);
            this.writeBorder("Left", leftLineStyle, leftWeight, leftColor);
            String rightColor = style.getProperty(19);
            String rightLineStyle = style.getProperty(20);
            String rightWeight = style.getProperty(21);
            this.writeBorder("Right", rightLineStyle, rightWeight, rightColor);
            this.writer.closeTag("Borders");
            String fontName = style.getProperty(0);
            String size = style.getProperty(1);
            String fontStyle = style.getProperty(2);
            String fontWeight = style.getProperty(3);
            String strikeThrough = style.getProperty(4);
            String underline = style.getProperty(5);
            String color = style.getProperty(7);
            this.writeFont(fontName, size, fontWeight, fontStyle, strikeThrough, underline, color);
            String bgColor = style.getProperty(6);
            this.writeBackGroudColor(bgColor);
        }
        this.writeDataFormat(style);
        this.writer.closeTag("Style");
    }

    private void writeDataFormat(StyleEntry style) {
        String typeString = style.getProperty(25);
        if (typeString == null) {
            return;
        }
        int type = Integer.parseInt(typeString);
        if (type == 0 && style.getProperty(22) != null) {
            this.writer.openTag("NumberFormat");
            this.writer.attribute("ss:Format", style.getProperty(22));
            this.writer.closeTag("NumberFormat");
        }
        if (type == 1 && style.getProperty(23) != null) {
            this.writer.openTag("NumberFormat");
            String numberStyle = style.getProperty(23);
            this.writer.attribute("ss:Format", numberStyle);
            this.writer.closeTag("NumberFormat");
        }
    }

    private void writeDeclarations() {
        this.writer.startWriter();
        this.writer.getPrint().println();
        this.writer.getPrint().println("<?mso-application progid=\"Excel.Sheet\"?>");
        this.writer.openTag("Workbook");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.attribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        this.writer.attribute("xmlns:x", "urn:schemas-microsoft-com:office:excel");
        this.writer.attribute("xmlns:ss", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.attribute("xmlns:html", "http://www.w3.org/TR/REC-html40");
    }

    private void declareStyles(Map<StyleEntry, Integer> style2id) {
        this.writer.openTag("Styles");
        this.declareHyperlinkStyle();
        Set<Map.Entry<StyleEntry, Integer>> entrySet = style2id.entrySet();
        for (Map.Entry<StyleEntry, Integer> entry : entrySet) {
            this.declareStyle(entry.getKey(), entry.getValue());
        }
        this.writer.closeTag("Styles");
    }

    private void declareHyperlinkStyle() {
        this.writer.openTag("Style");
        this.writer.attribute("ss:ID", "HyperlinkId");
        this.writer.attribute("ss:Name", "Hyperlink");
        this.writeFont(null, null, null, null, null, "Single", "#0000FF");
        this.writer.closeTag("Style");
    }

    private void defineNames(Map.Entry<String, BookmarkDef> bookmarkEntry) {
        BookmarkDef bookmark = bookmarkEntry.getValue();
        String name = bookmark.getValidName();
        String refer = this.getRefer(bookmark.getSheetIndex(), bookmark);
        this.defineName(name, refer);
    }

    private String getRefer(int sheetIndex, BookmarkDef bookmark) {
        StringBuffer sb = new StringBuffer("=Sheet");
        sb.append(sheetIndex);
        sb.append("!R");
        sb.append(bookmark.getRowNo());
        sb.append("C");
        sb.append(bookmark.getColumnNo());
        return sb.toString();
    }

    private void defineName(String name, String refer) {
        this.writer.openTag("NamedRange");
        this.writer.attribute("ss:Name", name);
        this.writer.attribute("ss:RefersTo", refer);
        this.writer.closeTag("NamedRange");
    }

    public void startSheet(String name) {
        this.writer.openTag("Worksheet");
        this.writer.attribute("ss:Name", name);
        if (this.isRTLSheet) {
            this.writer.attribute("ss:RightToLeft", 1);
        }
    }

    public void closeSheet() {
        this.writer.closeTag("Worksheet");
        this.writer.endWriter();
    }

    public void ouputColumns(int[] width) {
        this.writer.openTag("ss:Table");
        if (width == null) {
            logger.log(Level.SEVERE, "Invalid columns width");
            return;
        }
        int i = 0;
        while (i < width.length) {
            this.writer.openTag("ss:Column");
            this.writer.attribute("ss:Width", width[i]);
            this.writer.closeTag("ss:Column");
            ++i;
        }
    }

    public void endTable() {
        this.writer.closeTag("ss:Table");
    }

    public void insertHorizontalMargin(int height, int span) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        this.writer.attribute("ss:Height", height);
        this.writer.openTag("Cell");
        this.writer.attribute(" ss:MergeAcross", span);
        this.writer.closeTag("Cell");
        this.writer.closeTag("Row");
    }

    public void insertVerticalMargin(int start, int end, int length) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        this.writer.attribute("ss:Height", 1);
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", start);
        this.writer.attribute(" ss:MergeDown", length);
        this.writer.closeTag("Cell");
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", end);
        this.writer.attribute(" ss:MergeDown", length);
        this.writer.closeTag("Cell");
        this.writer.closeTag("Row");
    }

    private void declareWorkSheetOptions(String orientation, String pageHeader, String pageFooter) {
        this.writer.openTag("WorksheetOptions");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:excel");
        this.writer.openTag("PageSetup");
        if (orientation != null) {
            this.writer.openTag("Layout");
            this.writer.attribute("x:Orientation", orientation);
            this.writer.closeTag("Layout");
        }
        if (pageHeader != null) {
            this.writer.openTag("Header");
            this.writer.attribute("x:Data", pageHeader);
            this.writer.closeTag("Header");
        }
        if (pageFooter != null) {
            this.writer.openTag("Footer");
            this.writer.attribute("x:Data", pageFooter);
            this.writer.closeTag("Footer");
        }
        this.writer.closeTag("PageSetup");
        this.writer.closeTag("WorksheetOptions");
    }

    private void startSheet(int sheetIndex) {
        this.startSheet("Sheet" + String.valueOf(sheetIndex));
    }

    @Override
    public void startSheet(int[] coordinates, String pageHeader, String pageFooter) {
        this.pageHeader = pageHeader;
        this.pageFooter = pageFooter;
        this.startSheet(this.sheetIndex);
        this.ouputColumns(coordinates);
        ++this.sheetIndex;
    }

    @Override
    public void endSheet(String orientaion) {
        this.endTable();
        this.declareWorkSheetOptions(this.orientation, this.pageHeader, this.pageFooter);
        this.closeSheet();
    }

    @Override
    public void start(IReportContent report, Map<StyleEntry, Integer> styles, HashMap<String, BookmarkDef> bookmarkList) {
        this.writeDeclarations();
        this.writeDocumentProperties(report);
        this.declareStyles(styles);
        this.outputBookmarks(bookmarkList);
    }

    private void outputBookmarks(HashMap<String, BookmarkDef> bookmarkList) {
        if (!bookmarkList.isEmpty()) {
            this.writer.openTag("Names");
            Set<Map.Entry<String, BookmarkDef>> bookmarkEntry = bookmarkList.entrySet();
            for (Map.Entry<String, BookmarkDef> bookmark : bookmarkEntry) {
                this.defineNames(bookmark);
            }
            this.writer.closeTag("Names");
        }
    }

    @Override
    public void end() {
        this.writer.closeTag("Workbook");
        this.close();
    }

    public void close() {
        this.writer.endWriter();
        this.writer.close();
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    static class XLSEncodeUtil
    extends XMLEncodeUtil {
        protected static final char[] XLS_TEXT_ENCODE = new char[]{'&', '<', '\r', '\n'};

        XLSEncodeUtil() {
        }

        static String encodeXLSText(String s) {
            char[] chars = s.toCharArray();
            int length = chars.length;
            int index = XLSEncodeUtil.testEscape((char[])chars, (char[])XLS_TEXT_ENCODE);
            if (index >= length) {
                return s;
            }
            StringBuilder sb = new StringBuilder(2 * length);
            sb.append(chars, 0, index);
            while (index < length) {
                char c;
                if (Character.isHighSurrogate(c = chars[index++])) {
                    index += XLSEncodeUtil.decodeSurrogate((char)c, (char[])chars, (int)index, (StringBuilder)sb);
                    continue;
                }
                if (XLSEncodeUtil.isValidCodePoint((int)c)) {
                    if (c == '&') {
                        sb.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        sb.append("&lt;");
                        continue;
                    }
                    if (c == '\r') {
                        char nc;
                        if (index < length && (nc = chars[index]) == '\n') {
                            ++index;
                        }
                        sb.append("&#10;");
                        continue;
                    }
                    if (c == '\n') {
                        sb.append("&#10;");
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                logger.log(Level.WARNING, "Invalid XML character:0x{0}", c);
            }
            return sb.toString();
        }
    }

    public class XMLWriterXLS
    extends XMLWriter {
        public PrintWriter getPrint() {
            return this.printWriter;
        }

        protected String encodeText(String text) {
            return XLSEncodeUtil.encodeXLSText(text);
        }
    }
}

