/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;
import org.eclipse.birt.report.engine.layout.emitter.Image;

public class ImageData
extends SheetData {
    private int rowNo;
    private int colNo;
    private double height;
    private double width;
    private String altText;
    private String imageUrl;
    private byte[] imageData;
    private Image imageInfo;

    public ImageData(IImageContent image, StyleEntry style, int datatype, Image imageInfo, XlsContainer currentContainer) {
        this.style = style;
        this.datatype = datatype;
        this.height = (double)imageInfo.getHeight() * ExcelUtil.PX_PT;
        double imageWidth = (double)imageInfo.getWidth() * ExcelUtil.PX_PT;
        this.width = Math.min((double)currentContainer.getSizeInfo().getWidth(), imageWidth);
        this.altText = image.getAltText();
        this.imageUrl = image.getURI();
        this.imageData = imageInfo.getData();
        this.container = currentContainer;
        this.rowSpanInDesign = 0;
        this.imageInfo = imageInfo;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public String getDescription() {
        return this.altText;
    }

    public void setDescription(String description) {
        this.altText = description;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setUrl(String url) {
        this.imageUrl = url;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public int getRowno() {
        return this.rowNo;
    }

    public void setRowNo(int rowno) {
        this.rowNo = rowno;
    }

    public int getColNo() {
        return this.colNo;
    }

    public void setColNo(int colno) {
        this.colNo = colno;
    }

    public Image getImageInfo() {
        return this.imageInfo;
    }
}

