/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskAttachmentMapper {
    private IRepositoryPerson author;
    private String comment;
    private String contentType;
    private Date creationDate;
    private Boolean deprecated;
    private String description;
    private String fileName;
    private Long length;
    private Boolean patch;
    private String url;
    private String attachmentId;

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public IRepositoryPerson getAuthor() {
        return this.author;
    }

    public String getComment() {
        return this.comment;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Long getLength() {
        return this.length;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean isDeprecated() {
        return this.deprecated;
    }

    public Boolean isPatch() {
        return this.patch;
    }

    public void setAttachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public void setAuthor(IRepositoryPerson author) {
        this.author = author;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public void setPatch(Boolean patch) {
        this.patch = patch;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public static TaskAttachmentMapper createFrom(TaskAttribute taskAttribute) {
        Long value;
        Assert.isNotNull((Object)taskAttribute);
        TaskAttributeMapper mapper = taskAttribute.getTaskData().getAttributeMapper();
        TaskAttachmentMapper attachment = new TaskAttachmentMapper();
        attachment.setAttachmentId(mapper.getValue(taskAttribute));
        TaskAttribute child = taskAttribute.getMappedAttribute("task.common.attachment.author");
        if (child != null) {
            attachment.setAuthor(mapper.getRepositoryPerson(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.ctype")) != null) {
            attachment.setContentType(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.date")) != null) {
            attachment.setCreationDate(mapper.getDateValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.description")) != null) {
            attachment.setDescription(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("filename")) != null) {
            attachment.setFileName(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.deprecated")) != null) {
            attachment.setDeprecated(mapper.getBooleanValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.patch")) != null) {
            attachment.setPatch(mapper.getBooleanValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.size")) != null && (value = mapper.getLongValue(child)) != null) {
            attachment.setLength(value);
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.url")) != null) {
            attachment.setUrl(mapper.getValue(child));
        }
        return attachment;
    }

    public void applyTo(TaskAttribute taskAttribute) {
        TaskAttribute child;
        Assert.isNotNull((Object)taskAttribute);
        TaskData taskData = taskAttribute.getTaskData();
        TaskAttributeMapper mapper = taskData.getAttributeMapper();
        taskAttribute.getMetaData().defaults().setType("attachment");
        if (this.getAttachmentId() != null) {
            mapper.setValue(taskAttribute, this.getAttachmentId());
        }
        if (this.getAuthor() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.author");
            child.getMetaData().defaults().setType("person");
            mapper.setRepositoryPerson(child, this.getAuthor());
        }
        if (this.getContentType() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.ctype");
            child.getMetaData().defaults().setType("shortText");
            mapper.setValue(child, this.getContentType());
        }
        if (this.getCreationDate() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.date");
            child.getMetaData().defaults().setType("date");
            mapper.setDateValue(child, this.getCreationDate());
        }
        if (this.getDescription() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.description");
            child.getMetaData().defaults().setType("shortText");
            mapper.setValue(child, this.getDescription());
        }
        if (this.getFileName() != null) {
            child = taskAttribute.createMappedAttribute("filename");
            child.getMetaData().defaults().setType("shortText");
            mapper.setValue(child, this.getFileName());
        }
        if (this.isDeprecated() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.deprecated");
            child.getMetaData().defaults().setType("boolean");
            mapper.setBooleanValue(child, this.isDeprecated());
        }
        if (this.isPatch() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.patch");
            child.getMetaData().defaults().setType("boolean");
            mapper.setBooleanValue(child, this.isPatch());
        }
        if (this.getLength() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.size");
            mapper.setLongValue(child, this.getLength());
        }
        if (this.getUrl() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.url");
            child.getMetaData().defaults().setType("url");
            mapper.setValue(child, this.getUrl());
        }
    }

    public void applyTo(ITaskAttachment taskAttachment) {
        Assert.isNotNull((Object)taskAttachment);
        if (this.getAuthor() != null) {
            taskAttachment.setAuthor(this.getAuthor());
        }
        if (this.getContentType() != null) {
            taskAttachment.setContentType(this.getContentType());
        }
        if (this.getCreationDate() != null) {
            taskAttachment.setCreationDate(this.getCreationDate());
        }
        if (this.getDescription() != null) {
            taskAttachment.setDescription(this.getDescription());
        }
        if (this.getFileName() != null) {
            taskAttachment.setFileName(this.getFileName());
        }
        if (this.isDeprecated() != null) {
            taskAttachment.setDeprecated(this.isDeprecated());
        }
        if (this.isPatch() != null) {
            taskAttachment.setPatch(this.isPatch());
        }
        if (this.getLength() != null) {
            taskAttachment.setLength(this.getLength());
        }
        if (this.url != null) {
            taskAttachment.setUrl(this.getUrl());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TaskAttachmentMapper)) {
            return false;
        }
        TaskAttachmentMapper other = (TaskAttachmentMapper)obj;
        if (other.attachmentId != null && this.attachmentId != null && !other.attachmentId.equals(this.attachmentId)) {
            return false;
        }
        if (other.deprecated != null && this.deprecated != null && other.deprecated != this.deprecated) {
            return false;
        }
        if (other.patch != null && this.patch != null && other.patch != this.patch) {
            return false;
        }
        if (other.description != null && this.description != null && !other.description.equals(this.description)) {
            return false;
        }
        if (other.contentType != null && this.contentType != null && !other.contentType.equals(this.contentType)) {
            return false;
        }
        return other.fileName == null || this.fileName == null || other.fileName.equals(this.fileName);
    }
}

