/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenRepositoryTaskJob
extends Job {
    private final String repositoryUrl;
    private final String repositoryKind;
    private final String taskId;
    private final String taskUrl;
    private ITask task;

    public OpenRepositoryTaskJob(String repositoryKind, String repositoryUrl, String taskId, String taskUrl, IWorkbenchPage page) {
        super(MessageFormat.format(Messages.OpenRepositoryTaskJob_Opening_repository_task_X, taskId));
        this.repositoryKind = repositoryKind;
        this.taskId = taskId;
        this.repositoryUrl = repositoryUrl;
        this.taskUrl = taskUrl;
    }

    public ITask getTask() {
        return this.task;
    }

    public IStatus run(IProgressMonitor monitor) {
        block7: {
            monitor.beginTask(Messages.OpenRepositoryTaskJob_Opening_Remote_Task, 10);
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository(this.repositoryKind, this.repositoryUrl);
            if (repository == null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)Messages.OpenRepositoryTaskJob_Repository_Not_Found, (String)(String.valueOf(MessageFormat.format(Messages.OpenRepositoryTaskJob_Could_not_find_repository_configuration_for_X, OpenRepositoryTaskJob.this.repositoryUrl)) + "\n" + MessageFormat.format(Messages.OpenRepositoryTaskJob_Please_set_up_repository_via_X, Messages.TasksUiPlugin_Task_Repositories)));
                        TasksUiUtil.openUrl(OpenRepositoryTaskJob.this.taskUrl);
                    }
                });
                return Status.OK_STATUS;
            }
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.repositoryKind);
            try {
                try {
                    TaskData taskData = connector.getTaskData(repository, this.taskId, monitor);
                    if (taskData != null) {
                        this.task = TasksUi.getRepositoryModel().createTask(repository, taskData.getTaskId());
                        TasksUiPlugin.getTaskDataManager().putUpdatedTaskData(this.task, taskData, true);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                TasksUiUtil.openTask(OpenRepositoryTaskJob.this.task);
                            }
                        });
                        break block7;
                    }
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            TasksUiUtil.openUrl(OpenRepositoryTaskJob.this.taskUrl);
                        }
                    });
                }
                catch (CoreException e) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            TasksUiInternal.displayStatus(Messages.OpenRepositoryTaskJob_Unable_to_open_task, e.getStatus());
                        }
                    });
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }
}

