/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchHitCollector;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class ShowInSearchViewAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.open.browser";

    public ShowInSearchViewAction() {
        super(Messages.ShowInSearchViewAction_Open_in_Search_Label);
        this.setId(ID);
    }

    public void run() {
        if (super.getStructuredSelection() != null) {
            Iterator iter = super.getStructuredSelection().iterator();
            while (iter.hasNext()) {
                this.runWithSelection(iter.next());
            }
        }
    }

    private void runWithSelection(Object selectedObject) {
        if (selectedObject instanceof IRepositoryQuery) {
            IRepositoryQuery query = (IRepositoryQuery)selectedObject;
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(query.getConnectorKind());
            TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(query.getConnectorKind(), query.getRepositoryUrl());
            if (connector != null) {
                SearchHitCollector collector = new SearchHitCollector(TasksUiInternal.getTaskList(), taskRepository, query);
                NewSearchUI.runQueryInBackground((ISearchQuery)collector);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof IRepositoryQuery;
    }
}

