/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.ui.editors.CategoryEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.EditorPart;

public class CategoryEditor
extends EditorPart {
    public static final String ID_EDITOR = "org.eclipse.mylyn.tasks.ui.editors.category";
    private Text url;
    private CategoryEditorInput input = null;
    private boolean isDirty = false;
    private Text description = null;

    public void doSave(IProgressMonitor monitor) {
        this.input.setCategoryName(this.description.getText());
        this.input.setUrl(this.url.getText());
        this.isDirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.input = (CategoryEditorInput)input;
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getToolTipText());
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm sform = toolkit.createScrolledForm(parent);
        sform.getBody().setLayout((Layout)new TableWrapLayout());
        Composite editorComposite = sform.getBody();
        this.createSummarySection(editorComposite, toolkit);
    }

    public void setFocus() {
    }

    private void createSummarySection(Composite parent, FormToolkit toolkit) {
        Section summarySection = toolkit.createSection(parent, 256);
        summarySection.setText(Messages.CategoryEditor_Category_Summary);
        summarySection.setLayout((Layout)new TableWrapLayout());
        summarySection.setLayoutData((Object)new TableWrapData(256));
        Composite summaryContainer = toolkit.createComposite((Composite)summarySection);
        summarySection.setClient((Control)summaryContainer);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        summaryContainer.setLayout((Layout)layout);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CategoryEditor.this.markDirty();
            }
        };
        toolkit.createLabel(summaryContainer, Messages.CategoryEditor_Description_, 0);
        this.description = toolkit.createText(summaryContainer, this.input.getCategoryName(), 0x800000);
        this.description.setLayoutData((Object)new TableWrapData(256));
        this.description.setData((Object)"FormWidgetFactory.drawBorder");
        this.description.addModifyListener(modifyListener);
        toolkit.createLabel(summaryContainer, Messages.CategoryEditor_URL_, 0);
        this.url = toolkit.createText(summaryContainer, this.input.getUrl(), 0x800000);
        this.url.setLayoutData((Object)new TableWrapData(256, 16));
        this.url.addModifyListener(modifyListener);
        toolkit.paintBordersFor(summaryContainer);
    }

    private void markDirty() {
        this.isDirty = true;
        this.firePropertyChange(257);
    }
}

