/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.ResourceAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.dialog.MoveResourceDialog;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class MoveResourceAction
extends ResourceAction {
    public MoveResourceAction(LibraryExplorerTreeViewPage page) {
        super(Messages.getString((String)"MoveLibraryAction.Text"), page);
        this.setId(ActionFactory.MOVE.getId());
    }

    public boolean isEnabled() {
        return this.canModifySelectedResources();
    }

    public void run() {
        Object[] selected;
        Collection<File> files = null;
        try {
            files = this.getSelectedFiles();
        }
        catch (IOException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (files == null || files.isEmpty()) {
            return;
        }
        MoveResourceDialog dialog = new MoveResourceDialog();
        if (dialog.open() == 0 && (selected = dialog.getResult()) != null && selected.length == 1) {
            try {
                ResourceEntry entry = (ResourceEntry)selected[0];
                Path targetPath = new Path(MoveResourceAction.convertToFile(entry.getURL()).getAbsolutePath());
                for (File file : files) {
                    this.moveFile(file, targetPath.append(file.getName()).toFile());
                }
            }
            catch (IOException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (InterruptedException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private void moveFile(File srcFile, File targetFile) throws InvocationTargetException, InterruptedException {
        if (targetFile.exists()) {
            if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString((String)"MoveResourceAction.Dialog.Title"), (String)Messages.getString((String)"MoveResourceAction.Dialog.Message"))) {
                return;
            }
            new ProgressMonitorDialog(this.getShell()).run(true, true, this.createDeleteRunnable(Arrays.asList(targetFile)));
        }
        new ProgressMonitorDialog(this.getShell()).run(true, true, this.createRenameFileRunnable(srcFile, targetFile));
    }
}

