/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationHelper;

public class QuerySpecHelper {
    QuerySpecificationHelper m_specFactoryHelper;

    public QuerySpecHelper(String odaDataSourceId, String odaDataSetId) {
        ExtensionContributor[] contributors = null;
        try {
            contributors = ResultExtensionExplorer.getInstance().getContributorsOfDataSet(odaDataSourceId, odaDataSetId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (OdaException odaException) {}
        ExtensionContributor resultSetContributor = null;
        if (contributors != null && contributors.length > 0) {
            resultSetContributor = contributors[0];
        }
        this.m_specFactoryHelper = new QuerySpecificationHelper(resultSetContributor);
    }

    public QuerySpecHelper(String dynamicResultSetExtnId) {
        this.m_specFactoryHelper = new QuerySpecificationHelper(dynamicResultSetExtnId);
    }

    public QuerySpecificationHelper getFactoryHelper() {
        return this.m_specFactoryHelper;
    }

    public static void setParameterValue(QuerySpecification querySpec, ParameterHint paramHint, Object inputValue) throws DataException {
        boolean hasParamPos;
        if (querySpec == null || paramHint == null) {
            return;
        }
        boolean hasNativeName = PreparedStatement.hasValue(paramHint.getNativeName());
        boolean bl = hasParamPos = paramHint.getPosition() > 0;
        if (!paramHint.isInputMode() || !hasNativeName && !hasParamPos) {
            throw new DataException("ParameterHint.", (Throwable)new IllegalArgumentException(), paramHint);
        }
        QuerySpecification.ParameterIdentifier paramIdentifier = null;
        if (hasNativeName) {
            QuerySpecification.ParameterIdentifier parameterIdentifier;
            if (hasParamPos) {
                QuerySpecification querySpecification = querySpec;
                querySpecification.getClass();
                parameterIdentifier = new QuerySpecification.ParameterIdentifier(querySpecification, paramHint.getNativeName(), paramHint.getPosition());
            } else {
                QuerySpecification querySpecification = querySpec;
                querySpecification.getClass();
                parameterIdentifier = new QuerySpecification.ParameterIdentifier(querySpecification, paramHint.getNativeName());
            }
            paramIdentifier = parameterIdentifier;
        } else {
            QuerySpecification querySpecification = querySpec;
            querySpecification.getClass();
            paramIdentifier = new QuerySpecification.ParameterIdentifier(querySpecification, paramHint.getPosition());
        }
        querySpec.setParameterValue(paramIdentifier, inputValue);
    }
}

