/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMirroredDefinition;
import org.eclipse.birt.data.engine.olap.driver.DimensionAxis;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;

public class RowDataAccessorService {
    private int fetchLimit = -1;
    private DimensionAxis[] dimAxis;
    private BirtEdgeView view;

    public RowDataAccessorService(DimensionAxis[] dimAxis, BirtEdgeView view) {
        this.dimAxis = dimAxis;
        this.view = view;
    }

    public DimensionAxis[] getDimensionAxis() {
        return this.dimAxis;
    }

    public int getMirrorStartPosition() {
        int index = 0;
        if (this.view.getMirroredDefinition() != null) {
            IMirroredDefinition mirror = this.view.getMirroredDefinition();
            ILevelDefinition[] levelArray = CubeQueryDefinitionUtil.getLevelsOnEdge(this.view.getEdgeDefintion());
            int i = 0;
            while (i < levelArray.length) {
                if (levelArray[i].equals(mirror.getMirrorStartingLevel())) {
                    if (this.view.getPageEndingIndex() >= 0) {
                        index = i + this.view.getPageEndingIndex() + 1;
                        break;
                    }
                    index = i;
                    break;
                }
                ++i;
            }
            return index;
        }
        return index;
    }

    public boolean isBreakHierarchy() {
        if (this.view.getMirroredDefinition() != null) {
            return this.view.getMirroredDefinition().isBreakHierarchy();
        }
        return false;
    }

    public int getPagePosition() {
        return this.view.getPageEndingIndex();
    }

    public int getFetchSize() {
        return this.fetchLimit;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchLimit = fetchSize;
    }
}

