/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class ChartInXTabStatusManager {
    private static Map<AggregationCellHandle, Boolean> mapGrandItems = new HashMap<AggregationCellHandle, Boolean>();

    public static void updateGrandItemStatus(AggregationCellHandle detailCell) throws BirtException {
        if (detailCell != null) {
            List contents;
            AggregationCellHandle grandCell = ChartXTabUIUtil.getGrandTotalAggregationCell(detailCell, detailCell.getCrosstab().getMeasureDirection().equals("horizontal"));
            if (grandCell != null && (contents = grandCell.getContents()).size() > 0) {
                for (Object content : contents) {
                    if (!(content instanceof DataItemHandle)) continue;
                    mapGrandItems.put(detailCell, true);
                    return;
                }
            }
            mapGrandItems.put(detailCell, false);
        }
    }

    public static boolean hasGrandItem(AggregationCellHandle detailCell) {
        if (mapGrandItems.containsKey(detailCell)) {
            return mapGrandItems.get(detailCell);
        }
        return false;
    }

    public static boolean hasGrandItem(ExtendedItemHandle chartHandle) throws BirtException {
        if (ChartXTabUtil.isPlotChart((DesignElementHandle)chartHandle)) {
            return ChartInXTabStatusManager.hasGrandItem(ChartXTabUtil.getXtabContainerCell((DesignElementHandle)chartHandle));
        }
        return false;
    }
}

