/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.DataRowExpressionEvaluatorAdapter;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.reportitem.AbstractChartBaseQueryGenerator;
import org.eclipse.birt.chart.reportitem.BIRTCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.BaseGroupedQueryResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.ChartBaseQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartCubeQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.SharedCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIActivator;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ColumnBindingInfo;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DummyEngineTask;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.re.CrosstabQueryUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.util.CubeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDataServiceProvider
implements IDataServiceProvider {
    private ExtendedItemHandle itemHandle;
    private ChartWizardContext context;
    private final ShareBindingQueryHelper fShareBindingQueryHelper = new ShareBindingQueryHelper();
    static final String OPTION_NONE = Messages.getString("ReportDataServiceProvider.Option.None");
    private boolean isErrorFound = false;
    private IProject project = null;

    public ReportDataServiceProvider(ExtendedItemHandle itemHandle) {
        this.itemHandle = itemHandle;
        this.project = UIUtil.getCurrentProject();
    }

    public void setWizardContext(ChartWizardContext context) {
        this.context = context;
    }

    ModuleHandle getReportDesignHandle() {
        return this.itemHandle.getModuleHandle();
    }

    String[] getAllDataSets() {
        List list = this.getReportDesignHandle().getVisibleDataSets();
        String[] names = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            names[i] = ((DataSetHandle)list.get(i)).getQualifiedName();
            ++i;
        }
        return names;
    }

    String[] getAllDataCubes() {
        List list = this.getReportDesignHandle().getVisibleCubes();
        String[] names = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            names[i] = ((CubeHandle)list.get(i)).getQualifiedName();
            ++i;
        }
        return names;
    }

    String getDataCube() {
        CubeHandle cube = this.itemHandle.getCube();
        if (cube == null) {
            return null;
        }
        return cube.getQualifiedName();
    }

    void setDataCube(String cubeName) {
        try {
            if (this.itemHandle.getDataBindingType() == 2) {
                this.itemHandle.setDataBindingReference(null);
            }
            this.itemHandle.setDataSet(null);
            if (cubeName == null) {
                this.itemHandle.setCube(null);
                this.clearBindings();
            } else if (!cubeName.equals(this.getDataCube())) {
                CubeHandle cubeHandle = this.getReportDesignHandle().findCube(cubeName);
                this.itemHandle.setCube(cubeHandle);
                this.clearBindings();
                this.generateBindings(this.generateComputedColumns(cubeHandle));
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setDataCube");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setDataCube", (String)e.getLocalizedMessage());
        }
    }

    public final String[] getPreviewHeader() throws ChartException {
        Iterator iterator = ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)this.itemHandle);
        ArrayList<String> list = new ArrayList<String>();
        boolean bInheritColumnsOnly = this.isInheritColumnsOnly();
        while (iterator.hasNext()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)iterator.next();
            if (bInheritColumnsOnly && binding.getAggregateFunction() != null) continue;
            list.add(binding.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    public final List<Object[]> getPreviewData() throws ChartException {
        if (this.isSharedBinding() || this.isInheritColumnsGroups()) {
            return this.fShareBindingQueryHelper.getPreviewRowData(this.getPreviewHeadersInfo(), -1, true);
        }
        return this.getPreviewRowData(this.getPreviewHeader(true), -1, true);
    }

    public final ColumnBindingInfo[] getPreviewHeadersInfo() throws ChartException {
        Iterator iterator = ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)this.itemHandle);
        if (iterator == null) {
            return new ColumnBindingInfo[0];
        }
        ArrayList<ComputedColumnHandle> columnList = new ArrayList<ComputedColumnHandle>();
        boolean bInheritColumnsOnly = this.isInheritColumnsOnly();
        while (iterator.hasNext()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)iterator.next();
            if (bInheritColumnsOnly && binding.getAggregateFunction() != null) continue;
            columnList.add(binding);
        }
        if (columnList.size() == 0) {
            return new ColumnBindingInfo[0];
        }
        ColumnBindingInfo[] columnHeaders = null;
        if (this.isTableSharedBinding() || this.isInheritColumnsGroups()) {
            columnHeaders = this.fShareBindingQueryHelper.getPreviewHeadersInfo(columnList);
        } else {
            columnHeaders = new ColumnBindingInfo[columnList.size()];
            int i = 0;
            while (i < columnHeaders.length) {
                ComputedColumnHandle cch = (ComputedColumnHandle)columnList.get(i);
                columnHeaders[i] = new ColumnBindingInfo(cch.getName(), cch.getExpression(), null, null, (Object)cch);
                ++i;
            }
        }
        ArrayList<ColumnBindingInfo> columnsSet = new ArrayList<ColumnBindingInfo>();
        int i = columnHeaders.length - 1;
        while (i >= 0) {
            columnsSet.add(columnHeaders[i]);
            --i;
        }
        Collections.sort(columnsSet, new ColumnNameComprator());
        columnHeaders = columnsSet.toArray(new ColumnBindingInfo[0]);
        return columnHeaders;
    }

    private String[] getPreviewHeader(boolean isExpression) throws ChartException {
        ColumnBindingInfo[] cbis = this.getPreviewHeadersInfo();
        String[] exps = new String[cbis.length];
        int i = 0;
        ColumnBindingInfo[] columnBindingInfoArray = cbis;
        int n = cbis.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnBindingInfo cbi = columnBindingInfoArray[n2];
            exps[i] = isExpression ? ExpressionUtil.createJSRowExpression((String)cbi.getName()) : cbi.getName();
            ++i;
            ++n2;
        }
        return exps;
    }

    protected final List<Object[]> getPreviewRowData(String[] columnExpression, int rowCount, boolean isStringType) throws ChartException {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader parentLoader = oldContextLoader;
        if (parentLoader == null) {
            parentLoader = this.getClass().getClassLoader();
        }
        ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parentLoader, (ModuleHandle)this.itemHandle.getModuleHandle());
        Thread.currentThread().setContextClassLoader(newContextLoader);
        ReportEngine engine = null;
        DummyEngineTask engineTask = null;
        DataRequestSession session = null;
        try {
            try {
                int maxRow = this.getMaxRow();
                if (this.isReportDesignHandle()) {
                    engine = (ReportEngine)new ReportEngineFactory().createReportEngine(new EngineConfig());
                    engineTask = new DummyEngineTask(engine, new ReportEngineHelper(engine).openReportDesign((ReportDesignHandle)this.itemHandle.getModuleHandle()), this.itemHandle.getModuleHandle());
                    session = this.prepareDataRequestSession((EngineTask)engineTask, maxRow, false);
                    engineTask.run();
                } else {
                    session = this.prepareDataRequestSession(maxRow, false);
                }
                QueryDefinition queryDefn = new QueryDefinition();
                queryDefn.setMaxRows(maxRow);
                queryDefn.setDataSetName(this.getDataSetFromHandle().getQualifiedName());
                int i = 0;
                while (i < columnExpression.length) {
                    queryDefn.addResultSetExpression(columnExpression[i], (IBaseExpression)new ScriptExpression(columnExpression[i]));
                    ++i;
                }
                this.handleGroup(queryDefn, this.itemHandle);
                this.resetParametersForDataPreview(this.getDataSetFromHandle(), queryDefn);
                Iterator<FilterConditionHandle> filtersIterator = this.getFiltersIterator();
                IQueryResults actualResultSet = session.executeQuery((IQueryDefinition)queryDefn, null, filtersIterator, ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)this.itemHandle, (boolean)true));
                if (actualResultSet != null) {
                    String[] expressions = columnExpression;
                    int columnCount = expressions.length;
                    IResultIterator iter = actualResultSet.getResultIterator();
                    while (iter.next()) {
                        int n;
                        Object[] record;
                        if (isStringType) {
                            record = new String[columnCount];
                            n = 0;
                            while (n < columnCount) {
                                record[n] = DataTypeUtil.toString((Object)iter.getValue(expressions[n]));
                                ++n;
                            }
                            dataList.add(record);
                            continue;
                        }
                        record = new Object[columnCount];
                        n = 0;
                        while (n < columnCount) {
                            record[n] = iter.getValue(expressions[n]);
                            ++n;
                        }
                        dataList.add(record);
                    }
                    actualResultSet.close();
                }
            }
            catch (BirtException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextLoader);
            if (engine == null && session != null) {
                session.shutdown();
            }
            if (engineTask != null) {
                engineTask.close();
            }
            if (engine != null) {
                engine.destroy();
            }
        }
        return dataList;
    }

    private boolean isReportDesignHandle() {
        return this.itemHandle.getModuleHandle() instanceof ReportDesignHandle;
    }

    private void handleGroup(QueryDefinition queryDefn, ExtendedItemHandle reportItemHandle) {
        ReportItemHandle handle = ChartReportItemUtil.getBindingHolder((DesignElementHandle)reportItemHandle);
        if (handle instanceof ListingHandle) {
            SlotHandle groups = ((ListingHandle)handle).getGroups();
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                ChartBaseQueryHelper.handleGroup((GroupHandle)((GroupHandle)iter.next()), (IBaseQueryDefinition)queryDefn);
            }
        }
    }

    private QueryDefinition resetParametersForDataPreview(DataSetHandle dataSetHandle, QueryDefinition queryDefn) {
        Iterator iterParams = dataSetHandle.parametersIterator();
        LinkedHashMap<String, DataSetParameterHandle> dsphMap = new LinkedHashMap<String, DataSetParameterHandle>();
        while (iterParams.hasNext()) {
            DataSetParameterHandle dsph = (DataSetParameterHandle)iterParams.next();
            dsphMap.put(dsph.getName(), dsph);
        }
        iterParams = this.itemHandle.getPropertyHandle("paramBindings").iterator();
        LinkedHashMap<String, ParamBindingHandle> pbhMap = new LinkedHashMap<String, ParamBindingHandle>();
        while (iterParams.hasNext()) {
            ParamBindingHandle paramBindingHandle = (ParamBindingHandle)iterParams.next();
            pbhMap.put(paramBindingHandle.getParamName(), paramBindingHandle);
        }
        Object[] names = pbhMap.keySet().toArray();
        int i = 0;
        while (i < names.length) {
            DataSetParameterHandle dsph = (DataSetParameterHandle)dsphMap.get(names[i]);
            ScriptExpression se = null;
            String expr = ((ParamBindingHandle)pbhMap.get(names[i])).getExpression();
            se = dsph.getDefaultValue() != null && (expr == null || expr.indexOf("row[") >= 0 || expr.indexOf("row.") >= 0) ? new ScriptExpression(dsph.getDefaultValue()) : new ScriptExpression(expr);
            InputParameterBinding ipb = new InputParameterBinding((String)names[i], (IBaseExpression)se);
            queryDefn.addInputParamBinding(ipb);
            ++i;
        }
        return queryDefn;
    }

    String getBoundDataSet() {
        if (this.itemHandle.getDataSet() == null) {
            return null;
        }
        return this.itemHandle.getDataSet().getQualifiedName();
    }

    boolean isInheritanceOnly() {
        return this.isInMultiView() || this.isInXTabMeasureCell();
    }

    boolean isInMultiView() {
        return this.itemHandle.getContainer() instanceof MultiViewsHandle;
    }

    String getReportDataSet() {
        List list = DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer());
        if (list.size() > 0) {
            return ((DataSetHandle)list.get(0)).getQualifiedName();
        }
        return null;
    }

    void setDataSet(String datasetName) {
        try {
            boolean isPreviousDataBindingReference = false;
            if (this.itemHandle.getDataBindingType() == 2) {
                isPreviousDataBindingReference = true;
                this.itemHandle.setDataBindingReference(null);
            }
            this.itemHandle.setCube(null);
            if (datasetName == null) {
                if (this.getBoundDataSet() != null) {
                    this.clearBindings();
                }
                this.itemHandle.setDataSet(null);
            } else {
                DataSetHandle dataset = this.getReportDesignHandle().findDataSet(datasetName);
                if (isPreviousDataBindingReference || this.itemHandle.getDataSet() != dataset) {
                    this.itemHandle.setDataSet(dataset);
                    this.clearBindings();
                    this.generateBindings(this.generateComputedColumns(dataset));
                }
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setDataSet");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setDataSet", (String)e.getLocalizedMessage());
        }
    }

    private void clearBindings() throws SemanticException {
        this.clearProperty(this.itemHandle.getPropertyHandle("paramBindings"));
        this.clearProperty(this.itemHandle.getPropertyHandle("filter"));
        this.clearProperty(this.itemHandle.getColumnBindings());
    }

    private void clearProperty(PropertyHandle property) throws SemanticException {
        if (property != null) {
            property.clearValue();
        }
    }

    private Iterator<?> getPropertyIterator(PropertyHandle property) {
        if (property != null) {
            return property.iterator();
        }
        return null;
    }

    private void generateBindings(List<ComputedColumn> columnList) throws SemanticException {
        if (columnList.size() > 0) {
            Iterator<ComputedColumn> iter = columnList.iterator();
            while (iter.hasNext()) {
                DEUtil.addColumn((DesignElementHandle)this.itemHandle, (ComputedColumn)iter.next(), (boolean)false);
            }
        }
    }

    private List<ComputedColumn> generateComputedColumns(DataSetHandle dataSetHandle) throws SemanticException {
        if (dataSetHandle != null) {
            List resultSetColumnList = DataUtil.getColumnList((DataSetHandle)dataSetHandle);
            ArrayList<ComputedColumn> columnList = new ArrayList<ComputedColumn>();
            for (ResultSetColumnHandle resultSetColumn : resultSetColumnList) {
                ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)this.itemHandle, (String)resultSetColumn.getColumnName());
                column.setDataType(resultSetColumn.getDataType());
                column.setExpression(DEUtil.getExpression((Object)resultSetColumn));
                columnList.add(column);
            }
            return columnList;
        }
        return Collections.emptyList();
    }

    private List<ComputedColumn> generateComputedColumns(CubeHandle cubeHandle) throws SemanticException {
        if (cubeHandle != null) {
            ComputedColumn column;
            ArrayList<ComputedColumn> columnList = new ArrayList<ComputedColumn>();
            for (LevelHandle levelHandle : ChartXTabUtil.getAllLevels((CubeHandle)cubeHandle)) {
                column = StructureFactory.newComputedColumn((DesignElementHandle)this.itemHandle, (String)ChartXTabUtil.createLevelBindingName((LevelHandle)levelHandle));
                column.setDataType(levelHandle.getDataType());
                column.setExpression(ChartXTabUtil.createDimensionExpression((LevelHandle)levelHandle));
                columnList.add(column);
            }
            for (MeasureHandle measureHandle : ChartXTabUtil.getAllMeasures((CubeHandle)cubeHandle)) {
                column = StructureFactory.newComputedColumn((DesignElementHandle)this.itemHandle, (String)ChartXTabUtil.createMeasureBindingName((MeasureHandle)measureHandle));
                column.setDataType(measureHandle.getDataType());
                column.setExpression(ExpressionUtil.createJSMeasureExpression((String)measureHandle.getName()));
                column.setAggregateFunction(measureHandle.getFunction());
                columnList.add(column);
            }
            return columnList;
        }
        return Collections.emptyList();
    }

    protected DataSetHandle getDataSetFromHandle() {
        if (this.itemHandle.getDataSet() != null) {
            return this.itemHandle.getDataSet();
        }
        List datasetList = DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer());
        if (datasetList.size() > 0) {
            return (DataSetHandle)datasetList.get(0);
        }
        return null;
    }

    protected void processQueryDefinition(QueryDefinition queryDefn) {
    }

    private StyleHandle[] getAllStyleHandles() {
        List sLst = this.getReportDesignHandle().getAllStyles();
        StyleHandle[] list = sLst.toArray(new StyleHandle[sLst.size()]);
        Arrays.sort(list, new Comparator<StyleHandle>(){
            Collator collator = Collator.getInstance((ULocale)ULocale.getDefault());

            @Override
            public int compare(StyleHandle s1, StyleHandle s2) {
                return this.collator.compare(s1.getDisplayLabel(), s2.getDisplayLabel());
            }
        });
        return list;
    }

    public String[] getAllStyles() {
        StyleHandle[] handles = this.getAllStyleHandles();
        String[] names = new String[handles.length];
        int i = 0;
        while (i < names.length) {
            names[i] = handles[i].getQualifiedName();
            ++i;
        }
        names = this.filterPreStyles(names);
        return names;
    }

    private String[] filterPreStyles(String[] items) {
        String[] newItems = items;
        if (items == null) {
            newItems = new String[]{};
        }
        List preStyles = new DesignEngine(new DesignConfig()).getMetaData().getPredefinedStyles();
        ArrayList<String> preStyleNames = new ArrayList<String>();
        int i = 0;
        while (i < preStyles.size()) {
            preStyleNames.add(((IPredefinedStyle)preStyles.get(i)).getName());
            ++i;
        }
        ArrayList<String> sytleNames = new ArrayList<String>();
        int i2 = 0;
        while (i2 < newItems.length) {
            if (preStyleNames.indexOf(newItems[i2]) == -1) {
                sytleNames.add(newItems[i2]);
            }
            ++i2;
        }
        return sytleNames.toArray(new String[0]);
    }

    public String[] getAllStyleDisplayNames() {
        List<String> styles = Arrays.asList(this.getAllStyles());
        StyleHandle[] handles = this.getAllStyleHandles();
        String[] names = new String[styles.size()];
        int i = 0;
        int j = 0;
        while (i < handles.length) {
            if (styles.contains(handles[i].getQualifiedName())) {
                names[j++] = handles[i].getDisplayLabel();
            }
            ++i;
        }
        return names;
    }

    public String getCurrentStyle() {
        if (this.itemHandle.getStyle() == null) {
            return null;
        }
        return this.itemHandle.getStyle().getQualifiedName();
    }

    public void setStyle(String styleName) {
        try {
            if (styleName == null) {
                this.itemHandle.setStyle(null);
            } else {
                this.itemHandle.setStyle(this.getStyle(styleName));
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setStyle");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setStyle", (String)e.getLocalizedMessage());
        }
    }

    private SharedStyleHandle getStyle(String styleName) {
        return this.getReportDesignHandle().findStyle(styleName);
    }

    public final Object[] getDataForColumns(String[] sExpressions, int iMaxRecords, boolean byRow) throws ChartException {
        return null;
    }

    private int getMaxRow() {
        return PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ChartReportItemUIActivator.getDefault(), this.project).getInt("max_row");
    }

    public boolean isLivePreviewEnabled() {
        return !this.isErrorFound && PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ChartReportItemUIActivator.getDefault(), this.project).getBoolean("enable_live") && ChartReportItemUtil.getBindingHolder((DesignElementHandle)this.itemHandle) != null;
    }

    boolean isInvokingSupported() {
        if (this.isSharedBinding() || this.isInMultiView()) {
            return false;
        }
        ReportItemHandle container = DEUtil.getBindingHolder((DesignElementHandle)this.itemHandle);
        if (container != null) {
            return container.getDataBindingReference() == null;
        }
        return true;
    }

    public DataType getDataType(String expression) {
        if (expression == null || expression.trim().length() == 0) {
            return null;
        }
        Object[] returnObj = this.findDataType(expression, (ReportItemHandle)this.itemHandle);
        if (((Boolean)returnObj[0]).booleanValue()) {
            return (DataType)returnObj[1];
        }
        ReportItemHandle parentHandle = DEUtil.getBindingHolder((DesignElementHandle)this.itemHandle);
        if (parentHandle != null && ((Boolean)(returnObj = this.findDataType(expression, parentHandle))[0]).booleanValue()) {
            return (DataType)returnObj[1];
        }
        try {
            NumberFormat.getInstance().parse(expression);
            return DataType.NUMERIC_LITERAL;
        }
        catch (ParseException parseException) {
            try {
                DateFormat.getInstance().parse(expression);
                return DataType.DATE_TIME_LITERAL;
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }

    private String getQueryStringForProcessing(String expression) {
        if (expression.indexOf("[\"") > 0) {
            return expression.substring(expression.indexOf("[\"") + 2, expression.indexOf("\"]"));
        }
        return null;
    }

    private Object[] findDataType(String expression, ReportItemHandle itemHandle) {
        if (ChartReportItemUtil.checkStringInExpression((String)expression)) {
            return new Object[]{true, DataType.TEXT_LITERAL};
        }
        if (!ChartReportItemUtil.isSimpleExpression((String)expression)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = false;
            return objectArray;
        }
        Object[] returnObj = new Object[2];
        returnObj[0] = Boolean.FALSE;
        String columnName = this.getQueryStringForProcessing(expression);
        Iterator iterator = ChartReportItemUtil.getAllColumnBindingsIterator((ReportItemHandle)itemHandle);
        while (iterator.hasNext()) {
            String dataType;
            ComputedColumnHandle cc = (ComputedColumnHandle)iterator.next();
            if (!cc.getName().equalsIgnoreCase(columnName) || (dataType = cc.getDataType()) == null) continue;
            if (dataType.equals("string") || dataType.equals("blob")) {
                returnObj[0] = Boolean.TRUE;
                returnObj[1] = DataType.TEXT_LITERAL;
                break;
            }
            if (dataType.equals("decimal") || dataType.equals("float") || dataType.equals("integer") || dataType.equals("boolean")) {
                returnObj[0] = Boolean.TRUE;
                returnObj[1] = DataType.NUMERIC_LITERAL;
                break;
            }
            if (dataType.equals("date-time") || dataType.equals("date") || dataType.equals("time")) {
                returnObj[0] = Boolean.TRUE;
                returnObj[1] = DataType.DATE_TIME_LITERAL;
                break;
            }
            if (!dataType.equals("any")) continue;
            returnObj[0] = Boolean.TRUE;
            returnObj[1] = null;
            break;
        }
        return returnObj;
    }

    String[] getAllReportItemReferences() {
        List referenceList = this.itemHandle.getNamedDataBindingReferenceList();
        ArrayList<String> itemsWithName = new ArrayList<String>();
        int i = 0;
        while (i < referenceList.size()) {
            String qualfiedName = ((ReportItemHandle)referenceList.get(i)).getQualifiedName();
            if (qualfiedName != null && qualfiedName.length() > 0) {
                itemsWithName.add(qualfiedName);
            }
            ++i;
        }
        return itemsWithName.toArray(new String[itemsWithName.size()]);
    }

    String getReportItemReference() {
        ReportItemHandle ref = this.itemHandle.getDataBindingReference();
        if (ref == null) {
            return null;
        }
        return ref.getQualifiedName();
    }

    void setReportItemReference(String referenceName) {
        try {
            if (referenceName == null) {
                this.itemHandle.setDataBindingReference(null);
            } else {
                this.itemHandle.setDataSet(null);
                this.itemHandle.setCube(null);
                if (!referenceName.equals(this.getReportItemReference())) {
                    this.itemHandle.setDataBindingReference((ReportItemHandle)this.getReportDesignHandle().findElement(referenceName));
                }
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setReportItemReference");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setReportItemReference", (String)e.getLocalizedMessage());
        }
    }

    public IDataRowExpressionEvaluator prepareRowExpressionEvaluator(Chart cm, List<String> columnExpression, int rowCount, boolean isStringType) throws ChartException {
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader parentLoader = oldContextLoader;
        if (parentLoader == null) {
            parentLoader = this.getClass().getClassLoader();
        }
        ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parentLoader, (ModuleHandle)this.itemHandle.getModuleHandle());
        Thread.currentThread().setContextClassLoader(newContextLoader);
        IDataRowExpressionEvaluator evaluator = null;
        DataRequestSession session = null;
        ReportEngine engine = null;
        DummyEngineTask engineTask = null;
        try {
            CubeHandle cube;
            if (this.isReportDesignHandle()) {
                engine = (ReportEngine)new ReportEngineFactory().createReportEngine(new EngineConfig());
                engineTask = new DummyEngineTask(engine, new ReportEngineHelper(engine).openReportDesign((ReportDesignHandle)this.itemHandle.getModuleHandle()), this.itemHandle.getModuleHandle());
            }
            if ((cube = ChartXTabUtil.getBindingCube((DesignElementHandle)this.itemHandle)) != null) {
                if (this.isReportDesignHandle()) {
                    session = this.prepareDataRequestSession((EngineTask)engineTask, this.getMaxRow(), true);
                    engineTask.run();
                } else {
                    session = this.prepareDataRequestSession(this.getMaxRow(), true);
                }
                evaluator = this.createCubeEvaluator(cube, session, (EngineTask)engineTask, cm);
            } else {
                if (this.isReportDesignHandle()) {
                    session = this.prepareDataRequestSession((EngineTask)engineTask, this.getMaxRow(), false);
                    engineTask.run();
                } else {
                    session = this.prepareDataRequestSession(this.getMaxRow(), false);
                }
                evaluator = this.isSharedBinding() && !ChartReportItemUtil.isOldChartUsingInternalGroup((ReportItemHandle)this.itemHandle, (Chart)cm) || this.isInheritColumnsGroups() ? (this.isSharingChart(false) ? this.createBaseEvaluator((ExtendedItemHandle)this.itemHandle.getDataBindingReference(), ChartReportItemUtil.getChartFromHandle((ExtendedItemHandle)((ExtendedItemHandle)this.itemHandle.getDataBindingReference())), columnExpression, session, (EngineTask)engineTask) : this.fShareBindingQueryHelper.createShareBindingEvaluator(cm, session, (EngineTask)engineTask)) : this.createBaseEvaluator(this.itemHandle, cm, columnExpression, session, (EngineTask)engineTask);
            }
            IDataRowExpressionEvaluator iDataRowExpressionEvaluator = evaluator;
            return iDataRowExpressionEvaluator;
        }
        catch (BirtException e) {
            if (engine == null && session != null) {
                session.shutdown();
            }
            if (engineTask != null) {
                engineTask.close();
            }
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
        }
        catch (RuntimeException e) {
            if (engine == null && session != null) {
                session.shutdown();
            }
            if (engineTask != null) {
                engineTask.close();
            }
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
        }
        finally {
            if (engine != null) {
                engine.destroy();
            }
            Thread.currentThread().setContextClassLoader(oldContextLoader);
        }
    }

    private IDataRowExpressionEvaluator createBaseEvaluator(ExtendedItemHandle handle, Chart cm, List<String> columnExpression, final DataRequestSession session, final EngineTask engineTask) throws ChartException {
        BaseQueryHelper cbqh = new BaseQueryHelper(handle, cm);
        QueryDefinition queryDefn = (QueryDefinition)cbqh.createBaseQuery(columnExpression);
        this.resetParametersForDataPreview(this.getDataSetFromHandle(), queryDefn);
        this.handleGroup(queryDefn, handle);
        this.processQueryDefinition(queryDefn);
        try {
            Iterator<FilterConditionHandle> filtersIterator = this.getFiltersIterator();
            IQueryResults actualResultSet = session.executeQuery((IQueryDefinition)queryDefn, null, filtersIterator, ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)handle, (boolean)true));
            if (actualResultSet != null) {
                if (ChartReportItemUtil.isOldChartUsingInternalGroup((ReportItemHandle)this.itemHandle, (Chart)cm)) {
                    return this.createSimpleExpressionEvaluator(actualResultSet);
                }
                return new BaseGroupedQueryResultSetEvaluator(actualResultSet.getResultIterator(), ChartReportItemUtil.isSetSummaryAggregation((Chart)cm), cm){

                    public void close() {
                        super.close();
                        if (engineTask != null) {
                            engineTask.close();
                        } else if (session != null) {
                            session.shutdown();
                        }
                    }
                };
            }
        }
        catch (BirtException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
        }
        return null;
    }

    private IDataRowExpressionEvaluator createSimpleExpressionEvaluator(IQueryResults actualResultSet) throws BirtException {
        final IResultIterator resultIterator = actualResultSet.getResultIterator();
        return new DataRowExpressionEvaluatorAdapter(){

            public Object evaluate(String expression) {
                try {
                    return resultIterator.getValue(expression);
                }
                catch (BirtException birtException) {
                    return null;
                }
            }

            public Object evaluateGlobal(String expression) {
                return this.evaluate(expression);
            }

            public boolean next() {
                try {
                    return resultIterator.next();
                }
                catch (BirtException birtException) {
                    return false;
                }
            }

            public void close() {
                try {
                    resultIterator.close();
                }
                catch (BirtException birtException) {
                    return;
                }
            }

            public boolean first() {
                try {
                    return resultIterator.next();
                }
                catch (BirtException birtException) {
                    return false;
                }
            }
        };
    }

    private Iterator<FilterConditionHandle> getFiltersIterator() {
        FilterConditionHandle filter;
        Iterator filterIterator;
        ArrayList<FilterConditionHandle> filterList = new ArrayList<FilterConditionHandle>();
        PropertyHandle ph = null;
        if (this.getBoundDataSet() == null && this.getReportItemReference() == null && (ph = ChartReportItemUtil.getBindingHolder((DesignElementHandle)this.itemHandle).getPropertyHandle("filter")) != null && (filterIterator = ph.iterator()) != null) {
            while (filterIterator.hasNext()) {
                filter = (FilterConditionHandle)filterIterator.next();
                if (filter.getValue1() != null && filter.getValue1().indexOf("._outer") >= 0 || filter.getValue2() != null && filter.getValue2().indexOf("._outer") >= 0) continue;
                filterList.add(filter);
            }
        }
        if ((ph = this.itemHandle.getPropertyHandle("filter")) != null && (filterIterator = ph.iterator()) != null) {
            while (filterIterator.hasNext()) {
                filter = (FilterConditionHandle)filterIterator.next();
                if (filter.getValue1() != null && filter.getValue1().indexOf("._outer") >= 0 || filter.getValue2() != null && filter.getValue2().indexOf("._outer") >= 0) continue;
                filterList.add(filter);
            }
        }
        return filterList.isEmpty() ? null : filterList.iterator();
    }

    private IDataRowExpressionEvaluator createCubeEvaluator(CubeHandle cube, final DataRequestSession session, final EngineTask engineTask, Chart cm) throws BirtException {
        IBaseCubeQueryDefinition qd = null;
        ReportItemHandle referredHandle = ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle);
        boolean isChartCubeReference = ChartReportItemUtil.isChartReportItemHandle((ReportItemHandle)referredHandle);
        if (referredHandle != null && !isChartCubeReference) {
            ExtendedItemHandle bindingHandle = (ExtendedItemHandle)referredHandle;
            qd = CrosstabQueryUtil.createCubeQuery((CrosstabReportItemHandle)((CrosstabReportItemHandle)bindingHandle.getReportItem()), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        } else {
            qd = new ChartCubeQueryHelper(this.itemHandle, this.context.getModel()).createCubeQuery(null);
        }
        session.defineCube(cube);
        IPreparedCubeQuery ipcq = session.prepare((ICubeQueryDefinition)qd);
        if (referredHandle != null && !isChartCubeReference) {
            return new SharedCubeResultSetEvaluator((ICubeQueryResults)session.execute((IBasePreparedQuery)ipcq, null, null), qd, cm){

                public void close() {
                    super.close();
                    if (engineTask != null) {
                        engineTask.close();
                    } else if (session != null) {
                        session.shutdown();
                    }
                }
            };
        }
        return new BIRTCubeResultSetEvaluator((ICubeQueryResults)session.execute((IBasePreparedQuery)ipcq, null, null)){

            public void close() {
                super.close();
                if (engineTask != null) {
                    engineTask.close();
                } else if (session != null) {
                    session.shutdown();
                }
            }
        };
    }

    private DataRequestSession prepareDataRequestSession(EngineTask engineTask, int maxRow, boolean isCudeMode) throws BirtException {
        PropertyHandle filterProperty = this.itemHandle.getPropertyHandle("filter");
        if (filterProperty == null || filterProperty.getListValue() == null || filterProperty.getListValue().size() == 0) {
            HashMap<String, Integer> appContext = new HashMap<String, Integer>();
            if (!isCudeMode) {
                appContext.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, maxRow);
            } else {
                appContext.put(DataEngine.CUBECURSOR_FETCH_LIMIT_ON_COLUMN_EDGE, maxRow);
                appContext.put(DataEngine.CUBECUSROR_FETCH_LIMIT_ON_ROW_EDGE, maxRow);
            }
            engineTask.setAppContext(appContext);
        }
        DataRequestSession session = engineTask.getDataSession();
        return session;
    }

    private DataRequestSession prepareDataRequestSession(int maxRow, boolean isCudeMode) throws BirtException {
        DataSessionContext dsc = new DataSessionContext(3, this.getReportDesignHandle());
        PropertyHandle filterProperty = this.itemHandle.getPropertyHandle("filter");
        if (filterProperty == null || filterProperty.getListValue() == null || filterProperty.getListValue().size() == 0) {
            HashMap<String, Integer> appContext = new HashMap<String, Integer>();
            if (!isCudeMode) {
                appContext.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, maxRow);
            } else {
                appContext.put(DataEngine.CUBECURSOR_FETCH_LIMIT_ON_COLUMN_EDGE, maxRow);
                appContext.put(DataEngine.CUBECUSROR_FETCH_LIMIT_ON_ROW_EDGE, maxRow);
            }
            dsc.setAppContext(appContext);
        }
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)dsc);
        return session;
    }

    boolean isInXTabMeasureCell() {
        return ChartXTabUtil.isInXTabMeasureCell((DesignElementHandle)this.itemHandle);
    }

    boolean isPartChart() {
        return ChartXTabUtil.isPlotChart((DesignElementHandle)this.itemHandle) || ChartXTabUtil.isAxisChart((DesignElementHandle)this.itemHandle);
    }

    boolean isSharedBinding() {
        return this.itemHandle.getDataBindingReference() != null || this.isInMultiView();
    }

    boolean isTableSharedBinding() {
        return this.isSharedBinding() && ChartXTabUtil.getBindingCube((DesignElementHandle)this.itemHandle) == null;
    }

    public void setPredefinedExpressions(ColumnBindingInfo[] headers) {
        if (this.isSharedBinding() || this.isInheritColumnsGroups()) {
            this.fShareBindingQueryHelper.setPredefinedExpressions(headers);
        } else {
            LinkedHashMap<String, ColumnBindingInfo> commons = new LinkedHashMap<String, ColumnBindingInfo>();
            int i = 0;
            while (i < headers.length) {
                commons.put(ExpressionUtil.createJSRowExpression((String)headers[i].getName()), headers[i]);
                ++i;
            }
            Object[][] expressions = new Object[commons.size()][2];
            int index = 0;
            for (Map.Entry entry : commons.entrySet()) {
                expressions[index][0] = entry.getKey();
                expressions[index][1] = entry.getValue();
                ++index;
            }
            this.context.addPredefinedQuery("category", (Object[])expressions);
            this.context.addPredefinedQuery("value", (Object[])expressions);
            this.context.addPredefinedQuery("optional", (Object[])expressions);
        }
    }

    public ReportItemHandle getReportItemHandle() {
        if (this.isSharedBinding()) {
            if (this.isInMultiView()) {
                return (ReportItemHandle)this.itemHandle.getContainer().getContainer();
            }
            return this.itemHandle.getDataBindingReference();
        }
        return this.itemHandle;
    }

    public boolean update(String type, Object value) {
        boolean isUpdated;
        block5: {
            block6: {
                String[] levelNames;
                String dimExpr;
                List names;
                isUpdated = false;
                if (!"value".equals(type) || this.getDataCube() == null || !this.isSharedBinding()) break block5;
                LinkedHashMap<String, ComputedColumnHandle> bindingMap = new LinkedHashMap<String, ComputedColumnHandle>();
                Iterator bindings = ChartReportItemUtil.getAllColumnBindingsIterator((ReportItemHandle)this.itemHandle);
                while (bindings.hasNext()) {
                    ComputedColumnHandle column = (ComputedColumnHandle)bindings.next();
                    bindingMap.put(column.getName(), column);
                }
                String bindingName = ChartXTabUtil.getBindingName((String)((String)value), (boolean)false);
                ComputedColumnHandle computedBinding = (ComputedColumnHandle)bindingMap.get(bindingName);
                List aggOnList = computedBinding.getAggregateOnList();
                if (aggOnList.size() > 0 && (names = ChartXTabUtil.getRelatedBindingNames((String)(dimExpr = ExpressionUtil.createJSDimensionExpression((String)(levelNames = CubeUtil.splitLevelName((String)((String)aggOnList.get(0))))[0], (String)levelNames[1])), bindingMap.values())).size() > 0) {
                    SeriesDefinition sd = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.context.getModel()).get(0);
                    ((Query)sd.getDesignTimeSeries().getDataDefinition().get(0)).setDefinition(ExpressionUtil.createJSDataExpression((String)((String)names.get(0))));
                    isUpdated = true;
                }
                if (aggOnList.size() <= 1) break block6;
                levelNames = CubeUtil.splitLevelName((String)((String)aggOnList.get(1)));
                dimExpr = ExpressionUtil.createJSDimensionExpression((String)levelNames[0], (String)levelNames[1]);
                names = ChartXTabUtil.getRelatedBindingNames((String)dimExpr, bindingMap.values());
                int size = names.size();
                if (size <= 0) break block5;
                for (SeriesDefinition sd : ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.context.getModel())) {
                    sd.getQuery().setDefinition(ExpressionUtil.createJSDataExpression((String)((String)names.get(0))));
                    isUpdated = true;
                }
                break block5;
            }
            if (!ChartReportItemUtil.isChartReportItemHandle((ReportItemHandle)ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle))) {
                for (SeriesDefinition sd : ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.context.getModel())) {
                    sd.getQuery().setDefinition("");
                    isUpdated = true;
                }
            }
        }
        return isUpdated;
    }

    boolean hasMultiCubeDimensions() {
        CubeHandle cube = ChartXTabUtil.getBindingCube((DesignElementHandle)this.itemHandle);
        return ChartXTabUtil.getDimensionCount((CubeHandle)cube) > 1;
    }

    boolean isInXTabAggrCell() {
        try {
            AggregationCellHandle cell = ChartXTabUtil.getXtabContainerCell((DesignElementHandle)this.itemHandle);
            if (cell != null) {
                return ChartXTabUtil.isAggregationCell((AggregationCellHandle)cell);
            }
        }
        catch (BirtException birtException) {}
        return false;
    }

    boolean isInheritColumnsSet() {
        PropertyHandle property = this.itemHandle.getPropertyHandle("inheritColumns");
        return property != null && property.isSet();
    }

    boolean isInheritColumnsOnly() {
        return this.itemHandle.getDataSet() == null && ChartReportItemUtil.isContainerInheritable((ReportItemHandle)this.itemHandle) && this.context.isInheritColumnsOnly();
    }

    boolean isInheritColumnsGroups() {
        return this.itemHandle.getDataSet() == null && ChartReportItemUtil.isContainerInheritable((ReportItemHandle)this.itemHandle) && !this.context.isInheritColumnsOnly();
    }

    public int getState() {
        int states = 0;
        if (this.getBoundDataSet() != null) {
            states |= 1;
        }
        if (this.getDataCube() != null) {
            states |= 2;
        }
        if (this.itemHandle.getDataBindingReference() != null) {
            states |= 4;
        }
        if (this.isInMultiView()) {
            states |= 8;
        }
        if (this.isSharedBinding()) {
            states |= 0x10;
            if (this.isSharingChart(false)) {
                states |= 0x800;
            }
            if (ChartXTabUtil.getBindingCube((DesignElementHandle)this.itemHandle) != null) {
                states |= 0x100;
            } else if (!this.isSharingChart(false)) {
                states |= 0x80;
            }
        }
        if (this.isPartChart()) {
            states |= 0x20;
        }
        if (this.hasMultiCubeDimensions()) {
            states |= 0x40;
        }
        if (this.isInheritColumnsOnly()) {
            states |= 0x200;
        }
        if (this.isInheritColumnsGroups()) {
            states |= 0x400;
        }
        return states;
    }

    public boolean checkState(int state) {
        return (this.getState() & state) == state;
    }

    public Object checkData(String checkType, Object data) {
        if (("optional".equals(checkType) || "category".equals(checkType)) && (this.checkState(2) || this.checkState(256))) {
            return ChartXTabUIUtil.checkQueryExpression(checkType, data, this.context.getModel(), this.itemHandle, this);
        }
        return null;
    }

    private ListingHandle findListingInheritance() {
        DesignElementHandle container = this.itemHandle.getContainer();
        while (container != null) {
            if (container instanceof ListingHandle) {
                return (ListingHandle)container;
            }
            container = container.getContainer();
        }
        return null;
    }

    int getNumberOfSameDataDefinition(String expr) {
        String s;
        String[] expres;
        if (expr == null) {
            return 0;
        }
        int count = 0;
        Chart chart = this.context.getModel();
        String[] stringArray = expres = ChartUtil.getCategoryExpressions((Chart)chart);
        int n = expres.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (expr.equals(s)) {
                ++count;
            }
            ++n2;
        }
        stringArray = expres = ChartUtil.getValueSeriesExpressions((Chart)chart);
        n = expres.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (expr.equals(s)) {
                ++count;
            }
            ++n2;
        }
        stringArray = expres = ChartUtil.getYOptoinalExpressions((Chart)chart);
        n = expres.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (expr.equals(s)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    boolean isSharingChart(boolean isRecursive) {
        boolean isShare = this.isSharedBinding();
        if (isRecursive) {
            return isShare && ChartReportItemUtil.isChartReportItemHandle((ReportItemHandle)ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle));
        }
        return isShare && ChartReportItemUtil.isChartReportItemHandle((ReportItemHandle)this.itemHandle.getDataBindingReference());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BaseQueryHelper
    extends AbstractChartBaseQueryGenerator {
        public BaseQueryHelper(ExtendedItemHandle handle, Chart chart) {
            super((ReportItemHandle)handle, chart);
        }

        public IDataQueryDefinition createBaseQuery(List<String> columnExpression) throws ChartException {
            QueryDefinition queryDefn = new QueryDefinition();
            int maxRow = ReportDataServiceProvider.this.getMaxRow();
            queryDefn.setMaxRows(maxRow);
            queryDefn.setDataSetName(ReportDataServiceProvider.this.getDataSetFromHandle().getQualifiedName());
            int i = 0;
            while (i < columnExpression.size()) {
                String expr = columnExpression.get(i);
                Binding colBinding = new Binding(expr);
                colBinding.setExpression((IBaseExpression)new ScriptExpression(expr));
                try {
                    queryDefn.addBinding((IBinding)colBinding);
                }
                catch (DataException e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                }
                this.fNameSet.add(expr);
                ++i;
            }
            this.generateGroupBindings((BaseQueryDefinition)queryDefn);
            return queryDefn;
        }

        protected void addValueSeriesAggregateBindingForGrouping(BaseQueryDefinition query, EList<SeriesDefinition> seriesDefinitions, GroupDefinition innerMostGroupDef, Map<String, String[]> valueExprMap, SeriesDefinition baseSD) throws ChartException {
            for (SeriesDefinition orthSD : seriesDefinitions) {
                Series series = orthSD.getDesignTimeSeries();
                List qlist = ChartEngine.instance().getDataSetProcessor(series.getClass()).getDataDefinitionsForGrouping(series);
                for (Query qry : series.getDataDefinition()) {
                    String aggName;
                    String expr = qry.getDefinition();
                    if (expr == null || "".equals(expr) || (aggName = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)qry)) == null || "".equals(aggName)) continue;
                    String name = ChartUtil.getValueSeriesFullExpression((Query)qry, (SeriesDefinition)orthSD, (SeriesDefinition)baseSD);
                    if (this.fNameSet.contains(name)) {
                        query.getBindings().remove(name);
                    }
                    this.fNameSet.add(name);
                    Binding colBinding = new Binding(name);
                    colBinding.setDataType(0);
                    if (qlist.contains(qry)) {
                        try {
                            this.setBindingExpressionDueToAggregation(colBinding, expr, aggName);
                        }
                        catch (DataException e1) {
                            throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e1);
                        }
                        if (innerMostGroupDef != null) {
                            try {
                                colBinding.addAggregateOn(innerMostGroupDef.getName());
                            }
                            catch (DataException e) {
                                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                            }
                        }
                        colBinding.setAggrFunction(ChartReportItemUtil.convertToDtEAggFunction((String)aggName));
                        IAggregateFunction aFunc = PluginSettings.instance().getAggregateFunction(aggName);
                        if (aFunc.getParametersCount() > 0) {
                            String[] parameters = ChartUtil.getAggFunParameters((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)qry);
                            int i = 0;
                            while (i < parameters.length && i < aFunc.getParametersCount()) {
                                String param = parameters[i];
                                colBinding.addArgument((IBaseExpression)new ScriptExpression(param));
                                ++i;
                            }
                        }
                    } else {
                        colBinding.setExpression((IBaseExpression)new ScriptExpression(expr));
                    }
                    String newExpr = this.getExpressionForEvaluator(name);
                    try {
                        query.addBinding((IBinding)colBinding);
                    }
                    catch (DataException e) {
                        throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                    }
                    valueExprMap.put(expr, new String[]{name, newExpr});
                }
            }
        }

        public IDataQueryDefinition createBaseQuery(IDataQueryDefinition parent) {
            throw new UnsupportedOperationException("Don't be implemented in the class.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ColumnNameComprator
    implements Comparator<ColumnBindingInfo> {
        ColumnNameComprator() {
        }

        @Override
        public int compare(ColumnBindingInfo src, ColumnBindingInfo target) {
            return src.getName().compareTo(target.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShareBindingQueryHelper {
        ShareBindingQueryHelper() {
        }

        private void setPredefinedExpressions(ColumnBindingInfo[] headers) {
            Object[] expressionsArray = this.getPredefinedExpressionsForSharing(headers);
            ReportDataServiceProvider.this.context.addPredefinedQuery("category", (Object[])expressionsArray[0]);
            ReportDataServiceProvider.this.context.addPredefinedQuery("optional", (Object[])expressionsArray[1]);
            ReportDataServiceProvider.this.context.addPredefinedQuery("value", (Object[])expressionsArray[2]);
        }

        private Object[] getPredefinedExpressionsForSharing(ColumnBindingInfo[] headers) {
            LinkedHashMap<String, ColumnBindingInfo> commons = new LinkedHashMap<String, ColumnBindingInfo>();
            LinkedHashMap<String, ColumnBindingInfo> aggs = new LinkedHashMap<String, ColumnBindingInfo>();
            LinkedHashMap<String, ColumnBindingInfo> groups = new LinkedHashMap<String, ColumnBindingInfo>();
            LinkedHashMap<String, ColumnBindingInfo> groupsWithAgg = new LinkedHashMap<String, ColumnBindingInfo>();
            LinkedHashMap groupsWithoutAgg = new LinkedHashMap();
            int i = 0;
            while (i < headers.length) {
                int type = headers[i].getColumnType();
                switch (type) {
                    case 0: {
                        commons.put(ExpressionUtil.createJSRowExpression((String)headers[i].getName()), headers[i]);
                        break;
                    }
                    case 2: {
                        aggs.put(ExpressionUtil.createJSRowExpression((String)headers[i].getName()), headers[i]);
                        break;
                    }
                    case 1: {
                        groups.put(ExpressionUtil.createJSRowExpression((String)headers[i].getName()), headers[i]);
                    }
                }
                ++i;
            }
            groupsWithoutAgg = new LinkedHashMap(groups);
            Iterator iter = groupsWithoutAgg.entrySet().iterator();
            block6: while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String groupName = ((ColumnBindingInfo)entry.getValue()).getName();
                ColumnBindingInfo[] aggsValues = aggs.values().toArray(new ColumnBindingInfo[0]);
                int j = 0;
                while (j < aggs.size()) {
                    if (groupName.equals(((ComputedColumnHandle)aggsValues[j].getObjectHandle()).getAggregateOn())) {
                        iter.remove();
                        groupsWithAgg.put((String)entry.getKey(), (ColumnBindingInfo)entry.getValue());
                        continue block6;
                    }
                    ++j;
                }
            }
            Object[][] categorys = new Object[][]{};
            Object[][] optionals = new Object[][]{};
            categorys = new Object[groups.size() + commons.size()][2];
            int index = 0;
            for (Map.Entry entry : groups.entrySet()) {
                categorys[index][0] = entry.getKey();
                categorys[index][1] = entry.getValue();
                ++index;
            }
            for (Map.Entry entry : commons.entrySet()) {
                categorys[index][0] = entry.getKey();
                categorys[index][1] = entry.getValue();
                ++index;
            }
            int size = groups.size() > 0 ? 1 : 0;
            optionals = new Object[size][2];
            if (groups.size() > 0) {
                Map.Entry entry = groups.entrySet().iterator().next();
                optionals[0][0] = entry.getKey();
                optionals[0][1] = entry.getValue();
            }
            Object[][] values = new Object[aggs.size() + commons.size()][2];
            index = 0;
            for (Map.Entry entry : aggs.entrySet()) {
                values[index][0] = entry.getKey();
                values[index][1] = entry.getValue();
                ++index;
            }
            for (Map.Entry entry : commons.entrySet()) {
                values[index][0] = entry.getKey();
                values[index][1] = entry.getValue();
                ++index;
            }
            return new Object[]{categorys, optionals, values};
        }

        private IDataRowExpressionEvaluator createShareBindingEvaluator(Chart cm, final DataRequestSession session, final EngineTask engineTask) throws BirtException, AdapterException, DataException, ChartException {
            QueryDefinition queryDefn = new QueryDefinition();
            int maxRow = ReportDataServiceProvider.this.getMaxRow();
            queryDefn.setMaxRows(maxRow);
            final HashMap<String, String> bindingExprsMap = new HashMap<String, String>();
            Iterator iterator = ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)ReportDataServiceProvider.this.itemHandle);
            ArrayList<ComputedColumnHandle> columnList = new ArrayList<ComputedColumnHandle>();
            while (iterator.hasNext()) {
                columnList.add((ComputedColumnHandle)iterator.next());
            }
            this.generateShareBindingsWithTable(this.getPreviewHeadersInfo(columnList), queryDefn, session, bindingExprsMap);
            this.addCustomExpressions(queryDefn, cm, bindingExprsMap);
            IQueryResults actualResultSet = session.executeQuery((IQueryDefinition)queryDefn, null, ReportDataServiceProvider.this.getPropertyIterator(ReportDataServiceProvider.this.itemHandle.getPropertyHandle("filter")), null);
            if (actualResultSet != null) {
                return new BaseGroupedQueryResultSetEvaluator(actualResultSet.getResultIterator(), ChartReportItemUtil.isSetSummaryAggregation((Chart)cm), cm){

                    public Object evaluate(String expression) {
                        try {
                            String newExpr = (String)bindingExprsMap.get(expression);
                            if (newExpr != null) {
                                return this.fResultIterator.getValue(newExpr);
                            }
                            return this.fResultIterator.getValue(expression);
                        }
                        catch (BirtException e) {
                            sLogger.log((Exception)((Object)e));
                            return null;
                        }
                    }

                    public void close() {
                        super.close();
                        if (engineTask != null) {
                            engineTask.close();
                        } else if (session != null) {
                            session.shutdown();
                        }
                    }
                };
            }
            return null;
        }

        private void addCustomExpressions(QueryDefinition queryDefn, Chart cm, Map<String, String> bindingExprsMap) throws DataException {
            List queryList = ChartBaseQueryHelper.getAllQueryExpressionDefinitions((Chart)cm);
            int i = 0;
            while (i < queryList.size()) {
                Query query = (Query)queryList.get(i);
                String expr = query.getDefinition();
                if (expr != null && !"".equals(expr) && !bindingExprsMap.containsKey(expr)) {
                    String name = StructureFactory.newComputedColumn((DesignElementHandle)ReportDataServiceProvider.this.itemHandle, (String)ChartUtil.removeInvalidSymbols((String)expr)).getName();
                    queryDefn.addBinding((IBinding)new Binding(name, (IBaseExpression)new ScriptExpression(expr)));
                    bindingExprsMap.put(expr, name);
                }
                ++i;
            }
        }

        private final ColumnBindingInfo[] getPreviewHeadersInfo(List<ComputedColumnHandle> columnList) throws ChartException {
            if (columnList == null || columnList.size() == 0) {
                return new ColumnBindingInfo[0];
            }
            ColumnBindingInfo[] columnHeaders = null;
            List<GroupHandle> groupList = this.getGroupsOfSharedBinding();
            columnHeaders = new ColumnBindingInfo[columnList.size() + groupList.size()];
            int index = 0;
            int i = 0;
            while (i < groupList.size()) {
                GroupHandle gh = groupList.get(i);
                String groupName = gh.getName();
                String groupKeyExpr = gh.getKeyExpr();
                String tooltip = String.valueOf(Messages.getString("ReportDataServiceProvider.Tooltip.GroupExpression")) + groupKeyExpr;
                columnHeaders[index++] = new ColumnBindingInfo(groupName, groupKeyExpr, 1, "icons/obj16/group.gif", tooltip, (Object)gh);
                Iterator<ComputedColumnHandle> iter = columnList.iterator();
                while (iter.hasNext()) {
                    ComputedColumnHandle cch = iter.next();
                    String aggOn = cch.getAggregateOn();
                    if (!groupName.equals(aggOn)) continue;
                    iter.remove();
                    tooltip = String.valueOf(Messages.getString("ReportDataServiceProvider.Tooltip.Aggregate")) + cch.getAggregateFunction() + "\n" + Messages.getString("ReportDataServiceProvider.Tooltip.OnGroup") + groupName;
                    columnHeaders[index] = new ColumnBindingInfo(cch.getName(), ExpressionUtil.createJSRowExpression((String)cch.getName()), 2, "icons/obj16/sigma.gif", tooltip, (Object)cch);
                    columnHeaders[index].setChartAggExpression(ChartReportItemUtil.convertToChartAggExpression((String)cch.getAggregateFunction()));
                    ++index;
                }
                ++i;
            }
            Iterator<ComputedColumnHandle> iter = columnList.iterator();
            while (iter.hasNext()) {
                ComputedColumnHandle cch = iter.next();
                if (cch.getAggregateFunction() == null) continue;
                iter.remove();
                String tooltip = String.valueOf(Messages.getString("ReportDataServiceProvider.Tooltip.Aggregate")) + cch.getAggregateFunction() + "\n" + Messages.getString("ReportDataServiceProvider.Tooltip.OnGroup");
                columnHeaders[index] = new ColumnBindingInfo(cch.getName(), ExpressionUtil.createJSRowExpression((String)cch.getName()), 2, "icons/obj16/sigma.gif", tooltip, (Object)cch);
                columnHeaders[index].setChartAggExpression(ChartReportItemUtil.convertToChartAggExpression((String)cch.getAggregateFunction()));
                ++index;
            }
            for (ComputedColumnHandle cch : columnList) {
                columnHeaders[index++] = new ColumnBindingInfo(cch.getName(), ExpressionUtil.createJSRowExpression((String)cch.getName()), 0, null, null, (Object)cch);
            }
            return columnHeaders;
        }

        private List<GroupHandle> getGroupsOfSharedBinding() {
            ArrayList<GroupHandle> groupList = new ArrayList<GroupHandle>();
            ListingHandle table = null;
            if (ReportDataServiceProvider.this.isInheritColumnsGroups()) {
                table = ReportDataServiceProvider.this.findListingInheritance();
            } else {
                ReportItemHandle handle = ReportDataServiceProvider.this.getReportItemHandle();
                if ((handle = this.getSharedListingHandle(handle)) instanceof ListingHandle) {
                    table = (ListingHandle)handle;
                }
            }
            if (table != null) {
                SlotHandle groups = table.getGroups();
                Iterator iter = groups.iterator();
                while (iter.hasNext()) {
                    groupList.add((GroupHandle)iter.next());
                }
            }
            return groupList;
        }

        private ListingHandle getSharedListingHandle(ReportItemHandle itemHandle) {
            if (itemHandle instanceof ListingHandle) {
                return (ListingHandle)itemHandle;
            }
            ReportItemHandle handle = itemHandle.getDataBindingReference();
            if (handle != null) {
                return this.getSharedListingHandle(handle);
            }
            if (itemHandle.getContainer() instanceof MultiViewsHandle) {
                return this.getSharedListingHandle((ReportItemHandle)itemHandle.getContainer().getContainer());
            }
            return null;
        }

        private List<Object[]> getPreviewRowData(ColumnBindingInfo[] headers, int rowCount, boolean isStringType) throws ChartException {
            ArrayList<Object[]> dataList = new ArrayList<Object[]>();
            ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader parentLoader = oldContextLoader;
            if (parentLoader == null) {
                parentLoader = this.getClass().getClassLoader();
            }
            ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parentLoader, (ModuleHandle)ReportDataServiceProvider.this.itemHandle.getModuleHandle());
            Thread.currentThread().setContextClassLoader(newContextLoader);
            ReportEngine engine = null;
            DummyEngineTask engineTask = null;
            DataRequestSession session = null;
            try {
                try {
                    int maxRow = ReportDataServiceProvider.this.getMaxRow();
                    if (ReportDataServiceProvider.this.isReportDesignHandle()) {
                        engine = (ReportEngine)new ReportEngineFactory().createReportEngine(new EngineConfig());
                        engineTask = new DummyEngineTask(engine, new ReportEngineHelper(engine).openReportDesign((ReportDesignHandle)ReportDataServiceProvider.this.itemHandle.getModuleHandle()), ReportDataServiceProvider.this.itemHandle.getModuleHandle());
                        session = ReportDataServiceProvider.this.prepareDataRequestSession((EngineTask)engineTask, maxRow, false);
                        engineTask.run();
                    } else {
                        session = ReportDataServiceProvider.this.prepareDataRequestSession(maxRow, false);
                    }
                    QueryDefinition queryDefn = new QueryDefinition();
                    queryDefn.setMaxRows(maxRow);
                    List<String> columns = this.generateShareBindingsWithTable(headers, queryDefn, session, new HashMap<String, String>());
                    IQueryResults actualResultSet = session.executeQuery((IQueryDefinition)queryDefn, null, ReportDataServiceProvider.this.getPropertyIterator(ReportDataServiceProvider.this.itemHandle.getPropertyHandle("filter")), null);
                    if (actualResultSet != null) {
                        int columnCount = columns.size();
                        IResultIterator iter = actualResultSet.getResultIterator();
                        while (iter.next()) {
                            int n;
                            Object[] record;
                            if (isStringType) {
                                record = new String[columnCount];
                                n = 0;
                                while (n < columnCount) {
                                    record[n] = DataTypeUtil.toString((Object)iter.getValue(columns.get(n)));
                                    ++n;
                                }
                                dataList.add(record);
                                continue;
                            }
                            record = new Object[columnCount];
                            n = 0;
                            while (n < columnCount) {
                                record[n] = iter.getValue(columns.get(n));
                                ++n;
                            }
                            dataList.add(record);
                        }
                        actualResultSet.close();
                    }
                }
                catch (BirtException e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextLoader);
                if (engine == null && session != null) {
                    session.shutdown();
                }
                if (engineTask != null) {
                    engineTask.close();
                }
                if (engine != null) {
                    engine.destroy();
                }
            }
            return dataList;
        }

        private List<String> generateShareBindingsWithTable(ColumnBindingInfo[] headers, QueryDefinition queryDefn, DataRequestSession session, Map<String, String> bindingExprsMap) throws AdapterException, DataException {
            ArrayList<String> columns = new ArrayList<String>();
            ReportItemHandle reportItemHandle = ReportDataServiceProvider.this.getReportItemHandle();
            if (ReportDataServiceProvider.this.isInheritColumnsGroups()) {
                reportItemHandle = ReportDataServiceProvider.this.findListingInheritance();
            }
            queryDefn.setDataSetName(reportItemHandle.getDataSet().getQualifiedName());
            int i = 0;
            while (i < headers.length) {
                ColumnBindingInfo chi = headers[i];
                int type = chi.getColumnType();
                switch (type) {
                    case 0: 
                    case 2: {
                        IBinding binding = session.getModelAdaptor().adaptBinding((ComputedColumnHandle)chi.getObjectHandle());
                        queryDefn.addBinding(binding);
                        columns.add(binding.getBindingName());
                        bindingExprsMap.put(chi.getExpression(), binding.getBindingName());
                        break;
                    }
                    case 1: {
                        GroupDefinition gd = session.getModelAdaptor().adaptGroup((GroupHandle)chi.getObjectHandle());
                        queryDefn.addGroup(gd);
                        String name = StructureFactory.newComputedColumn((DesignElementHandle)reportItemHandle, (String)gd.getName()).getName();
                        IBinding binding = new Binding(name);
                        binding.setExpression((IBaseExpression)new ScriptExpression(gd.getKeyExpression()));
                        queryDefn.addBinding(binding);
                        columns.add(name);
                        bindingExprsMap.put(((ScriptExpression)binding.getExpression()).getText(), binding.getBindingName());
                    }
                }
                ++i;
            }
            if (reportItemHandle instanceof ListingHandle) {
                queryDefn.getSorts().addAll(ChartBaseQueryHelper.createSorts((Iterator)((ListingHandle)reportItemHandle).sortsIterator()));
            }
            return columns;
        }
    }
}

