/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.editors.script.IScriptEditor;
import org.eclipse.birt.report.designer.internal.ui.editors.script.IScriptMethodInfo;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSEditor;
import org.eclipse.birt.report.designer.internal.ui.editors.script.ScriptParser;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.ITemplateMethodInfo;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.AbstractTextEditor;

class JSSubFunctionListProvider
implements IStructuredContentProvider,
ILabelProvider,
ISelectionChangedListener {
    protected static Logger logger = Logger.getLogger(JSSubFunctionListProvider.class.getName());
    private JSEditor editor;

    public JSSubFunctionListProvider(JSEditor editor) {
        this.editor = editor;
    }

    public Object[] getElements(Object inputElement) {
        String scriptName;
        ExtendedItemHandle extHandle;
        List methods;
        int selectedIndex;
        ArrayList<String> elements = new ArrayList<String>();
        if (inputElement instanceof ExtendedItemHandle && (selectedIndex = this.editor.cmbExpList.getSelectionIndex()) >= 0 && (methods = (extHandle = (ExtendedItemHandle)inputElement).getMethods(scriptName = this.editor.cmbExpList.getItem(this.editor.cmbExpList.getSelectionIndex()))) != null) {
            elements.add(0, Messages.getString((String)"JSEditor.cmb.NewEventFunction"));
            elements.addAll(methods);
        }
        return elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            viewer.refresh();
        }
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IMethodInfo) {
            IMethodInfo eleDef = (IMethodInfo)element;
            return "  " + eleDef.getName();
        }
        if (element instanceof String) {
            return (String)element;
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object[] sel;
        ISelection selection;
        boolean isContextChange = false;
        if (event.getSource() instanceof ComboViewer) {
            isContextChange = "context".equals(((ComboViewer)event.getSource()).getData("Category"));
        }
        if ((selection = event.getSelection()) != null && (sel = ((IStructuredSelection)selection).toArray()).length == 1) {
            if (isContextChange) {
                this.editor.cmbSubFunctionsViewer.refresh();
                int itemCount = this.editor.cmbSubFunctions.getItemCount();
                if (itemCount > 0) {
                    this.editor.cmbSubFunctions.select(0);
                }
                this.editor.cmbSubFunctions.setEnabled(itemCount > 0);
            } else if (sel[0] instanceof IMethodInfo) {
                IMethodInfo methodInfo = (IMethodInfo)sel[0];
                Position pos = this.findMethod(methodInfo);
                if (pos != null) {
                    IScriptEditor viewer = this.editor.getScriptEditor();
                    if (viewer instanceof AbstractTextEditor) {
                        AbstractTextEditor editor = (AbstractTextEditor)viewer;
                        editor.selectAndReveal(pos.getOffset(), pos.length);
                    }
                } else {
                    String signature = this.createSignature(methodInfo);
                    try {
                        IScriptEditor viewer = this.editor.getScriptEditor();
                        if (viewer instanceof AbstractTextEditor) {
                            AbstractTextEditor editor = (AbstractTextEditor)viewer;
                            IDocument doc = editor.getDocumentProvider().getDocument((Object)viewer.getEditorInput());
                            int length = doc.getLength();
                            doc.replace(length, 0, signature);
                            editor.selectAndReveal(length + 1, signature.length());
                        }
                    }
                    catch (BadLocationException e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                this.editor.cmbSubFunctions.select(0);
            }
        }
    }

    private Position findMethod(IMethodInfo methodInfo) {
        ScriptParser parser = new ScriptParser(this.editor.getEditorText());
        Collection<IScriptMethodInfo> coll = parser.getAllMethodInfo();
        for (IScriptMethodInfo mtd : coll) {
            if (!methodInfo.getName().equals(mtd.getName())) continue;
            return mtd.getPosition();
        }
        return null;
    }

    private String createSignature(IMethodInfo info) {
        String code;
        StringBuffer signature = new StringBuffer();
        String javaDoc = info.getJavaDoc();
        if (javaDoc != null && javaDoc.length() > 0) {
            signature.append("\n");
            signature.append(info.getJavaDoc());
        }
        if (info instanceof ITemplateMethodInfo && (code = ((ITemplateMethodInfo)info).getCodeTemplate()) != null) {
            signature.append("\n").append(code).append("\n");
            return signature.toString();
        }
        signature.append("\nfunction ");
        signature.append(info.getName());
        signature.append("( ");
        Iterator iter = info.argumentListIterator();
        if (iter.hasNext()) {
            IArgumentInfoList argumentList = (IArgumentInfoList)iter.next();
            Iterator argumentIter = argumentList.argumentsIterator();
            while (argumentIter.hasNext()) {
                IArgumentInfo argument = (IArgumentInfo)argumentIter.next();
                String argName = argument.getName();
                if (argName == null || argName.length() == 0) {
                    String type = argument.getType();
                    argName = JSEditor.convertToParameterName(type);
                }
                signature.append(argName);
                if (!argumentIter.hasNext()) continue;
                signature.append(", ");
            }
        }
        signature.append(" )\n{\n}\n");
        return signature.toString();
    }
}

