/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.compatibility;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.internal.compatibility.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.statushandlers.StatusManager;

public class JavaRuntimeVersionChecker
implements IStartup {
    private static final String ID_PLUGIN = "org.eclipse.mylyn.compatibility";
    private static final String PREF_WARN_DISABLED = "org.eclipse.mylyn.internal.compatibility.warn.disabled";
    private static final float JRE_MIN_VERSION = 1.5f;

    public void earlyStartup() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    ScopedPreferenceStore preferenceStore;
                    String minorString;
                    Float versionFloat;
                    String versionString = System.getProperty("java.runtime.version");
                    int minorMinorIndex = versionString.lastIndexOf(46);
                    if (minorMinorIndex != -1 && (versionFloat = new Float(minorString = versionString.substring(0, minorMinorIndex))).compareTo(new Float(1.5f)) < 0 && !(preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), JavaRuntimeVersionChecker.ID_PLUGIN)).getBoolean(JavaRuntimeVersionChecker.PREF_WARN_DISABLED)) {
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.JavaRuntimeVersionChecker_JDK_Version_Check, (String)Messages.JavaRuntimeVersionChecker_Mylyn_was_installed_but_requires_Java_5_or_later_to_run, (String)Messages.JavaRuntimeVersionChecker_Do_not_warn_again, (boolean)false, (IPreferenceStore)preferenceStore, (String)JavaRuntimeVersionChecker.PREF_WARN_DISABLED);
                        preferenceStore.setValue(JavaRuntimeVersionChecker.PREF_WARN_DISABLED, dialog.getToggleState());
                        preferenceStore.save();
                    }
                }
                catch (Throwable t) {
                    StatusManager.getManager().handle((IStatus)new Status(1, JavaRuntimeVersionChecker.ID_PLUGIN, "Could determine JRE version.", t), 1);
                }
            }
        });
    }
}

