/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.fieldassist;

import org.eclipse.birt.chart.ui.swt.fieldassist.FieldAssistHelper;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public abstract class AssistField {
    protected Menu quickFixMenu;
    protected ControlDecoration controlDecoration;
    protected Control control;
    protected IControlContentAdapter contentAdapter;
    protected FieldDecoration errorDecoration;
    protected FieldDecoration warningDecoration;
    protected boolean hasContentAssist = false;

    public AssistField(Control control, Composite composite, IControlContentAdapter adapter) {
        this(control, composite, adapter, null);
    }

    public AssistField(Control control, Composite composite, IControlContentAdapter adapter, String[] values) {
        this.controlDecoration = FieldAssistHelper.getInstance().createControlDecoration(control, composite);
        this.contentAdapter = adapter;
        this.control = control;
        this.setContent(values);
        this.initAssistListeners();
    }

    protected void initAssistListeners() {
        this.initModifyListener();
        this.initQuickFixMenu();
    }

    protected void initModifyListener() {
    }

    protected void initQuickFixMenu() {
        if (this.hasQuickFix()) {
            this.controlDecoration.addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent event) {
                    if (AssistField.this.isValid()) {
                        return;
                    }
                    if (AssistField.this.quickFixMenu == null) {
                        AssistField.this.quickFixMenu = FieldAssistHelper.getInstance().createQuickFixMenu(AssistField.this);
                    }
                    AssistField.this.quickFixMenu.setLocation(event.x, event.y);
                    AssistField.this.quickFixMenu.setVisible(true);
                }
            });
        }
    }

    public void setContent(String[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        this.hasContentAssist = true;
        FieldAssistHelper.getInstance().installContentProposalAdapter(this.control, this.contentAdapter, values);
    }

    public boolean isRequiredField() {
        return false;
    }

    public boolean hasQuickFix() {
        return false;
    }

    public void quickFix() {
    }

    public boolean hasContentAssist() {
        return this.hasContentAssist;
    }

    public void dispose() {
        if (this.quickFixMenu != null) {
            this.quickFixMenu.dispose();
            this.quickFixMenu = null;
        }
    }

    public FieldDecoration getErrorDecoration() {
        if (this.errorDecoration == null) {
            FieldDecoration standardError = this.hasQuickFix() ? FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERRORQUICKFIX") : FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            this.errorDecoration = this.getErrorMessage() == null ? standardError : new FieldDecoration(standardError.getImage(), this.getErrorMessage());
        }
        if (this.getErrorMessage() != null) {
            this.errorDecoration.setDescription(this.getErrorMessage());
        }
        return this.errorDecoration;
    }

    public FieldDecoration getWarningDecoration() {
        if (this.warningDecoration == null) {
            FieldDecoration standardWarning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
            this.warningDecoration = this.getWarningMessage() == null ? standardWarning : new FieldDecoration(standardWarning.getImage(), this.getWarningMessage());
        }
        return this.warningDecoration;
    }

    public String getContents() {
        return this.contentAdapter.getControlContents(this.control);
    }

    public IControlContentAdapter getContentAdapter() {
        return this.contentAdapter;
    }

    public void setContents(String contents) {
        this.contentAdapter.setControlContents(this.control, contents, contents.length());
    }

    public abstract boolean isValid();

    public abstract boolean isWarning();

    public String getErrorMessage() {
        return null;
    }

    public String getWarningMessage() {
        return null;
    }
}

