/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.api.IParameterMetaData;
import org.eclipse.birt.data.engine.impl.ParameterMetaData;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.ParameterPageUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleInputDialog;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ControlProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionHelper;
import org.eclipse.birt.report.designer.internal.ui.processor.ElementProcessorFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterDialog;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.model.adapter.oda.ReportParameterAdapter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DataSetParametersPage
extends AbstractDescriptionPropertyPage
implements Listener {
    private boolean modelChanged = true;
    private PropertyHandle parameters;
    private PropertyHandleTableViewer viewer;
    private DataSetParameter originalStructure = null;
    private String parameterName;
    private boolean isOdaDataSetHandle;
    private boolean isJointOrDerivedDataSetHandle;
    private static String DEFAULT_MESSAGE = Messages.getString((String)"dataset.editor.parameters");
    private static String NONE_DEFAULT_VALUE = Messages.getString((String)"DataSetParametersPage.default.None");
    private static String UNLINKED_REPORT_PARAM = Messages.getString((String)"DataSetParametersPage.reportParam.None");
    private static final char RENAME_SEPARATOR = '_';
    private static final String PARAM_PREFIX = "param_";

    public Control createContents(Composite parent) {
        this.parameters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("parameters");
        return this.createParameterPageControl(parent);
    }

    private Control createParameterPageControl(Composite parent) {
        this.viewer = new PropertyHandleTableViewer(parent, true, true, true);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(" ");
        column.setResizable(false);
        column.setWidth(23);
        DataSetHandle dataSetHandle = (DataSetHandle)this.getContainer().getModel();
        this.isOdaDataSetHandle = ParameterPageUtil.isOdaDataSetHandle(dataSetHandle);
        this.isJointOrDerivedDataSetHandle = ParameterPageUtil.isJointOrDerivedDataSetHandle(dataSetHandle);
        if (this.isOdaDataSetHandle) {
            String[] cellLabels = ParameterPageUtil.odaCellLabels;
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[0]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[1]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[2]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[3]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[4]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[5]);
            column.setWidth(180);
        } else {
            String[] cellLabels = ParameterPageUtil.cellLabels;
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[0]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[1]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[2]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[3]);
            column.setWidth(100);
            if (this.isJointOrDerivedDataSetHandle) {
                column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
                column.setText(ParameterPageUtil.odaCellLabels[5]);
                column.setWidth(180);
            }
        }
        this.viewer.getViewer().setContentProvider((IContentProvider)new ParameterViewContentProvider());
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)new ParameterViewLableProvider(dataSetHandle));
        this.adjustParameterOnPosition(this.parameters);
        if (ParameterPageUtil.isJointDataSetHandle(dataSetHandle)) {
            this.viewer.getViewer().setInput((Object)((JointDataSetHandle)dataSetHandle));
        } else {
            this.viewer.getViewer().setInput((Object)this.parameters);
        }
        this.setToolTips();
        if (!this.isJointOrDerivedDataSetHandle) {
            this.addRefreshMenu();
            this.addListeners();
            dataSetHandle.addListener((Listener)this);
        }
        return this.viewer.getControl();
    }

    private void addRefreshMenu() {
        MenuItem itmRefresh = new MenuItem(this.viewer.getMenu(), 0, 0);
        new MenuItem(this.viewer.getMenu(), 2, 1);
        itmRefresh.setText(Messages.getString((String)"parameters.menuItem.reset"));
        itmRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyHandle handle = (PropertyHandle)DataSetParametersPage.this.viewer.getViewer().getInput();
                try {
                    handle.clearValue();
                }
                catch (SemanticException semanticException) {}
                DataSetParametersPage.this.refreshParameters();
                DataSetParametersPage.this.viewer.getViewer().refresh();
            }
        });
    }

    private String[] getDirections() {
        boolean supportInput = ((DataSetEditor)this.getContainer()).supportsInParameters();
        boolean supportOutput = ((DataSetEditor)this.getContainer()).supportsOutputParameters();
        String[] directions = supportInput && supportOutput ? new String[]{Messages.getString((String)"label.input"), Messages.getString((String)"label.output"), Messages.getString((String)"label.inputOutput")} : (supportInput ? new String[]{Messages.getString((String)"label.input")} : (supportOutput ? new String[]{Messages.getString((String)"label.output")} : new String[]{Messages.getString((String)"label.input"), Messages.getString((String)"label.output"), Messages.getString((String)"label.inputOutput")}));
        return directions;
    }

    private void addListeners() {
        this.viewer.getNewButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.doNew();
            }
        });
        this.viewer.getEditButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DataSetParametersPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DataSetParametersPage.this.setPageProperties();
                    DataSetParametersPage.this.refreshMessage();
                }
            }
        });
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.setPageProperties();
                DataSetParametersPage.this.refreshMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.setPageProperties();
                DataSetParametersPage.this.refreshMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.setPageProperties();
                DataSetParametersPage.this.refreshMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
    }

    private void doNew() {
        Object newParam = null;
        newParam = this.isOdaDataSetHandle ? new OdaDataSetParameter() : new DataSetParameter();
        int position = this.viewer.getViewer().getTable().getItemCount();
        newParam.setName(this.getUniqueName());
        newParam.setIsInput(true);
        newParam.setPosition(new Integer(position + 1));
        this.doEdit(newParam);
    }

    private void doEdit() {
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        DataSetParameterHandle handle = (DataSetParameterHandle)this.viewer.getViewer().getTable().getItem(index).getData();
        this.originalStructure = (DataSetParameter)handle.getStructure().copy();
        this.doEdit(handle);
    }

    private void doEdit(Object structureOrHandle) {
        ParameterInputDialog dlg = new ParameterInputDialog(structureOrHandle, this.isOdaDataSetHandle);
        if (dlg.open() == 0) {
            this.viewer.getViewer().refresh();
            this.refreshMessage();
            this.refreshLinkedReportParamStatus();
        }
    }

    private void refreshLinkedReportParamStatus() {
        TableItem[] items = this.viewer.getViewer().getTable().getItems();
        int i = 0;
        while (i < items.length) {
            OdaDataSetParameterHandle handle;
            if (items[i].getData() instanceof OdaDataSetParameterHandle && (handle = (OdaDataSetParameterHandle)items[i].getData()).getParamName() != null && !this.doesLinkedReportParamExist(handle)) {
                this.getContainer().setMessage(Messages.getFormattedString((String)"DataSetParametersPage.errorMessage.LinkedReportParamNotFound", (Object[])new Object[]{handle.getParamName(), handle.getName()}), 3);
                this.viewer.getViewer().refresh();
                break;
            }
            ++i;
        }
    }

    private boolean doesLinkedReportParamExist(OdaDataSetParameterHandle handle) {
        String[] reportParamNames = ParameterPageUtil.getLinkedReportParameterNames(handle);
        boolean exists = false;
        int i = 0;
        while (i < reportParamNames.length) {
            if (reportParamNames[i].equalsIgnoreCase(handle.getParamName())) {
                exists = true;
                break;
            }
            ++i;
        }
        return exists;
    }

    private void refreshMessage() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        if (!this.doSaveEmptyParameter(this.parameters)) {
            this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.noInputParameterDefaultValue", (Object[])new Object[]{this.getNoneValuedParameterName()}), 3);
        }
    }

    private DataSetParameter getStructure(Object structureOrHandle) {
        DataSetParameter structure = null;
        structure = structureOrHandle instanceof DataSetParameter ? (DataSetParameter)structureOrHandle : (DataSetParameter)((DataSetParameterHandle)structureOrHandle).getStructure();
        return structure;
    }

    private void adjustParameterOnPosition(PropertyHandle handle) {
        if (handle.getListValue() != null) {
            int i = 1;
            while (i <= handle.getListValue().size()) {
                int position = i - 1;
                while (position < handle.getListValue().size()) {
                    DataSetParameterHandle param = (DataSetParameterHandle)handle.getAt(position);
                    if (param.getPosition() == i) {
                        try {
                            handle.moveItem(position, i - 1);
                            break;
                        }
                        catch (PropertyValueException propertyValueException) {}
                    }
                    ++position;
                }
                ++i;
            }
        }
    }

    private void setToolTips() {
        this.viewer.getNewButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.New"));
        this.viewer.getEditButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Edit"));
        this.viewer.getRemoveButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Remove"));
        this.viewer.getUpButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Up"));
        this.viewer.getDownButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Down"));
    }

    protected final String getDirectionDisplayName(boolean isInput, boolean isOutput) {
        if (isInput && isOutput) {
            return ParameterPageUtil.directions[2];
        }
        if (isOutput) {
            return ParameterPageUtil.directions[1];
        }
        return ParameterPageUtil.directions[0];
    }

    public void pageActivated() {
        this.refreshMessage();
        if (this.viewer != null && this.modelChanged) {
            this.modelChanged = false;
            List invalidReportParam = this.getMultipleValueReportParameter(this.parameters);
            if (!invalidReportParam.isEmpty()) {
                this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.invalidLinkedParameter", (Object[])invalidReportParam.toArray()), 3);
            }
            this.adjustParameterOnPosition(this.parameters);
            this.viewer.getViewer().refresh();
        }
        this.setPageProperties();
        this.refreshLinkedReportParamStatus();
        this.viewer.getViewer().getTable().select(0);
    }

    private void refreshParameters() {
        try {
            DataSetHandle ds = (DataSetHandle)this.getContainer().getModel();
            Collection paramsFromDataSet = null;
            paramsFromDataSet = DataSetProvider.getCurrentInstance().getParametersFromDataSet(ds);
            if (paramsFromDataSet != null) {
                for (IParameterMetaData paramFromDataSet : paramsFromDataSet) {
                    DataSetParameter parameter = null;
                    parameter = paramFromDataSet.getPosition() > 0 ? this.findParameterByPosition(paramFromDataSet.getPosition()) : this.findParameterByName(paramFromDataSet.getName());
                    if (parameter != null) {
                        DataSetParameter newParameter = this.newParameter(paramFromDataSet);
                        if (this.isSameParameters(parameter, newParameter)) continue;
                        this.parameters.replaceItem((IStructure)parameter, (IStructure)newParameter);
                        continue;
                    }
                    this.parameters.addItem((IStructure)this.newParameter(paramFromDataSet));
                }
                if (this.parameters.getListValue() != null && paramsFromDataSet.size() < this.parameters.getListValue().size()) {
                    int size = this.parameters.getListValue().size();
                    while (size > paramsFromDataSet.size()) {
                        this.parameters.removeItem(size - 1);
                        size = this.parameters.getListValue().size();
                    }
                }
                this.updateParams2UniqueName(this.parameters.getListValue());
            } else if (this.viewer != null) {
                PropertyHandle handle = (PropertyHandle)this.viewer.getViewer().getInput();
                handle.clearValue();
            }
            this.refreshPositions();
            this.setPageProperties();
        }
        catch (Exception exception) {}
    }

    private DataSetParameter newParameter(IParameterMetaData paramFromDataSet) {
        OdaDataSetParameter parameter = null;
        if (this.isOdaDataSetHandle) {
            parameter = new OdaDataSetParameter();
            if (paramFromDataSet instanceof ParameterMetaData) {
                parameter.setNativeName(((ParameterMetaData)paramFromDataSet).getNativeName());
            }
            if ("REF CURSOR".equals(paramFromDataSet.getNativeTypeName())) {
                parameter.setNativeDataType(new Integer(-10));
            }
        } else {
            parameter = new DataSetParameter();
        }
        try {
            parameter.setParameterDataType(DataAdapterUtil.coreDataTypeToModelDataType((String)paramFromDataSet.getDataTypeName()));
        }
        catch (Exception exception) {}
        parameter.setDefaultValue(paramFromDataSet.getDefaultInputValue());
        if (paramFromDataSet.isOptional() != null) {
            parameter.setIsOptional(paramFromDataSet.isOptional().booleanValue());
        }
        if (paramFromDataSet.isNullable() != null) {
            parameter.setAllowNull(paramFromDataSet.isNullable().booleanValue());
        }
        if (paramFromDataSet.isInputMode() != null) {
            parameter.setIsInput(paramFromDataSet.isInputMode().booleanValue());
        }
        if (paramFromDataSet.isOutputMode() != null) {
            parameter.setIsOutput(paramFromDataSet.isOutputMode().booleanValue());
        }
        if (paramFromDataSet.isInputMode() == null && paramFromDataSet.isOutputMode() == null || !parameter.isInput() && !parameter.isOutput()) {
            parameter.setIsInput(true);
        }
        if (paramFromDataSet.getName() == null || paramFromDataSet.getName().trim().length() == 0) {
            parameter.setName(this.getUniqueName());
        } else {
            parameter.setName(paramFromDataSet.getName());
        }
        parameter.setPosition(new Integer(paramFromDataSet.getPosition()));
        return parameter;
    }

    private boolean isSameParameters(DataSetParameter param1, DataSetParameter param2) {
        boolean isSame = false;
        if (param1 == param2) {
            isSame = true;
        } else if (param1 == null || param2 == null) {
            isSame = false;
        } else if (param1.getParameterDataType().equals(param2.getParameterDataType()) && param1.isInput() == param2.isInput() && param1.isOutput() == param2.isOutput()) {
            isSame = true;
        }
        return isSame;
    }

    private void updateParams2UniqueName(List parameters) {
        List existedNames = DataSetParametersPage.collectParameterNames(parameters);
        ArrayList<String> newNames = new ArrayList<String>();
        int i = 0;
        while (i < parameters.size()) {
            DataSetParameter param = (DataSetParameter)parameters.get(i);
            String name = param.getName();
            if (newNames.contains(name)) {
                String prefix = String.valueOf(name) + '_';
                int n = 1;
                while (existedNames.contains(name = String.valueOf(prefix) + n) || newNames.contains(name)) {
                    ++n;
                }
                param.setName(name);
            }
            newNames.add(name);
            ++i;
        }
    }

    private static List collectParameterNames(List parameters) {
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < parameters.size()) {
            DataSetParameter param = (DataSetParameter)parameters.get(i);
            String name = param.getName();
            if (!StringUtil.isBlank((String)name) && !names.contains(name)) {
                names.add(name);
            }
            ++i;
        }
        return names;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        this.modelChanged = true;
    }

    protected final DataSetParameter findParameterByPosition(int position) {
        Iterator iter;
        if (this.parameters != null && (iter = this.parameters.iterator()) != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (parameter.getPosition() == null || parameter.getPosition() != position) continue;
                return (DataSetParameter)parameter.getStructure();
            }
        }
        return null;
    }

    protected final DataSetParameter findParameterByName(String name) {
        Iterator iter;
        if (this.parameters != null && (iter = this.parameters.iterator()) != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (name == null || !name.equals(parameter.getName())) continue;
                return (DataSetParameter)parameter.getStructure();
            }
        }
        return null;
    }

    protected final void refreshPositions() {
        if (this.parameters == null) {
            this.parameters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("parameters");
        }
        if (this.parameters != null) {
            int position = 1;
            Iterator iter = this.parameters.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                    if (parameter instanceof OdaDataSetParameterHandle) {
                        boolean hasNativeName;
                        boolean bl = hasNativeName = ((OdaDataSetParameterHandle)parameter).getNativeName() != null && ((OdaDataSetParameterHandle)parameter).getNativeName().trim().length() > 0;
                        if (!(hasNativeName || parameter.getPosition() != null && parameter.getPosition() == position)) {
                            parameter.setPosition(new Integer(position));
                        } else if (hasNativeName && parameter.getPosition() != null && parameter.getPosition() > 0 && parameter.getPosition() != position) {
                            parameter.setPosition(new Integer(position));
                        }
                        ++position;
                        continue;
                    }
                    parameter.setPosition(new Integer(position++));
                }
            }
        }
    }

    protected final String getUniqueName() {
        int n = 1;
        StringBuffer buf = new StringBuffer();
        while (buf.length() == 0) {
            Iterator iter;
            buf.append(PARAM_PREFIX).append(n++);
            if (this.parameters == null || (iter = this.parameters.iterator()) == null) continue;
            while (iter.hasNext() && buf.length() > 0) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (!buf.toString().equalsIgnoreCase(parameter.getName())) continue;
                buf.setLength(0);
            }
        }
        return buf.toString();
    }

    public boolean performCancel() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    public boolean performOk() {
        if (this.doSaveEmptyParameter(this.parameters)) {
            this.refreshPositions();
            if (this.modelChanged && this.getContainer() != null && this.getContainer() instanceof DataSetEditor) {
                this.modelChanged = false;
                ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
                ((DataSetEditor)this.getContainer()).updateDataSetDesign((IPropertyPage)this);
            }
            return super.performOk();
        }
        String name = this.getNoneValuedParameterName();
        boolean confirm = MessageDialog.openConfirm(null, (String)Messages.getString((String)"dataset.editor.error.title"), (String)Messages.getFormattedString((String)"dataset.editor.error.validationParameter", (Object[])new Object[]{name}));
        if (confirm) {
            ((DataSetEditor)this.getContainer()).updateDataSetDesign((IPropertyPage)this);
        }
        return confirm;
    }

    private boolean doSaveEmptyParameter(PropertyHandle parameters) {
        if (this.isJointOrDerivedDataSetHandle) {
            return true;
        }
        if (parameters == null) {
            parameters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("parameters");
        }
        if (parameters != null) {
            Iterator iter = parameters.iterator();
            String paramName = null;
            if (iter != null) {
                while (iter.hasNext()) {
                    DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                    if (this.isOdaDataSetHandle) {
                        paramName = ((OdaDataSetParameterHandle)parameter).getParamName();
                    }
                    if (!parameter.isInput() || paramName != null || parameter.getDefaultValue() != null && parameter.getDefaultValue().trim().length() != 0) continue;
                    this.setNoneValuedParameterName(parameter.getName());
                    return false;
                }
            }
        }
        return true;
    }

    private List getMultipleValueReportParameter(PropertyHandle parameters) {
        ArrayList<String> multipleValueList = new ArrayList<String>();
        if (parameters == null) {
            parameters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("parameters");
        }
        if (parameters != null && (DataSetHandle)this.getContainer().getModel() instanceof OdaDataSetHandle) {
            Iterator iter = parameters.iterator();
            String paramName = null;
            if (iter != null) {
                boolean needsRefresh = true;
                while (iter.hasNext()) {
                    DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                    paramName = ((OdaDataSetParameterHandle)parameter).getParamName();
                    if (paramName == null) continue;
                    ScalarParameterHandle handle = ParameterPageUtil.getScalarParameter(paramName, needsRefresh);
                    needsRefresh = false;
                    if (handle == null || !handle.getQualifiedName().equals(paramName) || !"multi-value".equals(handle.getParamType())) continue;
                    multipleValueList.add(paramName);
                }
            }
        }
        return multipleValueList;
    }

    public boolean canLeave() {
        this.refreshPositions();
        if (this.modelChanged && this.getContainer() != null && this.getContainer() instanceof DataSetEditor) {
            this.modelChanged = false;
            ((DataSetEditor)this.getContainer()).updateDataSetDesign((IPropertyPage)this);
        }
        return true;
    }

    public boolean canFinish() {
        this.refreshPositions();
        return this.doSaveEmptyParameter(this.parameters);
    }

    private void setPageProperties() {
        boolean parametersExist = false;
        boolean bl = parametersExist = this.parameters != null && this.parameters.getListValue() != null && this.parameters.getListValue().size() > 0;
        if (this.viewer != null) {
            this.viewer.getNewButton().setEnabled(!this.isJointOrDerivedDataSetHandle);
            this.viewer.getEditButton().setEnabled(!this.isJointOrDerivedDataSetHandle && parametersExist);
            this.viewer.getRemoveButton().setEnabled(!this.isJointOrDerivedDataSetHandle && parametersExist);
            this.viewer.getUpButton().setEnabled(!this.isJointOrDerivedDataSetHandle && parametersExist && this.parameters.getListValue().size() > 1);
            this.viewer.getDownButton().setEnabled(!this.isJointOrDerivedDataSetHandle && parametersExist && this.parameters.getListValue().size() > 1);
            this.viewer.getRemoveMenuItem().setEnabled(!this.isJointOrDerivedDataSetHandle && parametersExist);
            this.viewer.getRemoveAllMenuItem().setEnabled(!this.isJointOrDerivedDataSetHandle && parametersExist);
        }
        if (!parametersExist) {
            this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        }
    }

    public String getToolTip() {
        return Messages.getString((String)"DataSetParametersPage.Filter.Tooltip");
    }

    public String getNoneValuedParameterName() {
        return this.parameterName;
    }

    private void setNoneValuedParameterName(String name) {
        this.parameterName = name;
    }

    private void enableModelChanged() {
        ((DataSetEditor)this.getContainer()).enableLinkedParamChanged();
    }

    private class ParameterInputDialog
    extends PropertyHandleInputDialog {
        private DataSetParameterHandle structureHandle;
        private Composite defaultValueComposite;
        private Composite reportParamComposite;
        private String defaultValueString;
        private String directionString;
        private Text dataSetParamName;
        private Text nativeParameterName;
        private Combo dataType;
        private Combo direction;
        private Text defaultValue;
        private Combo linkToSalarParameter;
        private boolean inputChanged;
        private boolean isOdaDataSetHandle;

        protected ParameterInputDialog(Object structureOrHandle, boolean isOdaDataSetHandle) {
            super(structureOrHandle);
            this.structureHandle = null;
            this.defaultValueComposite = null;
            this.reportParamComposite = null;
            this.defaultValueString = "";
            this.directionString = "";
            this.dataSetParamName = null;
            this.nativeParameterName = null;
            this.dataType = null;
            this.direction = null;
            this.defaultValue = null;
            this.linkToSalarParameter = null;
            this.inputChanged = DataSetParametersPage.this.modelChanged;
            this.isOdaDataSetHandle = false;
            this.isOdaDataSetHandle = isOdaDataSetHandle;
            this.structureHandle = this.getStructureHandle(structureOrHandle);
        }

        protected void createCustomControls(Composite parent) {
            int index = 0;
            if (!this.isOdaDataSetHandle) {
                String[] dialogLables = ParameterPageUtil.dialogLabels;
                this.createNameCell(parent, dialogLables[index]);
                this.createComboCellDataType(parent, dialogLables[++index]);
                this.createComboCellDirection(parent, dialogLables[++index]);
                this.createExpressionCell(parent, dialogLables[++index]);
                this.directionChanged();
            } else {
                String[] dialogLables = ParameterPageUtil.odaDialogLabels;
                this.createNameCell(parent, dialogLables[index]);
                this.createNativeNameCell(parent, dialogLables[++index]);
                this.createComboCellDataType(parent, dialogLables[++index]);
                this.createComboCellDirection(parent, dialogLables[++index]);
                this.createExpressionCell(parent, dialogLables[++index]);
                this.createComboCellParameter(parent, dialogLables[++index]);
                this.directionChanged();
            }
        }

        private void createNameCell(Composite parent, String lable) {
            ControlProvider.createLabel(parent, lable);
            this.dataSetParamName = ControlProvider.createText(parent, this.structureHandle.getName());
            this.dataSetParamName.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.dataSetParamName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterInputDialog.this.validateSyntax();
                }
            });
        }

        private void createNativeNameCell(Composite parent, String lable) {
            ControlProvider.createLabel(parent, lable);
            this.nativeParameterName = ControlProvider.createText(parent, ((OdaDataSetParameterHandle)this.structureHandle).getNativeName());
            this.nativeParameterName.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.nativeParameterName.setEnabled(false);
        }

        private void createComboCellDataType(Composite parent, String label) {
            ControlProvider.createLabel(parent, label);
            this.dataType = ControlProvider.createCombo(parent, 8);
            this.dataType.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            if (this.structureHandle.getNativeDataType() != null && this.structureHandle.getNativeDataType() == -10) {
                this.dataType.setEnabled(false);
            } else {
                this.dataType.setItems(ParameterPageUtil.getDataTypeDisplayNames());
                this.dataType.select(Utility.findIndex((String[])this.dataType.getItems(), (String)ParameterPageUtil.getTypeDisplayName(this.structureHandle.getParameterDataType())));
                this.dataType.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ParameterInputDialog.this.validateSyntax();
                    }
                });
            }
        }

        private void createComboCellDirection(Composite parent, String label) {
            ControlProvider.createLabel(parent, label);
            this.direction = ControlProvider.createCombo(parent, 8);
            this.direction.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.direction.setItems(DataSetParametersPage.this.getDirections());
            this.directionString = DataSetParametersPage.this.getDirectionDisplayName(this.structureHandle.isInput(), this.structureHandle.isOutput());
            this.direction.select(Utility.findIndex((String[])this.direction.getItems(), (String)this.directionString));
            this.direction.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ParameterInputDialog.this.needsUpdateUI()) {
                        ParameterInputDialog.this.directionString = ParameterInputDialog.this.direction.getText();
                        ParameterInputDialog.this.directionChanged();
                        ParameterInputDialog.this.validateSyntax();
                    }
                }
            });
        }

        private boolean needsUpdateUI() {
            if (this.directionString.equals(this.direction.getText())) {
                return false;
            }
            return this.directionString.equals(ParameterPageUtil.directions[1]) || this.isOutputParameter();
        }

        private void createExpressionCell(Composite parent, String label) {
            ControlProvider.createLabel(parent, label);
            this.defaultValueComposite = ControlProvider.getDefaultComposite(parent);
            this.defaultValueString = Utility.getNonNullString((String)this.structureHandle.getDefaultValue());
            this.defaultValue = ControlProvider.createText(this.defaultValueComposite, this.defaultValueString);
            this.defaultValue.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            this.defaultValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (ParameterInputDialog.this.defaultValue.isEnabled()) {
                        ParameterInputDialog.this.validateSyntax();
                    }
                }
            });
            new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(ParameterInputDialog.this.defaultValue.getText());
                    expressionBuilder.setExpressionProvier(null);
                    if (expressionBuilder.open() == 0) {
                        ParameterInputDialog.this.defaultValue.setText(expressionBuilder.getResult().trim());
                    }
                }
            };
            ExpressionButton exprButton = this.createExpressionButton(this.defaultValueComposite);
            this.defaultValue.setData("exprButton", (Object)exprButton);
            ExpressionHandle expr = this.getExpressionHandle();
            this.defaultValue.setText(expr == null || expr.getExpression() == null ? "" : (String)expr.getExpression());
            this.defaultValue.setData("exprType", expr == null || expr.getType() == null ? null : expr.getType());
            ExpressionButton button = (ExpressionButton)this.defaultValue.getData("exprButton");
            if (button != null) {
                button.refresh();
            }
        }

        private void createComboCellParameter(Composite parent, String label) {
            ControlProvider.createLabel(parent, label);
            this.reportParamComposite = ControlProvider.getDefaultComposite(parent);
            this.linkToSalarParameter = new Combo(this.reportParamComposite, 8);
            this.linkToSalarParameter.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            this.linkToSalarParameter.setItems(ParameterPageUtil.getLinkedReportParameterNames((OdaDataSetParameterHandle)this.structureHandle));
            this.linkToSalarParameter.select(Utility.findIndex((String[])this.linkToSalarParameter.getItems(), (String)((OdaDataSetParameterHandle)this.structureHandle).getParamName()));
            this.linkToSalarParameter.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterInputDialog.this.linkToSalarParameterChanged();
                    if (ParameterInputDialog.this.linkToSalarParameter.isEnabled()) {
                        ParameterInputDialog.this.validateSyntax();
                    }
                }
            });
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ParameterInputDialog.this.updateStructureHandle();
                    OdaDataSetParameterHandle dataSetParameterHandle = (OdaDataSetParameterHandle)ParameterInputDialog.this.structureHandle;
                    String originalParamName = dataSetParameterHandle.getParamName();
                    ParameterDialog dialog = null;
                    ScalarParameterHandle handle = ParameterPageUtil.getScalarParameter(ParameterInputDialog.this.linkToSalarParameter.getText(), false);
                    boolean isCreateMode = true;
                    if (handle == null) {
                        handle = (ScalarParameterHandle)ElementProcessorFactory.createProcessor((String)"ScalarParameter").createElement(null);
                        dialog = new ParameterDialog(ParameterInputDialog.this.getParentShell(), Messages.getString((String)"ParameterGroupNodeProvider.Dialogue.ParameterNew"), false);
                        if (dataSetParameterHandle != null) {
                            ReportParameterAdapter adapter = new ReportParameterAdapter();
                            try {
                                adapter.updateLinkedReportParameter(handle, dataSetParameterHandle, ((DataSetEditor)DataSetParametersPage.this.getContainer()).getCurrentDataSetDesign());
                            }
                            catch (SemanticException semanticException) {
                            }
                            catch (OdaException odaException) {}
                        }
                        isCreateMode = true;
                    } else {
                        dialog = new ParameterDialog(ParameterInputDialog.this.getParentShell(), Messages.getString((String)"ParameterNodeProvider.dial.title.editScalar"), false);
                        isCreateMode = false;
                    }
                    handle.addListener((Listener)new ScalarParameterListener());
                    dialog.setInput((Object)handle);
                    if (dialog.open() == 0) {
                        if (dialog.getResult() instanceof ParameterHandle) {
                            ParameterHandle paramerHandle = (ParameterHandle)dialog.getResult();
                            if (isCreateMode) {
                                SlotHandle parameterSlotHandle = Utility.getReportModuleHandle().getParameters();
                                try {
                                    parameterSlotHandle.add((DesignElementHandle)paramerHandle);
                                    ParameterInputDialog.this.linkToSalarParameter.add(paramerHandle.getQualifiedName());
                                }
                                catch (ContentException e) {
                                    ExceptionHandler.handle((Throwable)e);
                                }
                                catch (NameException e) {
                                    ExceptionHandler.handle((Throwable)e);
                                }
                            }
                            ParameterInputDialog.this.linkToSalarParameter.setItems(ParameterPageUtil.getLinkedReportParameterNames((OdaDataSetParameterHandle)ParameterInputDialog.this.structureHandle));
                            ParameterInputDialog.this.linkToSalarParameter.select(Utility.findIndex((String[])ParameterInputDialog.this.linkToSalarParameter.getItems(), (String)paramerHandle.getQualifiedName()));
                        }
                    } else {
                        dataSetParameterHandle.setParamName(originalParamName);
                    }
                }
            };
            ControlProvider.createButton(this.reportParamComposite, 8, (SelectionListener)listener);
        }

        protected void rollback() {
            DataSetParameter structure = DataSetParametersPage.this.getStructure(this.getStructureOrHandle());
            if (DataSetParametersPage.this.originalStructure != null) {
                structure.setName(DataSetParametersPage.this.originalStructure.getName());
                structure.setParameterDataType(DataSetParametersPage.this.originalStructure.getParameterDataType());
                structure.setIsInput(DataSetParametersPage.this.originalStructure.isInput());
                structure.setIsOutput(DataSetParametersPage.this.originalStructure.isOutput());
                structure.setDefaultValue(DataSetParametersPage.this.originalStructure.getDefaultValue());
                if (this.isOdaDataSetHandle) {
                    ((OdaDataSetParameter)structure).setParamName(((OdaDataSetParameter)DataSetParametersPage.this.originalStructure).getParamName());
                }
                DataSetParametersPage.this.originalStructure = null;
            } else {
                try {
                    DataSetParametersPage.this.parameters.removeItem((Object)structure);
                    DataSetParametersPage.this.viewer.getViewer().refresh();
                }
                catch (PropertyValueException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            DataSetParametersPage.this.modelChanged = this.inputChanged;
        }

        protected IStatus validateSemantics(Object structureOrHandle) {
            Status status = this.updateStructureHandle();
            if (status != null && status.getSeverity() == 4) {
                return status;
            }
            return this.getOKStatus();
        }

        private ExpressionButton createExpressionButton(Composite composite) {
            ExpressionButton expressionButton = UIUtil.createExpressionButton((Composite)composite, (int)8);
            IExpressionHelper helper = new IExpressionHelper(){

                public String getExpression() {
                    return ParameterInputDialog.this.defaultValue.getText();
                }

                public void setExpression(String expression) {
                    if (expression != null) {
                        ParameterInputDialog.this.defaultValue.setText(expression);
                    }
                }

                public void notifyExpressionChangeEvent(String oldExpression, String newExpression) {
                }

                public IExpressionProvider getExpressionProvider() {
                    return new ExpressionProvider((DesignElementHandle)((DataSetHandle)DataSetParametersPage.this.getContainer().getModel()));
                }

                public String getExpressionType() {
                    return (String)ParameterInputDialog.this.defaultValue.getData("exprType");
                }

                public void setExpressionType(String exprType) {
                    ParameterInputDialog.this.defaultValue.setData("exprType", (Object)exprType);
                }
            };
            expressionButton.setExpressionHelper(helper);
            return expressionButton;
        }

        private ExpressionHandle getExpressionHandle() {
            String propName = "defaultValue";
            return this.structureHandle.getExpressionProperty(propName);
        }

        private Status updateStructureHandle() {
            try {
                this.structureHandle.setName(this.dataSetParamName.getText());
                this.structureHandle.setParameterDataType(ParameterPageUtil.getTypeName(this.dataType.getText()));
                this.setDirection(this.direction.getText());
                this.structureHandle.setExpressionProperty("defaultValue", new Expression((Object)(this.defaultValue.isEnabled() ? this.defaultValue.getText().trim() : this.defaultValueString), (String)this.defaultValue.getData("exprType")));
                if (this.isOdaDataSetHandle) {
                    ((OdaDataSetParameterHandle)this.structureHandle).setParamName(Utility.findIndex((String[])this.linkToSalarParameter.getItems(), (String)this.linkToSalarParameter.getText()) == 0 ? null : this.linkToSalarParameter.getText());
                }
            }
            catch (SemanticException e) {
                return this.getMiscStatus(4, Utility.getNonNullString((String)e.getMessage()));
            }
            return null;
        }

        private void setDirection(String direction) {
            if (direction == null || direction.equals("")) {
                return;
            }
            if (direction.equals(ParameterPageUtil.directions[0])) {
                this.structureHandle.setIsInput(true);
                this.structureHandle.setIsOutput(false);
            } else if (direction.equals(ParameterPageUtil.directions[1])) {
                this.structureHandle.setIsInput(false);
                this.structureHandle.setIsOutput(true);
            } else if (direction.equals(ParameterPageUtil.directions[2])) {
                this.structureHandle.setIsInput(true);
                this.structureHandle.setIsOutput(true);
            }
        }

        protected IStatus validateSyntax(Object structureOrHandle) {
            if (!this.isUniqueName()) {
                return this.getMiscStatus(4, Messages.getString((String)"dataset.editor.error.duplicateParameterName"));
            }
            if (this.isBlankProperty(this.dataSetParamName.getText())) {
                return this.getBlankPropertyStatus(ParameterPageUtil.dialogLabels[0]);
            }
            if (this.checkParamDataType()) {
                return this.getMiscStatus(2, Messages.getString((String)"DataSetParameterPage.warning.UnmatchedParamDataType"));
            }
            return this.getOKStatus();
        }

        private boolean checkParamDataType() {
            return this.linkToSalarParameter != null && this.linkToSalarParameter.isEnabled() && this.linkToSalarParameter.getSelectionIndex() > 0 && !this.isMatchedParamDataType();
        }

        private boolean isMatchedParamDataType() {
            String dataSetParamType = ParameterPageUtil.getTypeName(this.dataType.getText());
            ScalarParameterHandle scalarParam = ParameterPageUtil.getScalarParameter(this.linkToSalarParameter.getText(), false);
            if (dataSetParamType != null && scalarParam != null) {
                return dataSetParamType.equalsIgnoreCase(scalarParam.getDataType());
            }
            return true;
        }

        private boolean isUniqueName() {
            DataSetParameter structure = DataSetParametersPage.this.getStructure(this.getStructureOrHandle());
            Iterator iter = DataSetParametersPage.this.parameters.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    DataSetParameterHandle handle = (DataSetParameterHandle)iter.next();
                    if (structure == handle.getStructure() || !handle.getName().equals(this.dataSetParamName.getText())) continue;
                    return false;
                }
            }
            return true;
        }

        private void directionChanged() {
            if (this.isOutputParameter()) {
                this.enableComposite(this.defaultValueComposite, false);
                this.defaultValue.setText("");
                this.defaultValueString = "";
                if (this.isOdaDataSetHandle) {
                    this.enableComposite(this.reportParamComposite, false);
                    this.linkToSalarParameter.select(0);
                }
            } else if (this.isOdaDataSetHandle) {
                this.enableComposite(this.reportParamComposite, true);
                this.linkToSalarParameterChanged();
            } else {
                this.enableComposite(this.defaultValueComposite, true);
            }
        }

        private void linkToSalarParameterChanged() {
            String paramName;
            String string = paramName = Utility.findIndex((String[])this.linkToSalarParameter.getItems(), (String)this.linkToSalarParameter.getText()) == 0 ? null : this.linkToSalarParameter.getText();
            if (paramName == null) {
                this.enableComposite(this.defaultValueComposite, this.linkToSalarParameter.isEnabled());
                this.defaultValue.setText(this.defaultValueString);
            } else {
                if (this.defaultValue.isEnabled()) {
                    this.defaultValueString = this.defaultValue.getText();
                }
                this.structureHandle.setDefaultValue("");
                this.enableComposite(this.defaultValueComposite, false);
                this.defaultValue.setText(NONE_DEFAULT_VALUE);
            }
        }

        private boolean isOutputParameter() {
            return this.direction.getText().equals(ParameterPageUtil.directions[1]);
        }

        private void enableComposite(Composite composite, boolean enable) {
            if (composite.isEnabled() != enable) {
                composite.setEnabled(enable);
                Control[] controls = composite.getChildren();
                int i = 0;
                while (i < controls.length) {
                    controls[i].setEnabled(enable);
                    ++i;
                }
            }
        }

        private DataSetParameterHandle getStructureHandle(Object structureOrHandle) {
            if (structureOrHandle instanceof DataSetParameterHandle) {
                return (DataSetParameterHandle)structureOrHandle;
            }
            DataSetParameterHandle handle = null;
            try {
                handle = (DataSetParameterHandle)DataSetParametersPage.this.parameters.addItem((IStructure)((DataSetParameter)structureOrHandle));
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            assert (handle != null);
            return handle;
        }

        protected String getTitle() {
            return this.getStructureOrHandle() instanceof Structure ? Messages.getString((String)"DataSetParameterBindingInputDialog.Title.NewParameter") : Messages.getString((String)"DataSetParameterBindingInputDialog.Title.EditParameter");
        }
    }

    private class ParameterViewContentProvider
    implements IStructuredContentProvider {
        private final String separator = "::";

        private ParameterViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof JointDataSetHandle) {
                JointDataSetHandle handle = (JointDataSetHandle)inputElement;
                List params = this.getSubDataSetParameters(handle, "", 0);
                return params.toArray();
            }
            if (!(inputElement instanceof PropertyHandle)) {
                return new Object[0];
            }
            Iterator iter = ((PropertyHandle)inputElement).iterator();
            ArrayList params = new ArrayList(10);
            if (iter != null) {
                while (iter.hasNext()) {
                    params.add(iter.next());
                }
            }
            DataSetParametersPage.this.refreshPositions();
            return params.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        /*
         * Unable to fully structure code
         */
        private List getSubDataSetParameters(JointDataSetHandle jointDataSetHandle, String prefix, int count) {
            block6: {
                subDataSetParams = new ArrayList<DataSetParameter>();
                children = jointDataSetHandle.dataSetsIterator();
                if (jointDataSetHandle.getDataSetNames().size() != 1 || !children.hasNext()) ** GOTO lbl37
                nextElement = (DataSetHandle)children.next();
                prefix = String.valueOf(prefix) + nextElement.getName();
                if (nextElement instanceof JointDataSetHandle) {
                    subDataSetParams.addAll(this.getSubDataSetParameters((JointDataSetHandle)nextElement, String.valueOf(prefix) + "1" + "::", count));
                    subDataSetParams.addAll(this.getSubDataSetParameters((JointDataSetHandle)nextElement, String.valueOf(prefix) + "2" + "::", count += subDataSetParams.size()));
                } else {
                    params = nextElement.parametersIterator();
                    while (params.hasNext()) {
                        param = (DataSetParameterHandle)params.next();
                        v0 = ++count;
                        newParam1 = this.createDataSetParameter(param, String.valueOf(prefix) + "1", v0);
                        newParam2 = this.createDataSetParameter(param, String.valueOf(prefix) + "2", ++count);
                        subDataSetParams.add(newParam1);
                        subDataSetParams.add(newParam2);
                    }
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    nextElement = (DataSetHandle)children.next();
                    preFixStr = String.valueOf(prefix) + nextElement.getName();
                    if (nextElement instanceof JointDataSetHandle) {
                        subDataSetParams.addAll(this.getSubDataSetParameters((JointDataSetHandle)nextElement, String.valueOf(preFixStr) + "::", count));
                        count += subDataSetParams.size();
                        continue;
                    }
                    params = nextElement.parametersIterator();
                    while (params.hasNext()) {
                        param = (DataSetParameterHandle)params.next();
                        subDataSetParams.add(this.createDataSetParameter(param, preFixStr, ++count));
                    }
lbl37:
                    // 3 sources

                    ** while (children.hasNext())
                }
            }
            return subDataSetParams;
        }

        private DataSetParameter createDataSetParameter(DataSetParameterHandle parameter, String dataSetName, int position) {
            OdaDataSetParameter dataSetParameter = null;
            if (parameter instanceof OdaDataSetParameterHandle) {
                dataSetParameter = new OdaDataSetParameter();
                dataSetParameter.setParamName(((OdaDataSetParameterHandle)parameter).getParamName());
            } else {
                dataSetParameter = new DataSetParameter();
            }
            dataSetParameter.setDataType(parameter.getDataType());
            dataSetParameter.setAllowNull(parameter.allowNull());
            dataSetParameter.setDefaultValue(parameter.getDefaultValue());
            dataSetParameter.setIsInput(parameter.isInput());
            dataSetParameter.setIsOutput(parameter.isOutput());
            dataSetParameter.setName(String.valueOf(dataSetName) + "::" + parameter.getName());
            dataSetParameter.setIsOptional(parameter.isOptional());
            dataSetParameter.setPosition(Integer.valueOf(position));
            return dataSetParameter;
        }
    }

    private class ParameterViewLableProvider
    implements ITableLabelProvider {
        private DataSetHandle dataSetHandle;

        public ParameterViewLableProvider(DataSetHandle dataSetHandle) {
            this.dataSetHandle = dataSetHandle;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String value = null;
            DataSetParameter parameter = DataSetParametersPage.this.getStructure(element);
            value = DataSetParametersPage.this.isOdaDataSetHandle ? this.getOdaParametersValue((OdaDataSetParameter)parameter, columnIndex) : (DataSetParametersPage.this.isJointOrDerivedDataSetHandle ? this.getJointDataSetParametersValue(parameter, columnIndex) : this.getParametersValue(parameter, columnIndex));
            return value == null ? "" : value;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        private String getJointDataSetParametersValue(DataSetParameter parameter, int columnIndex) {
            if (columnIndex == 4) {
                String linkedParamName;
                if (parameter instanceof OdaDataSetParameter && (linkedParamName = ((OdaDataSetParameter)parameter).getParamName()) != null && linkedParamName.trim().length() > 0) {
                    return NONE_DEFAULT_VALUE;
                }
                return parameter.getDefaultValue();
            }
            if (columnIndex == 5) {
                String value = null;
                if (parameter instanceof OdaDataSetParameter) {
                    value = ((OdaDataSetParameter)parameter).getParamName();
                }
                return value == null || value.trim().length() == 0 ? UNLINKED_REPORT_PARAM : value;
            }
            return this.getParametersValue(parameter, columnIndex);
        }

        private String getParametersValue(DataSetParameter parameter, int columnIndex) {
            String value = null;
            switch (columnIndex) {
                case 0: {
                    if (parameter.getPosition() == null) break;
                    value = parameter.getPosition().toString();
                    break;
                }
                case 1: {
                    value = parameter.getName();
                    break;
                }
                case 2: {
                    value = ParameterPageUtil.getTypeDisplayName(parameter.getParameterDataType());
                    break;
                }
                case 3: {
                    value = DataSetParametersPage.this.getDirectionDisplayName(parameter.isInput(), parameter.isOutput());
                    break;
                }
                case 4: {
                    value = parameter.getDefaultValue();
                }
            }
            return value;
        }

        private String getOdaParametersValue(OdaDataSetParameter parameter, int columnIndex) {
            String value = null;
            switch (columnIndex) {
                case 0: {
                    if (parameter.getPosition() != null && parameter.getPosition() > 0) {
                        value = parameter.getPosition().toString();
                        break;
                    }
                    value = "";
                    break;
                }
                case 1: {
                    value = parameter.getName();
                    break;
                }
                case 2: {
                    value = parameter.getNativeName();
                    break;
                }
                case 3: {
                    if (parameter.getNativeDataType() != null && parameter.getNativeDataType() == -10) {
                        value = null;
                        break;
                    }
                    value = ParameterPageUtil.getTypeDisplayName(parameter.getParameterDataType());
                    break;
                }
                case 4: {
                    value = DataSetParametersPage.this.getDirectionDisplayName(parameter.isInput(), parameter.isOutput());
                    break;
                }
                case 5: {
                    if (parameter.getParamName() == null || parameter.getParamName().trim().length() == 0) {
                        value = parameter.getDefaultValue();
                        break;
                    }
                    value = NONE_DEFAULT_VALUE;
                    break;
                }
                case 6: {
                    value = parameter.getParamName();
                    if (value != null && value.trim().length() != 0) break;
                    value = UNLINKED_REPORT_PARAM;
                }
            }
            return value;
        }
    }

    private class ScalarParameterListener
    implements Listener {
        private ScalarParameterListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            DataSetParametersPage.this.modelChanged = true;
            DataSetParametersPage.this.enableModelChanged();
        }
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DataSetParametersPage.this.setPageProperties();
        }
    }
}

