/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleInputDialog;
import org.eclipse.birt.report.designer.data.ui.util.ControlProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataSetExpressionProvider;
import org.eclipse.birt.report.designer.data.ui.util.SelectValueFetcher;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.MultiValueCombo;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ValueCombo;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

class FilterConditionBuilder
extends PropertyHandleInputDialog {
    private static String[] cellLabels = new String[]{Messages.getString((String)"dataset.editor.inputDialog.expression"), Messages.getString((String)"dataset.editor.inputDialog.operator"), Messages.getString((String)"dataset.editor.inputDialog.value1"), Messages.getString((String)"dataset.editor.inputDialog.value2")};
    protected static Logger logger = Logger.getLogger(FilterConditionBuilder.class.getName());
    public static final String DLG_TITLE_NEW = Messages.getString((String)"FilterConditionBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"FilterConditionBuilder.DialogTitle.Edit");
    public static final String DLG_MESSAGE_NEW = Messages.getString((String)"FilterConditionBuilder.DialogMessage.New");
    public static final String DLG_MESSAGE_EDIT = Messages.getString((String)"FilterConditionBuilder.DialogMessage.Edit");
    protected transient String[] popupItems = null;
    private static String[] actions = new String[]{Messages.getString((String)"ExpressionValueCellEditor.selectValueAction"), Messages.getString((String)"ExpressionValueCellEditor.buildExpressionAction")};
    protected Label label1;
    protected Label label2;
    protected Label valueLabel1;
    protected Label valueLabel2;
    protected List valueList = new ArrayList();
    protected static final String[][] OPERATOR;
    private ParamBindingHandle[] bindingParams = null;
    private transient boolean refreshItems = true;
    protected transient DataSetHandle currentItem = null;
    protected static String[] EMPTY_ARRAY;
    protected int valueVisible;
    protected Table table;
    protected TableViewer tableViewer;
    protected IChoiceSet choiceSet;
    protected Combo expression;
    protected Combo operator;
    protected Button addBtn;
    protected Button editBtn;
    protected Button delBtn;
    protected Button delAllBtn;
    protected ValueCombo exprValue1;
    protected ValueCombo exprValue2;
    protected MultiValueCombo addExprValue;
    protected Composite valueListComposite;
    protected Label value1Label;
    protected Label value2Label;
    protected static final String VALUE_OF_THIS_DATA_ITEM;
    private String[] dataSetColumns;
    private Object inputHandle;
    protected ValueCombo.ISelection expValueAction = new ValueCombo.ISelection(){

        public String doSelection(String input) {
            String retValue = null;
            ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
            dialog.setExpressionProvier(FilterConditionBuilder.this.expressionProvider);
            if (dialog.open() == 0) {
                retValue = dialog.getResult();
            }
            return retValue;
        }
    };
    protected ValueCombo.ISelection selectValueAction = new ValueCombo.ISelection(){

        public String doSelection(String input) {
            String[] value = new String[1];
            boolean returnValue = false;
            try {
                List selectValueList = FilterConditionBuilder.this.getSelectValueList();
                SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                dialog.setSelectedValueList((Collection)selectValueList);
                if (FilterConditionBuilder.this.valueListComposite != null && FilterConditionBuilder.this.valueListComposite.isEnabled()) {
                    dialog.setMultipleSelection(true);
                }
                if (FilterConditionBuilder.this.bindingParams != null) {
                    dialog.setBindingParams(FilterConditionBuilder.this.bindingParams);
                }
                if (dialog.open() == 0) {
                    returnValue = true;
                    value = dialog.getSelectedExprValues();
                }
            }
            catch (Exception ex) {
                MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
            }
            return returnValue ? DEUtil.resolveNull((String)value[0]) : input;
        }
    };
    protected MultiValueCombo.ISelection mAddSelValueAction = new MultiValueCombo.ISelection(){

        public String[] doSelection(String input) {
            String[] retValue = null;
            try {
                List selectValueList = FilterConditionBuilder.this.getSelectValueList();
                SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                dialog.setMultipleSelection(true);
                dialog.setSelectedValueList((Collection)selectValueList);
                if (FilterConditionBuilder.this.bindingParams != null) {
                    dialog.setBindingParams(FilterConditionBuilder.this.bindingParams);
                }
                if (dialog.open() == 0) {
                    retValue = dialog.getSelectedExprValues();
                }
            }
            catch (Exception ex) {
                MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
            }
            return retValue;
        }

        public void doAfterSelection(MultiValueCombo combo) {
            FilterConditionBuilder.this.addBtn.setEnabled(false);
            if (FilterConditionBuilder.this.addExprValue.getSelStrings().length == 1) {
                FilterConditionBuilder.this.addExprValue.setText(DEUtil.resolveNull((String)FilterConditionBuilder.this.addExprValue.getSelStrings()[0]));
            } else if (FilterConditionBuilder.this.addExprValue.getSelStrings().length > 1) {
                FilterConditionBuilder.this.addExprValue.setText("");
            }
            boolean change = false;
            int i = 0;
            while (i < FilterConditionBuilder.this.addExprValue.getSelStrings().length) {
                if (FilterConditionBuilder.this.valueList.indexOf(DEUtil.resolveNull((String)FilterConditionBuilder.this.addExprValue.getSelStrings()[i])) < 0) {
                    FilterConditionBuilder.this.valueList.add(DEUtil.resolveNull((String)FilterConditionBuilder.this.addExprValue.getSelStrings()[i]));
                    change = true;
                }
                ++i;
            }
            if (change) {
                FilterConditionBuilder.this.tableViewer.refresh();
                FilterConditionBuilder.this.updateButtons();
                FilterConditionBuilder.this.addExprValue.setFocus();
            }
        }
    };
    protected MultiValueCombo.ISelection mAddExpValueAction = new MultiValueCombo.ISelection(){

        public String[] doSelection(String input) {
            String[] retValue = null;
            ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
            dialog.setExpressionProvier(FilterConditionBuilder.this.expressionProvider);
            if (dialog.open() == 0 && dialog.getResult().length() != 0) {
                retValue = new String[]{dialog.getResult()};
            }
            return retValue;
        }

        public void doAfterSelection(MultiValueCombo combo) {
            FilterConditionBuilder.this.mAddSelValueAction.doAfterSelection(combo);
        }
    };
    protected ITableLabelProvider tableLableProvier = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return (String)element;
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    protected IStructuredContentProvider tableContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }
    };
    protected SelectionListener OpoertorSelection = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            String value = FilterConditionBuilder.getValueForOperator(FilterConditionBuilder.this.operator.getText());
            FilterConditionBuilder.this.valueVisible = FilterConditionBuilder.determineValueVisible(value);
            if (FilterConditionBuilder.this.valueVisible == 3) {
                FilterConditionBuilder.this.createValueListComposite(FilterConditionBuilder.this.operator.getParent().getParent());
                if (FilterConditionBuilder.this.inputHandle != null) {
                    FilterConditionBuilder.this.valueList = FilterConditionBuilder.this.inputHandle instanceof FilterCondition ? new ArrayList(((FilterCondition)FilterConditionBuilder.this.inputHandle).getValue1List()) : new ArrayList(((FilterConditionHandle)FilterConditionBuilder.this.inputHandle).getValue1List());
                }
                int i = 0;
                while (i < FilterConditionBuilder.this.valueList.size()) {
                    if (FilterConditionBuilder.this.valueList.get(i) == null) {
                        FilterConditionBuilder.this.valueList.remove(i);
                    }
                    ++i;
                }
                FilterConditionBuilder.this.tableViewer.setInput((Object)FilterConditionBuilder.this.valueList);
            } else {
                FilterConditionBuilder.this.createValueInputComposite(FilterConditionBuilder.this.operator.getParent().getParent());
                if (FilterConditionBuilder.this.inputHandle != null) {
                    if (FilterConditionBuilder.this.inputHandle instanceof FilterCondition) {
                        FilterConditionBuilder.this.exprValue1.setText(DEUtil.resolveNull((String)((FilterCondition)FilterConditionBuilder.this.inputHandle).getValue1()));
                        FilterConditionBuilder.this.exprValue2.setText(DEUtil.resolveNull((String)((FilterCondition)FilterConditionBuilder.this.inputHandle).getValue2()));
                    } else {
                        FilterConditionBuilder.this.exprValue1.setText(DEUtil.resolveNull((String)((FilterConditionHandle)FilterConditionBuilder.this.inputHandle).getValue1()));
                        FilterConditionBuilder.this.exprValue2.setText(DEUtil.resolveNull((String)((FilterConditionHandle)FilterConditionBuilder.this.inputHandle).getValue2()));
                    }
                }
            }
            if (FilterConditionBuilder.this.valueVisible == 0) {
                FilterConditionBuilder.this.exprValue1.setEnabled(false);
                FilterConditionBuilder.this.exprValue2.setEnabled(false);
            } else if (FilterConditionBuilder.this.valueVisible == 1) {
                FilterConditionBuilder.this.exprValue1.setEnabled(true);
                FilterConditionBuilder.this.exprValue2.setEnabled(false);
            } else if (FilterConditionBuilder.this.valueVisible == 2) {
                FilterConditionBuilder.this.exprValue1.setEnabled(true);
                FilterConditionBuilder.this.exprValue2.setEnabled(true);
            }
            FilterConditionBuilder.this.updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    protected Listener ComboModify = new Listener(){

        public void handleEvent(Event e) {
            Combo combo = (Combo)e.widget;
            String newValue = combo.getText();
            String value = FilterConditionBuilder.this.getExpression(newValue);
            if (value != null) {
                newValue = value;
            }
            combo.setText(newValue);
            FilterConditionBuilder.this.updateButtons();
        }
    };
    protected IExpressionProvider expressionProvider;

    static {
        EMPTY_ARRAY = new String[0];
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet((String)"FilterCondition", (String)"operator");
        IChoice[] chs = chset.getChoices();
        OPERATOR = new String[chs.length][2];
        int i = 0;
        while (i < chs.length) {
            FilterConditionBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            FilterConditionBuilder.OPERATOR[i][1] = chs[i].getName();
            ++i;
        }
        VALUE_OF_THIS_DATA_ITEM = Messages.getString((String)"FilterConditionBuilder.choice.ValueOfThisDataItem");
    }

    protected FilterConditionBuilder(Object structureOrHandle) {
        super(structureOrHandle);
        this.inputHandle = this.getStructureOrHandle();
    }

    public void setBindingParams(Iterator parameters) {
        if (parameters == null) {
            return;
        }
        ArrayList params = new ArrayList();
        while (parameters.hasNext()) {
            params.add(parameters.next());
        }
        this.bindingParams = new ParamBindingHandle[params.size()];
        int i = 0;
        while (i < this.bindingParams.length) {
            this.bindingParams[i] = (ParamBindingHandle)params.get(i);
            ++i;
        }
    }

    public static String getValueForOperator(String name) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][0].equals(name)) {
                return OPERATOR[i][1];
            }
            ++i;
        }
        return null;
    }

    public static int determineValueVisible(String operatorValue) {
        if ("any".equals(operatorValue) || "is-false".equals(operatorValue) || "is-true".equals(operatorValue) || "is-null".equals(operatorValue) || "is-not-null".equals(operatorValue)) {
            return 0;
        }
        if ("lt".equals(operatorValue) || "le".equals(operatorValue) || "eq".equals(operatorValue) || "ne".equals(operatorValue) || "ge".equals(operatorValue) || "gt".equals(operatorValue) || "like".equals(operatorValue)) {
            return 1;
        }
        if ("between".equals(operatorValue) || "not-between".equals(operatorValue)) {
            return 2;
        }
        if ("in".equals(operatorValue) || "not-in".equals(operatorValue)) {
            return 3;
        }
        return 1;
    }

    public static String getNameForOperator(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return OPERATOR[i][0];
            }
            ++i;
        }
        return "";
    }

    protected static int getIndexForOperatorValue(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected void createFilterConditionContent(Composite innerParent) {
        Label lb = new Label(innerParent, 0);
        lb.setText(Messages.getString((String)"FilterConditionBuilder.text.Condition"));
        Composite condition = new Composite(innerParent, 0);
        this.refreshList();
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 3;
        gd.widthHint = 400;
        gd.heightHint = 200;
        condition.setLayoutData((Object)gd);
        GridLayout glayout = new GridLayout(3, false);
        condition.setLayout((Layout)glayout);
        ControlProvider.createLabel(condition, cellLabels[0]);
        Composite composite = ControlProvider.getDefaultComposite(condition);
        this.expression = new Combo(composite, 0);
        this.expression.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
        this.expression.addListener(13, this.ComboModify);
        this.expression.setItems(this.dataSetColumns);
        if (this.expression.getItemCount() == 0) {
            this.expression.add(DEUtil.resolveNull(null));
        }
        this.expression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterConditionBuilder.this.updateButtons();
            }
        });
        this.createExpressionBuilder(composite, (Control)this.expression);
        ControlProvider.createLabel(condition, cellLabels[1]);
        composite = ControlProvider.getDefaultComposite(condition);
        this.operator = new Combo(composite, 8);
        int i = 0;
        while (i < OPERATOR.length) {
            this.operator.add(OPERATOR[i][0]);
            ++i;
        }
        gd = ControlProvider.getGridDataWithHSpan(1);
        this.operator.setLayoutData((Object)gd);
        this.operator.addSelectionListener(this.OpoertorSelection);
        this.createValueInputComposite(condition);
        if (this.inputHandle != null) {
            this.syncViewProperties();
        }
        new Label(innerParent, 258).setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
    }

    private void createExpressionBuilder(Composite condition, final Control c) {
        Button expBuilder = new Button(condition, 8);
        UIUtil.setExpressionButtonImage((Button)expBuilder);
        expBuilder.setToolTipText(Messages.getString((String)"FilterConditionBuilder.tooltip.ExpBuilder"));
        expBuilder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConditionBuilder.this.editValue(c);
            }
        });
    }

    public void setDataSetColumns(String[] dataSetColumns) {
        this.dataSetColumns = dataSetColumns;
    }

    private void createValueInputComposite(Composite condition) {
        if (this.exprValue1 != null && !this.exprValue1.isDisposed()) {
            return;
        }
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            this.valueListComposite.dispose();
            this.valueListComposite = null;
        }
        this.valueLabel1 = ControlProvider.createLabel(condition, cellLabels[2]);
        this.exprValue1 = this.createValueCombo(condition);
        this.valueLabel2 = ControlProvider.createLabel(condition, cellLabels[3]);
        this.exprValue2 = this.createValueCombo(condition);
        condition.getParent().layout(true, true);
        if (this.getButtonBar() != null) {
            condition.getShell().pack();
        }
    }

    private ValueCombo createValueCombo(Composite condition) {
        GridData expgd = new GridData(768);
        expgd.minimumWidth = 100;
        expgd.horizontalSpan = 2;
        ValueCombo exprValue = new ValueCombo(condition, 2048);
        exprValue.setLayoutData((Object)expgd);
        exprValue.setItems(this.popupItems);
        exprValue.addSelectionListener(0, this.selectValueAction);
        exprValue.addSelectionListener(1, this.expValueAction);
        exprValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterConditionBuilder.this.updateButtons();
            }
        });
        return exprValue;
    }

    private void createValueListComposite(Composite parent) {
        parent.setEnabled(true);
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            return;
        }
        if (this.exprValue1 != null && !this.exprValue1.isDisposed()) {
            this.exprValue1.dispose();
            this.exprValue1 = null;
            this.exprValue2.dispose();
            this.exprValue2 = null;
            this.valueLabel1.dispose();
            this.valueLabel1 = null;
            this.valueLabel2.dispose();
            this.valueLabel2 = null;
        }
        this.valueListComposite = new Composite(parent, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 4;
        this.valueListComposite.setLayoutData((Object)gdata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.valueListComposite.setLayout((Layout)layout);
        this.createValueTable(this.valueListComposite);
        Composite rightPart = new Composite(this.valueListComposite, 0);
        GridData data = new GridData(1808);
        rightPart.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        rightPart.setLayout((Layout)layout);
        this.editBtn = new Button(rightPart, 8);
        this.editBtn.setText(Messages.getString((String)"FilterConditionBuilder.multipleValue.button.edit"));
        this.editBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.edit.tooltip"));
        this.setButtonLayoutData(this.editBtn);
        this.editBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)FilterConditionBuilder.this.tableViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof String) {
                    String initValue = (String)selection.getFirstElement();
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(FilterConditionBuilder.this.getShell(), initValue);
                    expressionBuilder.setExpressionProvier(FilterConditionBuilder.this.expressionProvider);
                    if (expressionBuilder.open() == 0) {
                        String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
                        if (result == null || result.trim().length() == 0) {
                            MessageDialog.openWarning((Shell)FilterConditionBuilder.this.tableViewer.getControl().getShell(), (String)Messages.getString((String)"dataset.editor.error.title"), (String)Messages.getString((String)"dataset.error.emptyexpression"));
                        } else {
                            int index = FilterConditionBuilder.this.table.getSelectionIndex();
                            FilterConditionBuilder.this.valueList.remove(index);
                            FilterConditionBuilder.this.valueList.add(index, result);
                            FilterConditionBuilder.this.tableViewer.refresh();
                            FilterConditionBuilder.this.table.select(index);
                        }
                    }
                    FilterConditionBuilder.this.updateButtons();
                } else {
                    FilterConditionBuilder.this.editBtn.setEnabled(false);
                }
            }
        });
        this.delBtn = new Button(rightPart, 8);
        this.delBtn.setText(Messages.getString((String)"FilterConditionBuilder.multipleValue.button.remove"));
        this.delBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.delete.tooltip"));
        this.setButtonLayoutData(this.delBtn);
        this.delBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = FilterConditionBuilder.this.table.getSelectionIndex();
                if (index > -1) {
                    FilterConditionBuilder.this.valueList.remove(index);
                    FilterConditionBuilder.this.tableViewer.refresh();
                    if (FilterConditionBuilder.this.valueList.size() > 0) {
                        if (FilterConditionBuilder.this.valueList.size() <= index) {
                            --index;
                        }
                        FilterConditionBuilder.this.table.select(index);
                    }
                    FilterConditionBuilder.this.updateButtons();
                } else {
                    FilterConditionBuilder.this.delBtn.setEnabled(false);
                }
            }
        });
        this.delAllBtn = new Button(rightPart, 8);
        this.delAllBtn.setText(Messages.getString((String)"FilterConditionBuilder.multipleValue.button.removeAll"));
        this.delAllBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.deleteall.tooltip"));
        this.setButtonLayoutData(this.delAllBtn);
        this.delAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int count = FilterConditionBuilder.this.valueList.size();
                if (count > 0) {
                    FilterConditionBuilder.this.valueList.clear();
                    FilterConditionBuilder.this.tableViewer.refresh();
                    FilterConditionBuilder.this.updateButtons();
                } else {
                    FilterConditionBuilder.this.delAllBtn.setEnabled(false);
                }
            }
        });
        parent.getParent().layout(true, true);
    }

    private void createAddButton(Composite container) {
        Label valueLabel = new Label(container, 0x1000400);
        valueLabel.setText(Messages.getString((String)"FilterConditionBuilder.multipleValue.label"));
        GridData expgd = new GridData(768);
        expgd.minimumWidth = 100;
        expgd.horizontalSpan = 2;
        this.addExprValue = new MultiValueCombo(container, 2048);
        this.addExprValue.setLayoutData((Object)expgd);
        this.addExprValue.setItems(this.popupItems);
        this.addExprValue.addSelectionListener(0, this.mAddSelValueAction);
        this.addExprValue.addSelectionListener(1, this.mAddExpValueAction);
        this.addExprValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterConditionBuilder.this.updateButtons();
            }
        });
        this.addBtn = new Button(container, 8);
        this.addBtn.setText(Messages.getString((String)"FilterConditionBuilder.multipleValue.button.add"));
        this.addBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.add.tooltip"));
        this.addBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String value = FilterConditionBuilder.this.addExprValue.getText();
                if (FilterConditionBuilder.this.valueList.indexOf(value) < 0) {
                    FilterConditionBuilder.this.valueList.add(value);
                    FilterConditionBuilder.this.tableViewer.refresh();
                    FilterConditionBuilder.this.updateButtons();
                    FilterConditionBuilder.this.addExprValue.setFocus();
                    FilterConditionBuilder.this.addExprValue.setText("");
                } else {
                    FilterConditionBuilder.this.addBtn.setEnabled(false);
                }
            }
        });
    }

    public void create() {
        super.create();
        Point pt = this.getShell().computeSize(-1, -1);
        pt.x = Math.max(pt.x, 400);
        pt.y = Math.max(pt.y, 365);
        this.getShell().setSize(pt);
        this.getShell().setText(this.getTitle());
    }

    private void createValueTable(Composite parent) {
        Group container = new Group(parent, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 3;
        container.setLayoutData((Object)gdata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 3;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        container.setLayout((Layout)layout);
        this.createAddButton((Composite)container);
        this.createTable((Composite)container);
    }

    private void createTable(Composite container) {
        int tableStyle = 68356;
        this.table = new Table(container, tableStyle);
        GridData data = new GridData();
        data.heightHint = 80;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        String[] columNames = new String[]{Messages.getString((String)"FilterConditionBuilder.list.item1")};
        int[] columLength = new int[]{250};
        int i = 0;
        while (i < columNames.length) {
            TableColumn column = new TableColumn(this.table, 0, i);
            column.setText(columNames[i]);
            column.setWidth(columLength[i]);
            ++i;
        }
        this.addListenerForTable();
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLableProvier);
        this.tableViewer.setContentProvider((IContentProvider)this.tableContentProvider);
    }

    private void addListenerForTable() {
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilterConditionBuilder.this.checkEditDelButtonStatus();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    int index = FilterConditionBuilder.this.table.getSelectionIndex();
                    if (index > -1) {
                        FilterConditionBuilder.this.valueList.remove(index);
                        FilterConditionBuilder.this.tableViewer.refresh();
                        if (FilterConditionBuilder.this.valueList.size() > 0) {
                            if (FilterConditionBuilder.this.valueList.size() <= index) {
                                --index;
                            }
                            FilterConditionBuilder.this.table.select(index);
                        }
                        FilterConditionBuilder.this.updateButtons();
                    } else {
                        FilterConditionBuilder.this.delBtn.setEnabled(false);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)FilterConditionBuilder.this.tableViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof String) {
                    String initValue = (String)selection.getFirstElement();
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(FilterConditionBuilder.this.getShell(), initValue);
                    expressionBuilder.setExpressionProvier(FilterConditionBuilder.this.expressionProvider);
                    if (expressionBuilder.open() == 0) {
                        String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
                        if (result == null || result.trim().length() == 0) {
                            MessageDialog.openWarning((Shell)FilterConditionBuilder.this.tableViewer.getControl().getShell(), (String)Messages.getString((String)"dataset.editor.error.title"), (String)Messages.getString((String)"dataset.error.emptyexpression"));
                        } else {
                            int index = FilterConditionBuilder.this.table.getSelectionIndex();
                            FilterConditionBuilder.this.valueList.remove(index);
                            FilterConditionBuilder.this.valueList.add(index, result);
                            FilterConditionBuilder.this.tableViewer.refresh();
                            FilterConditionBuilder.this.table.select(index);
                        }
                    }
                    FilterConditionBuilder.this.updateButtons();
                } else {
                    FilterConditionBuilder.this.editBtn.setEnabled(false);
                }
            }
        });
    }

    private String getExpression(String name) {
        int i = 0;
        while (i < this.dataSetColumns.length) {
            if (this.dataSetColumns[i].equals(name)) {
                return ExpressionUtil.createJSRowExpression((String)name);
            }
            ++i;
        }
        return name;
    }

    protected Composite createDummy(Composite parent, int colSpan) {
        Composite dummy = new Composite(parent, 0);
        GridData gdata = new GridData(16);
        gdata.widthHint = 22;
        gdata.horizontalSpan = colSpan;
        gdata.heightHint = 10;
        dummy.setLayoutData((Object)gdata);
        return dummy;
    }

    public void updateHandle(FilterConditionHandle handle, int handleCount) {
        this.inputHandle = handle;
    }

    public void setExpressionProvider(DesignElementHandle designHandle) {
        this.currentItem = (DataSetHandle)designHandle;
        this.expressionProvider = new DataSetExpressionProvider(designHandle);
    }

    protected void updateButtons() {
        this.enableInput(this.isExpressionOK());
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.isConditionOK());
        }
    }

    protected void enableInput(boolean val) {
        if (this.valueVisible == 0) {
            this.exprValue1.setEnabled(false);
            this.exprValue2.setEnabled(false);
        } else if (this.valueVisible == 1) {
            this.exprValue1.setEnabled(val);
            this.exprValue2.setEnabled(false);
        } else if (this.valueVisible == 2) {
            this.exprValue1.setEnabled(val);
            this.exprValue2.setEnabled(val);
        } else if (this.valueVisible == 3) {
            this.valueListComposite.setEnabled(val);
            this.setControlEnable((Control)this.valueListComposite, val);
            if (val) {
                this.checkAddButtonStatus();
                this.checkEditDelButtonStatus();
            }
        }
    }

    protected void setControlEnable(Control control, boolean bool) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(bool);
        Composite tmp = null;
        if (control instanceof Composite) {
            tmp = (Composite)control;
        }
        if (tmp != null && tmp.getChildren() != null) {
            int i = 0;
            while (i < tmp.getChildren().length) {
                this.setControlEnable(tmp.getChildren()[i], bool);
                ++i;
            }
        }
    }

    private boolean isExpressionOK() {
        if (this.expression == null) {
            return false;
        }
        return this.expression.getText() != null && this.expression.getText().length() != 0;
    }

    protected boolean isConditionOK() {
        if (this.expression == null) {
            return false;
        }
        if (!this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    private boolean checkValues() {
        if (this.valueVisible == 3) {
            return this.valueList.size() > 0;
        }
        assert (!this.exprValue1.isDisposed());
        assert (!this.exprValue2.isDisposed());
        if (this.exprValue1.isEnabled() && (this.exprValue1.getText() == null || this.exprValue1.getText().trim().length() == 0)) {
            return false;
        }
        return !this.exprValue2.isEnabled() || this.exprValue2.getText() != null && this.exprValue2.getText().trim().length() != 0;
    }

    protected void checkAddButtonStatus() {
        if (this.addExprValue == null) {
            return;
        }
        String value = this.addExprValue.getText();
        if (value == null || value.trim().length() == 0) {
            this.addBtn.setEnabled(false);
            return;
        }
        if (this.valueList.indexOf(value) < 0) {
            this.addBtn.setEnabled(true);
        } else {
            this.addBtn.setEnabled(false);
        }
    }

    protected void checkEditDelButtonStatus() {
        StructuredSelection selection;
        boolean enabled;
        if (this.tableViewer == null) {
            return;
        }
        boolean bl = enabled = this.tableViewer.getSelection() != null;
        if (enabled && this.tableViewer.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)this.tableViewer.getSelection()).toList().size() <= 0) {
            enabled = false;
        }
        this.editBtn.setEnabled(enabled);
        this.delBtn.setEnabled(enabled);
        enabled = this.table.getItemCount() > 0;
        this.delAllBtn.setEnabled(enabled);
    }

    protected void syncViewProperties() {
        FilterCondition fc = null;
        fc = this.inputHandle instanceof FilterCondition ? (FilterCondition)this.inputHandle : (FilterCondition)((FilterConditionHandle)this.inputHandle).getStructure();
        this.expression.setText(DEUtil.resolveNull((String)fc.getExpr()));
        this.operator.select(FilterConditionBuilder.getIndexForOperatorValue(fc.getOperator()));
        this.valueVisible = FilterConditionBuilder.determineValueVisible(fc.getOperator());
        if (this.valueVisible == 3) {
            this.createValueListComposite(this.operator.getParent().getParent());
            this.valueList = new ArrayList(fc.getValue1List());
            this.tableViewer.setInput((Object)this.valueList);
        } else {
            this.createValueInputComposite(this.operator.getParent().getParent());
            this.exprValue1.setText(DEUtil.resolveNull((String)fc.getValue1()));
            this.exprValue2.setText(DEUtil.resolveNull((String)fc.getValue2()));
        }
        if (this.valueVisible == 0) {
            this.exprValue1.setEnabled(false);
            this.exprValue2.setEnabled(false);
        } else if (this.valueVisible == 1) {
            this.exprValue1.setEnabled(true);
            this.exprValue2.setEnabled(false);
        } else if (this.valueVisible == 2) {
            this.exprValue1.setEnabled(true);
            this.exprValue2.setEnabled(true);
        } else if (this.valueVisible == 3) {
            if (this.expression.getText().length() == 0) {
                this.valueListComposite.setEnabled(false);
            } else {
                this.valueListComposite.setEnabled(true);
            }
        }
    }

    protected void okPressed() {
        try {
            if (this.inputHandle instanceof FilterCondition) {
                FilterCondition filter = (FilterCondition)this.inputHandle;
                filter.setProperty("operator", (Object)DEUtil.resolveNull((String)FilterConditionBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible == 3) {
                    filter.setValue1(this.valueList);
                    filter.setValue2(null);
                } else {
                    assert (!this.exprValue1.isDisposed());
                    assert (!this.exprValue2.isDisposed());
                    if (this.exprValue1.isEnabled()) {
                        filter.setValue1(DEUtil.resolveNull((String)this.exprValue1.getText()));
                    } else {
                        filter.setValue1(null);
                    }
                    if (this.exprValue2.isEnabled()) {
                        filter.setValue2(DEUtil.resolveNull((String)this.exprValue2.getText()));
                    } else {
                        filter.setValue2(null);
                    }
                }
                filter.setExpr(DEUtil.resolveNull((String)this.expression.getText()));
            } else {
                FilterConditionHandle handle = (FilterConditionHandle)this.inputHandle;
                handle.setOperator(DEUtil.resolveNull((String)FilterConditionBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible == 3) {
                    handle.setValue1(this.valueList);
                    handle.setValue2(null);
                } else {
                    assert (!this.exprValue1.isDisposed());
                    assert (!this.exprValue2.isDisposed());
                    if (this.exprValue1.isEnabled()) {
                        handle.setValue1(DEUtil.resolveNull((String)this.exprValue1.getText()));
                    } else {
                        handle.setValue1(null);
                    }
                    if (this.exprValue2.isEnabled()) {
                        handle.setValue2(DEUtil.resolveNull((String)this.exprValue2.getText()));
                    } else {
                        handle.setValue2(null);
                    }
                }
                handle.setExpr(DEUtil.resolveNull((String)this.expression.getText()));
            }
        }
        catch (Exception e) {
            WidgetUtil.processError((Shell)this.getShell(), (Exception)e);
        }
        super.okPressed();
    }

    protected void editValue(Control control) {
        String initValue = null;
        if (control instanceof Text) {
            initValue = ((Text)control).getText();
        } else if (control instanceof Combo) {
            initValue = ((Combo)control).getText();
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
        expressionBuilder.setExpressionProvier(this.expressionProvider);
        if (expressionBuilder.open() == 0) {
            String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
            if (control instanceof Text) {
                ((Text)control).setText(result);
            } else if (control instanceof Combo) {
                ((Combo)control).setText(result);
            }
        }
        this.updateButtons();
    }

    private void refreshList() {
        if (this.refreshItems) {
            ArrayList<String> finalItems = new ArrayList<String>(10);
            int n = 0;
            while (n < actions.length) {
                finalItems.add(actions[n]);
                ++n;
            }
            this.popupItems = finalItems.toArray(EMPTY_ARRAY);
        }
        this.refreshItems = false;
    }

    private List getSelectValueList() throws BirtException {
        return SelectValueFetcher.getSelectValueList(this.expression.getText(), this.currentItem, false);
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        this.updateButtons();
        return super.open();
    }

    protected void createCustomControls(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.AddEditFilterCondition_ID");
        FilterConditionBuilder.applyDialogFont((Control)parent);
        this.createFilterConditionContent(parent);
    }

    protected void rollback() {
    }

    protected IStatus validateSemantics(Object structureOrHandle) {
        return null;
    }

    protected IStatus validateSyntax(Object structureOrHandle) {
        return null;
    }
}

