/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.editor;

import org.eclipse.birt.report.debug.internal.ui.script.editor.DebugJsInput;
import org.eclipse.birt.report.debug.internal.ui.script.editor.DebugScriptSourceViewerConfiguration;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ScriptSWTFactory;
import org.eclipse.birt.report.debug.internal.ui.script.outline.ScriptOutlinePage;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.ui.editor.script.DecoratedScriptEditor;
import org.eclipse.birt.report.designer.ui.editor.script.ScriptDocumentProvider;
import org.eclipse.birt.report.designer.ui.editors.IReportScriptLocation;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;

public class DebugJsEditor
extends DecoratedScriptEditor {
    private static final String SCRIPT_LABEL = "Script:";
    private Label messageLabel;
    private ScriptOutlinePage outlinePage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DebugJsEditor() {
        super(null);
        this.setRulerContextMenuId("#ScriptRulerContext");
        this.setEditorContextMenuId("#ScriptEditorContext");
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new DebugScriptSourceViewerConfiguration(this.getContext()));
    }

    public void createPartControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = ScriptSWTFactory.createComposite(parent, font, 1, 1, 768, 0, 0);
        Composite header = ScriptSWTFactory.createComposite(composite, font, 2, 1, 768, 5, 5);
        Label lblScript = new Label(header, 0);
        lblScript.setText(SCRIPT_LABEL);
        FontData fd = lblScript.getFont().getFontData()[0];
        Font labelFont = FontManager.getFont((String)fd.getName(), (int)fd.getHeight(), (int)1);
        lblScript.setFont(labelFont);
        GridData gd = new GridData(1);
        gd.horizontalIndent = 5;
        gd.verticalAlignment = 2;
        lblScript.setLayoutData((Object)gd);
        this.messageLabel = new Label(header, 0);
        GridData labelLayoutData = new GridData(768);
        labelLayoutData.verticalAlignment = 3;
        this.messageLabel.setLayoutData((Object)labelLayoutData);
        this.messageLabel.setText(this.getLabelMessage());
        this.messageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (DebugJsEditor.this.outlinePage != null) {
                    DebugJsEditor.this.outlinePage.selectionItem(DebugJsEditor.this.getDebugJSInput().getId());
                }
            }
        });
        final Composite sep = new Composite(composite, 0);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 1;
        sep.setLayoutData((Object)layoutData);
        sep.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Rectangle rect = sep.getBounds();
                gc.setForeground(ReportColorConstants.DarkGrayForground);
                gc.drawLine(0, 0, rect.width, 0);
            }
        });
        Composite mainComsite = new Composite(composite, 0);
        mainComsite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        mainComsite.setLayout((Layout)new FillLayout());
        super.createPartControl(mainComsite);
        if (this.getEditorInput() != null && this.getViewer() != null) {
            this.getViewer().getTextWidget().setEnabled(((DebugJsInput)this.getEditorInput()).sourceAvailable());
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        String name = this.getLabelMessage();
        if (this.messageLabel != null && !this.messageLabel.isDisposed()) {
            this.messageLabel.setText(name);
            this.messageLabel.redraw();
        }
        ScriptDocumentProvider provider = (ScriptDocumentProvider)this.getDocumentProvider();
        provider.setId(((DebugJsInput)input).getId());
        provider.setFileName(((DebugJsInput)input).getFile().getAbsolutePath());
        provider.update(provider.getAnnotationModel((Object)input));
        if (this.getViewer() != null) {
            this.getViewer().getTextWidget().setEnabled(((DebugJsInput)input).sourceAvailable());
        }
    }

    private String getLabelMessage() {
        DebugJsInput jsInput = this.getDebugJSInput();
        Object obj = ModuleUtil.getScriptObject((ModuleHandle)jsInput.getModuleHandle(), (String)jsInput.getId());
        String name = "";
        name = obj instanceof PropertyHandle ? String.valueOf(DEUtil.getFlatHirarchyPathName((Object)((PropertyHandle)obj).getElementHandle())) + "." + ((PropertyHandle)obj).getDefn().getName() : jsInput.getId();
        return name;
    }

    protected IEditorInput createScriptInput(String script) {
        return null;
    }

    public boolean isDirty() {
        return false;
    }

    private DebugJsInput getDebugJSInput() {
        return (DebugJsInput)this.getEditorInput();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.designer.ui.editors.IReportScriptLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new IReportScriptLocation(){

                public String getID() {
                    return DebugJsEditor.this.getDebugJSInput().getId();
                }

                public int getLineNumber() {
                    return -1;
                }

                public String getReportFileName() {
                    return DebugJsEditor.this.getDebugJSInput().getFile().getAbsolutePath();
                }

                public String getDisplayName() {
                    return DebugJsEditor.this.getLabelMessage();
                }
            };
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            this.outlinePage = new ScriptOutlinePage(this.getDebugJSInput().getModuleHandle());
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }
}

