/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.launcher;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ScriptSWTFactory {
    public static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public static Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public static Text createSingleText(Composite parent, int hspan) {
        Text t = new Text(parent, 2052);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        t.setLayoutData((Object)gd);
        return t;
    }

    public static Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        ScriptSWTFactory.setButtonDimensionHint(button);
        return button;
    }

    public static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        ScriptSWTFactory.setButtonDimensionHint(button);
        return button;
    }

    public static Button createCheckBox(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        ScriptSWTFactory.setButtonDimensionHint(button);
        return button;
    }

    private static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = ScriptSWTFactory.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    private static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Label createLabel(Composite parent, String text, Font font, int hspan) {
        Label l = new Label(parent, 0);
        l.setFont(font);
        l.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Combo createCombo(Composite parent, Font font, int hspan) {
        Combo cb = new Combo(parent, 2056);
        cb.setFont(font);
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        cb.setLayoutData((Object)gd);
        return cb;
    }

    static class PixelConverter {
        private FontMetrics fFontMetrics;

        public PixelConverter(Control control) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            this.fFontMetrics = gc.getFontMetrics();
            gc.dispose();
        }

        public int convertHorizontalDLUsToPixels(int dlus) {
            return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
        }

        public int convertWidthInCharsToPixels(int chars) {
            return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
        }
    }
}

